#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../dst/Distance_Constraints.hh"
#include "../fil/Family.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../fil/Trajectory.hh"
#include "../glo/Glo.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <iomanip>
#include <cmath>

int main(int argc, char* argv[]){

   if( argc!=5 ){
      std::cerr<<"ERROR: Number of command line arguments "
                 "should equal 4.\n";
      std::exit( 1);
   }
   std::string FAMILY=argv[1];
   std::string PROTEIN=argv[2];
   std::string CONFORMATION=argv[3];
   std::string SUBSET=argv[4];

   double bac_ps,bac_ss;
   double h_ion;
   {
      DAT_PHYSICS_CONSTS pc;
      DAT_ARRAY_CONSTS ac;
      DAT_ENERGY_PARAMS ep(pc);
      bac_ps= ep.fac_ps;
      bac_ss= ep.fac_ss;
      DAT_RESIDUE_MAPPINGS rm(pc,ac,ep);
      Structure s;
      {
         s.fam=FAMILY;
         s.mol=PROTEIN;
      }
      s.FIL2SEQ(rm);
      double q= (0.00);
      int n=0;
      int oZ0=s.nZ0;
      int oR0=(s.Z0[oZ0-1].R0a+s.Z0[oZ0-1].cR0);
      for(int iR0= 0;iR0<oR0;iR0++){
         std::string aa=s.R0[iR0].aa;
         std::string ab=s.R0[iR0].aa;
         if( (ab[0]=='e')||(ab[0]=='z') )ab=ab.substr(1,3)+' ';
         if( (ab[3]=='e')||(ab[3]=='z') )ab=ab.substr(0,3)+' ';
         if( aa[0]=='e' ){
            q++;
         }
         if      ( (ab=="ASP ")||(ab=="GLU ")||(ab=="TYZ ")||(ab=="CYZ ")||
                   (ab=="PO  ")||(ab=="PSR ")||(ab=="PSS ")||(ab=="GM  ")||
                   (ab=="TM  ")||(ab=="UM  ") ){
            q--;
         }else if( (ab=="LYS ")||(ab=="ARG ")||(ab=="ORN ")||(ab=="HIP ")||
                   (ab=="AP  ")||(ab=="GP  ")||(ab=="CP  ") ){
            q++;
         }else if( (ab=="5PO ")||(ab=="3PO ")||(ab=="SEP ")||(ab=="THP ")||
                   (ab=="TYP ") ){
            q-=(2.00);
         }
         if( aa[3]=='e' ){
            q--;
         }
         char c1=s.R0[iR0].c1;
         if( c1=='p' ){
            n++;
         }
      }
      double v= double( oR0);
      double r3= ((3.)*v*(140.00))/((4.)*pc.PI);
      double r= std::exp( std::log( r3)/(3.));
      double a= ((4.)*pc.PI)*std::pow(( r -(2.5962))/(5.1925), 2);
      if      ( n>16 ){
         h_ion=(  1.380);
      }else if( q<(  0.00) ){
         h_ion+=(0.80)*(-q/a);
      }else{
         h_ion+=(0.20)*( q/a);
      }
   }

   DAT_PHYSICS_CONSTS physics_consts;
   DAT_ARRAY_CONSTS array_consts;
   DAT_DISULFIDE_LINKS disulfide_links;
   DAT_ENERGY_PARAMS energy_params(physics_consts);
   {
      energy_params.fac_h*=h_ion;
   }
   DAT_RESIDUE_MAPPINGS residue_mappings(physics_consts,array_consts,
                                         energy_params);
   DAT_REGION_MAPS region_maps;
   DAT_DEFORM_PARAMS deform_params;

   Thread_Options opt;
   {
      opt.QSUB=SUBSET;
      opt.nD0_final=64;
      opt.FUNC="estp";
   }
   Output_Streams out;
   {
      std::string filename="../../"+FAMILY+"/dgn/estp."+PROTEIN+"."+CONFORMATION
                          +"."+SUBSET;
      out.FILE3.open(filename.c_str());
      out.FAMILY=FAMILY;
      out.PROTEIN=PROTEIN;
      out.CONFORMATION=CONFORMATION;
      out.SUBSET=SUBSET;
   }

   Structure str;
   {
      str.fam=FAMILY;
      str.mol=PROTEIN;
      str.cnf=CONFORMATION;
   }
   Trajectory tra;
   Family fam;

   str.FIL2SEQ(residue_mappings);
   str.FIL2CAR();
   tra.STR2TRA( 0,str);
   out.FILE3<<"REGULARIZE GEOMETRY"<< std::endl;
   str.REG(physics_consts,residue_mappings,out);
   str.POLARH(physics_consts,residue_mappings);
   str.TOR(physics_consts,residue_mappings);
   str.CAR(physics_consts,residue_mappings);
   str.STA(physics_consts,region_maps);
   str.SUP(physics_consts,out,tra);
   tra.STR2TRA( 1,str);

   Search_Subspace sub;
   {
      sub.FIL2STP(residue_mappings,str,opt);
      if      ( SUBSET[0]=='l' ){
      }else if( SUBSET[0]=='h' ){
      }else{
/**/     sub.UNIONSC(residue_mappings,str);
      }
   }
//
//
// loop over combinatorial sequence space
//
   out.FILE3<<"SEARCH COMBINATORIAL SEQUENCE SPACE"<< std::endl;
   int oR1=sub.nR1;
   for(int iR1= 0;iR1<oR1;iR1++){
      sub.R1[iR1].jR3=(sub.R1[iR1].R3a-1);
   }

   int iR1= 0;
   for(;;){
      sub.R1[iR1].jR3++;
      if( sub.R1[iR1].jR3>(sub.R1[iR1].R3a-1+sub.R1[iR1].cR3) ){
         if( iR1== 0 ){
            break;
         }else{
            sub.R1[iR1].jR3=(sub.R1[iR1].R3a-1);
            iR1--;
            continue;
         }

      }else{
         if( iR1==(oR1-1) ){
/**/        if( (SUBSET[0]=='h')||
/**/            (SUBSET[0]=='i') ){
/**/           bool INITIAL=true;
/**/           bool FINAL=true;
/**/           for(int aR1= 0;aR1<oR1;aR1++){
/**/              if( sub.R1[aR1].jR3>sub.R1[aR1].R3a )INITIAL=false;
/**/              if( sub.R1[aR1].jR3<(sub.R1[aR1].R3a-1+sub.R1[aR1].cR3) )
/**/                FINAL=false;
/**/           }
/**/           if( (!INITIAL)&&(!FINAL) )continue;
/**/        }
//
//
// populate mutated Structure object
//
            Structure mstr(residue_mappings,str,sub);
//
//
// regularize mutated structure
//
            mstr.REG(physics_consts,residue_mappings,out);
            mstr.POLARH(physics_consts,residue_mappings);
            mstr.TOR(physics_consts,residue_mappings);
            mstr.CAR(physics_consts,residue_mappings);
            mstr.STA(physics_consts,region_maps);
//
//
// populate mutated Search_Subspace object
//
            Search_Subspace msub(residue_mappings,sub,mstr);
//
//
// dependence of dielectric constant on q
//
            energy_params.fac_ps= bac_ps;
            energy_params.fac_ss= bac_ss;
            double q= (0.00);
            double qm= (0.00);
            double qp= (0.00);
            int n=0;
            int oZ0=mstr.nZ0;
            int oR0=(mstr.Z0[oZ0-1].R0a+mstr.Z0[oZ0-1].cR0);
            for(int iR0= 0;iR0<oR0;iR0++){
               std::string aa=mstr.R0[iR0].aa;
               std::string ab=mstr.R0[iR0].aa;
               if( (ab[0]=='e')||(ab[0]=='z') )ab=ab.substr(1,3)+' ';
               if( (ab[3]=='e')||(ab[3]=='z') )ab=ab.substr(0,3)+' ';
               if( aa[0]=='e' ){
                  q++;
                  qp++;
               }
               if      ( (ab=="ASP ")||(ab=="GLU ")||(ab=="TYZ ")||
                         (ab=="CYZ ")||(ab=="PO  ")||(ab=="PSR ")||
                         (ab=="PSS ")||(ab=="GM  ")||(ab=="TM  ")||
                         (ab=="UM  ") ){
                  q--;
                  qm++;
               }else if( (ab=="LYS ")||(ab=="ARG ")||(ab=="ORN ")||
                         (ab=="HIP ")||(ab=="AP  ")||(ab=="GP  ")||
                         (ab=="CP  ") ){
                  q++;
                  qp++;
               }else if( (ab=="5PO ")||(ab=="3PO ")||(ab=="SEP ")||
                         (ab=="THP ")||(ab=="TYP ") ){
                  q-=(2.00);
                  qm+=(2.00);
               }
               if( aa[3]=='e' ){
                  q--;
                  qm++;
               }
               char c1=mstr.R0[iR0].c1;
               if( c1=='p' ){
                  n++;
               }
            }
            double ps_ion= (1.00);
            double ss_ion= (1.00);
            if      ( n>16 ){
               ps_ion=(  0.960);
               ss_ion=(  0.960);
            }else if( q<(  0.00) ){
               double v= double( oR0);
               double r3= ((3.)*v*(140.00))/((4.)*physics_consts.PI);
               double r= std::exp( std::log( r3)/(3.));
               double a= (4.)*physics_consts.PI
                        *std::pow(( r -(2.5962))/(5.1925), 2);
               double n= physics_consts.CAL*physics_consts.ANG
                        *( q*q)/r;
               double d=( n +a*( 8.00) +physics_consts.CAL*physics_consts.ANG
                                       *(.50)*( qm/(3.40) +qp/(3.80))
                          );
               ps_ion-=(.0375)*(n/d);
               ss_ion-=(.0375)*(n/d);
            }
            energy_params.fac_ps*=ps_ion;
            energy_params.fac_ss*=ss_ion;
//
//
// global energy minimization for a fixed composition
//
            out.FILE3<<"MINIMIZE RESTBCHMGP GLOBALLY"<< std::endl;
            Glo xglo;
            opt.MODE="   ";
            Distance_Constraints dst(physics_consts,residue_mappings,
                                     opt,out,mstr,msub);
            opt.iW0_active=6;
            xglo.GLO(physics_consts,array_consts,disulfide_links,
                     energy_params,residue_mappings,region_maps,
                     deform_params,
                     opt,out,mstr,msub,fam,dst);

         }else{
            iR1++;
         }

      }
   }
//
//
// write structures and energies
//
   out.FILE3<<"COMPACT ANALYSIS"<< std::endl;
   Structure mstr;
   int iM1=0;
   for(int i1= 0;i1<10&&(iM1<fam.nM1);i1++){
      char a1=char('0'+i1);
      for(int i2= 0;i2<10&&(iM1<fam.nM1);i2++){
         char a2=char('0'+i2);
         for(int i3= 0;i3<10&&(iM1<fam.nM1);i3++){
            char a3=char('0'+i3);
            mstr.FAM2STR(fam.M1ord(iM1),fam);
            mstr.cnf=std::string("v")+a1+a2+a3;
            mstr.CAR2FIL();
            iM1++;
         }
      }
   }
   out.FILE3<<" energy minima in sequence-structure space\n";
   out.FILE3<< std::fixed<< std::setprecision(2);
   out.FILE3<<" iM1"
            <<"    Fr  "
            <<"    Fe  "
            <<"    Fs  "
            <<"    Ft  "
            <<"    Fb  "
            <<"    Fh  "
            <<"    Fm  "
            <<"    Fg  "
            <<"    Fp  "
            <<"    Fc  "
            <<'\n';
   for(int iM1= 0;iM1<fam.nM1;iM1++){
      int jM1=fam.M1ord(iM1);
      out.FILE3<< std::setw( 4)<<iM1
               << std::setw( 8)<<fam.M1[jM1].e[ 1]
               << std::setw( 8)<<fam.M1[jM1].e[ 2]
               << std::setw( 8)<<fam.M1[jM1].e[ 3]
               << std::setw( 8)<<fam.M1[jM1].e[ 4]
               << std::setw( 8)<<fam.M1[jM1].e[ 6]
               << std::setw( 8)<<fam.M1[jM1].e[ 7]
               << std::setw( 8)<<fam.M1[jM1].e[ 8]
               << std::setw( 8)<<fam.M1[jM1].e[ 9]
               << std::setw( 8)<<fam.M1[jM1].e[10]
               << std::setw( 8)<<fam.M1[jM1].e[ 5]
               <<'\n';
   }
   out.FILE3<<" iM1"
            <<" G -Gu  "
            <<"    Gu  "
            <<"    Qsol"
            <<'\n';
   for(int iM1= 0;iM1<fam.nM1;iM1++){
      int jM1=fam.M1ord(iM1);
      out.FILE3<< std::setw( 4)<<iM1
               << std::setw( 8)<<fam.M1[jM1].e[ 0]
               << std::setw( 8)<<fam.M1[jM1].e[11]
               << std::setw( 8)<<fam.M1[jM1].e[12]
               <<'\n';
   }
   out.FILE3<<" iM1"
            <<"  sequence substitutions"
            <<'\n';
   out.FILE3<<"     ";
   for(int iR1= 0;iR1<oR1;iR1++){
      int iR0=sub.R1[iR1].R0;
      out.FILE3<< std::setw( 4)<<(iR0+1);
   }
   out.FILE3<<'\n';
   for(int iM1= 0;iM1<fam.nM1;iM1++){
      int jM1=fam.M1ord(iM1);
      out.FILE3<< std::setw( 4)<<iM1<<"  ";
      for(int iR1= 0;iR1<oR1;iR1++){
         int iR0=sub.R1[iR1].R0;
         out.FILE3<<fam.M1[jM1].R0[iR0].aa;
      }
      out.FILE3<<'\n';
   }

   out.FILE3.close();
}
