#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../dst/Distance_Constraints.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../fil/Trajectory.hh"
#include "../loc/Loc.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <iomanip>

int main(int argc, char* argv[]){

   if( argc!=3 ){
      std::cerr<<"ERROR: Number of command line arguments "
                 "should equal 2.\n";
      std::exit( 1);
   }
   std::string FAMILY=argv[1];
   std::string PROTEIN=argv[2];

   std::string filename="../../"+FAMILY+"/exp/"+PROTEIN+".pdb";
   std::ifstream file_exists(filename.c_str());
   if( !file_exists ){
      std::cerr<<"ERROR: File "+filename.erase( 0, 6)+" does not exist.\n";
      std::exit( 1);
   }else{
      file_exists.close();
   }

   DAT_PHYSICS_CONSTS physics_consts;
   DAT_ARRAY_CONSTS array_consts;
   DAT_DISULFIDE_LINKS disulfide_links;
   Structure s;
   {
      DAT_ENERGY_PARAMS ep(physics_consts);
      DAT_RESIDUE_MAPPINGS rm(physics_consts,array_consts,ep);
      s.fam=FAMILY;
      s.mol=PROTEIN;
      s.REFORM(physics_consts,rm);
   }
   DAT_ENERGY_PARAMS energy_params(physics_consts,s);
   DAT_RESIDUE_MAPPINGS residue_mappings(physics_consts,array_consts,
                                         energy_params);
   DAT_REGION_MAPS region_maps;

   Thread_Options opt;
   {
      opt.MODE="loc";
      opt.Rcut= (999.00);
   }
   Output_Streams out;
   {
      filename="../../"+FAMILY+"/dgn/ereg."+PROTEIN;
      out.FILE3.open(filename.c_str());
      out.FAMILY=FAMILY;
      out.PROTEIN=PROTEIN;
   }

   Structure str;
   {
      str.fam=FAMILY;
      str.mol=PROTEIN;
   }
   Trajectory tra;

   str.cnf="exp";
   str.REFORM(physics_consts,residue_mappings);
   str.SEQ2FIL();
   str.TOR(physics_consts,residue_mappings);
   tra.STR2TRA( 0,str);
   Search_Subspace sub;
   Distance_Constraints dst(physics_consts,residue_mappings,
                            opt,out,str,sub);

   str.cnf="00";
   out.FILE3<<"REGULARIZE GEOMETRY"<< std::endl;
   str.REG(physics_consts,residue_mappings,out);
   str.POLARH(physics_consts,residue_mappings);
   str.TOR(physics_consts,residue_mappings);
   str.TOR2FIL(physics_consts);
   str.CAR(physics_consts,residue_mappings);
   str.SUP(physics_consts,out,tra);
   str.CAR2FIL();
   tra.STR2TRA( 1,str);

   int oZ0=str.nZ0;
   int oR0=(str.Z0[oZ0-1].R0a+str.Z0[oZ0-1].cR0);
   int oQ1=oZ0;
   int oU1=0;
   int oF1=0;
   int oB1=0;
   int oG1=0;
   int oH1=0;
   int oJ1=0;
   int oY1=0;
   for(int iR0= 0;iR0<oR0;iR0++){
      int iL0=str.R0[iR0].L0;
      oQ1+=residue_mappings.L0[iL0].cQ0;
      oU1+=residue_mappings.L0[iL0].cU0;
      oF1+=residue_mappings.L0[iL0].cF0;
      oB1+=residue_mappings.L0[iL0].cB0;
      oG1+=residue_mappings.L0[iL0].cG0;
      oH1+=residue_mappings.L0[iL0].cH0;
      oJ1+=residue_mappings.L0[iL0].cJ0;
      oY1+=residue_mappings.L0[iL0].cY0;
   }
   opt.iW0_active=0;
   Mechanical_System mol(oZ0,oR0,oQ1,oU1,oF1,oB1,oG1,oH1,oJ1,oY1);
   Subset_Contracted_System col(disulfide_links,residue_mappings,
                                opt,str,sub);
   Conf_Dependent_System dep(oZ0,oQ1,oF1,oG1,oJ1,oY1);
   out.FILE3<<"CONSTRUCT MECHANICAL SYSTEM"<< std::endl;
   mol.SET(physics_consts,array_consts,energy_params,residue_mappings,
           opt,str,out,dst,col,dep);
   out.FILE3<<"CONTRACT MECHANICAL SYSTEM"<< std::endl;
   mol.CON(physics_consts,array_consts,energy_params,
           region_maps,
           opt,out,col,dep);
   Loc xloc;

   out.FILE3<<"MINIMIZE RESTBCHMGP LOCALLY"<< std::endl;
   bool DECREASE=true;
   int iCNF=-1;
   for(int i= 0;i< 2&&(DECREASE);i++){
      char a0=char('0'+i);
      for(int j= 0;j<10&&(DECREASE);j++){
         char a1=char('0'+j);
         iCNF++;
         if( iCNF< 1 )continue;
         if( iCNF> 9 )continue;
         str.cnf=std::string("")+a0+a1;
         opt.iW0_active=(1-iCNF);
         DECREASE=xloc.LOC(physics_consts,array_consts,energy_params,
                           residue_mappings,region_maps,
                           opt,out,str,mol,col,dep);
         if( DECREASE ){
            str.CAR(physics_consts,residue_mappings);
            double rmsd= str.SUP(physics_consts,out,tra);
            str.CAR2FIL();
            str.TOR2FIL(physics_consts);
            tra.STR2TRA(iCNF,str);
            int n=xloc.Table.size();
            xloc.Table[n-1].iW0=opt.iW0_active;
            xloc.Table[n-1].rmsd= rmsd;
         }
      }
   }
//
//
// output compact analysis of local minimization
//
   out.FILE3<<"COMPACT ANALYSIS"<< std::endl;
   out.FILE3<< std::fixed<< std::setprecision(2);
   int n=xloc.Table.size();
   int j=(n-1);
   out.FILE3<<" W0"
            <<"     F   "
            <<"  RMSD \n";
   for(int i=0;i<n;i++){
      out.FILE3<< std::setw( 3)<<xloc.Table[i].iW0
               << std::setw( 9)<<xloc.Table[i].F
               << std::setw( 7)<<xloc.Table[i].rmsd<<'\n';
   }
   out.FILE3<<"   "
            <<" ________\n";
   out.FILE3<<"   "
            << std::setw( 9)<<( xloc.Table[j].F  -xloc.Table[0].F )<<'\n';
   out.FILE3<<" W0"
            <<"     Fr  "
            <<"     Fe  "
            <<"     Fs  "
            <<"     Ft  "
            <<"     Fb  "
            <<"     Fc  "
            <<"     Fh  "
            <<"     Fm  "
            <<"     Fg  "
            <<"     Fp  \n";
   for(int i=0;i<n;i++){
      out.FILE3<< std::setw( 3)<<xloc.Table[i].iW0
               << std::setw( 9)<<xloc.Table[i].Fr
               << std::setw( 9)<<xloc.Table[i].Fe
               << std::setw( 9)<<xloc.Table[i].Fs
               << std::setw( 9)<<xloc.Table[i].Ft
               << std::setw( 9)<<xloc.Table[i].Fb
               << std::setw( 9)<<xloc.Table[i].Fc
               << std::setw( 9)<<xloc.Table[i].Fh
               << std::setw( 9)<<xloc.Table[i].Fm
               << std::setw( 9)<<xloc.Table[i].Fg
               << std::setw( 9)<<xloc.Table[i].Fp<<'\n';
   }
   out.FILE3<<"   "
            <<" ________"
            <<" ________"
            <<" ________"
            <<" ________"
            <<" ________"
            <<" ________"
            <<" ________"
            <<" ________"
            <<" ________"
            <<" ________\n";
   out.FILE3<<"   "
            << std::setw( 9)<<( xloc.Table[j].Fr -xloc.Table[0].Fr)
            << std::setw( 9)<<( xloc.Table[j].Fe -xloc.Table[0].Fe)
            << std::setw( 9)<<( xloc.Table[j].Fs -xloc.Table[0].Fs)
            << std::setw( 9)<<( xloc.Table[j].Ft -xloc.Table[0].Ft)
            << std::setw( 9)<<( xloc.Table[j].Fb -xloc.Table[0].Fb)
            << std::setw( 9)<<( xloc.Table[j].Fc -xloc.Table[0].Fc)
            << std::setw( 9)<<( xloc.Table[j].Fh -xloc.Table[0].Fh)
            << std::setw( 9)<<( xloc.Table[j].Fm -xloc.Table[0].Fm)
            << std::setw( 9)<<( xloc.Table[j].Fg -xloc.Table[0].Fg)
            << std::setw( 9)<<( xloc.Table[j].Fp -xloc.Table[0].Fp)<<'\n';
// out.FILE3<<" W0"
//          <<"     Fps "
//          <<"     Fss "
//          <<"     Fp_a"
//          <<"     Fp_b"
//          <<"     Fp_c"
//          <<"     Fp_d"
//          <<"     Fp_e\n";
// for(int i=0;i<n;i++){
//    out.FILE3<< std::setw( 3)<<xloc.Table[i].iW0
//             << std::setw( 9)<<xloc.Table[i].Fps
//             << std::setw( 9)<<xloc.Table[i].Fss
//             << std::setw( 9)<<xloc.Table[i].Fp_a
//             << std::setw( 9)<<xloc.Table[i].Fp_b
//             << std::setw( 9)<<xloc.Table[i].Fp_c
//             << std::setw( 9)<<xloc.Table[i].Fp_d
//             << std::setw( 9)<<xloc.Table[i].Fp_e<<'\n';
// }
// out.FILE3<<"   "
//          <<" ________"
//          <<" ________"
//          <<" ________"
//          <<" ________"
//          <<" ________"
//          <<" ________"
//          <<" ________\n";
// out.FILE3<<"   "
//          << std::setw( 9)<<( xloc.Table[j].Fps -xloc.Table[0].Fps)
//          << std::setw( 9)<<( xloc.Table[j].Fss -xloc.Table[0].Fss)
//          << std::setw( 9)<<( xloc.Table[j].Fp_a -xloc.Table[0].Fp_a)
//          << std::setw( 9)<<( xloc.Table[j].Fp_b -xloc.Table[0].Fp_b)
//          << std::setw( 9)<<( xloc.Table[j].Fp_c -xloc.Table[0].Fp_c)
//          << std::setw( 9)<<( xloc.Table[j].Fp_d -xloc.Table[0].Fp_d)
//          << std::setw( 9)<<( xloc.Table[j].Fp_e -xloc.Table[0].Fp_e)<<'\n';

   out.FILE3.close();

}
