#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../dst/Distance_Constraints.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../fil/Trajectory.hh"
#include "../pck/Packing_Search.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Local_Minimiz.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <iomanip>
#include <cmath>

int main(int argc, char* argv[]){

   if( argc< 4 ){
      std::cerr<<"ERROR: Number of command line arguments "
                 "should be 3 or greater.\n";
      std::exit( 1);
   }
   std::string FAMILY=argv[1];
   int oG9=(argc-2);

   Packing_Search pck;
   for(int iG9= 0;iG9<oG9;iG9++){
      pck.G9.push_back( Packing_Search::tG9());
      pck.G9[iG9].bod=argv[ 2+iG9];
      std::string filename="../../"+FAMILY+"/exp/"+pck.G9[iG9].bod+".pdb";
      std::ifstream ifile(filename.c_str());
      if( !ifile ){
         std::cerr<<"ERROR: File "+filename.erase( 0, 6)+" does not exist.\n";
         std::exit( 1);
      }else{
         ifile.close();
      }
   }
   pck.oG9=oG9;

   DAT_PHYSICS_CONSTS physics_consts;
   DAT_ARRAY_CONSTS array_consts;
   DAT_DISULFIDE_LINKS disulfide_links;
   DAT_ENERGY_PARAMS energy_params(physics_consts);
   DAT_RESIDUE_MAPPINGS residue_mappings(physics_consts,array_consts,
                                         energy_params);
   DAT_REGION_MAPS region_maps;

   Thread_Options opt;
   {
      opt.MODE="bb ";
      opt.Rcut= (999.00);
      opt.iW0_active=-8;
      opt.QSUB="pck";
   }
   Output_Streams out;
   {
      out.FAMILY=FAMILY;
      out.PROTEIN=pck.G9[ 0].bod;
      for(int iG9= 1;iG9<oG9;iG9++){
         out.PROTEIN+='_';
         out.PROTEIN+=pck.G9[iG9].bod;
//       out.PROTEIN+=pck.G9[iG9].bod[ pck.G9[iG9].bod.find('#')+1];
      }
      out.CONFORMATION="doc";
      out.SUBSET="pck";
      std::string filename="../../"+out.FAMILY+"/dgn/edoc."+out.PROTEIN;
      out.FILE3.open(filename.c_str());
      out.VERBOSE=false;
      out.SHELL=false;
   }

   for(int iG9= 0;iG9<oG9;iG9++){
      Structure& str=pck.G9[iG9].str;
      str.fam=FAMILY;
      str.mol=pck.G9[iG9].bod;
      str.cnf="exp";
      str.REFORM(physics_consts,residue_mappings);
      str.SEQ2FIL();

      str.cnf="00";
      str.REG(physics_consts,residue_mappings,out);
      str.POLARH(physics_consts,residue_mappings);
      str.TOR(physics_consts,residue_mappings);
//    str.TOR2FIL(physics_consts);
      str.CAR(physics_consts,residue_mappings);
      Trajectory tra;
      tra.STR2TRA( 0,str);
      str.SUP(physics_consts,out,tra);
//    str.CAR2FIL();
      pck.G9[iG9].bac=str;
   }
//
//
// pack elements
//
   pck.PCK(physics_consts,array_consts,disulfide_links,energy_params,
           region_maps,residue_mappings,
           opt,out);

   int iU9=pck.pU9;
   if( iU9<oG9 ){
      return 0;
   }
/**/  return 0;
   int oY9=pck.U9[iU9].oY9;
   for(int iY9= 0;iY9<oY9;iY9++){
      int& oZ9=pck.Y9[iY9].oZ9;
//
//
// composite subspace
//
      std::vector<Structure> Z9str(oZ9);
      for(int iZ9= 0;iZ9<oZ9;iZ9++){
         int iG9=pck.U9[iU9].Y9[iY9].Z9[iZ9].G9;
         Z9str[iZ9]=pck.G9[iG9].str;
      }
      Search_Subspace sub;
      sub.PCKSTP(residue_mappings,Z9str);
//
//
// composite structure
//
      std::vector<Local_Minimizp::eRecord> D9e;
      int oD9=pck.Y9[iY9].oD9;
      for(int iD9= 0;iD9<oD9;iD9++){
         Structure str;
         {
            int iG9=pck.U9[iU9].Y9[iY9].Z9[ 0].G9;
            Coordinates TRANS=(physics_consts.ANG
                              *pck.Y9[iY9].D9[iD9].Z9[ 0].t);
            Rotation_Matrix ROT=pck.Y9[iY9].D9[iD9].Z9[ 0].c;
            pck.G9[iG9].bac.generate(TRANS,
                                     ROT,
                                     pck.G9[iG9].str);
            str=pck.G9[iG9].bac;
            str.mol=pck.G9[iG9].str.mol;
         }
         for(int iZ9= 1;iZ9<oZ9;iZ9++){
            int iG9=pck.U9[iU9].Y9[iY9].Z9[iZ9].G9;
            Coordinates TRANS=(physics_consts.ANG
                              *pck.Y9[iY9].D9[iD9].Z9[iZ9].t);
            Rotation_Matrix ROT=pck.Y9[iY9].D9[iD9].Z9[iZ9].c;
            pck.G9[iG9].bac.generate(TRANS,
                                     ROT,
                                     pck.G9[iG9].str);
            str+=pck.G9[iG9].bac;
            str.mol+=pck.G9[iG9].str.mol[ pck.G9[iG9].str.mol.find('#')+1];
         }
         {
            std::string cnf="____";
            int ii=iD9;
            for(int i=0;i<4;i++){
               cnf[3-i]=char('0'+(ii%10));
               ii/=10;
            }
            str.cnf="e"+cnf;
         }
         str.TOR(physics_consts,residue_mappings);
         str.CAR2FIL();
/**/     if( iD9==63 )break;
//
//
// set sizes
//
         int oZ0=str.nZ0;
         int oR0=(str.Z0[oZ0-1].R0a+str.Z0[oZ0-1].cR0);
         if( oR0> 200 ){
            return 0;
         }
         int oQ1=oZ0;
         int oU1=0;
         int oF1=0;
         int oB1=0;
         int oG1=0;
         int oH1=0;
         int oJ1=0;
         int oY1=0;
         for(int iR0= 0;iR0<oR0;iR0++){
            int iL0=str.R0[iR0].L0;
            oQ1+=residue_mappings.L0[iL0].cQ0;
            oU1+=residue_mappings.L0[iL0].cU0;
            oF1+=residue_mappings.L0[iL0].cF0;
            oB1+=residue_mappings.L0[iL0].cB0;
            oG1+=residue_mappings.L0[iL0].cG0;
            oH1+=residue_mappings.L0[iL0].cH0;
            oJ1+=residue_mappings.L0[iL0].cJ0;
            oY1+=residue_mappings.L0[iL0].cY0;
         }
//
//
// mechanical system
//
         opt.MODE="lp ";
         Subset_Contracted_System col(disulfide_links,residue_mappings,
                                      opt,str,sub);
         if( col.nM3!=1 ){
            std::cerr<<"ERROR: Number of subsets of degrees of freedom "
                       "should equal 1.\n";
            std::exit( 2);
         }
         Mechanical_System mol(oZ0,oR0,oQ1,oU1,oF1,oB1,oG1,oH1,oJ1,oY1);
         Conf_Dependent_System dep(oZ0,oQ1,oF1,oG1,oJ1,oY1);
         {
            out.VERBOSE=false;
////            Distance_Constraints dst(physics_consts,residue_mappings,
////                                     opt,out,str,sub);
            Distance_Constraints dst;
            opt.iW0_active=-9;
            mol.SET(physics_consts,array_consts,energy_params,residue_mappings,
                    opt,str,out,dst,col,dep);
            mol.CON(physics_consts,array_consts,energy_params,
                    region_maps,
                    opt,out,col,dep);
            out.VERBOSE=true;
         }
         const Subset_Contracted_System::tM3& con=col.M3[ 0];
         int oQ2=con.oQ2;
         int oF2=con.oF2;
//
//
// evaluate off-lattice energy for full model
//
         Trajectory tra;
         {
            tra.STR2TRA( 0,str);
         }
//
//
// initiate energy surface for restchm wrt generalized coords
//
         int oU2=0;
         for(int iZ0= 0;iZ0<oZ0;iZ0++){
            if( con.Z0[iZ0].sub )oU2+=6;
            oU2+=(con.Z0[iZ0].cQ2-1);
         }
         Energy_Surfq enq(oU2+6,  0,oZ0,oR0,oQ2,oF2);
         {
            int iU2=0;
            for(int iZ0= 0;iZ0<oZ0;iZ0++){
               if( con.Z0[iZ0].sub ){
                  enq.Z0[iZ0].U2a=iU2;
                  enq.U2chi(iU2  )= dep.Z0[iZ0].trans(0);
                  enq.U2chi(iU2+1)= dep.Z0[iZ0].trans(1);
                  enq.U2chi(iU2+2)= dep.Z0[iZ0].trans(2);
                  enq.U2chi(iU2+3)= dep.Z0[iZ0].rot(0);
                  enq.U2chi(iU2+4)= dep.Z0[iZ0].rot(1);
                  enq.U2chi(iU2+5)= dep.Z0[iZ0].rot(2);
                  enq.U2uca(iU2  )= (2.000);
                  enq.U2uca(iU2+1)= (2.000);
                  enq.U2uca(iU2+2)= (2.000);
                  enq.U2uca(iU2+3)= ( .125);
                  enq.U2uca(iU2+4)= ( .125);
                  enq.U2uca(iU2+5)= ( .125);
                  iU2+=6;
               }else{
                  enq.Z0[iZ0].U2a=enq.nU2;
               }
            }
            for(int iZ0= 0;iZ0<oZ0;iZ0++){
               int mQ2=con.Z0[iZ0].Q2a;
               int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
               if( nQ2>mQ2 ){
                  for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
                     enq.Q2[iQ2].U2=iU2;
                     enq.U2chi(iU2)= dep.Q2[iQ2].chi;
                     enq.U2uca(iU2)=( con.Q2[iQ2].br>0 )? ( .500): ( .125);
                     iU2++;
                  }
               }
            }
            enq.fac_m2= (  .000);
            enq.fac_m3= (  .375);
            for(int iF2= 0;iF2<oF2;iF2++){
               for(int jF2= 0;jF2<oF2;jF2++){
                  enq.F2F2b(iF2,jF2, true);
               }
            }
         }
//
//
// initiate local minimization of restchm wrt generalized coords
//
         int oM2=2048;
         Local_Minimizq loq(oM2,oU2);
         {
            loq.iCYC=0;
         }
//
//
// local minimization of restchm wrt generalized coordinates
//
         out.VERBOSE=true;
         loq.BETA= (2.00e-02);
         loq.BETA*=std::sqrt( oU2);
         loq.BMIN= (1.00e-04);
         loq.BMIN*=std::sqrt( oU2);
         loq.BMAX=( 1.00e-01);
         loq.BMAX*=std::sqrt( oU2);
         loq.EPS1= (1.00e-03);
         loq.EPS1= oU2*loq.EPS1*loq.EPS1;
         loq.nM2=128;
         bool INFLATE=false;
         out.FILE3<<"________________________________________"
                    "________________________________________\n";
         loq.TRA_LOQ(physics_consts,array_consts,energy_params,
                     region_maps,
                     opt,out,mol,con,dep,
                     enq,INFLATE);
         loq.TRA_LOQ_WRT(physics_consts,residue_mappings,
                         out,str,mol,con,dep,
                         enq,INFLATE);
         str.CAR(physics_consts,residue_mappings);
         out.VERBOSE=true;
//       str.TOR2FIL(physics_consts);
/**/     str.CAR2FIL();
//
//
// update table
//
         D9e.push_back( Local_Minimizp::eRecord());
         D9e[iD9].F= enq.TOT;
         D9e[iD9].Fr= enq.Fr;
         D9e[iD9].Fe= enq.Fe;
         D9e[iD9].Fs= enq.Fs;
         D9e[iD9].Ft= enq.Ft;
         D9e[iD9].Fc= enq.Fc;
         D9e[iD9].Fb= enq.Fb;
         D9e[iD9].Fh= enq.Fh;
         D9e[iD9].Fw= enq.Fh;
         D9e[iD9].Fp= enq.Fp;
         D9e[iD9].Fp_a= enq.Fp_a;
         D9e[iD9].Fp_b= enq.Fp_b;
         D9e[iD9].Fp_c= enq.Fp_c;
         D9e[iD9].Fp_d= enq.Fp_d;
         D9e[iD9].Fp_e= enq.Fp_e;
      }
//
//
// output compact analysis for collection of local minimizations
//
      out.FILE3<<"COMPACT ANALYSIS"<< std::endl;
      out.FILE3<<"    "
               <<"   Ftot "
               <<"    Fr  "
               <<"    Fe  "
               <<"    Fs  "
               <<"    Ft  "
               <<"    Fc  "
               <<"    Fb  "
               <<"    Fh  "
               <<"    Fw  "
               <<"    Fp  "
               <<'\n';
      for(int iD9= 0;iD9<oD9;iD9++){
         out.FILE3<< std::setw( 4)<<iD9
                  << std::setprecision(2)
                  << std::setw( 8)<<D9e[iD9].F
                  << std::setw( 8)<<D9e[iD9].Fr
                  << std::setw( 8)<<D9e[iD9].Fe
                  << std::setw( 8)<<D9e[iD9].Fs
                  << std::setw( 8)<<D9e[iD9].Ft
                  << std::setw( 8)<<D9e[iD9].Fc
                  << std::setw( 8)<<D9e[iD9].Fb
                  << std::setw( 8)<<D9e[iD9].Fh
                  << std::setw( 8)<<D9e[iD9].Fw
                  << std::setw( 8)<<D9e[iD9].Fp
                  <<'\n';
      }
   }

   out.FILE3.close();
}
