#ifndef DEF_PTRA_AUTOMATIC
#define DEF_PTRA_AUTOMATIC

#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../glo/Glo.hh"
#include "../loc/Loc.hh"
#include "../phi/Coordinates.hh"
#include "../str/Output_Streams.hh"
#include <vector>

class Ptra_Automatic {
public:
   class Neighbor_Subset {
   private:
      int oR0;                          //n of residues
      std::vector<bool> o_R0R0b;        //exclude from inflation
      std::vector<int> o_R0N4P1;        //map to atom
      std::vector<Coordinates> o_R0hn;  //unit vector N-->H of peptide plane
      std::vector<Coordinates> o_R0co;  //unit vector O-->C of peptide plane
      std::vector<bool> o_R0N2b;        //peptide H-bond { O<--H, H-->O}
      std::vector<bool> o_R0h;          //spanned by 4-13 alpha helix H-bond
      std::vector<bool> o_R0e;          //in strand of beta sheet
      int oF2;                          //n of atoms
      std::vector<bool> o_F2F2b;        //classified as short range
   public:
      double xfold;                     //measure of stability wrt unfolded
      Neighbor_Subset(int r,int f):
         oR0(r),
         o_R0R0b(r*(r-1)/2,false),
         o_R0N4P1(r*4,-1),
         o_R0hn(r),
         o_R0co(r),
         o_R0N2b(r*2,false),
         o_R0h(r,false),
         o_R0e(r,false),
         oF2(f),
         o_F2F2b(f*(f-1)/2,true)
      {
      }
      void R0R0b(int i,int j,bool a){
         if      ( i<j ){
            o_R0R0b[ i*oR0 -(i+1)*(i+2)/2 +j]=a;
         }else if( j<i ){
            o_R0R0b[ j*oR0 -(j+1)*(j+2)/2 +i]=a;
         }
      }
      bool R0R0b(int i,int j){
         if      ( i<j ){
            return o_R0R0b[ i*oR0 -(i+1)*(i+2)/2 +j];
         }else if( j<i ){
            return o_R0R0b[ j*oR0 -(j+1)*(j+2)/2 +i];
         }else{
            return true;
         }
      }
      int& R0N4P1(int i,int j){
         return o_R0N4P1.at( i*4 +j);  }
      Coordinates& R0hn(int i){
         return o_R0hn.at( i);  }
      Coordinates& R0co(int i){
         return o_R0co.at( i);  }
      void R0N2b(int i,int j,bool a){
         o_R0N2b[ i*2 +j]=a;  }
      bool R0N2b(int i,int j){
         return o_R0N2b[ i*2 +j];  }
      void R0h(int i,bool a){
         o_R0h[ i]=a;  }
      bool R0h(int i){
         return o_R0h[ i];  }
      const bool R0h(int i) const {
         return o_R0h[ i];  }
      void R0e(int i,bool a){
         o_R0e[ i]=a;  }
      bool R0e(int i){
         return o_R0e[ i];  }
      const bool R0e(int i) const {
         return o_R0e[ i];  }
      void F2F2b(int i,int j,bool a){
         if      ( i<j ){
            o_F2F2b[ i*oF2 -(i+1)*(i+2)/2 +j]=a;
         }else if( j<i ){
            o_F2F2b[ j*oF2 -(j+1)*(j+2)/2 +i]=a;
         }
      }
      bool F2F2b(int i,int j){
         if      ( i<j ){
            return o_F2F2b[ i*oF2 -(i+1)*(i+2)/2 +j];
         }else if( j<i ){
            return o_F2F2b[ j*oF2 -(j+1)*(j+2)/2 +i];
         }else{
            return true;
         }
      }

      void populate(const DAT_PHYSICS_CONSTS& physics_consts,
                    const Structure& str,
                    const Subset_Contracted_System::tM3& con);
   };
   class Random_Generator { /*random number generator*/
   private:
      const int m;              //
      const int a;              //
      const int q;              //
      const int r;              //
      int Tz[32];               //
      const int nT;             //
      const int d;              //
      int SEED;                 //
      int iT;                   //
   public:
      double random_gen(){
         double z= (double(Tz[iT])/double(m));
         int jT=(Tz[iT]/d);
         int k=SEED/q;
         SEED=a*(SEED-k*q)-r*k;
         if( SEED<0 )SEED+=m;
         Tz[iT]=SEED;
         iT=jT;
         return z;
      }
      Random_Generator():
         m(2147483647),
         a(16807),
         q(127773),
         r(2836),
         nT(32),
         d(m/nT+1),
         SEED(1111111111)
      {
         for(int i=0;i<8;i++){
            int k=SEED/q;
            SEED=a*(SEED-k*q)-r*k;
            if( SEED<0 )SEED+=m;
         }
         for(int jT= 0;jT<nT;jT++){
            int k=SEED/q;
            SEED=a*(SEED-k*q)-r*k;
            if( SEED<0 )SEED+=m;
            Tz[jT]=SEED;
         }
         iT=(SEED/d);
      }
   };
   class Record { /*decomposition of restchm*/
   public:
      double Ri;                //heavy atom rmsd (angstrom) post inflation
      int oM;                   //number of inflation +deflation steps
      double Rd;                //post deflation
      double Ftot;              //total (kcal)
      double Fr;                //repulsion+dispersion
      double Fe;                //electrostatic
      double Fs;                //disulfide bond
      double Ft;                //intrinsic torsional
      double Fc;                //distance constraint
      double Fb;                //ring closure
      double Fh;                //hydrophobic
      double Fm;                //dielectric medium
      double Fg;                //patch to disallow regions
      double Fp;                //polarization
      double g;                 //normalized gradient for enp surf
      double dtot;              //change in Ftot over cycle
      double rn;                //random number in range [ 0, 1]
      double z;                 //exp(-dtot/kT)
      int accept;               //{ 0=reject, 1=accept}
      double xfold;             //measure of stability wrt unfolded
      Record(){}
   };

private:
   std::vector<char> o_Jrec;            //subsets of parameters

public:
   Neighbor_Subset ns;                  //
   Random_Generator rng;                //
   std::vector<Record> o_Table;         //
   std::vector<char> o_OR0a1;           //(H,E,C) ss state

   Ptra_Automatic(int r,int f):
      o_Jrec(28),
      ns(r,f),
      o_OR0a1(r,' ')
   {
   }

   char& Jrec(int i){
      return o_Jrec.at( i);  }
   Record& Table(int i){
      return o_Table.at( i);  }
   char& OR0a1(int i){
      return o_OR0a1.at( i);  }

   void extern_loc(const DAT_PHYSICS_CONSTS& physics_consts,
                   const DAT_ARRAY_CONSTS& array_consts,
                   const DAT_DISULFIDE_LINKS& disulfide_links,
                   const DAT_ENERGY_PARAMS& energy_params,
                   const DAT_RESIDUE_MAPPINGS& residue_mappings,
                   const DAT_REGION_MAPS& region_maps,
                   Structure& str,
                   Output_Streams& out,
                   Loc& xloc);
   void extern_glo(const DAT_PHYSICS_CONSTS& physics_consts,
                   const DAT_ARRAY_CONSTS& array_consts,
                   const DAT_DISULFIDE_LINKS& disulfide_links,
                   const DAT_ENERGY_PARAMS& energy_params,
                   const DAT_RESIDUE_MAPPINGS& residue_mappings,
                   const DAT_REGION_MAPS& region_maps,
                   const DAT_DEFORM_PARAMS& deform_params,
                   Structure& str,
                   Search_Subspace& sub,
                   Output_Streams& out,
                   Glo& xglo);
};

#endif
