#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../dst/Distance_Constraints.hh"
#include "../fil/Family.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../fil/Trajectory.hh"
#include "../glo/Glo.hh"
#include "../loc/Loc.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Ptra_Automatic.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <iostream>
#include <cstdlib>
#include <iomanip>
#include <cmath>

void Ptra_Automatic::extern_loc(const DAT_PHYSICS_CONSTS& physics_consts,
                                const DAT_ARRAY_CONSTS& array_consts,
                                const DAT_DISULFIDE_LINKS& disulfide_links,
                                const DAT_ENERGY_PARAMS& energy_params,
                                const DAT_RESIDUE_MAPPINGS& residue_mappings,
                                const DAT_REGION_MAPS& region_maps,
                                Structure& str,
                                Output_Streams& out,
                                Loc& xloc){
   out.VERBOSE=false;
//
//
// set sizes
//
   int oZ0=str.nZ0;
   int oR0=(str.Z0[oZ0-1].R0a+str.Z0[oZ0-1].cR0);
   int oQ1=oZ0;
   int oU1=0;
   int oF1=0;
   int oB1=0;
   int oG1=0;
   int oH1=0;
   int oJ1=0;
   int oY1=0;
   for(int iR0= 0;iR0<oR0;iR0++){
      int iL0=str.R0[iR0].L0;
      oQ1+=residue_mappings.L0[iL0].cQ0;
      oU1+=residue_mappings.L0[iL0].cU0;
      oF1+=residue_mappings.L0[iL0].cF0;
      oB1+=residue_mappings.L0[iL0].cB0;
      oG1+=residue_mappings.L0[iL0].cG0;
      oH1+=residue_mappings.L0[iL0].cH0;
      oJ1+=residue_mappings.L0[iL0].cJ0;
      oY1+=residue_mappings.L0[iL0].cY0;
   }
//
//
// mechanical system
//
   Trajectory xtra;
   {
      xtra.STR2TRA( 0,str);
   }
   Thread_Options xopt;
   {
      xopt.Rcut= (999.00);
      xopt.QSUB=out.SUBSET;
      xopt.MODE="loc";
   }
   Search_Subspace xsub;
   {
      xsub.FIL2STP(residue_mappings,str,xopt);
   }
   Subset_Contracted_System xcol(disulfide_links,residue_mappings,
                                 xopt,str,xsub);
   if( xcol.nM3!=1 ){
      std::cerr<<"ERROR: Number of subsets of degrees of freedom "
                 "should equal 1.\n";
      std::exit( 2);
   }
   Mechanical_System xmol(oZ0,oR0,oQ1,oU1,oF1,oB1,oG1,oH1,oJ1,oY1);
   Conf_Dependent_System xdep(oZ0,oQ1,oF1,oG1,oJ1,oY1);
   {
      Search_Subspace emptysub;
      Distance_Constraints xdst(physics_consts,residue_mappings,
                                xopt,out,str,emptysub);
      xopt.iW0_active=0;
      xmol.SET(physics_consts,array_consts,energy_params,
               residue_mappings,
               xopt,str,out,xdst,xcol,xdep);
      xmol.CON(physics_consts,array_consts,energy_params,
               region_maps,
               xopt,out,xcol,xdep);
   }
   const Subset_Contracted_System::tM3& xcon=xcol.M3[ 0];
//
//
// local minimization
//
   bool DECREASE=true;
   for(int i=-4;i>-9&&( DECREASE);i--){
      xopt.iW0_active=i;
      DECREASE=xloc.LOC(physics_consts,array_consts,energy_params,
                        residue_mappings,region_maps,
                        xopt,out,str,xmol,xcol,xdep);
      if( DECREASE ){
         str.CAR(physics_consts,residue_mappings);
         int n=xloc.Table.size();
         xloc.Table[n-1].iW0=xopt.iW0_active;
         xloc.Table[n-1].rmsd= str.SUP(physics_consts,out,xtra);
         xtra.STR2TRA(-3-i,str);
      }else{
         str.TRA2STR(-4-i,xtra);
      }
   }
   str.CAR(physics_consts,residue_mappings);
   int n=xloc.Table.size();
   int j=(n-1);
//
//
// output compact analysis of local minimization
//
   out.FILE3<<"COMPACT ANALYSIS\n";
   out.FILE3<< std::fixed;
   out.FILE3<<"W0"
            <<"    F   "
            <<"    Fr  "
            <<"    Fe  "
            <<"    Fs  "
            <<"    Ft  "
            <<"    Fb  "
            <<"    Fc  "
            <<"    Fh  "
            <<"    Fm  "
            <<"    Fg  "
            <<"    Fp  "
            <<"  RMSD\n";
   for(int i=j;i<n;i++){
      out.FILE3<< std::setw( 2)<<xloc.Table[i].iW0
               << std::setprecision(1)
               << std::setw( 8)<<xloc.Table[i].F
               << std::setw( 8)<<xloc.Table[i].Fr
               << std::setw( 8)<<xloc.Table[i].Fe
               << std::setw( 8)<<xloc.Table[i].Fs
               << std::setw( 8)<<xloc.Table[i].Ft
               << std::setw( 8)<<xloc.Table[i].Fb
               << std::setw( 8)<<xloc.Table[i].Fc
               << std::setw( 8)<<xloc.Table[i].Fh
               << std::setw( 8)<<xloc.Table[i].Fm
               << std::setw( 8)<<xloc.Table[i].Fg
               << std::setw( 8)<<xloc.Table[i].Fp
               << std::setprecision(2)
               << std::setw( 6)<<xloc.Table[i].rmsd<<'\n';
   }
// out.FILE3<<"   Fp_a"
//          <<"   Fp_b"
//          <<"   Fp_c"
//          <<"   Fp_d"
//          <<"   Fp_e"<<'\n';
// out.FILE3<< std::setw( 7)<<xloc.Table[j].Fp_a
//          << std::setw( 7)<<xloc.Table[j].Fp_b
//          << std::setw( 7)<<xloc.Table[j].Fp_c
//          << std::setw( 7)<<xloc.Table[j].Fp_d
//          << std::setw( 7)<<xloc.Table[j].Fp_e<<'\n';
   out.VERBOSE=true;
   return;
}

void Ptra_Automatic::extern_glo(const DAT_PHYSICS_CONSTS& physics_consts,
                                const DAT_ARRAY_CONSTS& array_consts,
                                const DAT_DISULFIDE_LINKS& disulfide_links,
                                const DAT_ENERGY_PARAMS& energy_params,
                                const DAT_RESIDUE_MAPPINGS& residue_mappings,
                                const DAT_REGION_MAPS& region_maps,
                                const DAT_DEFORM_PARAMS& deform_params,
                                Structure& str,
                                Search_Subspace& sub,
                                Output_Streams& out,
                                Glo& xglo){
   out.VERBOSE=false;
   out.SHELL=false;
//
//
// set sizes
//
   int oZ0=str.nZ0;
   int oR0=(str.Z0[oZ0-1].R0a+str.Z0[oZ0-1].cR0);
//
//
// optimize search subspace for impact
//
   Search_Subspace xsub;
   str.TRA_STP(physics_consts,array_consts,energy_params,
               residue_mappings,region_maps,
               sub,xsub,out);
   Trajectory xtra;
   {
      xtra.STR2TRA( 0,str);
   }
   Family xfam;
   Thread_Options xopt;
   {
      xopt.Rcut= (999.00);
      xopt.QSUB="hot";
      xopt.nD0_final= 5;
      xopt.FUNC="ptra";
   }
//
//
// global energy minimization wrt subset of degs of free
//
   xopt.MODE="   ";
   Distance_Constraints xdst(physics_consts,residue_mappings,
                             xopt,out,str,xsub);
   xopt.iW0_active=6;
   xglo.GLO(physics_consts,array_consts,disulfide_links,
            energy_params,residue_mappings,region_maps,
            deform_params,
            xopt,out,str,xsub,xfam,xdst);
   xtra.STR2TRA( 1,str);
   str.SUP(physics_consts,out,xtra);
// str.TOR2FIL(physics_consts);
// str.CAR2FIL();
   out.VERBOSE=true;
   out.SHELL=false;
   return;
}

void Ptra_Automatic::Neighbor_Subset::populate(
                        const DAT_PHYSICS_CONSTS& physics_consts,
                        const Structure& str,
                        const Subset_Contracted_System::tM3& con){
//
//
// set sizes
//
   int oZ0=str.nZ0;
   int oR0=(str.Z0[oZ0-1].R0a+str.Z0[oZ0-1].cR0);
//
//
// (res,res) neighbor map, chain connectivity
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         for(int jZ0=iZ0;jZ0<oZ0;jZ0++){
            int aR0=str.Z0[jZ0].R0a;
            int bR0=(aR0-1+str.Z0[jZ0].cR0);
            if( jZ0==iZ0 )aR0=(iR0+ 1);
            for(int jR0=aR0;jR0<=bR0;jR0++){
               bool NEIGHBOR=( (jZ0==iZ0)&&
                               ((jR0-iR0)<6) );
               R0R0b(iR0,jR0, NEIGHBOR);
            }
         }
      }
   }
//
//
// (res,res) neighbor map, disulfide crosslinks
//
   {
      bool NEIGHBOR=true;
      for(int iS0= 0;iS0<str.nS0;iS0++){
         int iZ0=str.S0N2Z0(iS0, 0);
         int iR0=str.S0N2R0(iS0, 0);
         int mR0=str.Z0[iZ0].R0a;
         int nR0=(mR0-1+str.Z0[iZ0].cR0);
         int jZ0=str.S0N2Z0(iS0, 1);
         int jR0=str.S0N2R0(iS0, 1);
         int aR0=str.Z0[jZ0].R0a;
         int bR0=(aR0-1+str.Z0[jZ0].cR0);
         R0R0b(iR0,jR0, NEIGHBOR);
         if( iR0<nR0 ){
            R0R0b(iR0+1,jR0  , NEIGHBOR);
         }
         if( iR0>mR0 ){
            R0R0b(iR0-1,jR0  , NEIGHBOR);
         }
         if( jR0<bR0 ){
            R0R0b(iR0  ,jR0+1, NEIGHBOR);
         }
         if( jR0>aR0 ){
            R0R0b(iR0  ,jR0-1, NEIGHBOR);
         }
      }
   }
//
// (res,res) neighbor map, peptide-peptide H-bond crosslinks
// measure of stability wrt unfolded
//
   int nd(oR0- 1),na(oR0- 1);
   xfold= ( 0.00);
   for(int iR0= 0;iR0<oR0;iR0++){
      char c1=str.R0[iR0].c1;
      if( (c1!='a')&&(c1!='e') )continue;
      int mP1=str.R0[iR0].P1a;
      int nP1=(mP1-1+str.R0[iR0].cP1);
      for(int iP1=mP1;iP1<=nP1;iP1++){
         std::string atm=str.P1[iP1].atm;
         if      ( atm==" N  " ){
            R0N4P1(iR0, 0)=iP1;
         }else if( atm==" H  " ){
            R0N4P1(iR0, 1)=iP1;
         }else if( atm==" C  " ){
            R0N4P1(iR0, 2)=iP1;
         }else if( atm==" O  " ){
            R0N4P1(iR0, 3)=iP1;
         }
      }
   }
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<nR0;iR0++){
         char c1=str.R0[iR0].c1;
         if( (c1!='a')&&(c1!='e') )continue;
         int iP1=R0N4P1(iR0  , 2);
         int jP1=R0N4P1(iR0  , 3);
         if( (iP1==-1)||(jP1==-1) ){
            std::cerr<<"ERROR: Missing C--O vector.\n";
            std::exit( 2);
         }else{
            R0co(iR0)=( str.P1[iP1].x -str.P1[jP1].x).normalize();
            R0N2b(iR0, 0, false);
         }
         int kP1=R0N4P1(iR0+ 1, 0);
         int lP1=R0N4P1(iR0+ 1, 1);
         if( (kP1==-1)||(lP1==-1) ){
            nd--;
         }else{
            R0hn(iR0)=( str.P1[lP1].x -str.P1[kP1].x).normalize();
            R0N2b(iR0, 1, false);
         }
      }
   }
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<nR0;iR0++){
         char ci=str.R0[iR0].c1;
         if( (ci!='a')&&(ci!='e') )continue;
         int iP1=R0N4P1(iR0+ 1, 1);
         if( iP1==-1 )continue;
         for(int jZ0= 0;jZ0<oZ0;jZ0++){
            int aR0=str.Z0[jZ0].R0a;
            int bR0=(aR0-1+str.Z0[jZ0].cR0);
            for(int jR0=aR0;jR0<bR0;jR0++){
               char cj=str.R0[jR0].c1;
               if( (cj!='a')&&(cj!='e') )continue;
               if( (jZ0==iZ0)&&(jR0>(iR0- 2))&&(jR0<(iR0+ 3)) )continue;
               int jP1=R0N4P1(jR0  , 3);
               Coordinates v=( str.P1[jP1].x -str.P1[iP1].x);
               double R= v.r();
               if( R>( 2.75) )continue;
               v.normalize();
               double Cthe= dot(R0hn(iR0),v);
               double the= std::acos( Cthe)/physics_consts.RAD;
               if( the>(  75.00) )continue;
               double Cphi= dot(R0hn(iR0),R0co(jR0));
               double phi= std::acos( Cphi)/physics_consts.RAD;
               if( phi>(  75.00) )continue;
               R0N2b(iR0, 1, true);
               R0N2b(jR0, 0, true);
               R0R0b((iR0+ 1),jR0, true);
               if( (iR0+ 1)<nR0 ){
                  R0R0b((iR0+ 1)+1,jR0  , true);
               }
               if( (iR0+ 1)>mR0 ){
                  R0R0b((iR0+ 1)-1,jR0  , true);
               }
               if( jR0<bR0 ){
                  R0R0b((iR0+ 1)  ,jR0+1, true);
               }
               if( jR0>aR0 ){
                  R0R0b((iR0+ 1)  ,jR0-1, true);
               }
            }
         }
      }
   }
   int hd( 0),ha( 0);
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<nR0;iR0++){
         char c1=str.R0[iR0].c1;
         if( (c1!='a')&&(c1!='e') )continue;
         if( R0N2b(iR0, 0) )ha++;
         if( R0N2b(iR0, 1) )hd++;
      }
   }
   xfold= double( hd +ha)/double( nd +na);
//
//
// identify 3-14 alpha helicies
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         R0h(iR0   ,false);
      }
   }
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=(mR0+4);iR0<=nR0;iR0++){
         int iP1=R0N4P1(iR0, 1);
         if( iP1==-1 )continue;
         Coordinates u=R0hn(iR0- 1);
         int jZ0=iZ0;
         int jR0=(iR0- 4);
         int jP1=R0N4P1(jR0, 3);
         if( jP1==-1 )continue;
         Coordinates v=( str.P1[jP1].x -str.P1[iP1].x);
         double R= v.r();
         if( R>( 2.85) )continue;
         v.normalize();
         double Cthe= dot(u,v);
         double the= std::acos( Cthe)/physics_consts.RAD;
         if( the>(  75.00) )continue;
         double Cphi= dot(u,R0co(jR0));
         double phi= std::acos( Cphi)/physics_consts.RAD;
         if( phi>(  75.00) )continue;
         R0h(iR0- 3,true);
         R0h(iR0- 2,true);
         R0h(iR0- 1,true);
      }
   }
//
//
// (res,res) neighbor map, helicies
//
   {
      bool NEIGHBOR=true;
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         bool h0=false;
         int aR0(-1),bR0(-1);
         int mR0=str.Z0[iZ0].R0a;
         int nR0=(mR0-1+str.Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            bool h1=R0h(iR0);
            if( h1==h0 ){
               bR0=iR0;
            }else{
               if( h0 ){
                  for(int jR0=aR0;jR0<bR0;jR0++){
                     for(int kR0=(jR0+ 1);kR0<=bR0;kR0++){
                        R0R0b(jR0,kR0, NEIGHBOR);
                     }
                  }
               }
               h0=h1;
               aR0=iR0;
               bR0=iR0;
            }
         }
         if( h0 ){
            for(int jR0=aR0;jR0<bR0;jR0++){
               for(int kR0=(jR0+ 1);kR0<=bR0;kR0++){
                  R0R0b(jR0,kR0, NEIGHBOR);
               }
            }
         }
      }
   }
//
//
// (atm,atm) neighbor map
//
   for(int iF2= 0;iF2<(oF2- 1);iF2++){
      int iR0=con.F2[iF2].R0;
      char ci=str.R0[iR0].c1;
      if( (ci!='a')&&(ci!='e') )continue;
      std::string ai=con.F2[iF2].atm;
      if( (ai!=" N  ")&&(ai!=" CA ")&&(ai!=" C  ")&&(ai!=" H  ")&&
          (ai!=" CB ")&&(ai!=" O  ")&&(ai!=" HA ") )continue;
      for(int jF2=(iF2+ 1);jF2<oF2;jF2++){
         int jR0=con.F2[jF2].R0;
         char cj=str.R0[jR0].c1;
         if( (cj!='a')&&(cj!='e') )continue;
         std::string aj=con.F2[jF2].atm;
         if( (aj!=" N  ")&&(aj!=" CA ")&&(aj!=" C  ")&&(aj!=" H  ")&&
             (aj!=" CB ")&&(aj!=" O  ")&&(aj!=" HA ") )continue;
         bool NEIGHBOR=R0R0b(iR0,jR0);
         F2F2b(iF2,jF2, NEIGHBOR);
      }
   }
   return;
}
