#ifndef DEF_IONSTATE_AUTOMATIC
#define DEF_IONSTATE_AUTOMATIC

#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <vector>

class Ionstate_Automatic {
public:
   class tI8 { /*ionization states previously encountered*/
   public:
      Search_Subspace sub;              //associated search subspace
      Structure str;                    //associated minimized structure
      std::vector<int> o_V0N2;          //protonation state of ionizable groups
      double Fpp;                       //(Fr+Fe+Ft+Fb)
      double Fh;                        //Fh
      double Fps;                       //Fps
      double Fss;                       //Fss
      int& V0N2(int i){
         return o_V0N2.at( i);
      }
      tI8(int oV0):
         o_V0N2(oV0)
      {
      }
   };
   class tH6 { /*pH values of titration*/
   public:
      class tH6K8 { /*ionization states with lowest dG*/
      public:
         double e;                      //estimate of dG
         std::vector<int> o_V0N2;       //path through ionization state
         int I8;                        //index into set of ionization states
         double g;                      //dg(pH) sum for model compounds
         double dF;                     //dF=f(ionstate)-f(full)-f(pept)
         double pp;                     //(Fr+Fe+Ft+Fb)
         double h;                      //Fh
         double ps;                     //Fps
         double ss;                     //Fss
         bool EVAL;                     //evaluation of Fpp, Fh, Fps, Fss
         double dG;                     //dG
         double p;                      //statistical wt
         int& V0N2(int i){
            return o_V0N2.at( i);
         }
         tH6K8(int oV0):
            e( 1.00e+8),o_V0N2(oV0,-1),g( 0.00),EVAL(false)
         {
         }
      };
   private:
      std::vector<double> o_V0p;        //ionization state
   public:
      double pH;                        //pH
      int nK8;                          //number of ionization states
      std::vector<tH6::tH6K8> K8;       //set of ionization states
      int jK8;                          //optimal ionization state
      double dGmin;                     //min of dG over K8
      double s;                         //entropic contribution to dG
      double& V0p(int i){
         return o_V0p.at( i);
      }
      tH6(int oV0,double h):
         o_V0p(oV0),
         pH( h),
         nK8( 0),
         jK8(-1),
         dGmin( 1.00e+8)
      {
      }
   };
   class tL { /*occurance of type in residue sequence with locked ionization
                state*/
   public:
      int R0;                           //index of residue
      tL(){}
   };
   class tT { /*types of ionizable group*/
   public:
      double g;                         //displacement to peptide d(Fe+Fm)
      double f;                         //peptide d(Fe+Fm)
      int nL;                           //
      std::vector<tL> L;                //occurances with locked ion state
      double pK;                        //expt value
      double sgn;                       //
      tT():nL( 0){}
   };

public:
   std::vector<tT> T;                   //types of ionizable group
   std::vector<int> o_V0N2;             //path through ionization states
   std::vector<tI8> I8;                 //set of unique ionization states
   std::vector<tH6> H6;                 //set of pH values
   std::vector<tH6::tH6K8> K8;          //ionization states with low dG
/*protein environment modulation of peptide df*/
   std::vector<double> o_zV0f;          //df( 1bod deprot -full prot) -de(pept)
   int o_V0;                            //number of ionizable groups
   std::vector<double> o_zV0V0f;        //df( 2bod deprot -full prot -1bod)
   std::vector<double> o_zV0V0r;        //distance between residues (angstrom)
/*dead end combinatorial search through ionstates*/
   std::vector<double> o_V0N2f;         //path 1bod impulses, zV0f -dg(pH)
   std::vector<double> o_V0V0f;         //lower bound on path 2bod impulses
   std::vector<double> o_V0N2V0f;       //lower bound on path 2bod impulses
   std::vector<double> o_V0N2V0N2f;     //path 2bod plus 1bod impulses
   std::vector<double> o_V0g;           //model dG of partial path
   std::vector<double> o_V0h;           //min dG for remainder of path
   std::vector<double> o_K8f;           //displacement to pept d(Fe+Fm) of path
   std::vector<double> o_K8h;           //hbond contribution to path
/*sort*/
   std::vector<int> o_K8ord;            //
   std::vector<int> o_K8inv;            //
   std::vector<char> o_V0a1;            //header string of 1-char res names
   std::vector<double> o_H6g;           //dG from locked ionizable groups
   Ionstate_Automatic(int oT):
      T(oT)
   {
   }
   int& V0N2(int i){
      return o_V0N2.at( i);  }
   double& zV0f(int i){
      return o_zV0f.at( i);  }
   double& zV0V0f(int i,int j){
      return o_zV0V0f.at( i*o_V0 +j);  }
   double& zV0V0r(int i,int j){
      return o_zV0V0r.at( i*o_V0 +j);  }
   double& V0N2f(int i,int j){
      return o_V0N2f.at( i*2 +j);  }
   double& V0V0f(int i,int j){
      return o_V0V0f.at( i*o_V0 +j);  }
   double& V0N2V0f(int i,int j,int k){
      return o_V0N2V0f.at( i*2*o_V0 +j*o_V0 +k);  }
   double& V0N2V0N2f(int i,int j,int k,int l){
      return o_V0N2V0N2f.at( i*2*o_V0*2 +j*o_V0*2 +k*2 +l);  }
   double& V0g(int i){
      return o_V0g.at( i);  }
   double& V0h(int i){
      return o_V0h.at( i);  }
   double& K8f(int i){
      return o_K8f.at( i);  }
   double& K8h(int i){
      return o_K8h.at( i);  }
   int& K8ord(int i){
      return o_K8ord.at( i);  }
   int& K8inv(int i){
      return o_K8inv.at( i);  }
   char& V0a1(int i){
      return o_V0a1.at( i);  }
   double& H6g(int i){
      return o_H6g.at( i);  }

   void populate(Search_Subspace& msub,
                 Structure& mstr,
                 const DAT_PHYSICS_CONSTS& physics_consts,
                 const DAT_RESIDUE_MAPPINGS& residue_mappings,
                 const DAT_REGION_MAPS& region_maps,
                 Output_Streams& out,
                 const Structure& str,
                 bool REDUCE);
   void evaluate(double&  Fr,double&  Fe,double&  Ft,double&  Fb,
                 double&  Fh,double& Fps,double& Fss,
                 const DAT_PHYSICS_CONSTS& physics_consts,
                 const DAT_ARRAY_CONSTS& array_consts,
                 const DAT_DISULFIDE_LINKS& disulfide_links,
                 const DAT_ENERGY_PARAMS& energy_params,
                 const DAT_RESIDUE_MAPPINGS& residue_mappings,
                 const DAT_REGION_MAPS& region_maps,
                 Thread_Options& opt,
                 Output_Streams& out,
                 const Search_Subspace& sub,
                 Structure& str);
};

#endif
