#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../dst/Distance_Constraints.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../loc/Loc.hh"
#include "../loc/Loc_Automatic.hh"
#include "../med/Dielec_Continu.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi_Automatic.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Ionstate_Automatic.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <iostream>
#include <cmath>

void Ionstate_Automatic::populate(Search_Subspace& msub,
                                  Structure& mstr,
                                  const DAT_PHYSICS_CONSTS& physics_consts,
                                  const DAT_RESIDUE_MAPPINGS& residue_mappings,
                                  const DAT_REGION_MAPS& region_maps,
                                  Output_Streams& out,
                                  const Structure& str,
                                  bool REDUCE){
   int oZ0=str.nZ0;
//
//
// initiate ionization state Search_Subspace object
//
   int oR1=0;
   int jV0=0;
   for(int iZ0=0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<(mR0+1);iR0++){
         char c1=str.R0[iR0].c1;
         std::string aa=str.R0[iR0].aa;
         if      ( c1=='a' ){
            if( (aa[0]!='e')&&(aa[0]!='z') )continue;
            bool IONIZABLE=false;
            bool LOCKED=false;
            int oL=T[ 0].L.size();
            for(int iL=0;iL<oL;iL++){
               if( T[ 0].L[iL].R0==iR0 )LOCKED=true;
            }
            if( !LOCKED ){
               IONIZABLE=true;
               aa[0]=( V0N2(jV0++)==0 )? 'e': 'z';
               msub.R1.push_back(Search_Subspace::tR1());
               msub.R1[oR1].Z0=iZ0;
               msub.R1[oR1].R0=iR0;
               msub.R1[oR1].L0=residue_mappings.iresidue( aa);
               msub.R1[oR1++].aa=aa;
            }
            std::string ab=aa.substr(1,3);
            if      ( (ab=="ASP")||(ab=="ASZ") ){
               LOCKED=false;
               oL=T[ 1].L.size();
               for(int iL=0;iL<oL;iL++){
                  if( T[ 1].L[iL].R0==iR0 )LOCKED=true;
               }
               if( LOCKED )continue;
               aa[3]=( V0N2(jV0++)==0 )? 'Z': 'P';
            }else if( (ab=="CYH")||(ab=="CYZ") ){
               LOCKED=false;
               oL=T[ 2].L.size();
               for(int iL=0;iL<oL;iL++){
                  if( T[ 2].L[iL].R0==iR0 )LOCKED=true;
               }
               if( LOCKED )continue;
               aa[3]=( V0N2(jV0++)==0 )? 'H': 'Z';
            }else if( (ab=="GLU")||(ab=="GLZ") ){
               LOCKED=false;
               oL=T[ 3].L.size();
               for(int iL=0;iL<oL;iL++){
                  if( T[ 3].L[iL].R0==iR0 )LOCKED=true;
               }
               if( LOCKED )continue;
               aa[3]=( V0N2(jV0++)==0 )? 'Z': 'U';
            }else if( (ab=="HIS")||(ab=="HIP") ){
               LOCKED=false;
               oL=T[ 4].L.size();
               for(int iL=0;iL<oL;iL++){
                  if( T[ 4].L[iL].R0==iR0 )LOCKED=true;
               }
               if( LOCKED )continue;
               aa[3]=( V0N2(jV0++)==0 )? 'P': 'S';
            }else if( (ab=="LYS")||(ab=="LYZ") ){
               LOCKED=false;
               oL=T[ 5].L.size();
               for(int iL=0;iL<oL;iL++){
                  if( T[ 5].L[iL].R0==iR0 )LOCKED=true;
               }
               if( LOCKED )continue;
               aa[3]=( V0N2(jV0++)==0 )? 'S': 'Z';
            }else if( (ab=="TYR")||(ab=="TYZ") ){
               LOCKED=false;
               oL=T[ 6].L.size();
               for(int iL=0;iL<oL;iL++){
                  if( T[ 6].L[iL].R0==iR0 )LOCKED=true;
               }
               if( LOCKED )continue;
               aa[3]=( V0N2(jV0++)==0 )? 'R': 'Z';
            }else if( ab=="HIE" ){
               LOCKED=false;
               oL=T[ 8].L.size();
               for(int iL=0;iL<oL;iL++){
                  if( T[ 8].L[iL].R0==iR0 )LOCKED=true;
               }
               if( LOCKED )continue;
               aa[3]=( V0N2(jV0++)==0 )? 'P': 'E';
            }else{
               continue;
            }
            if( IONIZABLE ){
               msub.R1[oR1-1].L0=residue_mappings.iresidue( aa);
               msub.R1[oR1-1].aa=aa;
            }else{
               msub.R1.push_back(Search_Subspace::tR1());
               msub.R1[oR1].Z0=iZ0;
               msub.R1[oR1].R0=iR0;
               msub.R1[oR1].L0=residue_mappings.iresidue( aa);
               msub.R1[oR1++].aa=aa;
            }
         }else if( c1=='e' ){
         }else if( c1=='r' ){
         }else if( c1=='b' ){
         }else if( c1=='p' ){
         }else if( c1=='s' ){
         }
      }
      for(int iR0=(mR0+1);iR0<nR0;iR0++){
         char c1=str.R0[iR0].c1;
         std::string aa=str.R0[iR0].aa;
         if      ( c1=='a' ){
            if      ( (aa=="ASP ")||(aa=="ASZ ") ){
               bool LOCKED=false;
               int oL=T[ 1].L.size();
               for(int iL=0;iL<oL;iL++){
                  if( T[ 1].L[iL].R0==iR0 )LOCKED=true;
               }
               if( LOCKED )continue;
               aa[2]=( V0N2(jV0++)==0 )? 'Z': 'P';
            }else if( (aa=="CYH ")||(aa=="CYZ ") ){
               bool LOCKED=false;
               int oL=T[ 2].L.size();
               for(int iL=0;iL<oL;iL++){
                  if( T[ 2].L[iL].R0==iR0 )LOCKED=true;
               }
               if( LOCKED )continue;
               aa[2]=( V0N2(jV0++)==0 )? 'H': 'Z';
            }else if( (aa=="GLU ")||(aa=="GLZ ") ){
               bool LOCKED=false;
               int oL=T[ 3].L.size();
               for(int iL=0;iL<oL;iL++){
                  if( T[ 3].L[iL].R0==iR0 )LOCKED=true;
               }
               if( LOCKED )continue;
               aa[2]=( V0N2(jV0++)==0 )? 'Z': 'U';
            }else if( (aa=="HIS ")||(aa=="HIP ") ){
               bool LOCKED=false;
               int oL=T[ 4].L.size();
               for(int iL=0;iL<oL;iL++){
                  if( T[ 4].L[iL].R0==iR0 )LOCKED=true;
               }
               if( LOCKED )continue;
               aa[2]=( V0N2(jV0++)==0 )? 'P': 'S';
            }else if( (aa=="LYS ")||(aa=="LYZ ") ){
               bool LOCKED=false;
               int oL=T[ 5].L.size();
               for(int iL=0;iL<oL;iL++){
                  if( T[ 5].L[iL].R0==iR0 )LOCKED=true;
               }
               if( LOCKED )continue;
               aa[2]=( V0N2(jV0++)==0 )? 'S': 'Z';
            }else if( (aa=="TYR ")||(aa=="TYZ ") ){
               bool LOCKED=false;
               int oL=T[ 6].L.size();
               for(int iL=0;iL<oL;iL++){
                  if( T[ 6].L[iL].R0==iR0 )LOCKED=true;
               }
               if( LOCKED )continue;
               aa[2]=( V0N2(jV0++)==0 )? 'R': 'Z';
            }else if( aa=="HIE " ){
               bool LOCKED=false;
               int oL=T[ 8].L.size();
               for(int iL=0;iL<oL;iL++){
                  if( T[ 8].L[iL].R0==iR0 )LOCKED=true;
               }
               if( LOCKED )continue;
               aa[2]=( V0N2(jV0++)==0 )? 'P': 'E';
            }else{
               continue;
            }
            msub.R1.push_back(Search_Subspace::tR1());
            msub.R1[oR1].Z0=iZ0;
            msub.R1[oR1].R0=iR0;
            msub.R1[oR1].L0=residue_mappings.iresidue( aa);
            msub.R1[oR1++].aa=aa;
         }else if( c1=='e' ){
         }else if( c1=='r' ){
         }else if( c1=='b' ){
         }else if( c1=='p' ){
         }else if( c1=='s' ){
         }
      }
      for(int iR0=nR0;iR0<(nR0+1);iR0++){
         char c1=str.R0[iR0].c1;
         std::string aa=str.R0[iR0].aa;
         if      ( c1=='a' ){
            if( (aa[3]!='e')&&(aa[3]!='z') )continue;
            bool IONIZABLE=false;
            bool LOCKED=false;
            int oL=T[ 7].L.size();
            for(int iL=0;iL<oL;iL++){
               if( T[ 7].L[iL].R0==iR0 )LOCKED=true;
            }
            if( !LOCKED ){
               IONIZABLE=true;
               aa[3]=( V0N2(jV0++)==0 )? 'z': 'e';
               if( (oR1> 0)&&(msub.R1[oR1-1].R0==(iR0-1)) ){
               }else{
                  msub.R1.push_back(Search_Subspace::tR1());
                  msub.R1[oR1].Z0=iZ0;
                  msub.R1[oR1].R0=(iR0-1);
                  msub.R1[oR1].L0=str.R0[iR0-1].L0;
                  msub.R1[oR1++].aa=str.R0[iR0-1].aa;
               }
               msub.R1.push_back(Search_Subspace::tR1());
               msub.R1[oR1].Z0=iZ0;
               msub.R1[oR1].R0=iR0;
               msub.R1[oR1].L0=residue_mappings.iresidue( aa);
               msub.R1[oR1++].aa=aa;
            }
            std::string ab=aa.substr(0,3);
            if      ( (ab=="ASP")||(ab=="ASZ") ){
               LOCKED=false;
               oL=T[ 1].L.size();
               for(int iL=0;iL<oL;iL++){
                  if( T[ 1].L[iL].R0==iR0 )LOCKED=true;
               }
               if( LOCKED )continue;
               aa[2]=( V0N2(jV0++)==0 )? 'Z': 'P';
            }else if( (ab=="CYH")||(ab=="CYZ") ){
               LOCKED=false;
               oL=T[ 2].L.size();
               for(int iL=0;iL<oL;iL++){
                  if( T[ 2].L[iL].R0==iR0 )LOCKED=true;
               }
               if( LOCKED )continue;
               aa[2]=( V0N2(jV0++)==0 )? 'H': 'Z';
            }else if( (ab=="GLU")||(ab=="GLZ") ){
               LOCKED=false;
               oL=T[ 3].L.size();
               for(int iL=0;iL<oL;iL++){
                  if( T[ 3].L[iL].R0==iR0 )LOCKED=true;
               }
               if( LOCKED )continue;
               aa[2]=( V0N2(jV0++)==0 )? 'Z': 'U';
            }else if( (ab=="HIS")||(ab=="HIP") ){
               LOCKED=false;
               oL=T[ 4].L.size();
               for(int iL=0;iL<oL;iL++){
                  if( T[ 4].L[iL].R0==iR0 )LOCKED=true;
               }
               if( LOCKED )continue;
               aa[2]=( V0N2(jV0++)==0 )? 'P': 'S';
            }else if( (ab=="LYS")||(ab=="LYZ") ){
               LOCKED=false;
               oL=T[ 5].L.size();
               for(int iL=0;iL<oL;iL++){
                  if( T[ 5].L[iL].R0==iR0 )LOCKED=true;
               }
               if( LOCKED )continue;
               aa[2]=( V0N2(jV0++)==0 )? 'S': 'Z';
            }else if( (ab=="TYR")||(ab=="TYZ") ){
               LOCKED=false;
               oL=T[ 6].L.size();
               for(int iL=0;iL<oL;iL++){
                  if( T[ 6].L[iL].R0==iR0 )LOCKED=true;
               }
               if( LOCKED )continue;
               aa[2]=( V0N2(jV0++)==0 )? 'R': 'Z';
            }else if( ab=="HIE" ){
               LOCKED=false;
               oL=T[ 8].L.size();
               for(int iL=0;iL<oL;iL++){
                  if( T[ 8].L[iL].R0==iR0 )LOCKED=true;
               }
               if( LOCKED )continue;
               aa[2]=( V0N2(jV0++)==0 )? 'P': 'E';
            }else{
               continue;
            }
            if( IONIZABLE ){
               msub.R1[oR1-1].L0=residue_mappings.iresidue( aa);
               msub.R1[oR1-1].aa=aa;
            }else{
               if( (oR1> 0)&&(msub.R1[oR1-1].R0==(iR0-1)) ){
               }else{
                  msub.R1.push_back(Search_Subspace::tR1());
                  msub.R1[oR1].Z0=iZ0;
                  msub.R1[oR1].R0=(iR0-1);
                  msub.R1[oR1].L0=str.R0[iR0-1].L0;
                  msub.R1[oR1++].aa=str.R0[iR0-1].aa;
               }
               msub.R1.push_back(Search_Subspace::tR1());
               msub.R1[oR1].Z0=iZ0;
               msub.R1[oR1].R0=iR0;
               msub.R1[oR1].L0=residue_mappings.iresidue( aa);
               msub.R1[oR1++].aa=aa;
            }
         }else if( c1=='e' ){
         }else if( c1=='r' ){
         }else if( c1=='b' ){
         }else if( c1=='p' ){
         }else if( c1=='s' ){
         }
      }
   }
   msub.nR1=oR1;
//
//
// populate ionization state Structure object
//
   mstr.fam=str.fam;
   mstr.mol=str.mol;
   mstr.cnf=str.cnf;
   mstr.nZ0=oZ0;
   for(int iZ0=0;iZ0<oZ0;iZ0++){
      mstr.Z0.push_back( Structure::tZ0());
      mstr.Z0[iZ0].R0a=str.Z0[iZ0].R0a;
      mstr.Z0[iZ0].cR0=str.Z0[iZ0].cR0;
      mstr.Z0[iZ0].trans=str.Z0[iZ0].trans;
      mstr.Z0[iZ0].rot=str.Z0[iZ0].rot;
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         mstr.R0.push_back( Structure::tR0());
         mstr.R0[iR0].aa=str.R0[iR0].aa;
         mstr.R0[iR0].L0=str.R0[iR0].L0;
         mstr.R0[iR0].c1=str.R0[iR0].c1;
         mstr.R0[iR0].cha=str.R0[iR0].cha;
         mstr.R0[iR0].res=str.R0[iR0].res;
         mstr.R0[iR0].ins=str.R0[iR0].ins;
         mstr.R0[iR0].core=str.R0[iR0].core;
      }
   }
   for(int jR1= 0;jR1<oR1;jR1++){
      int jR0=msub.R1[jR1].R0;
      mstr.R0[jR0].aa=msub.R1[jR1].aa;
      mstr.R0[jR0].L0=msub.R1[jR1].L0;
   }
   mstr.nS0=str.nS0;
   for(int iS0=0;iS0<str.nS0;iS0++){
      mstr.S0.push_back( Structure::tS0());
      for(int iN2=0;iN2<2;iN2++){
         mstr.o_S0N2Z0.push_back( str.S0N2Z0(iS0,iN2));
         mstr.o_S0N2R0.push_back( str.S0N2R0(iS0,iN2));
      }
   }
   int iT1=0;
   int iP1=0;
   for(int iZ0=0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int iL0=mstr.R0[iR0].L0;
         int mT0=residue_mappings.L0[iL0].T0a;
         int nT0=(mT0-1+residue_mappings.L0[iL0].cT0);
         mstr.R0[iR0].T1a=iT1;
         mstr.R0[iR0].cT1=(nT0-mT0+1);
         for(int iT0=mT0;iT0<=nT0;iT0++){
            mstr.T1.push_back( Structure::tT1());
            mstr.T1[iT1].tor=residue_mappings.T0[iT0].tor;
            iT1++;
         }
         int mP0=residue_mappings.L0[iL0].P0a;
         int nP0=(mP0-1+residue_mappings.L0[iL0].cP0);
         mstr.R0[iR0].P1a=iP1;
         mstr.R0[iR0].cP1=(nP0-mP0+1);
         for(int iP0=mP0;iP0<=nP0;iP0++){
            mstr.P1.push_back( Structure::tP1());
            mstr.P1[iP1].atm=residue_mappings.P0[iP0].atm;
            mstr.P1[iP1].typ=residue_mappings.P0[iP0].typ;
            mstr.P1[iP1].sc=residue_mappings.P0[iP0].sc;
            mstr.P1[iP1].sub=0;
            iP1++;
         }
      }
   }
   for(int iZ0=0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         bool MUTATION=( mstr.R0[iR0].L0!=str.R0[iR0].L0 );
         int mP1=mstr.R0[iR0].P1a;
         int nP1=(mP1-1+mstr.R0[iR0].cP1);
         int aP1=str.R0[iR0].P1a;
         int bP1=(aP1-1+str.R0[iR0].cP1);
         if( MUTATION ){
            for(iP1=mP1;iP1<=nP1;iP1++){
               std::string atm=mstr.P1[iP1].atm;
               for(int jP1=aP1;jP1<=bP1;jP1++){
                  if( str.P1[jP1].atm==atm ){
                     mstr.P1[iP1].sub=1;
                     mstr.P1[iP1].x=str.P1[jP1].x;
                     break;
                  }
               }
            }

         }else{
            for(iP1=mP1;iP1<=nP1;iP1++){
               mstr.P1[iP1].sub=1;
               mstr.P1[iP1].x=str.P1[iP1-mP1+aP1].x;
            }

         }
      }
   }
//
//
// regularize ionization state structure
//
   mstr.REG(physics_consts,residue_mappings,out);
   mstr.POLARH(physics_consts,residue_mappings);
   mstr.TOR(physics_consts,residue_mappings);
   mstr.CAR(physics_consts,residue_mappings);
   mstr.STA(physics_consts,region_maps);
//
//
// populate ionization state Search_Subspace object
//
   for(int jR1=0;jR1<oR1;jR1++){
      std::string aa=msub.R1[jR1].aa;
      msub.R1[jR1].bb=( ((aa[0]=='e')&&(!REDUCE))||(aa[0]=='z')||
                        (aa[3]=='e')||((aa[3]=='z')&&(!REDUCE)) )? 1: 0;
      if( (aa[0]=='e')||(aa[0]=='z') )aa=aa.substr(1,3)+' ';
      if( (aa[3]=='e')||(aa[3]=='z') )aa=aa.substr(0,3)+' ';
      msub.R1[jR1].sc=( ((aa=="ASZ ")&&(!REDUCE))||(aa=="ASP ")||
                        ((aa=="GLZ ")&&(!REDUCE))||(aa=="GLU ")||
                        ((aa=="HIP ")&&(!REDUCE))||(aa=="HIS ")||
                        (aa=="HIE ")||
                        ((aa=="TYR ")&&(!REDUCE))||(aa=="TYZ ")||
                        ((aa=="LYS ")&&(!REDUCE))||(aa=="LYZ ")||
                        ((aa=="CYH ")&&(!REDUCE))||(aa=="CYZ ") )? 1: 0;
      msub.R1[jR1].pt=0;
   }
   msub.mBOD=0;
   int mT5=0;
   for(int jR1=0;jR1<oR1;jR1++){
      int iR0=msub.R1[jR1].R0;
      msub.R1[jR1].T5a=mT5;
      msub.R1[jR1].cT5=mstr.R0[iR0].cT1;
      int mT1=mstr.R0[iR0].T1a;
      int nT1=(mT1-1+mstr.R0[iR0].cT1);
      for(iT1=mT1;iT1<=nT1;iT1++){
         msub.T5.push_back( Search_Subspace::tT5());
         msub.T5[iT1-mT1+mT5].tor=mstr.T1[iT1].tor;
      }
      mT5+=msub.R1[jR1].cT5;
   }
   for(int jR1=0;jR1<oR1;jR1++){
      int iR0=msub.R1[jR1].R0;
      int mP1=mstr.R0[iR0].P1a;
      int nP1=(mP1-1+mstr.R0[iR0].cP1);
      for(iP1=mP1;iP1<=nP1;iP1++){
         if( mstr.P1[iP1].sub==0 )continue;
         std::string atm=mstr.P1[iP1].atm;
         if      ( atm==" CA " ){
            msub.R1[jR1].ca=mstr.P1[iP1].x;
         }else if( atm==" CB " ){
            msub.R1[jR1].cb=mstr.P1[iP1].x;
         }
      }
   }
   return;
}

void Ionstate_Automatic::evaluate(
              double&  Fr,double&  Fe,double&  Ft,double&  Fb,
              double&  Fh,double& Fps,double& Fss,
              const DAT_PHYSICS_CONSTS& physics_consts,
              const DAT_ARRAY_CONSTS& array_consts,
              const DAT_DISULFIDE_LINKS& disulfide_links,
              const DAT_ENERGY_PARAMS& energy_params,
              const DAT_RESIDUE_MAPPINGS& residue_mappings,
              const DAT_REGION_MAPS& region_maps,
              Thread_Options& opt,
              Output_Streams& out,
              const Search_Subspace& sub,
              Structure& str){
   int oZ0=str.nZ0;
   int oR0=(str.Z0[oZ0-1].R0a+str.Z0[oZ0-1].cR0);
   int oQ1=oZ0;
   int oU1=0;
   int oF1=0;
   int oB1=0;
   int oG1=0;
   int oH1=0;
   int oJ1=0;
   int oY1=0;
   for(int iR0= 0;iR0<oR0;iR0++){
      int iL0=str.R0[iR0].L0;
      oQ1+=residue_mappings.L0[iL0].cQ0;
      oU1+=residue_mappings.L0[iL0].cU0;
      oF1+=residue_mappings.L0[iL0].cF0;
      oB1+=residue_mappings.L0[iL0].cB0;
      oG1+=residue_mappings.L0[iL0].cG0;
      oH1+=residue_mappings.L0[iL0].cH0;
      oJ1+=residue_mappings.L0[iL0].cJ0;
      oY1+=residue_mappings.L0[iL0].cY0;
   }
//
//
// dependence of dielectric constant on q
//
   double z= (1.00);
   {
      double q= (0.00);
      double qm= (0.00);
      double qp= (0.00);
      for(int iR0= 0;iR0<oR0;iR0++){
         std::string aa=str.R0[iR0].aa;
         std::string ab=str.R0[iR0].aa;
         if( (ab[0]=='e')||(ab[0]=='z') )ab=ab.substr(1,3)+' ';
         if( (ab[3]=='e')||(ab[3]=='z') )ab=ab.substr(0,3)+' ';
         if( aa[0]=='e' ){
            q++;
            qp++;
         }
         if      ( (ab=="ASP ")||(ab=="GLU ")||(ab=="TYZ ")||(ab=="CYZ ")||
                   (ab=="PO  ")||(ab=="PSR ")||(ab=="PSS ")||(ab=="GM  ")||
                   (ab=="TM  ")||(ab=="UM  ") ){
            q--;
            qm++;
         }else if( (ab=="LYS ")||(ab=="ARG ")||(ab=="ORN ")||(ab=="HIP ")||
                   (ab=="AP  ")||(ab=="GP  ")||(ab=="CP  ") ){
            q++;
            qp++;
         }else if( (ab=="5PO ")||(ab=="3PO ") ){
            q-=(2.00);
            qm+=(2.00);
         }
         if( aa[3]=='e' ){
            q--;
            qm++;
         }
      }
      if( q<(0.00) ){
         double v= double( oR0);
         double r3= ((3.)*v*(140.00))/((4.)*physics_consts.PI);
         double r= std::exp( std::log( r3)/(3.));
         double a= (4.)*physics_consts.PI
                  *std::pow(( r -(2.5962))/(5.1925), 2);
         double n= physics_consts.CAL*physics_consts.ANG
                  *( q*q)/r;
         double d=( n +a*( 8.00) +physics_consts.CAL*physics_consts.ANG
                                 *(.50)*( qm/(3.40) +qp/(3.80))
                    );
         z=( (1.00) -(.0375)*n/d);
      }
   }
//
//
// F for ionization state
//
   opt.MODE="lp ";
   Distance_Constraints dst(physics_consts,residue_mappings,
                            opt,out,str,sub);
   Mechanical_System mol(oZ0,oR0,oQ1,oU1,oF1,oB1,oG1,oH1,oJ1,oY1);
   Subset_Contracted_System col(disulfide_links,residue_mappings,
                                opt,str,sub);
   Conf_Dependent_System dep(oZ0,oQ1,oF1,oG1,oJ1,oY1);
   mol.SET(physics_consts,array_consts,energy_params,residue_mappings,
           opt,str,out,dst,col,dep);
   mol.CON(physics_consts,array_consts,energy_params,
           region_maps,
           opt,out,col,dep);
   int oM3= 1;
   const Subset_Contracted_System::tM3& con=col.M3[ 0];
   int oQ2=con.oQ2;
   int oF2=con.oF2;
   int oE1=con.oE1;
   int oU2=(con.oU2+6);
   int oA5=con.oA5;
   Energy_Surface2 ene(oZ0,oR0,oQ2,oF2,oE1,oU2);
   int oM2=2048;
   Local_Minimization2 loc(oM2,oM3);
   {
      loc.M3BETA( 0)= (2.00e-02);
      loc.iM3=0;
   }
   Loc xloc;
   Loc_Automatic aut(oZ0,oQ1,oF1,oG1,oQ2);
   Phi_Automatic ph2(con);
   xloc.LOC_Q2(aut,
               array_consts,energy_params,
               mol,con,dep,ene);
   xloc.LOC_U2(aut,
               mol,con,dep,ene,loc);
   xloc.LOC_F2(aut,
               mol,con,dep);
   ene.RECYCLE=false;
   loc.nM2=64;
   ene.QMEDIUM=true;
   ene.QFAC(ph2,
            physics_consts,
            out,mol,con,dep);
   opt.MODE="bb ";
   std::cout<<"LOCAL MINIMIZATION TRAJECTORY"<< std::endl;
   loc.MOV(ph2,
           physics_consts,array_consts,energy_params,
           region_maps,
           opt,out,mol,con,dep,ene);
   opt.MODE="loc";
   loc.WRT(physics_consts,residue_mappings,
           opt,out,str,mol,con,dep,ene);
   opt.MODE="bb ";
   str.CAR(physics_consts,residue_mappings);

   ene.RECYCLE=false;
   ene.ethresh= (1.00e-5);
   Dielec_Continu med(oQ2,oF2,oA5,oR0);
   {
      med.bse_nA5=0;
   }
   ene.QMEDIUM=false;
   ene.QFAC(ph2,
            physics_consts,
            out,mol,con,dep);
   std::cout<<"SINGLE POINT FULL ENERGY"<< std::endl;
   ene.PHIG(ph2,
            physics_consts,array_consts,energy_params,
            region_maps,
            opt,out,mol,con,dep);
   ene.Fr*= physics_consts.CAL;
   ene.Fe*= physics_consts.CAL;
   ene.Fs*= physics_consts.CAL;
   ene.Ft*= physics_consts.CAL;
   ene.Fc*= physics_consts.CAL;
   ene.Fb*= physics_consts.CAL;
   ene.Fh*= physics_consts.CAL;
   ene.Fw*=physics_consts.CAL;         //here Fw is zero
   ene.Fp*=physics_consts.CAL;
// ene.Fp_a*=physics_consts.CAL;
// ene.Fp_b*=physics_consts.CAL;
// ene.Fp_c*=physics_consts.CAL;
// ene.Fp_d*=physics_consts.CAL;
// ene.Fp_e*=physics_consts.CAL;
   ene.MED(ph2,med,
           physics_consts,array_consts,energy_params,
           opt,out,str,mol,con,dep);
   opt.MODE="lp ";
   med.Fps*=z;
   med.Fss*=z;
   med.Fps*=physics_consts.CAL;
   med.Fss*=physics_consts.CAL;
   ene.Fm=( energy_params.fac_ps*med.Fps
           +energy_params.fac_ss*med.Fss);

   Fr= ene.Fr;
   Fe= ene.Fe;
   Ft= ene.Ft;
   Fb= ene.Fb;
   Fh= ene.Fh;
   Fps= med.Fps;
   Fss= med.Fss;
   return;
}
