#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../glo/Backbone_Defs.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Gaussian_Volume.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include <vector>
#include <cmath>

class MEM_shf_sco {
private:
   std::vector<int> o_R0i;              //
   std::vector<Coordinates> o_R0x;      //
public:
   MEM_shf_sco(int o):
      o_R0i(o, 0),
      o_R0x(o)
   {
   }
   int& R0i(int i){
      return o_R0i.at( i);  }
   Coordinates& R0x(int i){
      return o_R0x.at( i);  }
};

void Backbone_Defs::SHF_SCO(const DAT_PHYSICS_CONSTS& physics_consts,
                            const DAT_RESIDUE_MAPPINGS& residue_mappings,
                            const Search_Subspace& sub,
                            const Mechanical_System& mol,
                            const Subset_Contracted_System::tM3& con,
                            Energy_Surface4& ene,
                            int iJ3){
   int oZ0=mol.nZ0;
   int oR0=( mol.Z0[oZ0-1].R0a +mol.Z0[oZ0-1].cR0);
   MEM_shf_sco vv(oR0);
//
//
// construct displacement map
//
   for(int iZ2= 0;iZ2<nZ2;iZ2++){
      int shf1=Z2[iZ2].J3[iJ3].shf1;
      int shf2=Z2[iZ2].J3[iJ3].shf2;
      if( (shf1==0)&&(shf2==0) )continue;
      int iR1=Z2[iZ2].CYC;
      int aR0=sub.R1[iR1].R0;
      int bR0=(aR0-1+sub.R1[iR1].pt);
      if( shf1!=0 ){
         int jR1=Z2[iZ2-1].CYC;
         int cR0=(sub.R1[jR1].R0+sub.R1[jR1].pt);
         for(int iR0=cR0;iR0<aR0;iR0++){
            vv.R0i(iR0)=shf1;
         }
      }
      if      ( shf2==shf1 ){
         for(int iR0=aR0;iR0<=bR0;iR0++){
            vv.R0i(iR0)=shf1;
         }
      }else if( shf2> shf1 ){
         int pR0=(aR0-1+(sub.R1[iR1].pt/2));
         int qR0=(bR0+1-(sub.R1[iR1].pt/2));
         for(int iR0=aR0;iR0<=pR0;iR0++){
            vv.R0i(iR0)=shf1;
         }
         vv.R0i(pR0+1)=9999;
         for(int iR0=qR0;iR0<=bR0;iR0++){
           vv.R0i(iR0)=shf2;
         }
      }else if( shf2< shf1 ){
         int pR0=(aR0-1+(sub.R1[iR1].pt/2)-2);
         int qR0=(bR0+1-(sub.R1[iR1].pt/2)+2);
         for(int iR0=aR0;iR0<=pR0;iR0++){
            vv.R0i(iR0)=shf1;
         }
         vv.R0i(pR0+1)=9999;
         vv.R0i(pR0+2)=9999;
         vv.R0i(pR0+3)=9999;
         vv.R0i(pR0+4)=9999;
         vv.R0i(pR0+5)=9999;
         for(int iR0=qR0;iR0<=bR0;iR0++){
           vv.R0i(iR0)=shf2;
         }
      }
   }
//
//
// generate coords for interaction sites
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( vv.R0i(iR0)==9999 )continue;
         int iL0=mol.R0[iR0].L0;
         int aR0=(iR0+vv.R0i(iR0));
         int jF2=con.R0N6F2(aR0,0);
         int iF2=con.R0N6F2(aR0,1);
         int kF2=con.R0N6F2(aR0,2);

         double r= residue_mappings.L0[iL0].dst;
         double the=( physics_consts.PI -residue_mappings.L0[iL0].lam);
         double phi= residue_mappings.L0[iL0].chi;
         double CT= std::cos( the);
         double ST= std::sin( the);
         double CP= std::cos( phi);
         double SP= std::sin( phi);

         Coordinates zU=( F2x(iF2) -F2x(jF2)).normalize();
         Coordinates zV=( F2x(kF2) -F2x(jF2));
         double zVU= dot(zV,zU);
         zV-=(zVU*zU);
         zV.normalize();
         Coordinates zW= cross(zU,zV);

         Rotation_Matrix B;
         B(0,0)= zU(0);
         B(1,0)= zU(1);
         B(2,0)= zU(2);
         B(0,1)= zV(0);
         B(1,1)= zV(1);
         B(2,1)= zV(2);
         B(0,2)= zW(0);
         B(1,2)= zW(1);
         B(2,2)= zW(2);

         Coordinates x;
         x(0)= r*CT;
         x(1)= r*ST*CP;
         x(2)= r*ST*SP;

         vv.R0x(aR0).generate(F2x(iF2),B,x);
      }
   }
//
//
// evaluate coarse-grain knowledge-based contact energy
//
   ene.Fs3= (0.00);

   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( vv.R0i(iR0)==9999 )continue;
         int aR0=(iR0+vv.R0i(iR0));
////     if( str.R0[aR0].C7==3 )continue;
         int iL0=mol.R0[iR0].L0;
         for(int jZ0=iZ0;jZ0<oZ0;jZ0++){
            int jR0min=mol.Z0[jZ0].R0a;
            int jR0max=(jR0min-1+mol.Z0[jZ0].cR0);
            if( jZ0==iZ0 )jR0min=(iR0+1);
            for(int jR0=jR0min;jR0<=jR0max;jR0++){
               if( vv.R0i(jR0)==9999 )continue;
               int bR0=(jR0+vv.R0i(jR0));
////           if( str.R0[bR0].C7==3 )continue;
               int jL0=mol.R0[jR0].L0;
               double zR=( vv.R0x(bR0) -vv.R0x(aR0)).r();
               if( zR<(12.28) )ene.Fs3+=residue_mappings.L0L0con(iL0,jL0);
            }
         }
      }
   }
//
//
// evaluate coarse-grain physics-based electrostatic energy
//
   ene.Fs4= (0.00);
   ene.Fs5= (0.00);

   int nTOT=0;
   int nPOS=0;
   int nNEG=0;
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         nTOT++;
         if( vv.R0i(iR0)==9999 )continue;
         int aR0=(iR0+vv.R0i(iR0));
////     if( str.R0[aR0].C7==3 )continue;
         int iL0=mol.R0[iR0].L0;
         if( residue_mappings.L0[iL0].pol<2 )continue;
         double sig1= residue_mappings.L0[iL0].gau.sig;
         double eta1= residue_mappings.L0[iL0].gau.eta;
         if( sig1<(0.00) ){
            nNEG++;
         }else{
            nPOS++;
         }
         for(int jZ0=iZ0;jZ0<oZ0;jZ0++){
            int jR0min=mol.Z0[jZ0].R0a;
            int jR0max=(jR0min-1+mol.Z0[jZ0].cR0);
            if( jZ0==iZ0 )jR0min=iR0;
            for(int jR0=jR0min;jR0<=jR0max;jR0++){
               if( vv.R0i(jR0)==9999 )continue;
               int bR0=(jR0+vv.R0i(jR0));
////           if( str.R0[bR0].C7==3 )continue;
               int jL0=mol.R0[jR0].L0;
               if( residue_mappings.L0[jL0].pol<2 )continue;
               double zF=( jR0==iR0 )? (1.): (2.);
               double sig= residue_mappings.L0[jL0].gau.sig;
               double eta= residue_mappings.L0[jL0].gau.eta;
               double eta2=( eta1 +eta);
               double zRR=( vv.R0x(bR0) -vv.R0x(aR0)).rr();
               double zG= (eta1*eta/eta2);
               double sig2a= zF*(4.)*eta1*eta*sig1*sig*std::exp(-zG*zRR);
               double zH= sig2a*( eta1 -eta)/eta2;
               Coordinates x= ((1.00)/eta2)*( eta1*vv.R0x(aR0)
                                              +eta*vv.R0x(bR0));
               Coordinates sig2b= zH*( vv.R0x(aR0) -vv.R0x(bR0));
               double sig2c= sig2a*(-zG*zRR/eta2);
               double zZ= (physics_consts.PI/eta2);
               ene.Fs4+=(zZ*std::sqrt( zZ)*( ((1.50)/eta2)*sig2a +sig2c));
               for(int kZ0= 0;kZ0<oZ0;kZ0++){
                  int kR0min=mol.Z0[kZ0].R0a;
                  int kR0max=(kR0min-1+mol.Z0[kZ0].cR0);
                  for(int kR0=kR0min;kR0<=kR0max;kR0++){
                     if( vv.R0i(kR0)==9999 )continue;
                     int pR0=(kR0+vv.R0i(kR0));
////                 if( str.R0[pR0].C7==3 )continue;
                     int kL0=mol.R0[kR0].L0;
                     if( residue_mappings.L0[kL0].pol>0 )continue;
                     sig= residue_mappings.L0[kL0].gau.sig;
                     eta= residue_mappings.L0[kL0].gau.eta;
                     double eta3=( eta2 +eta);
                     Coordinates zD=( vv.R0x(pR0) -x);
                     zRR= zD.rr();
                     zG= (eta2*eta/eta3);
                     double sig3= sig*std::exp(-zG*zRR);
                     zH= (eta/eta3);
                     zZ= (physics_consts.PI/eta3);
                     ene.Fs5+=sig3*zZ*std::sqrt( zZ)*(
                               +sig2a*( ((1.50)/eta3) +(zH*zH)*zRR)
                               +zH*dot(sig2b,zD)
                               +sig2c);
                  }
               }
            }
         }
      }
   }
//
//
// evaluate electrostatic correction for composition
//
   if( (nPOS+nNEG)>0 ){
      int nFREE=( nPOS>=nNEG )? (nPOS-nNEG): (nNEG-nPOS);
      int nPAIR=( nPOS>=nNEG )? nNEG: nPOS;
      double zRfree= ((3.6)/physics_consts.ANG)
                    *std::exp( (.33333333)*std::log( nTOT));
      double zRpair= ((4.0)/physics_consts.ANG);
      double sig1= residue_mappings.L0[ 9].gau.sig;
      double eta1= residue_mappings.L0[ 9].gau.eta;
      double eta2=( eta1 +eta1);
      double zG= (eta1*eta1/eta2);
      double sig2a= (4.)*eta1*eta1*sig1*sig1;
      double zZ= (physics_consts.PI/eta2);
      double Fpp=   nFREE*zZ*std::sqrt( zZ)*sig2a*((1.5)/eta2);
      double Fpn= 2*nPAIR*zZ*std::sqrt( zZ)*sig2a*((1.5)/eta2);
      double zRR= (zRfree*zRfree);
      double sig3= sig2a*std::exp(-zG*zRR)/eta2;
      Fpp+=( nFREE*(nFREE-1))*zZ*std::sqrt( zZ)*sig3*( (1.5) -zG*zRR);
      zRR= (zRpair*zRpair);
      sig3=-(2.)*sig2a*std::exp(-zG*zRR)/eta2;
      Fpn+=             nPAIR*zZ*std::sqrt( zZ)*sig3*( (1.5) -zG*zRR);
      ene.Fs4-=( Fpp +Fpn);
   }

   return;
}
