#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../glo/Backbone_Defs.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <iomanip>

class MEM_shf {
private:
   std::vector<double> o_J3sco;         //
   std::vector<int> o_J3ord;            //
   std::vector<int> o_J3inv;            //
public:
   MEM_shf(int o):
      o_J3sco(o),
      o_J3ord(o),
      o_J3inv(o)
   {
   }
   double& J3sco(int i){
      return o_J3sco.at( i);  }
   int& J3ord(int i){
      return o_J3ord.at( i);  }
   int& J3inv(int i){
      return o_J3inv.at( i);  }
};

void Backbone_Defs::SHF(const DAT_PHYSICS_CONSTS& physics_consts,
                        const DAT_RESIDUE_MAPPINGS& residue_mappings,
                        Output_Streams& out,
                        const Search_Subspace& sub,
                        const Mechanical_System& mol,
                        const Subset_Contracted_System::tM3& con,
                        Conf_Dependent_System& dep,
                        Energy_Surface4& ene){
   if( nJ3<= 1 )return;
   MEM_shf vv(nJ3);
//
//
// generate atom coords
//
   Coordinates TRANS;                           //rigid body translation
   o_F2x.resize(con.oF2);
   Rotation_Matrix PR[3];                       //generation matrix

   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      double alp,bet,gam;
      if( !con.Z0[iZ0].sub ){
         TRANS=dep.Z0[iZ0].trans;
         alp= dep.Z0[iZ0].rot(0);
         bet= dep.Z0[iZ0].rot(1);
         gam= dep.Z0[iZ0].rot(2);
      }else{
         int iU2=ene.Z0[iZ0].U2a;
         TRANS(0)= ene.U2chi(iU2  );
         TRANS(1)= ene.U2chi(iU2+1);
         TRANS(2)= ene.U2chi(iU2+2);
         alp= ene.U2chi(iU2+3);
         bet= ene.U2chi(iU2+4);
         gam= ene.U2chi(iU2+5);
      }
      Rotation_Matrix ROT(alp,bet,gam);
      int mB3=con.Z0[iZ0].B3a;
      int nB3=(mB3-1+con.Z0[iZ0].cB3);
      for(int iB3=mB3;iB3<=nB3;iB3++){
         int iF2=con.B3[iB3].F2;
         int iT2=con.F2[iF2].typ;
         if( iT2== 7 )continue;
         if( iT2>17 )continue;
         F2x(iF2).generate(TRANS,
                          ROT,
                          dep.F2[iF2].x);
      }
      if( nQ2>mQ2 ){
         PR[ 0]= ROT;
         int iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            int br=con.Q2[iQ2].br;
            int cbr=con.Q2[iQ2].cbr;
            PR[br].extend(PR[cbr],
                          dep.Q2[iQ2].tu,
                          ene.U2chi(ene.Q2[iQ2].U2));
            int mG3=con.Q2[iQ2].G3a;
            int nG3=(mG3-1+con.Q2[iQ2].cG3);
            for(int iG3=mG3;iG3<=nG3;iG3++){
               int iF2=con.G3[iG3].F2;
               int iT2=con.F2[iF2].typ;
               if( iT2== 7 )continue;
               if( iT2>17 )continue;
               F2x(iF2).generate(F2x(con.Q2[iQ2].bseF2),
                                PR[br],
                                dep.G3[iG3].b);
            }
         }
      }
   }
//
//
// evaluate screen energy
//
   if( out.VERBOSE&& out.SHELL ){
      out.FILE3<<"   iJ3""  J3sco  ""  "
                 " Z2J3shf1 Z2J3shf2                      "
                 "  ""   Fs3   ""   Fs4   ""   Fs5   \n";
      out.FILE3<< std::fixed<< std::setprecision( 2);
   }
   for(int iJ3= 0;iJ3<nJ3;iJ3++){
      SHF_SCO(physics_consts,residue_mappings,
              sub,mol,con,ene,
              iJ3);
      vv.J3sco(iJ3)=( ene.Fs3 +ene.Fs4 +ene.Fs5);
      if( out.VERBOSE&& out.SHELL ){
         out.FILE3<< std::setw( 6)<<iJ3
                  << std::setw( 9)<<vv.J3sco(iJ3)<<"  ";
         for(int jZ2= 0;jZ2<nZ2;jZ2++){
            out.FILE3<< std::setw( 2)<<Z2[jZ2].J3[iJ3].shf1
                     << std::setw( 2)<<Z2[jZ2].J3[iJ3].shf2<<' ';
         }
         for(int jZ2=nZ2;jZ2< 8;jZ2++){
            out.FILE3<<"     ";
         }
         out.FILE3<<"  "<< std::setw( 9)<<ene.Fs3
                        << std::setw( 9)<<ene.Fs4
                        << std::setw( 9)<<ene.Fs5<<'\n';
      }
   }
//
//
// order
//
   for(int iJ3= 0;iJ3<nJ3;iJ3++){
      vv.J3ord(iJ3)=iJ3;
   }

   for(int iJ3max=(nJ3-1);iJ3max>0;iJ3max--){
      bool ORDERED=true;
      double sco1=vv.J3sco(vv.J3ord( 0));
      for(int iJ3= 1;iJ3<=iJ3max;iJ3++){
         double sco2=vv.J3sco(vv.J3ord(iJ3));
         if( sco2<sco1 ){
            int i=vv.J3ord(iJ3);
            vv.J3ord(iJ3)=vv.J3ord(iJ3-1);
            vv.J3ord(iJ3-1)=i;
            ORDERED=false;
         }else{
            sco1= sco2;
         }
      }
      if( ORDERED )break;
   }

   for(int iJ3= 0;iJ3<nJ3;iJ3++){
      vv.J3inv(vv.J3ord(iJ3))=iJ3;
   }
   int pJ3=vv.J3inv( 0);

   for(int iJ3= 0;iJ3<nJ3;iJ3++){
      int jJ3=vv.J3ord(iJ3);
      int kJ3=vv.J3inv(iJ3);
      if( jJ3==iJ3 )continue;
      double z=vv.J3sco(iJ3);
      vv.J3sco(iJ3)= vv.J3sco(jJ3);
      vv.J3sco(jJ3)=z;
      for(int jZ2= 0;jZ2<nZ2;jZ2++){
         Z2[jZ2].J3[iJ3].swap( Z2[jZ2].J3[jJ3]);
      }
      vv.J3ord(iJ3)=iJ3;
      vv.J3inv(iJ3)=iJ3;
      vv.J3ord(kJ3)=jJ3;
      vv.J3inv(jJ3)=kJ3;
   }
//
//
// reduce
//
   if( pJ3> 7 ){
      for(int jZ2= 0;jZ2<nZ2;jZ2++){
         Z2[jZ2].J3[ 7]=Z2[jZ2].J3[pJ3];
      }
   }
   int oJ3=nJ3;
   if( nJ3> 8 )nJ3= 8;
   if( nJ3>(pJ3+3) )nJ3=(pJ3+3);
   for(int jZ2= 0;jZ2<nZ2;jZ2++){
      for(int iJ3=(oJ3-1);iJ3>(nJ3-1);iJ3--){
         Z2[jZ2].J3.pop_back();
      }
   }
//
//
// print
//
   if( out.VERBOSE&& out.SHELL ){
      out.FILE3<<"   iJ3""  J3sco  ""  "
                 " Z2J3shf1 Z2J3shf2                      "
                 "  ""   Fs3   ""   Fs4   ""   Fs5   \n";
      for(int iJ3= 0;iJ3<nJ3;iJ3++){
         out.FILE3<< std::setw( 6)<<iJ3
                  << std::setw( 9)<<vv.J3sco(iJ3)<<' ';
         for(int jZ2= 0;jZ2<nZ2;jZ2++){
            out.FILE3<<' '<< std::setw( 2)<<Z2[jZ2].J3[iJ3].shf1
                          << std::setw( 2)<<Z2[jZ2].J3[iJ3].shf2;
         }
         out.FILE3<<'\n';
      }
   }


   o_F2x.clear();
   return;
}
