#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../set/Mechanical_System.hh"
#include "../set/Set_Automatic.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <iomanip>

void Mechanical_System::SET_WRITE(Set_Automatic& aut,
                                  const DAT_PHYSICS_CONSTS& physics_consts,
                                  const DAT_RESIDUE_MAPPINGS& residue_mappings,
                                  const Structure& str,
                                  Output_Streams& out,
                                  const Subset_Contracted_System::tM3& con,
                                  const Conf_Dependent_System& dep) const {
   std::string hrule="________________________________________"
                     "________________________________________\n";
   out.FILE3<< std::fixed;

   if( out.VERBOSE&& out.SHELL ){
      out.FILE3<<"   nZ0"<<"   nS0"<<'\n';
      out.FILE3<< std::setw( 6)<<nZ0
               << std::setw( 6)<<str.nS0<<'\n';
   }
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mQ1=Z0[iZ0].Q1a;
////  int nQ1=(mQ1-1+Z0[iZ0].cQ1);
////  int mQ2=con.Z0[iZ0].Q2a;
////  int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
////  out.FILE3<<hrule;
      if( out.VERBOSE ){
         out.FILE3<<"   cQ1"<<" cQ1bb"<<"   cU1"<<"   cJ1"<<"   cY1"<<'\n';
         out.FILE3<< std::setw( 6)<<Z0[iZ0].cQ1
                  << std::setw( 6)<<Z0[iZ0].cQ1bb
                  << std::setw( 6)<<Z0[iZ0].cU1
                  << std::setw( 6)<<Z0[iZ0].cJ1
                  << std::setw( 6)<<Z0[iZ0].cY1<<'\n';
         out.FILE3<<"   cQ2"<<" cQ2bb"<<'\n';
         out.FILE3<< std::setw( 6)<<con.Z0[iZ0].cQ2
                  << std::setw( 6)<<con.Z0[iZ0].cQ2bb<<'\n';
         out.FILE3<<"   cF1"<<"   cG2"<<"   cB2"<<"   cH1"<<"   cG1"
                  <<"   cB1"<<'\n';
         out.FILE3<< std::setw( 6)<<Z0[iZ0].cF1
                  << std::setw( 6)<<con.Z0[iZ0].cG2
                  << std::setw( 6)<<con.Z0[iZ0].cB2
                  << std::setw( 6)<<Z0[iZ0].cH1
                  << std::setw( 6)<<Z0[iZ0].cG1
                  << std::setw( 6)<<Z0[iZ0].cB1<<'\n';
         out.FILE3<<"   cQ3"<<"   cX2"<<'\n';
         out.FILE3<< std::setw( 6)<<con.Z0[iZ0].cQ3
                  << std::setw( 6)<<con.Z0[iZ0].cX2<<'\n';
         out.FILE3<<"   cE0"<<"   cC1"<<'\n';
         out.FILE3<< std::setw( 6)<<con.Z0[iZ0].cE0
                  << std::setw( 6)<<con.Z0[iZ0].cC1<<'\n';

         out.FILE3<<" Z0sub"<<'\n';
         out.FILE3<<"  "<< std::setw( 1)<<(( con.Z0[iZ0].sub )? 1: 0)<<'\n';
         out.FILE3<<" iR0"<<" R0aa"<<" Q0sub"<<'\n';
         int iQ1=mQ1;
         int iQ1hold=(mQ1+Z0[iZ0].cQ1bb);
         int mR0=Z0[iZ0].R0a;
         int nR0=(mR0-1+Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            out.FILE3<< std::setw( 4)<<(iR0+1)
                     <<' '<<str.R0[iR0].aa;
            int iL0=str.R0[iR0].L0;
            int mQ0=residue_mappings.L0[iL0].Q0a;
            int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
            if( nQ0>=mQ0 ){
               out.FILE3<<"  ";
               for(int icQ1=(nQ0-mQ0+1);icQ1>0;icQ1--){
                  if( Q1[iQ1].omg==1 ){
                     int L=iQ1hold;
                     iQ1hold=(iQ1+1);
                     iQ1=L;
                  }else{
                     iQ1++;
                  }
                  out.FILE3<< std::setw( 1)<<(( con.Q1[iQ1].sub )? 1: 0);
               }
            }
            out.FILE3<<'\n';
         }
      }
//
// write Q1,X1,U1
//
////  if( nQ1>=mQ1 ){
////     out.FILE3<<"  iQ1"<<" tor"<<" sub"<<"  br"
////              <<"  jnt"<<" cbr"<<" omg"<<"   bse"
////              <<"   G2a"<<" cG2"<<"  sq"<<"  X1a"
////              <<"  U1a"<<"  U1z"<<" chg"<<" Q1Q2"
////              <<"  ord"<<'\n';
////     for(int iQ1=mQ1;iQ1<=nQ1;iQ1++){
////        bool bse=(iQ1==mQ1);
////        out.FILE3<< std::setw( 5)<<iQ1
////                 <<' '<<((bse)?"   ":Q1[iQ1].tor)
////                 << std::setw( 4)<<con.Q1[iQ1].sub
////                 << std::setw( 4)<<Q1[iQ1].br
////                 << std::setw( 5)<<((bse)?-1:Q1[iQ1].jnt)
////                 << std::setw( 4)<<((bse)?-1:Q1[iQ1].cbr)
////                 << std::setw( 4)<<Q1[iQ1].omg
////                 << std::setw( 6)<<((bse)?-1:Q1[iQ1].bse)
////                 << std::setw( 6)<<con.Q1[iQ1].G2a
////                 << std::setw( 4)<<Q1[iQ1].cG2
////                 << std::setw( 4)<<aut.Q1[iQ1].sq
////                 << std::setw( 5)<<((bse)?-1:aut.Q1[iQ1].X1a)
////                 << std::setw( 5)<<((bse)?-1:aut.Q1[iQ1].U1a)
////                 << std::setw( 5)<<((bse)?-1:aut.Q1[iQ1].U1z)
////                 << std::setw( 4)<<((bse)?-1:aut.Q1[iQ1].chg)
////                 << std::setw( 5)<<aut.Q1[iQ1].Q2
////                 << std::setw( 5)<<con.Q1[iQ1].ord<<'\n';
////     }
////     out.FILE3<<"  iX1"<<" tor"<<"   F1a"<<" cF1"
////              <<" X1Q1"<<"  sx"<<"  ord"<<" X1X2"<<'\n';
////     int mX1=mQ1;
////     int nX1=nQ1;
////     for(int iX1=mX1;iX1<=nX1;iX1++){
////        bool bse=(iX1==mX1);
////        out.FILE3<< std::setw( 5)<<iX1
////                 <<' '<<((bse)?"   ":Q1[aut.X1[iX1].Q1].tor)
////                 << std::setw( 6)<<((bse)?-1:X1[iX1].F1a)
////                 << std::setw( 4)<<((bse)?-1:X1[iX1].cF1)
////                 << std::setw( 5)<<((bse)?-1:aut.X1[iX1].Q1)
////                 << std::setw( 4)<<aut.X1[iX1].sx
////                 << std::setw( 5)<<((bse)?-1:con.X1[iX1].ord)
////                 << std::setw( 5)<<((bse)?-1:aut.X1[iX1].X2)<<'\n';
////     }
////  }
////  int mU1=Z0[iZ0].U1a;
////  int nU1=(mU1-1+Z0[iZ0].cU1);
////  if( nU1>=mU1 ){
////     out.FILE3<<"  iU1"<<" tor"<<"   H1a"<<" cH1"
////              <<" U1Q1"<<'\n';
////     for(int iU1=mU1;iU1<=nU1;iU1++){
////        out.FILE3<< std::setw( 5)<<iU1
////                 <<' '<<Q1[aut.U1[iU1].Q1].tor
////                 << std::setw( 6)<<U1[iU1].H1a
////                 << std::setw( 4)<<U1[iU1].cH1
////                 << std::setw( 5)<<aut.U1[iU1].Q1<<'\n';
////     }
////  }
//
// write Q2
//
////  if( nQ2>=mQ2 ){
////     out.FILE3<<"  iQ2"<<" tor"<<" Q2Q1"<<"  br"<<"  jnt"
////              <<" cbr"<<" omg"<<"   bse"<<"   G2a"<<"   cG2"
////              <<"  sq"<<" chg"<<"  Q3a"<<"  cQ3"<<"  X2a"
////              <<"  cX2"<<"  cE0"<<"  ORD"<<" bor"<<'\n';
////     for(int iQ2=mQ2;iQ2<=nQ2;iQ2++){
////        bool bse=(iQ2==mQ2);
////        out.FILE3<< std::setw( 5)<<iQ2
////                 <<' '<<((bse)?"   ":con.Q2[iQ2].tor)
////                 << std::setw( 5)<<aut.Q2[iQ2].Q1
////                 << std::setw( 4)<<con.Q2[iQ2].br
////                 << std::setw( 5)<<((bse)?-1:con.Q2[iQ2].jnt)
////                 << std::setw( 4)<<((bse)?-1:con.Q2[iQ2].cbr)
////                 << std::setw( 4)<<con.Q2[iQ2].omg
////                 << std::setw( 6)<<((bse)?-1:con.Q2[iQ2].bseF1)
////                 << std::setw( 6)<<((bse)?-1:con.Q2[iQ2].G2a)
////                 << std::setw( 6)<<((bse)?-1:con.Q2[iQ2].cG2)
////                 << std::setw( 4)<<aut.Q2[iQ2].sq
////                 << std::setw( 4)<<((bse)?-1:con.Q2[iQ2].chg)
////                 << std::setw( 5)<<con.Q2[iQ2].Q3a
////                 << std::setw( 5)<<con.Q2[iQ2].cQ3
////                 << std::setw( 5)<<((bse)?-1:con.Q2[iQ2].X2a)
////                 << std::setw( 5)<<((bse)?-1:con.Q2[iQ2].cX2)
////                 << std::setw( 5)<<con.Q2[iQ2].cE0
////                 << std::setw( 5)<<aut.Q2[iQ2].ORD
////                 << std::setw( 4)<<((bse)?-1:aut.Q2[iQ2].bor)<<'\n';
////     }
////  }
//
// write B2,G2,H1
//
////  int mB2=con.Z0[iZ0].B2a;
////  int nB2=(mB2-1+con.Z0[iZ0].cB2);
////  out.FILE3<<"   iB2"<<"  atm"
////           <<"  sb"<<"  B2F1"<<" cC1"<<'\n';
////  for(int iB2=mB2;iB2<=nB2;iB2++){
////     out.FILE3<< std::setw( 6)<<iB2
////              <<' '<<F1[con.B2[iB2].F1].atm
////              << std::setw( 4)<<con.B2[iB2].sb
////              << std::setw( 6)<<con.B2[iB2].F1
////              << std::setw( 4)<<con.B2[iB2].cC1<<'\n';
////  }
////  int mG2=con.Z0[iZ0].G2a;
////  int nG2=(mG2-1+con.Z0[iZ0].cG2);
////  if( nG2>=mG2 ){
////     out.FILE3<<"   iG2"<<"  atm"
////              <<"                      "<<"     b"<<"                    "
////              <<"  sg"<<"  G2F1"<<"  b4"<<" cC1"<<'\n';
////     out.FILE3<< std::setprecision(10);
////     for(int iG2=mG2;iG2<=nG2;iG2++){
////        out.FILE3<< std::setw( 6)<<iG2
////                 <<' '<<F1[con.G2[iG2].F1].atm<<"   ";
////        for(int i=0;i<3;i++){
////           out.FILE3<< std::setw(15)<<dep.G2[iG2].b(i);
////        }
////        out.FILE3<< std::setw( 4)<<con.G2[iG2].sg
////                 << std::setw( 6)<<con.G2[iG2].F1
////                 << std::setw( 4)<<con.G2[iG2].b4
////                 << std::setw( 4)<<con.G2[iG2].cC1<<'\n';
////     }
////  }
////  int mH1=Z0[iZ0].H1a;
////  int nH1=(mH1-1+Z0[iZ0].cH1);
////  if( nH1>=mH1 ){
////     out.FILE3<<"   iH1"<<"  atm"
////              <<"  H1F1"<<"  b4"<<'\n';
////     for(int iH1=mH1;iH1<=nH1;iH1++){
////        out.FILE3<< std::setw( 6)<<iH1
////                 <<' '<<F1[H1[iH1].F1].atm
////                 << std::setw( 6)<<H1[iH1].F1
////                 << std::setw( 4)<<con.H1[iH1].b4<<'\n';
////     }
////  }
//
// write F1
//
////  int mF1=Z0[iZ0].F1a;
////  int nF1=(mF1-1+Z0[iZ0].cF1);
////  out.FILE3<<"   iF1"<<"  atm"
////           <<"           "<<"    x"<<"           "
////           <<" typ"<<"  hb"<<"  b4"<<"  sf"
////           <<" lte"<<"    chg"<<"    off"<<"  mu"
////           <<"   lnk"<<"   R0"<<'\n';
////  for(int iF1=mF1;iF1<=nF1;iF1++){
////     out.FILE3<< std::setw( 6)<<iF1
////              <<' '<<F1[iF1].atm;
////     out.FILE3<< std::setprecision( 4);
////     for(int i=0;i<3;i++){
////        out.FILE3<< std::setw( 9)<<aut.F1[iF1].x(i);
////     }
////     int lte=F1[iF1].lte;
////     double q=( lte>=0 )? F1[iF1].q.r(0,0): (0.00);
////     out.FILE3<< std::setprecision( 4);
////     out.FILE3<< std::setw( 4)<<F1[iF1].typ
////              << std::setw( 4)<<F1[iF1].hb
////              << std::setw( 4)<<con.F1[iF1].b4
////              << std::setw( 4)<<con.F1[iF1].sf
////              << std::setw( 4)<<lte
////              << std::setw( 7)<<q
////              << std::setw( 7)<<F1[iF1].off
////              << std::setw( 4)<<F1[iF1].mu
////              << std::setw( 6)<<F1[iF1].lnk
////              << std::setw( 7)<<F1[iF1].R0<<'\n';
////  }
////  out.FILE3<<"   iF1"<<"  atm"
////           <<"  ztip"<<"  zbse"<<"  xtip"<<"  xbse"
////           <<'\n';
////  for(int iF1=mF1;iF1<=nF1;iF1++){
////     if( F1[iF1].lte<1 )continue;
////     out.FILE3<< std::setw( 6)<<iF1
////              <<' '<<F1[iF1].atm
////              << std::setw( 6)<<aut.F1[iF1].ztip
////              << std::setw( 6)<<aut.F1[iF1].zbse
////              << std::setw( 6)<<aut.F1[iF1].xtip
////              << std::setw( 6)<<aut.F1[iF1].xbse<<'\n';
////  }
////  out.FILE3<<"   iF1"<<"  atm"
////           <<"  mu"<<"      "<<"      "<<"   fac"
////           <<"    sig"<<"    eta"
////           <<"wjnt"<<"      "<<"      "<<"     u"<<'\n';
////  for(int iF1=mF1;iF1<=nF1;iF1++){
////     if( F1[iF1].mu<1 )continue;
////     out.FILE3<< std::setw( 6)<<iF1
////              <<' '<<F1[iF1].atm
////              << std::setw( 4)<<F1[iF1].mu;
////     for(int i=0;i<3;i++){
////        out.FILE3<< std::setw( 6)<<F1[iF1].fac[i];
////     }
////     out.FILE3<< std::setprecision( 4);
////     out.FILE3<< std::setw( 7)<<F1[iF1].gau.sig
////              << std::setw( 7)<<F1[iF1].gau.eta;
////     if( F1[iF1].typ==30 ){
////        out.FILE3<<F1[iF1].wjnt;
////        out.FILE3<< std::setprecision( 2);
////        for(int i=0;i<3;i++){
////           out.FILE3<< std::setw( 6)<<F1[iF1].u(i);
////        }
////     }
////     out.FILE3<<'\n';
////  }
//
// write Q3,X2
//
////  int mQ3=con.Z0[iZ0].Q3a;
////  int nQ3=(mQ3-1+con.Z0[iZ0].cQ3);
////  out.FILE3<<"  iQ3"<<"  Q1a"<<"  cQ1"<<'\n';
////  for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
////     out.FILE3<< std::setw( 5)<<iQ3
////              << std::setw( 5)<<con.Q3[iQ3].Q1a
////              << std::setw( 5)<<con.Q3[iQ3].cQ1<<'\n';
////  }
////  int mX2=con.Z0[iZ0].X2a;
////  int nX2=(mX2-1+con.Z0[iZ0].cX2);
////  if( nX2>=mX2 ){
////     out.FILE3<<"  iX2"<<"  X1a"<<"  cX1"<<'\n';
////     for(int iX2=mX2;iX2<=nX2;iX2++){
////        out.FILE3<< std::setw( 5)<<iX2
////                 << std::setw( 5)<<con.X2[iX2].X1a
////                 << std::setw( 5)<<con.X2[iX2].cX1<<'\n';
////     }
////  }
//
// write E0
//
////  int mE0=con.Z0[iZ0].E0a;
////  int nE0=(mE0-1+con.Z0[iZ0].cE0);
////  if( nE0>=mE0 ){
////     out.FILE3<<"   iE0"<<" sse"<<"  Z0"<<" lam"
////              <<"   k "<<"   Q3"<<"   X2"<<'\n';
////     for(int iE0=mE0;iE0<=nE0;iE0++){
////        out.FILE3<< std::setw( 6)<<iE0
////                 << std::setw( 4)<<con.E0[iE0].sse
////                 << std::setw( 4)<<con.E0[iE0].Z0
////                 << std::setw( 4)<<con.E0[iE0].lam
////                 << std::setw( 5)<<con.E0[iE0].k
////                 << std::setw( 5)<<con.E0[iE0].Q3
////                 << std::setw( 5)<<con.E0[iE0].X2<<'\n';
////     }
////  }
//
// write C1
//
////  int mC1=con.Z0[iZ0].C1a;
////  int nC1=(mC1-1+con.Z0[iZ0].cC1);
////  if( nC1>=mC1 ){
////     out.FILE3<<"  iC1"<<"  Z0"<<" lam"<<"   k "
////              <<"   F1a"<<" CC"<<"  W0"
////              <<"      a0"<<"      d0"<<'\n';
////     for(int iC1=mC1;iC1<=nC1;iC1++){
////        out.FILE3<< std::setw( 5)<<iC1
////                 << std::setw( 4)<<con.C1[iC1].Z0
////                 << std::setw( 4)<<con.C1[iC1].lam
////                 << std::setw( 5)<<con.C1[iC1].k
////                 << std::setw( 6)<<con.C1[iC1].F1a
////                 << std::setw( 2)<<int(con.C1[iC1].CYCLE)
////                 << std::setw( 4)<<con.C1[iC1].W0
////                 << std::setprecision( 1)
////                 << std::setw( 8)<<con.C1[iC1].a0
////                 << std::setprecision( 3)
////                 << std::setw( 8)<<con.C1[iC1].d0<<'\n';
////     }
////  }
//
// write J1
//
////  int mJ1=Z0[iZ0].J1a;
////  int nJ1=(mJ1-1+Z0[iZ0].cJ1);
////  if( nJ1>=mJ1 ){
////     out.FILE3<<"  iJ1"<<"     "<<" N2Q1"<<"    "<<" tor"<<'\n';
////     for(int iJ1=mJ1;iJ1<=nJ1;iJ1++){
////        out.FILE3<< std::setw( 5)<<iJ1;
////        for(int iN2=0;iN2<2;iN2++){
////           out.FILE3<< std::setw( 5)<<J1N2Q1(iJ1,iN2);
////        }
////        for(int iN2=0;iN2<2;iN2++){
////           out.FILE3<<' '<<Q1[J1N2Q1(iJ1,iN2)].tor;
////        }
////        out.FILE3<<'\n';
////     }
////  }
//
// write Y1
//
////  int mY1=Z0[iZ0].Y1a;
////  int nY1=(mY1-1+Z0[iZ0].cY1);
////  if( nY1>=mY1 ){
////     out.FILE3<<"  iY1"<<"     "<<"     "<<" N3Q1"
////                       <<"    "<<"    "<<" tor"
////                       <<"     "<<"     "<<" N3J1"<<'\n';
////     for(int iY1=mY1;iY1<=nY1;iY1++){
////        out.FILE3<< std::setw( 5)<<iY1;
////        for(int iN3=0;iN3<3;iN3++){
////           out.FILE3<< std::setw( 5)<<Y1N3Q1(iY1,iN3);
////        }
////        for(int iN3=0;iN3<3;iN3++){
////           out.FILE3<<' '<<Q1[Y1N3Q1(iY1,iN3)].tor;
////        }
////        for(int iN3=0;iN3<3;iN3++){
////           out.FILE3<< std::setw( 5)<<Y1N3J1(iY1,iN3);
////        }
////        out.FILE3<<'\n';
////     }
////  }
//
// write Q1tu
//
////    if( nQ1>=mQ1 ){
////       out.FILE3<<"  iQ1"<<" tor"<<"  "
////                <<"       chi     "<<"  "
////                <<"             "<<"      tu"<<'\n';
////       out.FILE3<< std::setprecision(10);
////       for(int iQ1=mQ1;iQ1<=nQ1;iQ1++){
////          bool bse=(iQ1==mQ1);
////          double chi=( bse )? (0.00): (dep.Q1[iQ1].chi/physics_consts.RAD);
////          out.FILE3<< std::setw( 5)<<iQ1
////                   <<' '<<((bse)?"   ":Q1[iQ1].tor)<<"  "
////                   << std::setw(15)<<chi<<"  ";
////          for(int i=0;i<3;i++){
////             if( i>0 ){
////                out.FILE3<<"                            ";
////             }
////             for(int j=0;j<3;j++){
////                out.FILE3<< std::setw(13)<<Q1[iQ1].tu(i,j);
////             }
////             out.FILE3<<'\n';
////          }
////       }
////    }
//
// write Q2tu
//
////    if( nQ2>=mQ2 ){
////       out.FILE3<<"  iQ2"<<" tor"<<"  "
////                <<"       chi     "<<"  "
////                <<"             "<<"      tu"<<'\n';
////       out.FILE3<< std::setprecision(10);
////       for(int iQ2=mQ2;iQ2<=nQ2;iQ2++){
////          bool bse=(iQ2==mQ2);
////          double chi=( bse )? (0.00): (dep.Q2[iQ2].chi/physics_consts.RAD);
////          out.FILE3<< std::setw( 5)<<iQ2
////                   <<' '<<((bse)?"   ":con.Q2[iQ2].tor)<<"  "
////                   << std::setw(15)<<chi<<"  ";
////          for(int i=0;i<3;i++){
////             if( i>0 ){
////                out.FILE3<<"                            ";
////             }
////             for(int j=0;j<3;j++){
////                out.FILE3<< std::setw(13)<<dep.Q2[iQ2].tu(i,j);
////             }
////             out.FILE3<<'\n';
////          }
////       }
////    }

   }
//// out.FILE3<<hrule;
   return;
}
