#include "../con/Subset_Contracted_System.hh"
#include "../set/Mechanical_System.hh"
#include "../set/Set_Automatic.hh"
#include <vector>

class MEM_set_q3 {
private:
   std::vector<int> o_Q3Q1;             //
   std::vector<int> o_Q3ord;            //
   std::vector<int> o_Q3inv;            //
   std::vector<int> o_X2X1;             //
   std::vector<int> o_X2ord;            //
   std::vector<int> o_X2inv;            //
public:
   MEM_set_q3(int o):
      o_Q3Q1(o),
      o_Q3ord(o),
      o_Q3inv(o),
      o_X2X1(o),
      o_X2ord(o),
      o_X2inv(o)
   {
   }
   int& Q3Q1(int i){
      return o_Q3Q1.at( i);  }
   int& Q3ord(int i){
      return o_Q3ord.at( i);  }
   int& Q3inv(int i){
      return o_Q3inv.at( i);  }
   int& X2X1(int i){
      return o_X2X1.at( i);  }
   int& X2ord(int i){
      return o_X2ord.at( i);  }
   int& X2inv(int i){
      return o_X2inv.at( i);  }
};

void Mechanical_System::SET_Q3(Set_Automatic& aut,
                               Subset_Contracted_System::tM3& con){
   int oQ1=con.oQ1;
   MEM_set_q3 vv(oQ1);
   int KPT[3];
//
//
// forward and backward sub-blocks
//
   int mQ3=0;
   int mX2=0;
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      con.Z0[iZ0].Q3a=mQ3;
      con.Z0[iZ0].X2a=mX2;

      int mQ1=Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+Z0[iZ0].cQ1);
      con.Z0[iZ0].cQ3=1;
      con.Q3.push_back( Subset_Contracted_System::tM3::tM3Q3());
      con.Q3[mQ3].cQ1=1;
      aut.Q1[mQ1].Q3=mQ3;
      vv.Q3Q1(mQ3)=mQ1;
      int kQ1=mQ1;
      con.Q1[kQ1].ord=mQ1;
      if( nQ1>mQ1 ){

         int iQ3=mQ3;
         int iQ1=mQ1;
         int iQ1hold=(mQ1+Z0[iZ0].cQ1bb);
         for(int icQ1=(nQ1-mQ1);icQ1>0;icQ1--){
            if( Q1[iQ1].omg==1 ){
               int L=iQ1hold;
               iQ1hold=(iQ1+1);
               iQ1=L;
            }else{
               iQ1++;
            }
            if( con.Q1[iQ1].sub||(Q1[iQ1].tor=="OMG")||
                                 (Q1[iQ1].tor=="BET")||
                                 (Q1[iQ1].tor=="EPS")||
                                 (Q1[iQ1].tor=="NU1") ){
               con.Z0[iZ0].cQ3++;
               con.Q3.push_back( Subset_Contracted_System::tM3::tM3Q3());
               con.Q3[++iQ3].cQ1=1;
               aut.Q1[iQ1].Q3=iQ3;
               vv.Q3Q1(iQ3)=iQ1;
            }else{
               int jQ1=Q1[iQ1].jnt;
               int jQ3=aut.Q1[jQ1].Q3;
               con.Q3[jQ3].cQ1++;
               aut.Q1[iQ1].Q3=jQ3;
            }
            con.Q1[++kQ1].ord=iQ1;
         }

         int nQ3=(mQ3-1+con.Z0[iZ0].cQ3);
         for(iQ3=mQ3;iQ3<=nQ3;iQ3++){
            vv.Q3ord(iQ3)=iQ3;
         }

         if( nQ3>mQ3 ){
            int iQ3min=(mQ3+1);
            for(int iQ3max=nQ3;iQ3max>mQ3;iQ3max--){
               bool ORDERED=true;
               int iORD=aut.Q2[ aut.Q1[ vv.Q3Q1( vv.Q3ord( mQ3))].Q2].ORD;
               for(iQ3=iQ3min;iQ3<=iQ3max;iQ3++){
                  int jORD=aut.Q2[ aut.Q1[ vv.Q3Q1( vv.Q3ord( iQ3))].Q2].ORD;
                  if( iORD>jORD ){
                     int L=vv.Q3ord(iQ3);
                     vv.Q3ord(iQ3)=vv.Q3ord(iQ3-1);
                     vv.Q3ord(iQ3-1)=L;
                     ORDERED=false;
                  }else{
                     iORD=jORD;
                  }
               }
               if( ORDERED )break;
            }
         }

         for(iQ3=mQ3;iQ3<=nQ3;iQ3++){
            vv.Q3inv( vv.Q3ord(iQ3))=iQ3;
         }

         for(iQ1=mQ1;iQ1<=nQ1;iQ1++){
            aut.Q1[iQ1].Q3=vv.Q3inv( aut.Q1[iQ1].Q3);
         }

         for(iQ3=mQ3;iQ3<=nQ3;iQ3++){
            int jQ3=vv.Q3ord(iQ3);
            int kQ3=vv.Q3inv(iQ3);
            int L=con.Q3[iQ3].cQ1;
            con.Q3[iQ3].cQ1=con.Q3[jQ3].cQ1;
            con.Q3[jQ3].cQ1=L;
            L=vv.Q3Q1(iQ3);
            vv.Q3Q1(iQ3)=vv.Q3Q1(jQ3);
            vv.Q3Q1(jQ3)=L;
            vv.Q3ord(iQ3)=iQ3;
            vv.Q3inv(iQ3)=iQ3;
            vv.Q3ord(kQ3)=jQ3;
            vv.Q3inv(jQ3)=kQ3;
         }

         int iQ1min=(mQ1+1);
         for(int iQ1max=nQ1;iQ1max>mQ1;iQ1max--){
            bool ORDERED=true;
            int iORD=aut.Q1[con.Q1[mQ1].ord].Q3;
            for(int iQ1=iQ1min;iQ1<=iQ1max;iQ1++){
               int jORD=aut.Q1[con.Q1[iQ1].ord].Q3;
               if( jORD<iORD ){
                  int L=con.Q1[iQ1].ord;
                  con.Q1[iQ1].ord=con.Q1[iQ1-1].ord;
                  con.Q1[iQ1-1].ord=L;
                  ORDERED=false;
               }else{
                  iORD=jORD;
               }
            }
            if( ORDERED )break;
         }

      }
      int iQ1=mQ1;
      int nQ3=(mQ3-1+con.Z0[iZ0].cQ3);
      for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
         con.Q3[iQ3].Q1a=iQ1;
         iQ1+=con.Q3[iQ3].cQ1;
      }

      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      for(int iQ2=mQ2;iQ2<=nQ2;iQ2++){
         con.Q2[iQ2].Q3a=-1;
         con.Q2[iQ2].cQ3=0;
      }

      for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
         int iQ2=aut.Q1[ vv.Q3Q1(iQ3)].Q2;
         if( con.Q2[iQ2].Q3a==-1 )con.Q2[iQ2].Q3a=iQ3;
         con.Q2[iQ2].cQ3++;
      }

      con.Z0[iZ0].cX2=0;
      int iX2=(mX2-1);
      int mX1=(mQ1+1);
      int nX1=nQ1;
      if( nX1>=mX1 ){
         KPT[ 0]=(mX1-1);
         for(int iX1=mX1;iX1<=nX1;iX1++){
            iQ1=aut.X1[iX1].Q1;
            int ibr=Q1[iQ1].br;
            int jbr=Q1[iQ1].cbr;
            if( (iX1==mX1)||con.Q1[iQ1].sub ){
               con.Z0[iZ0].cX2++;
               con.X2.push_back( Subset_Contracted_System::tM3::tM3X2());
               con.X2[++iX2].cX1=1;
               aut.X1[iX1].X2=iX2;
               vv.X2X1(iX2)=iX1;
            }else{
               int jX1=KPT[jbr];
               int jX2=aut.X1[jX1].X2;
               if( (Q1[iQ1].tor=="OMG")||
                   (Q1[iQ1].tor=="BET")||
                   (Q1[iQ1].tor=="EPS")||
                   (Q1[iQ1].tor=="NU1") ){
                  con.Z0[iZ0].cX2++;
                  con.X2.push_back( Subset_Contracted_System::tM3::tM3X2());
                  con.X2[++iX2].cX1=1;
                  aut.X1[iX1].X2=iX2;
                  vv.X2X1(iX2)=vv.X2X1(jX2);
               }else{
                  con.X2[jX2].cX1++;
                  aut.X1[iX1].X2=jX2;
               }
            }
            KPT[ibr]=iX1;
         }

         int nX2=(mX2-1+con.Z0[iZ0].cX2);
         for(iX2=mX2;iX2<=nX2;iX2++){
            vv.X2ord(iX2)=iX2;
         }

         if( nX2>mX2 ){
            int iX2min=(mX2+1);
            for(int iX2max=nX2;iX2max>mX2;iX2max--){
               bool ORDERED=true;
               int iORD=vv.X2X1( vv.X2ord( mX2));
               for(iX2=iX2min;iX2<=iX2max;iX2++){
                  int jORD=vv.X2X1( vv.X2ord( iX2));
                  if( iORD>jORD ){
                     int L=vv.X2ord(iX2);
                     vv.X2ord(iX2)=vv.X2ord(iX2-1);
                     vv.X2ord(iX2-1)=L;
                     ORDERED=false;
                  }else{
                     iORD=jORD;
                  }
               }
               if( ORDERED )break;
            }
         }

         for(iX2=mX2;iX2<=nX2;iX2++){
            vv.X2inv( vv.X2ord(iX2))=iX2;
         }

         for(int iX1=mX1;iX1<=nX1;iX1++){
            con.X1[iX1].ord=iX1;
            aut.X1[iX1].X2=vv.X2inv( aut.X1[iX1].X2);
         }

         for(iX2=mX2;iX2<=nX2;iX2++){
            int jX2=vv.X2ord(iX2);
            int kX2=vv.X2inv(iX2);
            int L=con.X2[iX2].cX1;
            con.X2[iX2].cX1=con.X2[jX2].cX1;
            con.X2[jX2].cX1=L;
            L=vv.X2X1(iX2);
            vv.X2X1(iX2)=vv.X2X1(jX2);
            vv.X2X1(jX2)=L;
            vv.X2ord(iX2)=iX2;
            vv.X2inv(iX2)=iX2;
            vv.X2ord(kX2)=jX2;
            vv.X2inv(jX2)=kX2;
         }

         int iX1min=(mX1+1);
         for(int iX1max=nX1;iX1max>mX1;iX1max--){
            bool ORDERED=true;
            int iORD=aut.X1[con.X1[mX1].ord].X2;
            for(int iX1=iX1min;iX1<=iX1max;iX1++){
               int jORD=aut.X1[con.X1[iX1].ord].X2;
               if( jORD<iORD ){
                  int L=con.X1[iX1].ord;
                  con.X1[iX1].ord=con.X1[iX1-1].ord;
                  con.X1[iX1-1].ord=L;
                  ORDERED=false;
               }else{
                  iORD=jORD;
               }
            }
            if( ORDERED )break;
         }

         int iX1=mX1;
         for(iX2=mX2;iX2<=nX2;iX2++){
            con.X2[iX2].X1a=iX1;
            iX1+=con.X2[iX2].cX1;
         }

      }
      for(int iQ2=mQ2;iQ2<=nQ2;iQ2++){
         con.Q2[iQ2].X2a=-1;
         con.Q2[iQ2].cX2=0;
      }

      int nX2=(mX2-1+con.Z0[iZ0].cX2);
      for(iX2=mX2;iX2<=nX2;iX2++){
         int iQ1=aut.X1[ vv.X2X1(iX2)].Q1;
         if( !con.Q1[iQ1].sub )continue;
         int iQ2=aut.Q1[iQ1].Q2;
         if( con.Q2[iQ2].X2a==-1 )con.Q2[iQ2].X2a=iX2;
         con.Q2[iQ2].cX2++;
      }

      mQ3+=con.Z0[iZ0].cQ3;
      mX2+=con.Z0[iZ0].cX2;
   }
   con.oQ3=con.Q3.size();
   con.oX2=con.X2.size();
   return;
}
