#include "../con/Subset_Contracted_System.hh"
#include "../dst/Distance_Constraints.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../set/Mechanical_System.hh"
#include "../set/Set_Automatic.hh"
#include "../str/Thread_Options.hh"
#include <vector>

class MEM_set_q2 {
private:
   std::vector<int> o_G1B2;             //
   std::vector<int> o_G1G2;             //
   std::vector<int> o_G1b4;             //uncontracted connection to bse
   std::vector<Coordinates> o_G1b;      //untransformed coords(bohr)
public:
   MEM_set_q2(int o):
      o_G1B2(o,-1),
      o_G1G2(o,-1),
      o_G1b4(o),
      o_G1b(o)
   {
   }
   int& G1B2(int i){
      return o_G1B2.at( i);  }
   int& G1G2(int i){
      return o_G1G2.at( i);  }
   int& G1b4(int i){
      return o_G1b4.at( i);  }
   Coordinates& G1b(int i){
      return o_G1b.at( i);  }
};

void Mechanical_System::SET_Q2(Set_Automatic& aut,
                               const Thread_Options& opt,
                               const Distance_Constraints& dst,
                               Subset_Contracted_System::tM3& con,
                               Conf_Dependent_System& dep){
   int oG1=G1.size();
   MEM_set_q2 vv(oG1);
//
//
// subset contraction of Q, B, G
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mQ1=Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+Z0[iZ0].cQ1);
      for(int iQ1=mQ1;iQ1<=nQ1;iQ1++){
         aut.Q1[iQ1].tu=Q1[iQ1].tu;
      }
   }
   int mQ2=0;
   int mB2=0;
   int mG2=0;
   int mGEN=0;
   int mBSE=0;
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      con.Z0[iZ0].Q2a=mQ2;
      con.Z0[iZ0].B2a=mB2;
      con.Z0[iZ0].G2a=mG2;

      con.Z0[iZ0].cB2=Z0[iZ0].cB1;
      int mB1=Z0[iZ0].B1a;
      int nB1=(mB1-1+Z0[iZ0].cB1);
      for(int iB1=mB1;iB1<=nB1;iB1++){
         int iB2=(mB2+iB1-mB1);
         con.B2.push_back( Subset_Contracted_System::tM3::tM3B2());
         con.B2[iB2].F1=B1[iB1].F1;
         con.B2[iB2].sb=aut.B1[iB1].sb;
      }

      int mQ1=Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+Z0[iZ0].cQ1);
      con.Q1[mQ1].G2a=mB2;
      Q1[mQ1].cG2=Z0[iZ0].cB1;
      aut.Q2[mQ2].Q1=mQ1;
      aut.Q1[mQ1].Q2=mQ2;
      con.Q2[mQ2].br=0;
      aut.Q2[mQ2].sq=((1<<aut.Q1[mQ1].sq)>>1);

      int iQ2=mQ2;
      if( nQ1>mQ1 ){
         for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
            if( con.Q1[iQ1].sub ){
               iQ2++;
               con.Q2[iQ2].tor=Q1[iQ1].tor;
               dep.Q2[iQ2].chi=dep.Q1[iQ1].chi;
               con.Q2[iQ2].bseF1=Q1[iQ1].bse;
               con.Q2[iQ2].br=Q1[iQ1].br;
//
// Q2br may be reset for the case Q2br==2
//
               aut.Q2[iQ2].sq=((1<<aut.Q1[iQ1].sq)>>1);
               con.Q2[iQ2].cG2=Q1[iQ1].cG1;
               con.Q2[iQ2].chg=aut.Q1[iQ1].chg;
//
// Q2sq, Q2cG2, Q2chg may be reset
//
               aut.Q2[iQ2].Q1=iQ1;
               aut.Q1[iQ1].Q2=iQ2;
               dep.Q2[iQ2].tu=Q1[iQ1].tu;
               int jQ1=Q1[iQ1].jnt;
               if( !con.Q1[jQ1].sub ){
                  dep.Q2[iQ2].tu=aut.Q1[jQ1].tu*dep.Q2[iQ2].tu;
               }
               int jQ2=aut.Q1[jQ1].Q2;
               con.Q2[iQ2].jnt=jQ2;
               con.Q2[iQ2].cbr=con.Q2[jQ2].br;
               int mG1=Q1[iQ1].G1a;
               int nG1=(mG1-1+Q1[iQ1].cG1);
               for(int iG1=mG1;iG1<=nG1;iG1++){
                  vv.G1b4(iG1)=1;
                  vv.G1b(iG1)=G1[iG1].b;
                  aut.F1[G1[iG1].F1].x=G1[iG1].b;
               }
            }else{
               aut.Q1[iQ1].tu.extend(dep.Q1[iQ1].chi);
               int jQ1=Q1[iQ1].jnt;
               if( !con.Q1[jQ1].sub ){
                  aut.Q1[iQ1].tu=aut.Q1[jQ1].tu*aut.Q1[iQ1].tu;
               }
               int jQ2=aut.Q1[jQ1].Q2;
               aut.Q1[iQ1].Q2=jQ2;
               if( jQ2==mQ2 ){
                  int mG1=Q1[iQ1].G1a;
                  int nG1=(mG1-1+Q1[iQ1].cG1);
                  for(int iG1=mG1;iG1<=nG1;iG1++){
                     int iB2=(mB2+con.Z0[iZ0].cB2+iG1-mG1);
                     con.B2.push_back( Subset_Contracted_System::tM3::tM3B2());
                     vv.G1B2(iG1)=iB2;
                     con.B2[iB2].F1=G1[iG1].F1;
                     con.B2[iB2].sb=aut.G1[iG1].sg;
                     aut.F1[G1[iG1].F1].x.generate(aut.F1[Q1[iQ1].bse].x,
                                                   aut.Q1[iQ1].tu,
                                                   G1[iG1].b);
                  }
                  con.Q1[iQ1].G2a=(mB2+con.Z0[iZ0].cB2);
                  Q1[iQ1].cG2=Q1[iQ1].cG1;
                  con.Z0[iZ0].cB2+=Q1[iQ1].cG1;
               }else{
                  int mG1=Q1[iQ1].G1a;
                  int nG1=(mG1-1+Q1[iQ1].cG1);
                  for(int iG1=mG1;iG1<=nG1;iG1++){
                     vv.G1b4(iG1)=0;
                     aut.F1[G1[iG1].F1].x.generate(aut.F1[Q1[iQ1].bse].x,
                                                   aut.Q1[iQ1].tu,
                                                   G1[iG1].b);
                     vv.G1b(iG1)=aut.F1[G1[iG1].F1].x;
                  }
                  con.Q2[jQ2].cG2+=Q1[iQ1].cG1;
                  con.Q2[jQ2].chg+=aut.Q1[iQ1].chg;
               }
               if( aut.Q1[iQ1].sq>0 ){
                  aut.Q2[jQ2].sq|=((1<<aut.Q1[iQ1].sq)>>1);
               }
            }
         }
      }
      con.Z0[iZ0].cQ2=(iQ2-mQ2+1);

      int mF1=Z0[iZ0].F1a;
      int nF1=(mF1-1+Z0[iZ0].cF1);
      for(int iF1=mF1;iF1<=nF1;iF1++){
         con.F1[iF1].b4=0;
      }
      int mX1=(Z0[iZ0].Q1a+1);
      int nX1=(mX1-2+Z0[iZ0].cQ1);
      if( nX1>=mX1 ){
         for(int iX1=mX1;iX1<=nX1;iX1++){
            int iQ1=aut.X1[iX1].Q1;
            if( con.Q1[iQ1].sub ){
               mF1=X1[iX1].F1a;
               nF1=(mF1-1+X1[iX1].cF1);
               for(int iF1=mF1;iF1<=nF1;iF1++){
                  con.F1[iF1].b4=1;
               }
            }
         }
      }

      int mU1=Z0[iZ0].U1a;
      int nU1=(mU1-1+Z0[iZ0].cU1);
      if( nU1>=mU1 ){
         for(int iU1=mU1;iU1<=nU1;iU1++){
            int mH1=U1[iU1].H1a;
            int nH1=(mH1-1+U1[iU1].cH1);
            int iQ1=aut.U1[iU1].Q1;
            if( con.Q1[iQ1].sub ){
               for(int iH1=mH1;iH1<=nH1;iH1++){
                  con.H1[iH1].b4=1;
               }
            }else{
               for(int iH1=mH1;iH1<=nH1;iH1++){
                  con.H1[iH1].b4=0;
               }
            }
         }
      }

      con.Z0[iZ0].cQ2bb=1;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      if( nQ2>mQ2 ){
         for(iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
            if( con.Q2[iQ2].br==0 )con.Z0[iZ0].cQ2bb++;
         }
         con.Q2[nQ2+1].jnt=mQ2;
      }

      int iQ2min=(mQ2+con.Z0[iZ0].cQ2bb);
      if( nQ2>=iQ2min ){
         for(iQ2=iQ2min;iQ2<=nQ2;iQ2++){
            if( con.Q2[iQ2].br<2 )continue;
            int pQ2=(iQ2+1);
            while( (con.Q2[pQ2].br ==2)&&
                   (con.Q2[pQ2].cbr==2) ){
               pQ2++;
            }
            if( (con.Q2[iQ2].cbr==0)||
                (con.Q2[pQ2].jnt!=con.Q2[iQ2].jnt) ){
               for(int jQ2=iQ2;jQ2<pQ2;jQ2++){
                  con.Q2[jQ2].br=1;
                  con.Q2[jQ2].cbr=con.Q2[con.Q2[jQ2].jnt].br;
               }
            }
            iQ2=(pQ2-1);
         }
      }

      aut.Z0[iZ0].GENa=mGEN;
      aut.Z0[iZ0].BSEa=mBSE;
      int iGEN=(mGEN-1);
      int iBSE=(mBSE-1);
      if( nQ1>mQ1 ){
         iQ2=mQ2;
         int br1=0;
         int iQ1=mQ1;
         int iQ1hold=(mQ1+Z0[iZ0].cQ1bb);
         for(int icQ1=(nQ1-mQ1);icQ1>0;icQ1--){
            if( Q1[iQ1].omg==1 ){
               int L=iQ1hold;
               iQ1hold=(iQ1+1);
               iQ1=L;
            }else{
               iQ1++;
            }
            if( con.Q1[iQ1].sub ){
               int br2=( Q1[iQ1].br>0 )?1:0;
               con.Q2[iQ2].omg=( br2!=br1 )?1:0;
               br1=br2;
               iQ2=aut.Q1[iQ1].Q2;
            }
            if( aut.Q1[iQ1].Q2>mQ2 ){
               aut.GEN[++iGEN].Q1=iQ1;
            }else{
               aut.BSE[++iBSE].Q1=iQ1;
            }
         }
         con.Q2[iQ2].omg=0;
      }
      aut.Z0[iZ0].cGEN=(iGEN-mGEN+1);
      aut.Z0[iZ0].cBSE=(iBSE-mBSE+1);

      aut.Q2[mQ2].ORD=0;
      if( nQ2>mQ2 ){
         int iORD=0;
         int jG2=mG2;
         iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            aut.Q2[iQ2].ORD=++iORD;
            con.Q2[iQ2].G2a=jG2;
            jG2+=con.Q2[iQ2].cG2;
         }
      }

      int nGEN=(mGEN-1+aut.Z0[iZ0].cGEN);
      if( nGEN>mGEN ){
         int iGENmin=(mGEN+1);
         for(int iGENmax=nGEN;iGENmax>mGEN;iGENmax--){
            bool ORDERED=true;
            int iORD=aut.Q2[aut.Q1[aut.GEN[mGEN].Q1].Q2].ORD;
            for(int iGEN=iGENmin;iGEN<=iGENmax;iGEN++){
               int jORD=aut.Q2[aut.Q1[aut.GEN[iGEN].Q1].Q2].ORD;
               if( jORD<iORD ){
                  int Lhold=aut.GEN[iGEN].Q1;
                  aut.GEN[iGEN].Q1=aut.GEN[iGEN-1].Q1;
                  aut.GEN[iGEN-1].Q1=Lhold;
                  ORDERED=false;
               }else{
                  iORD=jORD;
               }
            }
            if( ORDERED )break;
         }
      }

      int iG2=(mG2-1);
      if( nGEN>=mGEN ){
         for(int iGEN=mGEN;iGEN<=nGEN;iGEN++){
            int iQ1=aut.GEN[iGEN].Q1;
            int mG1=Q1[iQ1].G1a;
            int nG1=(mG1-1+Q1[iQ1].cG1);
            for(int iG1=mG1;iG1<=nG1;iG1++){
               vv.G1G2(iG1)=++iG2;
               con.G2.push_back( Subset_Contracted_System::tM3::tM3G2());
               con.G2[iG2].F1=G1[iG1].F1;
               con.G2[iG2].b4=vv.G1b4(iG1);
               con.G2[iG2].sg=aut.G1[iG1].sg;
               dep.G2[iG2].b=vv.G1b(iG1);
            }
            con.Q1[iQ1].G2a=(iG2-Q1[iQ1].cG1+1);
            Q1[iQ1].cG2=Q1[iQ1].cG1;
         }
      }
      con.Z0[iZ0].cG2=(iG2-mG2+1);

      mQ2+=con.Z0[iZ0].cQ2;
      mB2+=con.Z0[iZ0].cB2;
      mG2+=con.Z0[iZ0].cG2;
      mGEN+=aut.Z0[iZ0].cGEN;
      mBSE+=aut.Z0[iZ0].cBSE;
   }
   con.oB2=con.B2.size();
   con.oG2=con.G2.size();
//
//
// subset contraction of C
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mB2=con.Z0[iZ0].B2a;
      int nB2=(mB2-1+con.Z0[iZ0].cB2);
      for(int iB2=mB2;iB2<=nB2;iB2++){
         aut.B2[iB2].sub=false;
      }
      int mG2=con.Z0[iZ0].G2a;
      int nG2=(mG2-1+con.Z0[iZ0].cG2);
      if( nG2>=mG2 ){
         for(int iG2=mG2;iG2<=nG2;iG2++){
            aut.G2[iG2].sub=false;
         }
      }
   }
   int oC0=dst.nC0;
   aut.nC0=0;
   if( oC0>0 ){
      for(int iC0= 0;iC0<oC0;iC0++){
         for(int iN2=0;iN2<2;iN2++){
            int iZ0=dst.C0N2Z0(iC0,iN2);
            int mB1=Z0[iZ0].B1a;
//          int nB1=(mB1-1+Z0[iZ0].cB1);
            int mB2=con.Z0[iZ0].B2a;
            int nB2=(mB2-1+con.Z0[iZ0].cB2);
            int iG1=aut.C0N2G1(iC0,iN2);
            int iB1=aut.C0N2B1(iC0,iN2);
            if      ( iG1>=0 ){
               aut.C0N2G2(iC0,iN2)=vv.G1G2(iG1);
               aut.C0N2B2(iC0,iN2)=vv.G1B2(iG1);
            }else if( iB1>=0 ){
               aut.C0N2G2(iC0,iN2)=-1;
               aut.C0N2B2(iC0,iN2)=(mB2+iB1-mB1);
            }else{
               aut.C0N2G2(iC0,iN2)=-1;
               aut.C0N2B2(iC0,iN2)=nB2;
            }
         }
      }

      for(int iC0= 0;iC0<oC0;iC0++){
         if( dst.C0N2Z0(iC0, 1)!=dst.C0N2Z0(iC0, 0) )continue;
         if( aut.C0N2G2(iC0, 1)<aut.C0N2G2(iC0, 0) ){
            int L=aut.C0N2F1(iC0, 1);
            aut.C0N2F1(iC0, 1)=aut.C0N2F1(iC0, 0);
            aut.C0N2F1(iC0, 0)=L;
            L=aut.C0N2G2(iC0, 1);
            aut.C0N2G2(iC0, 1)=aut.C0N2G2(iC0, 0);
            aut.C0N2G2(iC0, 0)=L;
            L=aut.C0N2B2(iC0, 1);
            aut.C0N2B2(iC0, 1)=aut.C0N2B2(iC0, 0);
            aut.C0N2B2(iC0, 0)=L;
         }
      }

      for(int iC0= 0;iC0<oC0;iC0++){
         int iZ0=dst.C0N2Z0(iC0, 0);
         int jZ0=dst.C0N2Z0(iC0, 1);
         if( (aut.C0N2G2(iC0, 1)==-1)&&(aut.C0N2G2(iC0, 0)==-1) ){
            if( jZ0==iZ0 )continue;
            if(   (!con.Z0[jZ0].sub)
                &&(!con.Z0[iZ0].sub) )continue;
         }
         for(int iN2=0;iN2<2;iN2++){
            aut.C0N2Z0(aut.nC0,iN2)=dst.C0N2Z0(iC0,iN2);
            aut.C0N2F1(aut.nC0,iN2)=aut.C0N2F1(iC0,iN2);
            aut.C0N2G2(aut.nC0,iN2)=aut.C0N2G2(iC0,iN2);
            aut.C0N2B2(aut.nC0,iN2)=aut.C0N2B2(iC0,iN2);
         }
         aut.C0[aut.nC0].CYCLE=dst.C0[iC0].CYCLE;
         aut.C0[aut.nC0].W0=dst.C0[iC0].W0;
         aut.C0[aut.nC0].a0= dst.C0[iC0].a0;
         aut.C0[aut.nC0].d0= dst.C0[iC0].d0;
         if( aut.C0N2G2(aut.nC0, 1)>=0 ){
            aut.G2[aut.C0N2G2(aut.nC0, 1)].sub=true;
         }else{
            aut.B2[aut.C0N2B2(aut.nC0, 1)].sub=true;
         }
         aut.nC0++;
      }
   }

   if( aut.nC0>1 ){
      for(int iC0max=(aut.nC0-1);iC0max> 0;iC0max--){
         bool ORDERED=true;
         int iZ0=aut.C0N2Z0( 0, 1);
         int iG2=aut.C0N2G2( 0, 1);
         if( iG2==-1 ){
            iG2=aut.C0N2B2( 0, 1);
            if( iZ0>0 )iG2+=(con.Z0[iZ0-1].G2a+con.Z0[iZ0-1].cG2);
         }else{
            iG2+=(con.Z0[iZ0].B2a+con.Z0[iZ0].cB2);
         }
         for(int iC0= 1;iC0<=iC0max;iC0++){
            int jZ0=aut.C0N2Z0(iC0, 1);
            int jG2=aut.C0N2G2(iC0, 1);
            if( jG2==-1 ){
               jG2=aut.C0N2B2(iC0, 1);
               if( jZ0>0 )jG2+=(con.Z0[jZ0-1].G2a+con.Z0[jZ0-1].cG2);
            }else{
               jG2+=(con.Z0[jZ0].B2a+con.Z0[jZ0].cB2);
            }
            if( jG2<iG2 ){
               for(int iN2=0;iN2<2;iN2++){
                  int L=aut.C0N2Z0(iC0,iN2);
                  aut.C0N2Z0(iC0,iN2)=aut.C0N2Z0(iC0-1,iN2);
                  aut.C0N2Z0(iC0-1,iN2)=L;
                  L=aut.C0N2F1(iC0,iN2);
                  aut.C0N2F1(iC0,iN2)=aut.C0N2F1(iC0-1,iN2);
                  aut.C0N2F1(iC0-1,iN2)=L;
                  L=aut.C0N2G2(iC0,iN2);
                  aut.C0N2G2(iC0,iN2)=aut.C0N2G2(iC0-1,iN2);
                  aut.C0N2G2(iC0-1,iN2)=L;
                  L=aut.C0N2B2(iC0,iN2);
                  aut.C0N2B2(iC0,iN2)=aut.C0N2B2(iC0-1,iN2);
                  aut.C0N2B2(iC0-1,iN2)=L;
               }
               bool b=aut.C0[iC0].CYCLE;
               aut.C0[iC0].CYCLE=aut.C0[iC0-1].CYCLE;
               aut.C0[iC0-1].CYCLE=b;
               int L=aut.C0[iC0].W0;
               aut.C0[iC0].W0=aut.C0[iC0-1].W0;
               aut.C0[iC0-1].W0=L;
               double a= aut.C0[iC0].a0;
               aut.C0[iC0].a0=aut.C0[iC0-1].a0;
               aut.C0[iC0-1].a0= a;
               double d= aut.C0[iC0].d0;
               aut.C0[iC0].d0=aut.C0[iC0-1].d0;
               aut.C0[iC0-1].d0= d;
               ORDERED=false;
            }else{
               iG2=jG2;
            }
         }
         if( ORDERED )break;
      }
   }
//
//
// mark start and end of variable segments
//
   if( (opt.MODE=="bb ")||(opt.MODE=="sc ")||(opt.MODE=="lp ") ){
      for(int iZ0= 0;iZ0<nZ0;iZ0++){
         int mQ2=(con.Z0[iZ0].Q2a+1);
         int nQ2=(mQ2-2+con.Z0[iZ0].cQ2);
         if( nQ2<mQ2 )continue;
         for(int iQ2=mQ2;iQ2<=nQ2;iQ2++){
            aut.Q2[iQ2].bor=0;
         }
         int nQ2bb=(mQ2-2+con.Z0[iZ0].cQ2bb);
         if( nQ2bb>(mQ2+1) ){
            int mQ1=(Z0[iZ0].Q1a+1);
            int nQ1bb=(mQ1-2+Z0[iZ0].cQ1bb);
            if( aut.Q2[mQ2  ].Q1>(mQ1  +2) )aut.Q2[mQ2  ].bor=1;
            if( aut.Q2[nQ2bb].Q1<(nQ1bb-2) )aut.Q2[nQ2bb].bor=2;
            for(int iQ2=(mQ2+1);iQ2<nQ2bb;iQ2++){
               if( aut.Q2[iQ2+1].Q1>(aut.Q2[iQ2  ].Q1+1) )aut.Q2[iQ2  ].bor=2;
               if( aut.Q2[iQ2  ].Q1>(aut.Q2[iQ2-1].Q1+1) )aut.Q2[iQ2  ].bor=1;
            }
         }
      }
   }
   return;
}
