#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../dst/Distance_Constraints.hh"
#include "../fil/Structure.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../set/Set_Automatic.hh"
#include <string>
#include <vector>
#include <cstdlib>
#include <sstream>
#include <cmath>

class MEM_set_q1 {
private:
   std::vector<int> o_R0G1a;            //
   std::vector<int> o_X1bse;            //
   std::vector<double> o_F1q;           //
public:
   MEM_set_q1(int oR0,int oX1,int oF1):
      o_R0G1a(oR0),
      o_X1bse(oX1),
      o_F1q(oF1)
   {
   }
   int& R0G1a(int i){
      return o_R0G1a.at( i);  }
   int& X1bse(int i){
      return o_X1bse.at( i);  }
   double& F1q(int i){
      return o_F1q.at( i);  }
};

void Mechanical_System::SET_Q1(Set_Automatic& aut,
                               const DAT_PHYSICS_CONSTS& physics_consts,
                               const DAT_ARRAY_CONSTS& array_consts,
                               const DAT_ENERGY_PARAMS& energy_params,
                               const DAT_RESIDUE_MAPPINGS& residue_mappings,
                               const Structure& str,
                               const Distance_Constraints& dst,
                               Subset_Contracted_System::tM3& con,
                               Conf_Dependent_System& dep){
   int oR0=R0.size();
   int oX1=X1.size();
   int oF1=F1.size();
   MEM_set_q1 vv(oR0,oX1,oF1);

   int oQ0=residue_mappings.Q0.size();
   int oU0=residue_mappings.U0.size();
   int oF0=residue_mappings.F0.size();
   int oG0=residue_mappings.G0.size();
   int oH0=residue_mappings.H0.size();
   int oS1=con.oS1;
//
//
// populate Mechanical_System, 1st pass
//
   int mQ1=0;
   int mX1=0;
   int mU1=0;
   int mF1=0;
   int mB1=0;
   int mG1=0;
   int mH1=0;
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      dep.Z0[iZ0].trans=str.Z0[iZ0].trans;
      dep.Z0[iZ0].rot=str.Z0[iZ0].rot;
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      Z0[iZ0].R0a=mR0;
      Z0[iZ0].cR0=(nR0-mR0+1);

      Z0[iZ0].Q1a=mQ1;
      Z0[iZ0].cQ1=1;
      Z0[iZ0].cQ1bb=1;
      Z0[iZ0].F1a=mF1;
      Z0[iZ0].cF1=0;
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int iL0=str.R0[iR0].L0;
         Z0[iZ0].cQ1+=residue_mappings.L0[iL0].cQ0;
         Z0[iZ0].cQ1bb+=( residue_mappings.L0[iL0].cQ0
                         -residue_mappings.L0[iL0].cU0);
         Z0[iZ0].cF1+=residue_mappings.L0[iL0].cF0;
      }

      con.Q1[mQ1].sub=false;
      Q1[mQ1].br=0;
      Q1[mQ1].omg=0;
      aut.Q1[mQ1].sq=0;
      Q1[mQ1].tu.identity();

      mX1+=Z0[iZ0].cQ1;
      mF1+=Z0[iZ0].cF1;
      aut.X1[mX1-1].sx=0;
      Z0[iZ0].U1a=mU1;
      Z0[iZ0].B1a=mB1;
      Z0[iZ0].G1a=mG1;
      Z0[iZ0].H1a=mH1;
      int pX0=-1,dX0,pU0=-1,dU0,pF0=-1,dF0,pG0=-1,dG0,pH0=-1,dH0;
      int pG1=-1;
      int dG1=1;
      int iQ1bb=(mQ1+1);
      int iQ1sc=(mQ1+Z0[iZ0].cQ1bb);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int iL0=str.R0[iR0].L0;
         R0[iR0].L0=iL0;
         int mQ0=residue_mappings.L0[iL0].Q0a;
         int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
         int mX0=mQ0;
         int nX0=nQ0;
         int mU0=residue_mappings.L0[iL0].U0a;
         int nU0=(mU0-1+residue_mappings.L0[iL0].cU0);
         int mF0=residue_mappings.L0[iL0].F0a;
         int nF0=(mF0-1+residue_mappings.L0[iL0].cF0);
         int mB0=residue_mappings.L0[iL0].B0a;
         int nB0=(mB0-1+residue_mappings.L0[iL0].cB0);
         int mG0=residue_mappings.L0[iL0].G0a;
         int nG0=(mG0-1+residue_mappings.L0[iL0].cG0);
         int mH0=residue_mappings.L0[iL0].H0a;
         int nH0=(mH0-1+residue_mappings.L0[iL0].cH0);
//       int mJ0=residue_mappings.L0[iL0].J0a;
//       int nJ0=(mJ0-1+residue_mappings.L0[iL0].cJ0);
//       int mY0=residue_mappings.L0[iL0].Y0a;
//       int nY0=(mY0-1+residue_mappings.L0[iL0].cY0);
         int jS1=-1;
         int jN2=-1;
         if( oS1>0 ){
            for(int iS1= 0;iS1<oS1;iS1++){
               for(int iN2=0;iN2<2;iN2++){
                  if( con.S1N2Z0(iS1,iN2)!=iZ0 )continue;
                  if( con.S1N2R0(iS1,iN2)!=iR0 )continue;
                  jS1=iS1;
                  jN2=iN2;
               }
            }
         }
         char c1=residue_mappings.L0[iL0].c1;
         R0[iR0].c1=c1;
         std::string aa=residue_mappings.L0[iL0].aa;
         R0[iR0].aa=aa;
         if      ( c1=='r' ){
            int jL0=str.R0[iR0+1].L0;
            mX1-=(residue_mappings.L0[iL0].cQ0
                 +residue_mappings.L0[jL0].cQ0);
            mF1-=(residue_mappings.L0[iL0].cF0
                 +residue_mappings.L0[jL0].cF0);
         }else if( c1=='b' ){
            int jL0=str.R0[iR0-1].L0;
            mF1+=(pF0+1-residue_mappings.L0[jL0].F0a);
            mX1+=(pX0+1-residue_mappings.L0[jL0].Q0a);
         }else{
            mF1-=residue_mappings.L0[iL0].cF0;
            mX1-=residue_mappings.L0[iL0].cQ0;
         }
         if( c1=='r' ){
            int jL0=str.R0[iR0+1].L0;
            dX0=residue_mappings.L0[jL0].cQ0;
            pU0=mU0;
            dU0=residue_mappings.L0[jL0].cU0;
            dF0=residue_mappings.L0[jL0].cF0;
            dG0=1;
            pH0=(residue_mappings.U0[mU0].H0a
                +residue_mappings.U0[mU0].cH0-1);
            dH0=residue_mappings.L0[jL0].cH0;
            for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
               if      ( residue_mappings.Q0[iQ0].ext==1 ){
                  pG0=(residue_mappings.Q0[iQ0].G0a
                      +residue_mappings.Q0[iQ0].cG0-2);
                  pG1=(mG1+pG0+1-mG0);
               }else if( residue_mappings.Q0[iQ0].ext==2 ){
                  pX0=residue_mappings.Q0[iQ0].X0;
                  pF0=(residue_mappings.X0[pX0].F0a
                      +residue_mappings.X0[pX0].cF0-2);
               }
            }
         }else{
            pX0=oQ0;
            dX0=0;
            pU0=oU0;
            dU0=0;
            pF0=oF0;
            dF0=0;
            pG0=oG0;
            dG0=0;
            pH0=oH0;
            dH0=0;
         }
         if( aa=="5OH " ){
            mG1--;
         }
         vv.R0G1a(iR0)=mG1;
         R0[iR0].F1a=mF1;
         R0[iR0].cF1=residue_mappings.L0[iL0].cF0;
         R0[iR0].X1a=mX1;
         R0[iR0].cX1=residue_mappings.L0[iL0].cQ0;
         if( c1=='r' ){
            R0[iR0].cF1+=dF0;
            R0[iR0].cX1+=dX0;
         }

         if( nQ0>=mQ0 ){
            for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
               int iQ1=( residue_mappings.Q0[iQ0].br>0 )? iQ1sc++: iQ1bb++;
               con.Q1[iQ1].sub=con.R0Q0sub(iR0,iQ0-mQ0);
               Q1[iQ1].tor=residue_mappings.Q0[iQ0].tor;
               std::string tor=Q1[iQ1].tor;
               int jR0=( ((c1=='a')||(c1=='e'))&&
                         (tor=="OMG") )? iR0-1: iR0;
               int iT1=str.itorsion(jR0,tor);
               if( iT1==-1 ){
                  std::exit( 2);
               }else{
                  dep.Q1[iQ1].chi= (physics_consts.RAD*str.T1[iT1].chi);
               }
               Q1[iQ1].br=residue_mappings.Q0[iQ0].br;
               Q1[iQ1].omg=( residue_mappings.Q0[iQ0].omg )? 1: 0;
               Q1[iQ1].cbr=residue_mappings.Q0[iQ0].cbr;
               if( residue_mappings.Q0[iQ0].jnt>0 ){
                  Q1[iQ1].jnt=(iQ1-residue_mappings.Q0[iQ0].jnt);
               }else{
                  Q1[iQ1].jnt=(iQ1bb-1);
               }
               int iF0=residue_mappings.Q0[iQ0].bse;
               Q1[iQ1].bse=(mF1+iF0-mF0);
               if( iF0>pF0 ){
                  Q1[iQ1].bse+=dF0;
               }
               int iG0=residue_mappings.Q0[iQ0].G0a;
               Q1[iQ1].G1a=(mG1+iG0-mG0);
               if      ( c1=='r' ){
                  if( iG0>pG0 ){
                     Q1[iQ1].G1a+=dG0;
                  }
               }else if( c1=='b' ){
                  Q1[iQ1].G1a+=dG1;
               }
               Q1[iQ1].cG1=residue_mappings.Q0[iQ0].cG0;
               aut.Q1[iQ1].chg=residue_mappings.Q0[iQ0].chg;
               Q1[iQ1].tu=residue_mappings.Q0[iQ0].tu;
               Q1[iQ1].tau=residue_mappings.Q0[iQ0].tau;
               int iX0=residue_mappings.Q0[iQ0].X0a;
               if      ( c1=='r' ){
                  aut.Q1[iQ1].X1a=(mX1+iX0-mX0);
                  if( iX0>pX0 ){
                     aut.Q1[iQ1].X1a+=dX0;
                  }
               }else if( c1=='b' ){
                  aut.Q1[iQ1].X1a=(mX1+nU0-mU0+1);
               }else{
                  aut.Q1[iQ1].X1a=(mX1+iX0-mX0);
               }
               if( residue_mappings.Q0[iQ0].br==0 ){
                  aut.Q1[iQ1].U1a=-1;
                  aut.Q1[iQ1].U1z=-1;
               }else{
                  int iU0=residue_mappings.Q0[iQ0].U0;
                  if      ( c1=='r' ){
                     aut.Q1[iQ1].U1a=(mU1+iU0-mU0);
                     if( iU0>pU0 ){
                        aut.Q1[iQ1].U1a+=dU0;
                     }
                     if( iU0==mU0 ){
                        aut.Q1[iQ1].U1z=aut.Q1[iQ1].U1a;
                     }else{
                        aut.Q1[iQ1].U1z=(mU1+nU0-mU0+dU0);
                     }
                  }else if( c1=='b' ){
                     aut.Q1[iQ1].U1a=(mU1+iU0-mU0);
                     int jL0=str.R0[iR0-1].L0;
                     aut.Q1[iQ1].U1z=(mU1+nU0-mU0
                                     +residue_mappings.L0[jL0].cU0-1);
                  }else{
                     aut.Q1[iQ1].U1a=(mU1+iU0-mU0);
                     aut.Q1[iQ1].U1z=(mU1+nU0-mU0);
                     if( ((aa=="eAIB")||(aa=="AIB ")||(aa=="AIBe"))&&
                         (tor=="CH2") ){
                        aut.Q1[iQ1].U1z=aut.Q1[iQ1].U1a;
                     }
                  }
               }
               iX0=residue_mappings.Q0[iQ0].X0;
               int iX1=(mX1+iX0-mX0);
               if( iX0>pX0 ){
                  iX1+=dX0;
               }
               aut.X1[iX1].Q1=iQ1;
               aut.Q1[iQ1].sq=0;
               if( jS1>=0 ){
                  aut.Q1[iQ1].sq=con.S1N2Q0sq(jS1,jN2,iQ0-mQ0);
               }
            }
         }

         if( nX0>=mX0 ){
            for(int iX0=mX0;iX0<=nX0;iX0++){
               int iX1=(mX1+iX0-mX0);
               if( iX0>pX0 ){
                  iX1+=dX0;
               }
               int iF0=residue_mappings.X0[iX0].bse;
               vv.X1bse(iX1)=(mF1+iF0-mF0);
               if( iF0>pF0 ){
                  vv.X1bse(iX1)+=dF0;
               }
               iF0=residue_mappings.X0[iX0].F0a;
               X1[iX1].F1a=(mF1+iF0-mF0);
               if( iF0>pF0 ){
                  X1[iX1].F1a+=dF0;
               }
               X1[iX1].cF1=residue_mappings.X0[iX0].cF0;
               if( (c1=='r')&&
                   (iX0==nX0) ){
                  int jL0=str.R0[iR0-1].L0;
                  std::string ab=residue_mappings.L0[jL0].aa;
                  if( ab=="5OH " ){
                     X1[iX1].cF1++;
                  }
               }
               aut.X1[iX1-1].sx=0;
               if( jS1>=0 ){
                  aut.X1[iX1-1].sx=con.S1N2X0sx(jS1,jN2,iX0-mX0);
               }
            }
         }

         if( nU0>=mU0 ){
            for(int iU0=mU0;iU0<=nU0;iU0++){
               int iU1=(mU1+iU0-mU0);
               if( iU0>pU0 ){
                  iU1+=dU0;
               }
               int iX0=residue_mappings.U0[iU0].X0;
               int iX1=(mX1+iX0-mX0);
               if( iX0>pX0 ){
                  iX1+=dX0;
               }
               aut.U1[iU1].Q1=aut.X1[iX1].Q1;
               int iH0=residue_mappings.U0[iU0].H0a;
               int iH1=(mH1+iH0-mH0);
               if( iH0>pH0 ){
                  iH1+=dH0;
               }
               U1[iU1].H1a=iH1;
               U1[iU1].cH1=residue_mappings.U0[iU0].cH0;
            }
            for(int iH0=mH0;iH0<=nH0;iH0++){
               int iH1=(mH1+iH0-mH0);
               if( iH0>pH0 ){
                  iH1+=dH0;
               }
               std::string rec=residue_mappings.H0[iH0].F0;
               int iF1=-1;
               if( rec[0]=='[' ){
                  std::string atm=rec.substr( 1, 4);
                  if      ( c1=='r' ){
                     int jL0=str.R0[iR0+2].L0;
                     int aF0=residue_mappings.L0[jL0].F0a;
                     int bF0=(aF0-1+residue_mappings.L0[jL0].cF0);
                     int aF1=(mF1-bF0+aF0-1);
                     for(int iF0=aF0;iF0<=bF0;iF0++){
                        if( residue_mappings.F0[iF0].atm==atm ){
                           iF1=(aF1+iF0-aF0);
                        }
                     }
                  }else if( c1=='b' ){
                     int aF1=R0[iR0-1].F1a;
                     int bF1=(aF1-1+R0[iR0-1].cF1);
                     int nF1=(mF1+nF0-mF0);
                     for(int jF1=aF1;jF1<bF1;jF1++){
                        if      ( jF1<mF1 ){
                        }else if( jF1>nF1 ){
                        }else{
                           continue;
                        }
                        if( F1[jF1].atm==atm ){
                           iF1=jF1;
                        }
                     }
                  }else{
                     std::exit( 2);
                  }
               }else{
                  int iF0;
                  std::istringstream(rec.substr( 1, 4))>>iF0;
                  iF0+=(mF0-1);
                  iF1=(mF1+iF0-mF0);
                  if( iF0>pF0 ){
                     iF1+=dF0;
                  }
               }
               H1[iH1].F1=iF1;
            }
            if      ( c1=='r' ){
               mU1+=(pU0-mU0+1);
            }else if( c1=='b' ){
               int jL0=str.R0[iR0-1].L0;
               mU1+=(nU0-mU0+residue_mappings.L0[jL0].cU0);
            }else{
               mU1+=(nU0-mU0+1);
            }
            mH1=(U1[mU1-1].H1a+U1[mU1-1].cH1);
         }

         if( nG0>=mG0 ){
            for(int iG0=mG0;iG0<=nG0;iG0++){
               int iG1=(mG1+iG0-mG0);
               if      ( c1=='r' ){
                  if( iG0>pG0 ){
                     iG1+=dG0;
                  }
                  if( iG1<Z0[iZ0].G1a )continue;
               }else if( c1=='b' ){
                  iG1+=dG1;
               }else if( c1=='p' ){
                  if( iR0>mR0 ){
                  if( iG0<(mG0+dG1) ){
                     iG1=(pG1+iG0-mG0);
                  }
                  }
               }
               aut.G1[iG1].sg=0;
               if( jS1>=0 ){
                  aut.G1[iG1].sg=con.S1N2G0sg(jS1,jN2,iG0-mG0);
               }
               int iF0=residue_mappings.G0[iG0].F0;
               G1[iG1].F1=(mF1+iF0-mF0);
               if( iF0>pF0 ){
                  G1[iG1].F1+=dF0;
               }
               G1[iG1].b= residue_mappings.G0[iG0].b;
            }
            mG1+=residue_mappings.L0[iL0].cG0;
         }

         for(int iF0=mF0;iF0<=nF0;iF0++){
            int iF1=(mF1+iF0-mF0);
            if( iF0>pF0 ){
               iF1+=dF0;
            }
            F1[iF1].atm=residue_mappings.F0[iF0].atm;
            F1[iF1].typ=residue_mappings.F0[iF0].typ;
            F1[iF1].hb=residue_mappings.F0[iF0].hb;
            int lnk=residue_mappings.F0[iF0].lnk;
            if( lnk>-1 ){
               F1[iF1].lnk=(mF1+lnk-mF0);
               if( lnk>pF0 ){
                  F1[iF1].lnk+=dF0;
               }
            }else{
               F1[iF1].lnk=-1;
            }
            F1[iF1].lte=residue_mappings.F0[iF0].lte;
            aut.F1[iF1].ztip=-1;
            aut.F1[iF1].zbse=-1;
            aut.F1[iF1].xtip=-1;
            aut.F1[iF1].xbse=-1;
            if( F1[iF1].lte>-1 ){
               std::string ztip=residue_mappings.F0[iF0].ztip;
               std::string zbse=residue_mappings.F0[iF0].zbse;
               std::string xtip=residue_mappings.F0[iF0].xtip;
               std::string xbse=residue_mappings.F0[iF0].xbse;
               if( ztip=="    " ){
               }else{
                  int jzt=residue_mappings.if0atom(iL0,ztip);
                  if( jzt==-1 ){
                     int jL0;
                     int bF0;
                     if      ( c1=='p' ){ // C5'
                        jL0=str.R0[iR0+1].L0;
                        bF0=(mF0-residue_mappings.L0[jL0].cF0);
                     }else if( c1=='b' ){ // C1'
                        jL0=str.R0[iR0-1].L0;
                        bF0=(mF0-R0[iR0  ].F1a+R0[iR0-1].F1a);
                     }else{
                        std::exit( 2);
                     }
                     int jF0=residue_mappings.if0atom(jL0,ztip);
                     if( jF0==-1 )std::exit( 2);
                     jzt=(bF0+jF0-residue_mappings.L0[jL0].F0a);
                  }
                  aut.F1[iF1].ztip=(mF1+jzt-mF0);
                  if( jzt>pF0 ){
                     aut.F1[iF1].ztip+=dF0;
                  }
               }
               if( zbse=="    " ){
               }else{
                  int jzb=residue_mappings.if0atom(iL0,zbse);
                  if( jzb==-1 ){
                     std::exit( 2);
                  }
                  aut.F1[iF1].zbse=(mF1+jzb-mF0);
                  if( jzb>pF0 ){
                     aut.F1[iF1].zbse+=dF0;
                  }
               }
               if( xtip=="    " ){
               }else{
                  int jxt=residue_mappings.if0atom(iL0,xtip);
                  if( jxt==-1 ){
                     int jL0;
                     int bF0;
                     if      ( c1=='r' ){ // O5'
                        jL0=str.R0[iR0-1].L0;
                        bF0=(nF0+1);
                     }else if( c1=='p' ){ // C3' or C5'
                        if      ( xtip==" C3'" ){
                           jL0=str.R0[iR0-2].L0;
                           bF0=(nF0+1);
                        }else if( xtip==" C5'" ){
                           jL0=str.R0[iR0+1].L0;
                           bF0=(mF0-residue_mappings.L0[jL0].cF0);
                        }else{
                           std::exit( 2);
                        }
                     }else if( c1=='b' ){ // C1'
                        jL0=str.R0[iR0-1].L0;
                        bF0=(mF0-R0[iR0  ].F1a+R0[iR0-1].F1a);
                     }else{
                        std::exit( 2);
                     }
                     int jF0=residue_mappings.if0atom(jL0,xtip);
                     if( jF0==-1 )std::exit( 2);
                     jxt=(bF0+jF0-residue_mappings.L0[jL0].F0a);
                  }
                  aut.F1[iF1].xtip=(mF1+jxt-mF0);
                  if( jxt>pF0 ){
                     aut.F1[iF1].xtip+=dF0;
                  }
               }
               if( xbse=="    " ){
               }else{
                  int jxb=residue_mappings.if0atom(iL0,xbse);
                  if( jxb==-1 ){
                     std::exit( 2);
                  }
                  aut.F1[iF1].xbse=(mF1+jxb-mF0);
                  if( jxb>pF0 ){
                     aut.F1[iF1].xbse+=dF0;
                  }
               }
               F1[iF1].q= residue_mappings.F0[iF0].q;
            }
            F1[iF1].lhb=residue_mappings.F0[iF0].lhb;
            if( F1[iF1].lhb>-1 ){
               F1[iF1].p= residue_mappings.F0[iF0].p;
            }
            F1[iF1].gau=residue_mappings.F0[iF0].gau;
            F1[iF1].mu=residue_mappings.F0[iF0].mu;
            for(int i=0;i<3;i++){
               F1[iF1].fac[i]=-1;
            }
            int mu=residue_mappings.F0[iF0].mu;
            if( mu>0 ){
               for(int i=0;i<mu;i++){
                  int fac=residue_mappings.F0[iF0].fac[i];
                  if      ( fac> 500 ){
                     if( c1!='r' )std::exit( 2);
                     fac-=500;
                     int kF0=(fac+mF0-1);
                     F1[iF1].fac[i]=(mF1+kF0-mF0);
                  }else if( fac>   0 ){
                     int kF0=(fac+mF0-1);
                     F1[iF1].fac[i]=(mF1+kF0-mF0);
                     if( kF0>pF0 ){
                        F1[iF1].fac[i]+=dF0;
                     }
                  }else if( fac== -1 ){
                     if( (c1!='a')&&(c1!='e') )std::exit( 2);
                     int jL0=str.R0[iR0+1].L0;
                     std::string atm=" N  ";
                     int bF0=(mF0-residue_mappings.L0[jL0].cF0);
                     int jF0=residue_mappings.if0atom(jL0,atm);
                     if( jF0==-1 )std::exit( 2);
                     int kF0=(bF0+jF0-residue_mappings.L0[jL0].F0a);
                     F1[iF1].fac[i]=(mF1+kF0-mF0);
                  }else if( fac== -4 ){
                     if( c1!='r' )std::exit( 2);
                     int kF0=(fac+mF0-1);
                     F1[iF1].fac[i]=(mF1+kF0-mF0);
                  }else if( fac==-11 ){
                     if( c1!='p' )std::exit( 2);
                     int kF0=(fac+mF0-1);
                     F1[iF1].fac[i]=(mF1+kF0-mF0);
                  }else if( fac==-12 ){
                     if( c1!='b' )std::exit( 2);
                     int kF0=(fac+mF0-1);
                     F1[iF1].fac[i]=(mF1+kF0-mF0);
                  }else{
                     std::exit( 2);
                  }
               }
            }
            if( residue_mappings.F0[iF0].typ==30 ){
               F1[iF1].wjnt=residue_mappings.F0[iF0].wjnt;
               F1[iF1].u=residue_mappings.F0[iF0].u;
            }
            for(int i=0;i<4;i++){
               F1[iF1].ef[i]=residue_mappings.F0[iF0].ef[i];
            }
            F1[iF1].zet=residue_mappings.F0[iF0].zet;
            F1[iF1].vf=residue_mappings.F0[iF0].vf;
            F1[iF1].kap=residue_mappings.F0[iF0].kap;
            con.F1[iF1].sf=4;
            if( jS1>=0 ){
               con.F1[iF1].sf=con.S1N2F0sf(jS1,jN2,iF0-mF0);
            }
            F1[iF1].R0=iR0;
         }

         if( nB0>=mB0 ){
            for(int iB0=mB0;iB0<=nB0;iB0++){
               int iB1=(mB1+iB0-mB0);
               aut.B1[iB1].sb=0;
               if( jS1>=0 ){
                  aut.B1[iB1].sb=con.S1N2B0sb(jS1,jN2,iB0-mB0);
                  if( (aut.B1[iB1].sb&7)>0 )aut.Q1[mQ1].sq=(jS1+1);
               }
               int iF0=residue_mappings.B0[iB0].F0;
               B1[iB1].F1=(mF1+iF0-mF0);
               B1[iB1].x=residue_mappings.B0[iB0].x;
            }
            mB1+=residue_mappings.L0[iL0].cB0;
         }

         if( c1=='b' ){
            mF1=R0[iR0-1].F1a;
            mX1=R0[iR0-1].X1a;
         }
      }
      if( str.R0[mR0].aa=="5OH " ){
         Q1[mQ1+1].tu.identity();
      }
      Z0[iZ0].cU1=(mU1-Z0[iZ0].U1a);
      Z0[iZ0].cB1=(mB1-Z0[iZ0].B1a);
      Z0[iZ0].cG1=(mG1-Z0[iZ0].G1a);
      Z0[iZ0].cH1=(mH1-Z0[iZ0].H1a);

      mQ1+=Z0[iZ0].cQ1;
      mX1=mQ1;
      mF1=(Z0[iZ0].F1a+Z0[iZ0].cF1);
   }
//
//
// populate Mechanical_System, 2nd pass
//
   int mJ1=0;
   int mY1=0;
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      Z0[iZ0].J1a=mJ1;
      Z0[iZ0].Y1a=mY1;
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int iL0=str.R0[iR0].L0;
         char c1=residue_mappings.L0[iL0].c1;
         int mJ0=residue_mappings.L0[iL0].J0a;
         int nJ0=(mJ0-1+residue_mappings.L0[iL0].cJ0);
         int mY0=residue_mappings.L0[iL0].Y0a;
         int nY0=(mY0-1+residue_mappings.L0[iL0].cY0);
         int aX1=R0[iR0  ].X1a;
         int bX1=(aX1-1+R0[iR0  ].cX1);
         if      ( c1=='r' ){
         }else if( c1=='p' ){
            if( iR0>mR0 ){
               bX1+=(R0[iR0-2].cX1-2);
            }
            if( iR0<nR0 ){
               aX1-=2;
            }
         }else if( c1=='b' ){
            aX1=R0[iR0-1].X1a;
            bX1=(aX1-1+R0[iR0-1].cX1);
         }else{
         }
         int aJ1=mJ1;
         int bJ1=(aJ1+nJ0-mJ0);
         if      ( c1=='r' ){
         }else if( c1=='p' ){
            if( iR0>mR0 ){
               for(int jR0=(iR0-1);jR0>(iR0-3);jR0--){
                  int jL0=str.R0[jR0].L0;
                  aJ1-=residue_mappings.L0[jL0].cJ0;
               }
            }
         }else if( c1=='b' ){
            int jL0=str.R0[iR0-1].L0;
            aJ1-=residue_mappings.L0[jL0].cJ0;
         }else{
         }

         if( nJ0>=mJ0 ){
            for(int iJ0=mJ0;iJ0<=nJ0;iJ0++){
               int iJ1=(mJ1+iJ0-mJ0);
               for(int iN2=0;iN2<2;iN2++){
                  std::string tor=residue_mappings.J0N2tor(iJ0,iN2);
                  J1N2Q1(iJ1,iN2)=-1;
                  for(int iX1=aX1;iX1<=bX1;iX1++){
                     int iQ1=aut.X1[iX1].Q1;
                     if( Q1[iQ1].tor==tor ){
                        J1N2Q1(iJ1,iN2)=iQ1;
                     }
                  }
                  if( J1N2Q1(iJ1,iN2)==-1 ){
                     std::exit( 2);
                  }
               }
               J1[iJ1].tau=residue_mappings.J0[iJ0].tau;
            }
            mJ1+=(nJ0-mJ0+1);
         }

         if( nY0>=mY0 ){
            for(int iY0=mY0;iY0<=nY0;iY0++){
               int iY1=(mY1+iY0-mY0);
               for(int iN3=0;iN3<3;iN3++){
                  std::string tor=residue_mappings.Y0N3tor(iY0,iN3);
                  Y1N3Q1(iY1,iN3)=-1;
                  Y1N3J1(iY1,iN3)=-1;
                  for(int iX1=aX1;iX1<=bX1;iX1++){
                     int iQ1=aut.X1[iX1].Q1;
                     if( Q1[iQ1].tor==tor ){
                        Y1N3Q1(iY1,iN3)=iQ1;
                     }
                  }
                  if( Y1N3Q1(iY1,iN3)==-1 ){
                     std::exit( 2);
                  }
               }
               Y1[iY1].tau=residue_mappings.Y0[iY0].tau;
               for(int iJ1=aJ1;iJ1<=bJ1;iJ1++){
                  int iQ1=J1N2Q1(iJ1, 0);
                  int jQ1=J1N2Q1(iJ1, 1);
                  if      ( (iQ1==Y1N3Q1(iY1, 0))&&(jQ1==Y1N3Q1(iY1, 1)) ){
                     Y1N3J1(iY1, 0)=iJ1;
                  }else if( (iQ1==Y1N3Q1(iY1, 0))&&(jQ1==Y1N3Q1(iY1, 2)) ){
                     Y1N3J1(iY1, 1)=iJ1;
                  }else if( (iQ1==Y1N3Q1(iY1, 1))&&(jQ1==Y1N3Q1(iY1, 2)) ){
                     Y1N3J1(iY1, 2)=iJ1;
                  }
               }
            }
            mY1+=(nY0-mY0+1);
         }

      }
      Z0[iZ0].cJ1=(mJ1-Z0[iZ0].J1a);
      Z0[iZ0].cY1=(mY1-Z0[iZ0].Y1a);
   }
//
// patch for cis peptide bond preceding PRO
// (observed occurance ~.100) target de~ 1.364 kcal
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      int mQ1=Z0[iZ0].Q1a;
//    int nQ1=(mQ1-1+Z0[iZ0].cQ1);
      int iQ1bb=(mQ1+1);
      int iQ1sc=(mQ1+Z0[iZ0].cQ1bb);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         std::string aa=str.R0[iR0  ].aa;
         if( (aa=="HPR ")||(aa=="PROe") )aa=="PRO ";
         int iL0=str.R0[iR0].L0;
         int mQ0=residue_mappings.L0[iL0].Q0a;
         int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
         if( nQ0>=mQ0 ){
            for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
               int iQ1=( residue_mappings.Q0[iQ0].br>0 )? iQ1sc++: iQ1bb++;
               if( aa=="PRO " ){
                  std::string tor=Q1[iQ1].tor;
                  if( tor=="OMG" ){
                     double z= (2.525);
                     z*=(energy_params.fac_pp/physics_consts.CAL);
/**/                 Q1[iQ1].tau( 0)+=( 1.00000)*z;
/**/                 Q1[iQ1].tau( 1)+=(-1.00000)*z;
                  }
               }
            }
         }
      }
   }
//
// patch for alpha conf preceding PRO
// (observed occurance ~.125) target de~ 1.232 kcal
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      int mQ1=Z0[iZ0].Q1a;
//    int nQ1=(mQ1-1+Z0[iZ0].cQ1);
      int iQ1bb=(mQ1+1);
      int iQ1sc=(mQ1+Z0[iZ0].cQ1bb);
      for(int iR0=mR0;iR0<nR0;iR0++){
         std::string aa=str.R0[iR0  ].aa;
         if( (aa=="ACE ")||(aa=="eGLY") )aa="GLY ";
         std::string ab=str.R0[iR0+1].aa;
         if( (ab=="HPR ")||(ab=="PROe") )ab=="PRO ";
         int iL0=str.R0[iR0].L0;
         int mQ0=residue_mappings.L0[iL0].Q0a;
         int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
         if( nQ0>=mQ0 ){
            for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
               int iQ1=( residue_mappings.Q0[iQ0].br>0 )? iQ1sc++: iQ1bb++;
               if( (aa!="GLY ")&&(ab=="PRO ") ){
                  std::string tor=Q1[iQ1].tor;
                  if( tor=="PSI" ){
                     double z= (2.475);
                     z*=(energy_params.fac_pp/physics_consts.CAL);
/**/                 Q1[iQ1].tau( 0)+=( 1.00000)*z;
/**/                 Q1[iQ1].tau( 1)+=(-0.50000)*z;
/**/                 Q1[iQ1].tau( 2)+=( 0.86602)*z;
                  }
               }
            }
         }
      }
   }
//
// patch for nucleic acid end groups 5OH, 5PO, PSR, and PSS
//
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      int mQ1=Z0[iZ0].Q1a;
//    int nQ1=(mQ1-1+Z0[iZ0].cQ1);
      int iQ1bb=(mQ1+1);
      int iQ1sc=(mQ1+Z0[iZ0].cQ1bb);
      for(int iR0=mR0;iR0<nR0;iR0++){
         char c1=R0[iR0].c1;
         int iL0=str.R0[iR0].L0;
         int mQ0=residue_mappings.L0[iL0].Q0a;
         int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
         if( nQ0>=mQ0 ){
            for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
               int iQ1=( residue_mappings.Q0[iQ0].br>0 )? iQ1sc++: iQ1bb++;
               if( c1=='r' ){
                  std::string aa=str.R0[iR0-1].aa;
                  if( Q1[iQ1].tor=="BET" ){
                     if      ( aa=="5OH " ){
                        Q1[iQ1].tau( 0)= ( 0.0000);
                        std::string rec=
                          "  2.0439  0.3965  0.3979  0.0793  0.2998 -0.0250"
                          " -0.0870 -0.0076 -0.0050 -0.0087  0.0003  0.0021"
                          " -0.0031 -0.0057  0.0031 -0.0023  0.0013  0.0010"
                          "  0.0010 -0.0007  0.0009  0.0007  0.0011  0.0005";
                        std::istringstream irec(rec);
                        for(int i= 1;i<25;i++){
                           irec>>Q1[iQ1].tau( i);
                        }
                        double z= (energy_params.fac_pp/physics_consts.CAL);
                        Q1[iQ1].tau*=z;
                     }else if( aa=="5PO " ){
                        Q1[iQ1].tau( 0)= ( 0.0000);
                        std::string rec=
                          " -1.5860 -1.3048  2.3481  0.1826 -0.4806  0.3677"
                          "  0.2858  0.1447 -0.9316 -0.0451  0.0731  0.0963"
                          " -0.5194 -0.3616  0.6856  0.2157  0.4302  0.0656"
                          "  1.3524  0.8465  0.6608  0.5348  0.7893  0.8254";
                        std::istringstream irec(rec);
                        for(int i= 1;i<25;i++){
                           irec>>Q1[iQ1].tau( i);
                        }
                        double z= (energy_params.fac_pp/physics_consts.CAL);
                        Q1[iQ1].tau*=z;
                     }else if( aa=="PSR " ){
                        Q1[iQ1].tau( 0)= ( 0.0000);
                        std::string rec=
                          "  0.5401 -0.8247  0.3443 -0.4405 -1.0321  0.1278"
                          "  0.1181  0.0565 -0.4307 -0.0453  0.3333  0.2486"
                          " -0.1232  0.3274  0.3230  0.1781 -0.0252 -0.3443"
                          "  0.3959 -0.2560  0.0635 -0.4031  0.5840 -0.0114";
                        std::istringstream irec(rec);
                        for(int i= 1;i<25;i++){
                           irec>>Q1[iQ1].tau( i);
                        }
                        double z= (energy_params.fac_pp/physics_consts.CAL);
                        Q1[iQ1].tau*=z;
                     }else if( aa=="PSS " ){
                        Q1[iQ1].tau( 0)= ( 0.0000);
                        std::string rec=
                          "  0.2254 -0.5047 -0.1614 -0.0147 -0.4924  0.4028"
                          "  0.7000  0.0321 -0.2385 -0.3250  0.0010 -0.0403"
                          " -0.2888  0.1665  0.2091  0.2847  0.0186 -0.0707"
                          "  0.4399 -0.1565  0.2218 -0.4544  0.5193 -0.0624";
                        std::istringstream irec(rec);
                        for(int i= 1;i<25;i++){
                           irec>>Q1[iQ1].tau( i);
                        }
                        double z= (energy_params.fac_pp/physics_consts.CAL);
                        Q1[iQ1].tau*=z;
                     }
                  }
               }
            }
         }
      }
   }
//
//
// orient atomic multipoles consistent with rigid fragments
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mB1=Z0[iZ0].B1a;
      int nB1=(mB1-1+Z0[iZ0].cB1);
      for(int iB1=mB1;iB1<=nB1;iB1++){
         int iF1=B1[iB1].F1;
         aut.F1[iF1].x=B1[iB1].x;
      }
      for(int iB1=mB1;iB1<=nB1;iB1++){
         int iF1=B1[iB1].F1;
         if( F1[iF1].lte<1 )continue;
         Coordinates u= aut.F1[aut.F1[iF1].ztip].x
                       -aut.F1[aut.F1[iF1].zbse].x;
         u.normalize();
         Coordinates v= aut.F1[aut.F1[iF1].xtip].x
                       -aut.F1[aut.F1[iF1].xbse].x;
         double vu= dot(v,u);
         v-=vu*u;
         v.normalize();
         Coordinates w= cross(u,v);
         Rotation_Matrix ROT;
         ROT(0,0)= v(0);
         ROT(1,0)= v(1);
         ROT(2,0)= v(2);
         ROT(0,1)= w(0);
         ROT(1,1)= w(1);
         ROT(2,1)= w(2);
         ROT(0,2)= u(0);
         ROT(1,2)= u(1);
         ROT(2,2)= u(2);
         F1[iF1].q.rotate(array_consts,ROT);
         if( F1[iF1].lhb>-1 ){
            F1[iF1].p.rotate(array_consts,ROT);
         }
      }
      if( Z0[iZ0].cQ1==1 )continue;
      aut.PR[ 0].identity();
      int iQ1=Z0[iZ0].Q1a;
      int iQ1hold=(Z0[iZ0].Q1a+Z0[iZ0].cQ1bb);
      for(int icQ1=(Z0[iZ0].cQ1-1);icQ1>0;icQ1--){
         if( Q1[iQ1].omg==1 ){
            int L=iQ1hold;
            iQ1hold=(iQ1+1);
            iQ1=L;
         }else{
            iQ1++;
         }
         int br=Q1[iQ1].br;
         int cbr=Q1[iQ1].cbr;
         aut.PR[br].extend(aut.PR[cbr],Q1[iQ1].tu,dep.Q1[iQ1].chi);
         int mG1=Q1[iQ1].G1a;
         int nG1=(mG1-1+Q1[iQ1].cG1);
         for(int iG1=mG1;iG1<=nG1;iG1++){
            int iF1=G1[iG1].F1;
            aut.F1[iF1].x.generate(aut.F1[Q1[iQ1].bse].x,
                                   aut.PR[br],
                                   G1[iG1].b);
         }
         for(int iG1=mG1;iG1<=nG1;iG1++){
            int iF1=G1[iG1].F1;
            if( F1[iF1].lte<1 )continue;
            Coordinates u= aut.F1[aut.F1[iF1].ztip].x
                          -aut.F1[aut.F1[iF1].zbse].x;
            u.normalize();
            Coordinates v= aut.F1[aut.F1[iF1].xtip].x
                          -aut.F1[aut.F1[iF1].xbse].x;
            double vu= dot(v,u);
            v-=vu*u;
            v.normalize();
            Coordinates w= cross(u,v);
            Rotation_Matrix ROT;
            ROT(0,0)= v(0);
            ROT(1,0)= v(1);
            ROT(2,0)= v(2);
            ROT(0,1)= w(0);
            ROT(1,1)= w(1);
            ROT(2,1)= w(2);
            ROT(0,2)= u(0);
            ROT(1,2)= u(1);
            ROT(2,2)= u(2);
            F1[iF1].q.rotate(array_consts,ROT);
            if( F1[iF1].lhb>-1 ){
               F1[iF1].p.rotate(array_consts,ROT);
            }
            ROT=transpose(aut.PR[br]);
            F1[iF1].q.rotate(array_consts,ROT);
            if( F1[iF1].lhb>-1 ){
               F1[iF1].p.rotate(array_consts,ROT);
            }
         }
      }
   }
//
//
// neutralize forward groups
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mF1=Z0[iZ0].F1a;
      int nF1=(mF1-1+Z0[iZ0].cF1);
      for(int iF1=mF1;iF1<=nF1;iF1++){
         if( F1[iF1].lte<0 )continue;
         vv.F1q(iF1)= F1[iF1].q.r(0,0);
      }
      int mQ1=Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+Z0[iZ0].cQ1);
      int nQ1bb=(mQ1-1+Z0[iZ0].cQ1bb);
      Q1[nQ1+1].jnt=mQ1;
      if( nQ1>nQ1bb ){
         for(int iQ1=(nQ1bb+1);iQ1<=nQ1;iQ1++){
            if( Q1[iQ1+1].jnt!=iQ1 ){
               int br=Q1[iQ1].br;
               for(int jQ1=iQ1;Q1[jQ1].br==br;jQ1=Q1[jQ1].jnt){
                  int mG1=Q1[jQ1].G1a;
                  int nG1=(mG1-1+Q1[jQ1].cG1);
                  std::string atm='+'+F1[Q1[jQ1].bse].atm.substr(1,3);
                  int jG1=-1;
                  double z=-aut.Q1[jQ1].chg*((.001)/(1.12))
                                           *std::sqrt( energy_params.fac_pp);
                  for(int iG1=mG1;iG1<=nG1;iG1++){
                     int iF1=G1[iG1].F1;
                     if( F1[iF1].lte<0 )continue;
                     z+=vv.F1q(iF1);
                     if( F1[iF1].atm==atm )jG1=iG1;
                  }
                  if( jG1==-1 )std::exit( 2);
                  vv.F1q(Q1[jQ1].bse)+=z;
                  vv.F1q(G1[jG1].F1)-=z;
               }
            }
         }
      }
      if( nQ1bb>mQ1 ){
         for(int iQ1=nQ1bb;iQ1>mQ1;iQ1=Q1[iQ1].jnt){
            int mG1=Q1[iQ1].G1a;
            int nG1=(mG1-1+Q1[iQ1].cG1);
            std::string atm='+'+F1[Q1[iQ1].bse].atm.substr(1,3);
            int jG1=-1;
            double z=-aut.Q1[iQ1].chg*((.001)/(1.12))
                                     *std::sqrt( energy_params.fac_pp);
            for(int iG1=mG1;iG1<=nG1;iG1++){
               int iF1=G1[iG1].F1;
               if( F1[iF1].lte<0 )continue;
               z+=vv.F1q(iF1);
               if( F1[iF1].atm==atm )jG1=iG1;
            }
            if( jG1==-1 )std::exit( 2);
            vv.F1q(Q1[iQ1].bse)+=z;
            vv.F1q(G1[jG1].F1)-=z;
         }
      }
   }
//
//
// charge overlay to reduce full charges of ionized groups
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
//    int nR0=(mR0-1+Z0[iZ0].cR0);
      int mQ1=Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+Z0[iZ0].cQ1);
      int mF1=Z0[iZ0].F1a;
      int nF1=(mF1-1+Z0[iZ0].cF1);
      for(int iF1=mF1;iF1<=nF1;iF1++){
         F1[iF1].ion=false;
         F1[iF1].off= (0.00);
      }
      std::string aa=str.R0[mR0].aa;
      if( (aa[0]=='e')||(aa=="5PO ") ){
         int iX1=nQ1;
         int aF1=X1[iX1].F1a;
         int bF1=(aF1-1+X1[iX1].cF1);
	 std::string atm='+'+F1[vv.X1bse(iX1)].atm.substr(1,3);
         int jF1=-1;
         double z;
         if      ( aa[0]=='e' ){
            z=-((1.000)/(1.12))*std::sqrt( energy_params.fac_pp);
         }else if( aa=="5PO " ){
            z= ((2.000)/(1.12))*std::sqrt( energy_params.fac_pp);
         }
         for(int iF1=aF1;iF1<=bF1;iF1++){
            if( F1[iF1].lte<0 )continue;
            z+=F1[iF1].q.r(0,0);
            if( F1[iF1].atm==atm )jF1=iF1;
         }
         if( jF1==-1 )std::exit( 2);
         F1[vv.X1bse(iX1)].q.r(0,0)+=z;
         F1[jF1].q.r(0,0)-=z;
         for(int iF1=aF1;iF1<=bF1;iF1++){
            if( F1[iF1].lte<0 )continue;
            F1[iF1].ion=true;
            F1[iF1].off=-(.625)*F1[iF1].q.r(0,0);
         }
      }
      if( nQ1>mQ1 ){
         for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
            if( aut.Q1[iQ1].chg==0 )continue;
            int mG1=Q1[iQ1].G1a;
            int nG1=(mG1-1+Q1[iQ1].cG1);
            for(int iG1=mG1;iG1<=nG1;iG1++){
               int iF1=G1[iG1].F1;
               if( F1[iF1].lte<0 )continue;
               F1[iF1].ion=true;
               F1[iF1].off=-(.625)*vv.F1q(iF1);
            }
         }
      }
   }
//
//
// map distance constraints to mechanical system
//
   int oC0=dst.nC0;
   if( oC0>0 ){
      for(int iC0= 0;iC0<oC0;iC0++){
         for(int iN2=0;iN2<2;iN2++){
            int iZ0=dst.C0N2Z0(iC0,iN2);
            int iR0=dst.C0N2R0(iC0,iN2);
            int iL0=str.R0[iR0].L0;
            char c1=residue_mappings.L0[iL0].c1;
            int pF0=oF0;
            int dF0=0;
            if( c1=='r' ){
               int jL0=R0[iR0+1].L0;
               dF0=residue_mappings.L0[jL0].cF0;
               int mQ0=residue_mappings.L0[iL0].Q0a;
               int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
               for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
                  if( residue_mappings.Q0[iQ0].ext==2 ){
                     int pX0=residue_mappings.Q0[iQ0].X0;
                     pF0=(residue_mappings.X0[pX0].F0a
                         +residue_mappings.X0[pX0].cF0-2);
                  }
               }
            }
            int mF0=residue_mappings.L0[iL0].F0a;
            int iF0=dst.C0N2F0(iC0,iN2);
            int iF1=(R0[iR0].F1a+iF0-mF0);
            if( iF0>pF0 ){
               iF1+=dF0;
            }
            aut.C0N2F1(iC0,iN2)=iF1;
            int mB0=residue_mappings.L0[iL0].B0a;
            int iB0=dst.C0N2B0(iC0,iN2);
            if( iB0==-1 ){
               aut.C0N2B1(iC0,iN2)=-1;
            }else{
               aut.C0N2B1(iC0,iN2)=(Z0[iZ0].B1a+iB0-mB0);
            }
            int mG0=residue_mappings.L0[iL0].G0a;
            int iG0=dst.C0N2G0(iC0,iN2);
            if( iG0==-1 ){
               aut.C0N2G1(iC0,iN2)=-1;
            }else{
               int iG1=(vv.R0G1a(iR0)+iG0-mG0);
               if      ( c1=='r' ){
                  int pG0=-1;
                  int dG0=1;
                  int mQ0=residue_mappings.L0[iL0].Q0a;
                  int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
                  for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
                     if( residue_mappings.Q0[iQ0].ext==1 ){
                        pG0=(residue_mappings.Q0[iQ0].G0a
                            +residue_mappings.Q0[iQ0].cG0-2);
                     }
                  }
                  if( iG0>pG0 ){
                     iG1+=dG0;
                  }
                  if( iG1<Z0[iZ0].G1a )iG1=-1;
               }else if( c1=='b' ){
                  iG1+=1;
               }else if( c1=='p' ){
                  if( (iR0>Z0[iZ0].R0a)&&(iG0==mG0) ){
                     int jL0=str.R0[iR0-2].L0;
                     int pG1=-1;
                     int aG0=residue_mappings.L0[jL0].G0a;
                     int aQ0=residue_mappings.L0[jL0].Q0a;
                     int bQ0=(aQ0-1+residue_mappings.L0[jL0].cQ0);
                     for(int iQ0=aQ0;iQ0<=bQ0;iQ0++){
                        if( residue_mappings.Q0[iQ0].ext==1 ){
                           int pG0=(residue_mappings.Q0[iQ0].G0a
                                   +residue_mappings.Q0[iQ0].cG0-2);
                           pG1=(vv.R0G1a(iR0-2)+pG0+1-aG0);
                        }
                     }
                     iG1=pG1;
                  }
               }
               aut.C0N2G1(iC0,iN2)=iG1;
            }
         }
      }
   }
//
//
// structure atoms
//
   for(int iR0= 0;iR0<oR0;iR0++){
      R0[iR0].F1n=-1;
      R0[iR0].F1c=-1;
      R0[iR0].F1h=-1;
      R0[iR0].F1o=-1;
   }
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char c1=R0[iR0].c1;
         if( (c1!='a')&&(c1!='e') )continue;
         int mF1=R0[iR0].F1a;
         int nF1=(mF1-1+R0[iR0].cF1);
         for(int iF1=mF1;iF1<=nF1;iF1++){
            std::string atm=F1[iF1].atm;
            if( atm==" N  " )R0[iR0].F1n=iF1;
            if( atm==" H  " )R0[iR0].F1h=iF1;
            if( atm==" C  " )R0[iR0].F1c=iF1;
            if( atm==" O  " )R0[iR0].F1o=iF1;
         }
      }
   }
   return;
}
