#include "../con/Subset_Contracted_System.hh"
#include "../set/Mechanical_System.hh"
#include "../set/Set_Automatic.hh"

int Mechanical_System::SET_PASS(Set_Automatic& aut,
                                Subset_Contracted_System::tM3& con,
                                int mQ2,int iQ2,
                                int j__,int iQ3,
                                int iE0,
                                int SSBND){
   int lam=con.E0[1+iE0].lam;
   int mQ1=con.Q3[iQ3].Q1a;
   int nQ1=(mQ1-1+con.Q3[iQ3].cQ1);

   if      ( lam==0 ){
      int jX1=j__;
      int aF1=X1[jX1].F1a;
      int bF1=(aF1-1+X1[jX1].cF1);
      for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
         int iQ1=con.Q1[pQ1].ord;
         int mG2=con.Q1[iQ1].G2a;
         int nG2=(mG2-1+Q1[iQ1].cG2);
         for(int iG2=mG2;iG2<=nG2;iG2++){
            int iF1=con.G2[iG2].F1;
            for(int jF1=aF1;jF1<=bF1;jF1++){
               double RR=( aut.F1[iF1].x -aut.F1[jF1].x).rr();
               if( RR<aut.RRcut ){
                  con.Q2[iQ2].cE0++;
                  return 1;
               }
            }
         }
      }

   }else if( lam==1 ){
      int jU1=j__;
      int aH1=U1[jU1].H1a;
      int bH1=(aH1-1+U1[jU1].cH1);
      for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
         int iQ1=con.Q1[pQ1].ord;
         int mG2=con.Q1[iQ1].G2a;
         int nG2=(mG2-1+Q1[iQ1].cG2);
         for(int iG2=mG2;iG2<=nG2;iG2++){
            int iF1=con.G2[iG2].F1;
            for(int jH1=aH1;jH1<=bH1;jH1++){
               int jF1=H1[jH1].F1;
               double RR=( aut.F1[iF1].x -aut.F1[jF1].x).rr();
               if( RR<aut.RRcut ){
                  con.Q2[iQ2].cE0++;
                  return 1;
               }
            }
         }
      }

   }else if( lam==2 ){
      int jQ1=j__;
      int aG2=con.Q1[jQ1].G2a;
      int bG2=(aG2-1+Q1[jQ1].cG2);
      for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
         int iQ1=con.Q1[pQ1].ord;
         int mG2=con.Q1[iQ1].G2a;
         int nG2=(mG2-1+Q1[iQ1].cG2);
         for(int iG2=mG2;iG2<=nG2;iG2++){
            int iF1=con.G2[iG2].F1;
            for(int jG2=aG2;jG2<=bG2;jG2++){
               int jF1=con.G2[jG2].F1;
               double RR=( aut.F1[iF1].x -aut.F1[jF1].x).rr();
               if( RR<aut.RRcut ){
                  con.Q2[iQ2].cE0++;
                  return 1;
               }
            }
         }
      }

   }else if( lam==3 ){
      int jQ1=j__;
      int aB2=con.Q1[jQ1].G2a;
      int bB2=(aB2-1+Q1[jQ1].cG2);
      for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
         int iQ1=con.Q1[pQ1].ord;
         int mG2=con.Q1[iQ1].G2a;
         int nG2=(mG2-1+Q1[iQ1].cG2);
         for(int iG2=mG2;iG2<=nG2;iG2++){
            int iF1=con.G2[iG2].F1;
            for(int jB2=aB2;jB2<=bB2;jB2++){
               int jF1=con.B2[jB2].F1;
               double RR=( aut.F1[iF1].x -aut.F1[jF1].x).rr();
               if( RR<aut.RRcut ){
                  con.Q2[iQ2].cE0++;
                  return 1;
               }
            }
         }
      }

   }else if( lam==4 ){
      int jX2=j__;
      int aX1=con.X2[jX2].X1a;
      int bX1=(aX1-1+con.X2[jX2].cX1);
      for(int pX1=aX1;pX1<=bX1;pX1++){
         int jX1=con.X1[pX1].ord;
         int aF1=X1[jX1].F1a;
         int bF1=(aF1-1+X1[jX1].cF1);
         SSBND=((1<<aut.X1[jX1].sx)>>1)&aut.Q2[iQ2].sq;
         if( SSBND>0 ){
            for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
               int iQ1=con.Q1[pQ1].ord;
               int mG2=con.Q1[iQ1].G2a;
               int nG2=(mG2-1+Q1[iQ1].cG2);
               for(int iG2=mG2;iG2<=nG2;iG2++){
                  int j=con.G2[iG2].sg&7;
                  int iS1=(con.G2[iG2].sg-j);
                  if( iS1==0 )continue;
                  for(int jF1=aF1;jF1<=bF1;jF1++){
                     int i=con.F1[jF1].sf&7;
                     int jS1=(con.F1[jF1].sf-i);
                     if( jS1==0 )continue;
                     if( jS1==iS1 ){
                        con.Q2[iQ2].cE0++;
                        con.E0[1+iE0].sse=1;
                        return 1;
                     }
                  }
               }
            }
         }
      }
      for(int pX1=aX1;pX1<=bX1;pX1++){
         int jX1=con.X1[pX1].ord;
         int aF1=X1[jX1].F1a;
         int bF1=(aF1-1+X1[jX1].cF1);
         for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
            int iQ1=con.Q1[pQ1].ord;
            int mG2=con.Q1[iQ1].G2a;
            int nG2=(mG2-1+Q1[iQ1].cG2);
            for(int iG2=mG2;iG2<=nG2;iG2++){
               int iF1=con.G2[iG2].F1;
               for(int jF1=aF1;jF1<=bF1;jF1++){
                  double RR=( aut.F1[iF1].x -aut.F1[jF1].x).rr();
                  if( RR<aut.RRcut ){
                     con.Q2[iQ2].cE0++;
                     return 1;
                  }
               }
            }
         }
      }

   }else if( lam==6 ){
      int jQ3=j__;
      int aQ1=con.Q3[jQ3].Q1a;
      int bQ1=(aQ1-1+con.Q3[jQ3].cQ1);
      for(int qQ1=aQ1;qQ1<=bQ1;qQ1++){
         int jQ1=con.Q1[qQ1].ord;
         int aG2=con.Q1[jQ1].G2a;
         int bG2=(aG2-1+Q1[jQ1].cG2);
         SSBND=aut.Q2[iQ2].sq&((1<<-aut.Q1[jQ1].sq)>>1);
         if( SSBND>0 ){
            for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
               int iQ1=con.Q1[pQ1].ord;
               int mG2=con.Q1[iQ1].G2a;
               int nG2=(mG2-1+Q1[iQ1].cG2);
               for(int iG2=mG2;iG2<=nG2;iG2++){
                  int j=( iQ2==mQ2 )? con.B2[iG2].sb&7: con.G2[iG2].sg&7;
                  int iS1=( iQ2==mQ2 )? con.B2[iG2].sb-j: con.G2[iG2].sg-j;
                  if( iS1==0 )continue;
                  for(int jG2=aG2;jG2<=bG2;jG2++){
                     int jF1=con.G2[jG2].F1;
                     int i=con.F1[jF1].sf&7;
                     int jS1=(con.F1[jF1].sf-i);
                     if( jS1==0 )continue;
                     if( jS1==iS1 ){
                        con.Q2[iQ2].cE0++;
                        con.E0[1+iE0].sse=1;
                        return 1;
                     }
                  }
               }
            }
         }
      }
      for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
         int iQ1=con.Q1[pQ1].ord;
         int mG2=con.Q1[iQ1].G2a;
         int nG2=(mG2-1+Q1[iQ1].cG2);
         for(int qQ1=aQ1;qQ1<=bQ1;qQ1++){
            int jQ1=con.Q1[qQ1].ord;
            int aG2=con.Q1[jQ1].G2a;
            int bG2=(aG2-1+Q1[jQ1].cG2);
            for(int iG2=mG2;iG2<=nG2;iG2++){
               int iF1=( iQ2==mQ2 )? con.B2[iG2].F1: con.G2[iG2].F1;
               for(int jG2=aG2;jG2<=bG2;jG2++){
                  int jF1=con.G2[jG2].F1;
                  double RR=( aut.F1[iF1].x -aut.F1[jF1].x).rr();
                  if( RR<aut.RRcut ){
                     con.Q2[iQ2].cE0++;
                     return 1;
                  }
               }
            }
         }
      }

   }else if( lam==7 ){
      int jQ3=j__;
      int aQ1=con.Q3[jQ3].Q1a;
      int bQ1=(aQ1-1+con.Q3[jQ3].cQ1);
      for(int qQ1=aQ1;qQ1<=bQ1;qQ1++){
         int jQ1=con.Q1[qQ1].ord;
         int aB2=con.Q1[jQ1].G2a;
         int bB2=(aB2-1+Q1[jQ1].cG2);
         SSBND=aut.Q2[iQ2].sq&((1<<-aut.Q1[jQ1].sq)>>1);
         if( SSBND>0 ){
            for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
               int iQ1=con.Q1[pQ1].ord;
               int mG2=con.Q1[iQ1].G2a;
               int nG2=(mG2-1+Q1[iQ1].cG2);
               for(int iG2=mG2;iG2<=nG2;iG2++){
                  int j=( iQ2==mQ2 )? con.B2[iG2].sb&7: con.G2[iG2].sg&7;
                  int iS1=( iQ2==mQ2 )? con.B2[iG2].sb-j: con.G2[iG2].sg-j;
                  if( iS1==0 )continue;
                  for(int jB2=aB2;jB2<=bB2;jB2++){
                     int jF1=con.B2[jB2].F1;
                     int i=con.F1[jF1].sf&7;
                     int jS1=(con.F1[jF1].sf-i);
                     if( jS1==0 )continue;
                     if( jS1==iS1 ){
                        con.Q2[iQ2].cE0++;
                        con.E0[1+iE0].sse=1;
                        return 1;
                     }
                  }
               }
            }
         }
      }
      for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
         int iQ1=con.Q1[pQ1].ord;
         int mG2=con.Q1[iQ1].G2a;
         int nG2=(mG2-1+Q1[iQ1].cG2);
         for(int qQ1=aQ1;qQ1<=bQ1;qQ1++){
            int jQ1=con.Q1[qQ1].ord;
            int aB2=con.Q1[jQ1].G2a;
            int bB2=(aB2-1+Q1[jQ1].cG2);
            for(int iG2=mG2;iG2<=nG2;iG2++){
               int iF1=( iQ2==mQ2 )? con.B2[iG2].F1: con.G2[iG2].F1;
               for(int jB2=aB2;jB2<=bB2;jB2++){
                  int jF1=con.B2[jB2].F1;
                  double RR=( aut.F1[iF1].x -aut.F1[jF1].x).rr();
                  if( RR<aut.RRcut ){
                     con.Q2[iQ2].cE0++;
                     return 1;
                  }
               }
            }
         }
      }

   }

   con.E0.pop_back();
   return 0;
}
