#include "../con/Subset_Contracted_System.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../set/Set_Automatic.hh"
#include "../str/Thread_Options.hh"

void Mechanical_System::SET_E0(Set_Automatic& aut,
                               const Thread_Options& opt,
                               Subset_Contracted_System::tM3& con,
                               const Conf_Dependent_System& dep){
   int KPT[3];
   int KBR;

   int iE0=-1;

   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      con.Z0[iZ0].E0a=(iE0+1);
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      int nQ2bb=(mQ2-1+con.Z0[iZ0].cQ2bb);
      int mQ1=Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+Z0[iZ0].cQ1);
//    int nQ1bb=(mQ1-1+Z0[iZ0].cQ1bb);

      for(int iQ2=mQ2;iQ2<=nQ2;iQ2++){
         con.Q2[iQ2].cE0=0;
      }

      Coordinates TRANS;
      TRANS=dep.Z0[iZ0].trans;
      double alp= dep.Z0[iZ0].rot(0);
      double bet= dep.Z0[iZ0].rot(1);
      double gam= dep.Z0[iZ0].rot(2);
      Rotation_Matrix ROT(alp,bet,gam);

      int mB2=con.Z0[iZ0].B2a;
      int nB2=(mB2-1+con.Z0[iZ0].cB2);
      for(int iB2=mB2;iB2<=nB2;iB2++){
         Coordinates x=aut.F1[con.B2[iB2].F1].x;
         aut.F1[con.B2[iB2].F1].x.generate(TRANS,ROT,x);
      }

      aut.PR[ 0]=ROT;
      int iQ2=mQ2;
//
//
// interchain (B2+G2,B2) sub-block pair interactions
//
      if( iZ0>0 ){
         int mQ3=con.Q2[iQ2].Q3a;
         int nQ3=(mQ3-1+con.Q2[iQ2].cQ3);
         for(int jZ0= 0;jZ0<iZ0;jZ0++){
            if( con.Z0[iZ0].sub||
                con.Z0[jZ0].sub ){

               int jQ2=con.Z0[jZ0].Q2a;
               int aQ3=con.Q2[jQ2].Q3a;
               int bQ3=(aQ3-1+con.Q2[jQ2].cQ3);
               for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
                  for(int jQ3=aQ3;jQ3<=bQ3;jQ3++){
                     con.E0.push_back(
                       Subset_Contracted_System::tM3::tM3E0());
                     con.E0[1+iE0].Q3=iQ3;
                     con.E0[1+iE0].X2=jQ3;
                     con.E0[1+iE0].lam=7;
                     con.E0[1+iE0].sse=0;
                     con.E0[1+iE0].k=jQ2;
                     con.E0[1+iE0].Z0=jZ0;
                     iE0+=SET_PASS(aut,con,mQ2,iQ2,jQ3,iQ3,iE0);
                  }
               }

            }
            int aQ2=con.Z0[jZ0].Q2a;
            int bQ2=(aQ2-1+con.Z0[jZ0].cQ2);
            if( bQ2>aQ2 ){
               int jQ2=aQ2;
               int jQ2hold=(aQ2+con.Z0[jZ0].cQ2bb);
               for(int jcQ2=(bQ2-aQ2);jcQ2>0;jcQ2--){
                  if( con.Q2[jQ2].omg==1 ){
                     int L=jQ2hold;
                     jQ2hold=(jQ2+1);
                     jQ2=L;
                  }else{
                     jQ2++;
                  }
                  if( (opt.MODE=="bb ")||(opt.MODE=="sc ")||
                      (opt.MODE=="lp ") ){
                     if( aut.Q2[jQ2].bor==2 )continue;
                  }
                  int aQ3=con.Q2[jQ2].Q3a;
                  int bQ3=(aQ3-1+con.Q2[jQ2].cQ3);
                  for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
                     for(int jQ3=aQ3;jQ3<=bQ3;jQ3++){
                        con.E0.push_back(
                          Subset_Contracted_System::tM3::tM3E0());
                        con.E0[1+iE0].Q3=iQ3;
                        con.E0[1+iE0].X2=jQ3;
                        con.E0[1+iE0].lam=6;
                        con.E0[1+iE0].sse=0;
                        con.E0[1+iE0].k=jQ2;
                        con.E0[1+iE0].Z0=jZ0;
                        iE0+=SET_PASS(aut,con,mQ2,iQ2,jQ3,iQ3,iE0);
                     }
                  }
               }
            }
         }
      }

      if( nQ2>mQ2 ){
         iQ2=mQ2;
         int iQ2hold=(nQ2bb+1);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            int br=con.Q2[iQ2].br;
            int cbr=con.Q2[iQ2].cbr;

            aut.PR[br].extend(aut.PR[cbr],
                              dep.Q2[iQ2].tu,
                              dep.Q2[iQ2].chi);

            int mG2=con.Q2[iQ2].G2a;
            int nG2=(mG2-1+con.Q2[iQ2].cG2);
            for(int iG2=mG2;iG2<=nG2;iG2++){
               aut.F1[con.G2[iG2].F1].x.generate(aut.F1[con.Q2[iQ2].bseF1].x,
                                                 aut.PR[br],
                                                 dep.G2[iG2].b);
            }
//
//
// intrachain (H1+B2+G2+F1,G2) sub-block pair interactions
//
            int mQ3=con.Q2[iQ2].Q3a;
            int nQ3=(mQ3-1+con.Q2[iQ2].cQ3);
            KPT[ 0]=iQ2;
            if( br>0 ){

               bool BRANCH1=false;
               bool BRANCH2=false;
               int aU1=aut.Q1[aut.Q2[iQ2].Q1].U1a;
               int bU1=aut.Q1[aut.Q2[iQ2].Q1].U1z;
               for(int jU1=aU1;jU1<=bU1;jU1++){
                  int jQ1=aut.U1[jU1].Q1;
                  if      ( Q1[jQ1].br==Q1[aut.Q2[iQ2].Q1].br ){
                     if( con.Q1[jQ1].sub )KPT[ 0]=aut.Q1[jQ1].Q2;
                     for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
                        con.E0.push_back(
                          Subset_Contracted_System::tM3::tM3E0());
                        con.E0[1+iE0].Q3=iQ3;
                        con.E0[1+iE0].X2=jU1;
                        con.E0[1+iE0].lam=1;
                        con.E0[1+iE0].sse=0;
                        con.E0[1+iE0].k=KPT[ 0];
                        con.E0[1+iE0].Z0=iZ0;
                        iE0+=SET_PASS(aut,con,mQ2,iQ2,jU1,iQ3,iE0);
                     }
                  }else if( Q1[jQ1].br< Q1[aut.Q2[iQ2].Q1].br ){
                     if( !BRANCH1 ){
                        int kQ1=(aut.Q2[iQ2].Q1+1);
                        while( Q1[kQ1].br>=Q1[aut.Q2[iQ2].Q1].br ){
                           kQ1++;
                        }
                        for(; !con.Q1[kQ1].sub; kQ1++){
                           for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
                              con.E0.push_back(
                                Subset_Contracted_System::tM3::tM3E0());
                              con.E0[1+iE0].Q3=iQ3;
                              con.E0[1+iE0].X2=kQ1;
                              con.E0[1+iE0].lam=( aut.Q1[kQ1].Q2==mQ2 )?3:2;
                              con.E0[1+iE0].sse=0;
                              con.E0[1+iE0].k=KPT[ 0];
                              con.E0[1+iE0].Z0=iZ0;
                              iE0+=SET_PASS(aut,con,mQ2,iQ2,kQ1,iQ3,iE0);
                           }
                           if( Q1[kQ1].omg==1 )break;
                        }
                        BRANCH1=true;
                     }
                     if( con.Q1[jQ1].sub )KPT[ 0]=aut.Q1[jQ1].Q2;
                     for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
                        con.E0.push_back(
                          Subset_Contracted_System::tM3::tM3E0());
                        con.E0[1+iE0].Q3=iQ3;
                        con.E0[1+iE0].X2=jU1;
                        con.E0[1+iE0].lam=1;
                        con.E0[1+iE0].sse=0;
                        con.E0[1+iE0].k=KPT[ 0];
                        con.E0[1+iE0].Z0=iZ0;
                        iE0+=SET_PASS(aut,con,mQ2,iQ2,jU1,iQ3,iE0);
                     }
                  }else if( Q1[jQ1].br> Q1[aut.Q2[iQ2].Q1].br ){
                     if( !BRANCH2 ){
                        int bQ1=jQ1;
                        while( Q1[jQ1].br> Q1[aut.Q2[iQ2].Q1].br ){
                           jQ1=Q1[jQ1].jnt;
                        }
                        int aQ1=(jQ1+1);
                        KBR=0;
                        for(jQ1=aQ1;jQ1<=bQ1;jQ1++){
                           if( con.Q1[jQ1].sub ){
                              KBR=1;
                              KPT[ 1]=aut.Q1[jQ1].Q2;
                           }
                           for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
                              con.E0.push_back(
                                Subset_Contracted_System::tM3::tM3E0());
                              con.E0[1+iE0].Q3=iQ3;
                              con.E0[1+iE0].X2=jQ1;
                              con.E0[1+iE0].lam=( aut.Q1[jQ1].Q2==mQ2 )?3:2;
                              con.E0[1+iE0].sse=0;
                              con.E0[1+iE0].k=KPT[KBR];
                              con.E0[1+iE0].Z0=iZ0;
                              iE0+=SET_PASS(aut,con,mQ2,iQ2,jQ1,iQ3,iE0);
                           }
                        }
                        BRANCH2=true;
                     }
                  }
               }

               int tQ1=(aut.X1[aut.Q1[aut.Q2[iQ2].Q1].X1a].Q1+1);
               if( !con.Q1[tQ1].sub ){
                  int tQ2=aut.Q1[tQ1].Q2;
                  int tQ3=aut.Q1[tQ1].Q3;
                  int aQ1=con.Q3[tQ3].Q1a;
                  int bQ1=(aQ1-1+con.Q3[tQ3].cQ1);
                  while( con.Q1[aQ1].ord!=tQ1 ){
                     aQ1++;
                  }
                  for(int qQ1=aQ1;qQ1<=bQ1;qQ1++){
                     int jQ1=con.Q1[qQ1].ord;
                     for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
                        con.E0.push_back(
                          Subset_Contracted_System::tM3::tM3E0());
                        con.E0[1+iE0].Q3=iQ3;
                        con.E0[1+iE0].X2=jQ1;
                        con.E0[1+iE0].lam=( tQ2==mQ2 )?3:2;
                        con.E0[1+iE0].sse=0;
                        con.E0[1+iE0].k=KPT[ 0];
                        con.E0[1+iE0].Z0=iZ0;
                        iE0+=SET_PASS(aut,con,mQ2,iQ2,jQ1,iQ3,iE0);
                     }
                  }
                  int aQ3=(tQ3+1);
                  int bQ3=(con.Q2[tQ2].Q3a-1+con.Q2[tQ2].cQ3);
                  for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
                     for(int jQ3=aQ3;jQ3<=bQ3;jQ3++){
                        con.E0.push_back(
                          Subset_Contracted_System::tM3::tM3E0());
                        con.E0[1+iE0].Q3=iQ3;
                        con.E0[1+iE0].X2=jQ3;
                        con.E0[1+iE0].lam=( tQ2==mQ2 )?7:6;
                        con.E0[1+iE0].sse=0;
                        con.E0[1+iE0].k=KPT[ 0];
                        con.E0[1+iE0].Z0=iZ0;
                        iE0+=SET_PASS(aut,con,mQ2,iQ2,jQ3,iQ3,iE0);
                     }
                  }
               }
            }

            int tX1=aut.Q1[aut.Q2[iQ2].Q1].X1a;
            int tQ1=aut.X1[tX1].Q1;
            int aX2=aut.X1[tX1].X2;
            if( !con.Q1[tQ1].sub ){
               int aX1=con.X2[aX2].X1a;
               int bX1=(aX1-1+con.X2[aX2].cX1);
               while( con.X1[aX1].ord!=tX1 ){
                  aX1++;
               }
               for(int pX1=aX1;pX1<=bX1;pX1++){
                  int jX1=con.X1[pX1].ord;
                  for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
                     con.E0.push_back(
                       Subset_Contracted_System::tM3::tM3E0());
                     con.E0[1+iE0].Q3=iQ3;
                     con.E0[1+iE0].X2=jX1;
                     con.E0[1+iE0].lam=0;
                     con.E0[1+iE0].sse=0;
                     con.E0[1+iE0].k=KPT[ 0];
                     con.E0[1+iE0].Z0=iZ0;
                     iE0+=SET_PASS(aut,con,mQ2,iQ2,jX1,iQ3,iE0);
                  }
               }
               if( (con.X1.at(bX1).ord+1)<=nQ1 ){
                  aX2=aut.X1.at(con.X1.at(bX1).ord+1).X2;
               }else{
                  aX2=con.oX2;
               }
            }
            int bX2=(con.Z0[iZ0].X2a-1+con.Z0[iZ0].cX2);
            for(int jX2=aX2;jX2<=bX2;jX2++){
               int aX1=con.X2[jX2].X1a;
//             int bX1=(aX1-1+con.X2[jX2].cX1);
               if( con.X1[aX1].ord<tX1 )continue;
               int jQ1=aut.X1[ con.X1[aX1].ord].Q1;
               if( con.Q1[jQ1].sub )KPT[Q1[jQ1].br]=aut.Q1[jQ1].Q2;
               if( (opt.MODE=="bb ")||(opt.MODE=="sc ")||
                   (opt.MODE=="lp ") ){
                  if( aut.Q2[iQ2].bor==2 ){
                     if( aut.Q2[KPT[ 0]].bor==1 ){
                        if( Q1[aut.Q2[aut.Q1[jQ1].Q2].Q1].br==0 )continue;
                     }
                  }
               }
               for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
                  con.E0.push_back(
                    Subset_Contracted_System::tM3::tM3E0());
                  con.E0[1+iE0].Q3=iQ3;
                  con.E0[1+iE0].X2=jX2;
                  con.E0[1+iE0].lam=4;
                  con.E0[1+iE0].sse=0;
                  con.E0[1+iE0].k=KPT[Q1[aut.Q2[aut.Q1[jQ1].Q2].Q1].br];
                  con.E0[1+iE0].Z0=iZ0;
                  iE0+=SET_PASS(aut,con,mQ2,iQ2,jX2,iQ3,iE0);
               }
            }
//
//
// interchain (B2+G2,G2) sub-block pair interactions
//
            if( iZ0>0 ){
               for(int jZ0= 0;jZ0<iZ0;jZ0++){
                  int jQ2=con.Z0[jZ0].Q2a;
                  int aQ3=con.Q2[jQ2].Q3a;
                  int bQ3=(aQ3-1+con.Q2[jQ2].cQ3);
                  for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
                     for(int jQ3=aQ3;jQ3<=bQ3;jQ3++){
                        con.E0.push_back(
                          Subset_Contracted_System::tM3::tM3E0());
                        con.E0[1+iE0].Q3=iQ3;
                        con.E0[1+iE0].X2=jQ3;
                        con.E0[1+iE0].lam=7;
                        con.E0[1+iE0].sse=0;
                        con.E0[1+iE0].k=jQ2;
                        con.E0[1+iE0].Z0=jZ0;
                        iE0+=SET_PASS(aut,con,mQ2,iQ2,jQ3,iQ3,iE0);
                     }
                  }
                  int aQ2=con.Z0[jZ0].Q2a;
                  int bQ2=(aQ2-1+con.Z0[jZ0].cQ2);
                  if( bQ2>aQ2 ){
                     int jQ2=aQ2;
                     int jQ2hold=(aQ2+con.Z0[jZ0].cQ2bb);
                     for(int jcQ2=(bQ2-aQ2);jcQ2>0;jcQ2--){
                        if( con.Q2[jQ2].omg==1 ){
                           int L=jQ2hold;
                           jQ2hold=(jQ2+1);
                           jQ2=L;
                        }else{
                           jQ2++;
                        }
                        int aQ3=con.Q2[jQ2].Q3a;
                        int bQ3=(aQ3-1+con.Q2[jQ2].cQ3);
                        for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
                           for(int jQ3=aQ3;jQ3<=bQ3;jQ3++){
                              con.E0.push_back(
                                Subset_Contracted_System::tM3::tM3E0());
                              con.E0[1+iE0].Q3=iQ3;
                              con.E0[1+iE0].X2=jQ3;
                              con.E0[1+iE0].lam=6;
                              con.E0[1+iE0].sse=0;
                              con.E0[1+iE0].k=jQ2;
                              con.E0[1+iE0].Z0=jZ0;
                              iE0+=SET_PASS(aut,con,mQ2,iQ2,jQ3,iQ3,iE0);
                           }
                        }
                     }
                  }
               }
            }

         }
      }
      con.Z0[iZ0].cE0=(iE0-con.Z0[iZ0].E0a+1);
   }
   con.oE0=con.E0.size();
   return;
}
