#include "../con/Subset_Contracted_System.hh"
#include "../set/Mechanical_System.hh"
#include "../set/Set_Automatic.hh"

void Mechanical_System::SET_C1(Set_Automatic& aut,
                               Subset_Contracted_System::tM3& con){
   int KPT[3];
   int KBR;

   int jC1=-1;
   int iC0max=-1;

   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      con.Z0[iZ0].C1a=(jC1+1);
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      int nQ2bb=(mQ2-1+con.Z0[iZ0].cQ2bb);
//    int mQ1=Z0[iZ0].Q1a;
//    int nQ1=(mQ1-1+Z0[iZ0].cQ1);
//    int nQ1bb=(mQ1-1+Z0[iZ0].cQ1bb);

      int mB2=con.Z0[iZ0].B2a;
      int nB2=(mB2-1+con.Z0[iZ0].cB2);
      for(int iB2=mB2;iB2<=nB2;iB2++){
         con.B2[iB2].cC1=0;
      }

      int mG2=con.Z0[iZ0].G2a;
      int nG2=(mG2-1+con.Z0[iZ0].cG2);
      if( nG2>=mG2 ){
         for(int iG2=mG2;iG2<=nG2;iG2++){
            con.G2[iG2].cC1=0;
         }
      }

      int iQ2=mQ2;
      for(int iB2=mB2;iB2<=nB2;iB2++){
         if( !aut.B2[iB2].sub )continue;
         int iC0min=(iC0max+1);
         for(int iC0=iC0min;iC0<aut.nC0;iC0++){
            if( aut.C0N2B2(iC0, 1)==iB2 ){
               iC0max=iC0;
            }else{
               break;
            }
         }
//
//
// interchain (B2+G2,B2) sub-block pair interactions
//
         if( iZ0>0 ){
            for(int jZ0= 0;jZ0<iZ0;jZ0++){
               if( con.Z0[jZ0].sub||
                   con.Z0[iZ0].sub ){
                  int aB2=con.Z0[jZ0].B2a;
                  int bB2=(aB2-1+Z0[jZ0].cB1);
                  for(int jB2=aB2;jB2<=bB2;jB2++){
                     int jF1=con.B2[jB2].F1;
// check whether
// (jF1,iB2) is an atom pair with a distance constraint
                     int iC0=SET_DIST(aut,jF1,iC0min,iC0max);
                     if( iC0>-1 ){
                        con.B2[iB2].cC1++;
                        con.C1.push_back(
                          Subset_Contracted_System::tM3::tM3C1());
                        jC1++;
                        con.C1[jC1].F1a=jB2;
                        con.C1[jC1].lam=3;
                        con.C1[jC1].k=con.Z0[jZ0].Q2a;
                        con.C1[jC1].Z0=jZ0;
                        con.C1[jC1].CYCLE=aut.C0[iC0].CYCLE;
                        con.C1[jC1].W0=aut.C0[iC0].W0;
                        con.C1[jC1].a0= aut.C0[iC0].a0;
                        con.C1[jC1].d0= aut.C0[iC0].d0;
                     }
                  }
                  int mBSE=aut.Z0[jZ0].BSEa;
                  int nBSE=(mBSE-1+aut.Z0[jZ0].cBSE);
                  if( nBSE>=mBSE ){
                     for(int jBSE=mBSE;jBSE<=nBSE;jBSE++){
                        int jQ1=aut.BSE[jBSE].Q1;
                        aB2=con.Q1[jQ1].G2a;
                        bB2=(aB2-1+Q1[jQ1].cG2);
                        for(int jB2=aB2;jB2<=bB2;jB2++){
                           int jF1=con.B2[jB2].F1;
                           int iC0=SET_DIST(aut,jF1,iC0min,iC0max);
                           if( iC0>-1 ){
                              con.B2[iB2].cC1++;
                              con.C1.push_back(
                                Subset_Contracted_System::tM3::tM3C1());
                              jC1++;
                              con.C1[jC1].F1a=jB2;
                              con.C1[jC1].lam=3;
                              con.C1[jC1].k=con.Z0[jZ0].Q2a;
                              con.C1[jC1].Z0=jZ0;
                              con.C1[jC1].CYCLE=aut.C0[iC0].CYCLE;
                              con.C1[jC1].W0=aut.C0[iC0].W0;
                              con.C1[jC1].a0= aut.C0[iC0].a0;
                              con.C1[jC1].d0= aut.C0[iC0].d0;
                           }
                        }
                     }
                  }
               }
               int mGEN=aut.Z0[jZ0].GENa;
               int nGEN=(mGEN-1+aut.Z0[jZ0].cGEN);
               if( nGEN>=mGEN ){
                  for(int jGEN=mGEN;jGEN<=nGEN;jGEN++){
                     int jQ1=aut.GEN[jGEN].Q1;
                     int aG2=con.Q1[jQ1].G2a;
                     int bG2=(aG2-1+Q1[jQ1].cG2);
                     for(int jG2=aG2;jG2<=bG2;jG2++){
                        int jF1=con.G2[jG2].F1;
                        int iC0=SET_DIST(aut,jF1,iC0min,iC0max);
                        if( iC0>-1 ){
                           con.B2[iB2].cC1++;
                           con.C1.push_back(
                             Subset_Contracted_System::tM3::tM3C1());
                           jC1++;
                           con.C1[jC1].F1a=jG2;
                           con.C1[jC1].lam=2;
                           con.C1[jC1].k=aut.Q1[jQ1].Q2;
                           con.C1[jC1].Z0=jZ0;
                           con.C1[jC1].CYCLE=aut.C0[iC0].CYCLE;
                           con.C1[jC1].W0=aut.C0[iC0].W0;
                           con.C1[jC1].a0= aut.C0[iC0].a0;
                           con.C1[jC1].d0= aut.C0[iC0].d0;
                        }
                     }
                  }
               }
            }
         }
      }

      if( nQ2>mQ2 ){
         iQ2=mQ2;
         int iQ2hold=(nQ2bb+1);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }

            mG2=con.Q2[iQ2].G2a;
            nG2=(mG2-1+con.Q2[iQ2].cG2);
            for(int iG2=mG2;iG2<=nG2;iG2++){
               if( !aut.G2[iG2].sub )continue;
               int iC0min=(iC0max+1);
               for(int iC0=iC0min;iC0<aut.nC0;iC0++){
                  if( aut.C0N2G2(iC0, 1)==iG2 ){
                     iC0max=iC0;
                  }else{
                     break;
                  }
               }
//
//
// intrachain (H1+B2+G2+F1,G2) sub-block pair interactions
//
               KPT[0]=iQ2;
               if( con.Q2[iQ2].br>0 ){

                  bool BRANCH1=false;
                  bool BRANCH2=false;
                  int aU1=aut.Q1[aut.Q2[iQ2].Q1].U1a;
                  int bU1=aut.Q1[aut.Q2[iQ2].Q1].U1z;
                  for(int jU1=aU1;jU1<=bU1;jU1++){
                     int jQ1=aut.U1[jU1].Q1;
                     if      ( Q1[jQ1].br==Q1[aut.Q2[iQ2].Q1].br ){
                        if( con.Q1[jQ1].sub )KPT[ 0]=aut.Q1[jQ1].Q2;
                        int aH1=U1[jU1].H1a;
                        int bH1=(aH1-1+U1[jU1].cH1);
                        for(int jH1=aH1;jH1<=bH1;jH1++){
                           int jF1=H1[jH1].F1;
                           int iC0=SET_DIST(aut,jF1,iC0min,iC0max);
                           if( iC0>-1 ){
                              con.G2[iG2].cC1++;
                              con.C1.push_back(
                                Subset_Contracted_System::tM3::tM3C1());
                              jC1++;
                              con.C1[jC1].F1a=jH1;
                              con.C1[jC1].lam=1;
                              con.C1[jC1].k=KPT[0];
                              con.C1[jC1].Z0=iZ0;
                              con.C1[jC1].CYCLE=aut.C0[iC0].CYCLE;
                              con.C1[jC1].W0=aut.C0[iC0].W0;
                              con.C1[jC1].a0= aut.C0[iC0].a0;
                              con.C1[jC1].d0= aut.C0[iC0].d0;
                           }
                        }
                     }else if( Q1[jQ1].br< Q1[aut.Q2[iQ2].Q1].br ){
                        if( !BRANCH1 ){
                           int kQ1=(aut.Q2[iQ2].Q1+1);
                           while( Q1[kQ1].br>=Q1[aut.Q2[iQ2].Q1].br ){
                              kQ1++;
                           }
                           for(; !con.Q1[kQ1].sub; kQ1++){
                              int aG2=con.Q1[kQ1].G2a;
                              int bG2=(aG2-1+Q1[kQ1].cG2);
                              for(int jG2=aG2;jG2<=bG2;jG2++){
                                 bool BASE=( aut.Q1[kQ1].Q2==mQ2 );
                                 int jF1=( BASE )?con.B2[jG2].F1
                                                 :con.G2[jG2].F1;
                                 int iC0=SET_DIST(aut,jF1,iC0min,iC0max);
                                 if( iC0>-1 ){
                                    con.G2[iG2].cC1++;
                                    con.C1.push_back(
                                      Subset_Contracted_System::tM3::tM3C1());
                                    jC1++;
                                    con.C1[jC1].F1a=jG2;
                                    con.C1[jC1].lam=( BASE )?3:2;
                                    con.C1[jC1].k=KPT[0];
                                    con.C1[jC1].Z0=iZ0;
                                    con.C1[jC1].CYCLE=aut.C0[iC0].CYCLE;
                                    con.C1[jC1].W0=aut.C0[iC0].W0;
                                    con.C1[jC1].a0= aut.C0[iC0].a0;
                                    con.C1[jC1].d0= aut.C0[iC0].d0;
                                 }
                              }
                              if( Q1[kQ1].omg==1 )break;
                           }
                           BRANCH1=true;
                        }
                        if( con.Q1[jQ1].sub )KPT[ 0]=aut.Q1[jQ1].Q2;
                        int aH1=U1[jU1].H1a;
                        int bH1=(aH1-1+U1[jU1].cH1);
                        for(int jH1=aH1;jH1<=bH1;jH1++){
                           int jF1=H1[jH1].F1;
                           int iC0=SET_DIST(aut,jF1,iC0min,iC0max);
                           if( iC0>-1 ){
                              con.G2[iG2].cC1++;
                              con.C1.push_back(
                                Subset_Contracted_System::tM3::tM3C1());
                              jC1++;
                              con.C1[jC1].F1a=jH1;
                              con.C1[jC1].lam=1;
                              con.C1[jC1].k=KPT[0];
                              con.C1[jC1].Z0=iZ0;
                              con.C1[jC1].CYCLE=aut.C0[iC0].CYCLE;
                              con.C1[jC1].W0=aut.C0[iC0].W0;
                              con.C1[jC1].a0= aut.C0[iC0].a0;
                              con.C1[jC1].d0= aut.C0[iC0].d0;
                           }
                        }
                     }else if( Q1[jQ1].br> Q1[aut.Q2[iQ2].Q1].br ){
                        if( !BRANCH2 ){
                           int bQ1=jQ1;
                           while( Q1[jQ1].br> Q1[aut.Q2[iQ2].Q1].br ){
                              jQ1=Q1[jQ1].jnt;
                           }
                           int aQ1=(jQ1+1);
                           KBR=0;
                           for(jQ1=aQ1;jQ1<=bQ1;jQ1++){
                              if( con.Q1[jQ1].sub ){
                                 KBR=1;
                                 KPT[ 1]=aut.Q1[jQ1].Q2;
                              }
                              int aG2=con.Q1[jQ1].G2a;
                              int bG2=(aG2-1+Q1[jQ1].cG2);
                              for(int jG2=aG2;jG2<=bG2;jG2++){
                                 bool BASE=( aut.Q1[jQ1].Q2==mQ2 );
                                 int jF1=( BASE )?con.B2[jG2].F1
                                                 :con.G2[jG2].F1;
                                 int iC0=SET_DIST(aut,jF1,iC0min,iC0max);
                                 if( iC0>-1 ){
                                    con.G2[iG2].cC1++;
                                    con.C1.push_back(
                                      Subset_Contracted_System::tM3::tM3C1());
                                    jC1++;
                                    con.C1[jC1].F1a=jG2;
                                    con.C1[jC1].lam=( BASE )?3:2;
                                    con.C1[jC1].k=KPT[KBR];
                                    con.C1[jC1].Z0=iZ0;
                                    con.C1[jC1].CYCLE=aut.C0[iC0].CYCLE;
                                    con.C1[jC1].W0=aut.C0[iC0].W0;
                                    con.C1[jC1].a0= aut.C0[iC0].a0;
                                    con.C1[jC1].d0= aut.C0[iC0].d0;
                                 }
                              }
                           }
                           BRANCH2=true;
                        }
                     }
                  }

                  int tQ1=aut.X1[aut.Q1[aut.Q2[iQ2].Q1].X1a].Q1+1;
                  if( !con.Q1[tQ1].sub ){
                     int tQ2=aut.Q1[tQ1].Q2;
                     int tQ3=aut.Q1[tQ1].Q3;
                     int aQ1=con.Q3[tQ3].Q1a;
                     int bQ1=(aQ1-1+con.Q3[tQ3].cQ1);
                     while( con.Q1[aQ1].ord!=tQ1 ){
                        aQ1++;
                     }
                     for(int qQ1=aQ1;qQ1<=bQ1;qQ1++){
                        int jQ1=con.Q1[qQ1].ord;
                        int aG2=con.Q1[jQ1].G2a;
                        int bG2=(aG2-1+Q1[jQ1].cG2);
                        for(int jG2=aG2;jG2<=bG2;jG2++){
                           bool BASE=( aut.Q1[jQ1].Q2==mQ2 );
                           int jF1=( BASE )?con.B2[jG2].F1
                                           :con.G2[jG2].F1;
                           int iC0=SET_DIST(aut,jF1,iC0min,iC0max);
                           if( iC0>-1 ){
                              con.G2[iG2].cC1++;
                              con.C1.push_back(
                                Subset_Contracted_System::tM3::tM3C1());
                              jC1++;
                              con.C1[jC1].F1a=jG2;
                              con.C1[jC1].lam=( BASE )?3:2;
                              con.C1[jC1].k=KPT[ 0];
                              con.C1[jC1].Z0=iZ0;
                              con.C1[jC1].CYCLE=aut.C0[iC0].CYCLE;
                              con.C1[jC1].W0=aut.C0[iC0].W0;
                              con.C1[jC1].a0= aut.C0[iC0].a0;
                              con.C1[jC1].d0= aut.C0[iC0].d0;
                           }
                        }
                     }
                     int aQ3=(tQ3+1);
                     int bQ3=(con.Q2[tQ2].Q3a-1+con.Q2[tQ2].cQ3);
                     for(int jQ3=aQ3;jQ3<=bQ3;jQ3++){
                        aQ1=con.Q3[jQ3].Q1a;
                        bQ1=(aQ1-1+con.Q3[jQ3].cQ1);
                        for(int qQ1=aQ1;qQ1<=bQ1;qQ1++){
                           int jQ1=con.Q1[qQ1].ord;
                           int aG2=con.Q1[jQ1].G2a;
                           int bG2=(aG2-1+Q1[jQ1].cG2);
                           for(int jG2=aG2;jG2<=bG2;jG2++){
                              bool BASE=( aut.Q1[jQ1].Q2==mQ2 );
                              int jF1=( BASE )?con.B2[jG2].F1
                                              :con.G2[jG2].F1;
                              int iC0=SET_DIST(aut,jF1,iC0min,iC0max);
                              if( iC0>-1 ){
                                 con.G2[iG2].cC1++;
                                 con.C1.push_back(
                                   Subset_Contracted_System::tM3::tM3C1());
                                 jC1++;
                                 con.C1[jC1].F1a=jG2;
                                 con.C1[jC1].lam=( BASE )?3:2;
                                 con.C1[jC1].k=KPT[ 0];
                                 con.C1[jC1].Z0=iZ0;
                                 con.C1[jC1].CYCLE=aut.C0[iC0].CYCLE;
                                 con.C1[jC1].W0=aut.C0[iC0].W0;
                                 con.C1[jC1].a0= aut.C0[iC0].a0;
                                 con.C1[jC1].d0= aut.C0[iC0].d0;
                              }
                           }
                        }
                     }
                  }
               }

               int tX1=aut.Q1[aut.Q2[iQ2].Q1].X1a;
               int tQ1=aut.X1[tX1].Q1;
               int aX2=aut.X1[tX1].X2;
               if( !con.Q1[tQ1].sub ){
                  int aX1=con.X2[aX2].X1a;
                  int bX1=(aX1-1+con.X2[aX2].cX1);
                  while( con.X1[aX1].ord!=tX1 ){
                     aX1++;
                  }
                  for(int pX1=aX1;pX1<=bX1;pX1++){
                     int jX1=con.X1[pX1].ord;
                     int mF1=X1[jX1].F1a;
                     int nF1=(mF1-1+X1[jX1].cF1);
                     for(int jF1=mF1;jF1<=nF1;jF1++){
                        int iC0=SET_DIST(aut,jF1,iC0min,iC0max);
                        if( iC0>-1 ){
                           con.G2[iG2].cC1++;
                           con.C1.push_back(
                             Subset_Contracted_System::tM3::tM3C1());
                           jC1++;
                           con.C1[jC1].F1a=jF1;
                           con.C1[jC1].lam=0;
                           con.C1[jC1].k=KPT[ 0];
                           con.C1[jC1].Z0=iZ0;
                           con.C1[jC1].CYCLE=aut.C0[iC0].CYCLE;
                           con.C1[jC1].W0=aut.C0[iC0].W0;
                           con.C1[jC1].a0= aut.C0[iC0].a0;
                           con.C1[jC1].d0= aut.C0[iC0].d0;
                        }
                     }
                  }
                  if( (con.X1[bX1].ord+1)<con.oX1 ){
                     aX2=aut.X1[con.X1[bX1].ord+1].X2;
                  }else{
                     aX2=con.oX2;
                  }
               }
               int bX2=(con.Z0[iZ0].X2a-1+con.Z0[iZ0].cX2);
               for(int jX2=aX2;jX2<=bX2;jX2++){
                  int aX1=con.X2[jX2].X1a;
                  int bX1=(aX1-1+con.X2[jX2].cX1);
                  if( con.X1[aX1].ord<tX1 )continue;
                  int jQ1=aut.X1[ con.X1[aX1].ord].Q1;
                  if( con.Q1[jQ1].sub )KPT[Q1[jQ1].br]=aut.Q1[jQ1].Q2;
                  for(int pX1=aX1;pX1<=bX1;pX1++){
                     int jX1=con.X1[pX1].ord;
                     int mF1=X1[jX1].F1a;
                     int nF1=(mF1-1+X1[jX1].cF1);
                     for(int jF1=mF1;jF1<=nF1;jF1++){
                        int iC0=SET_DIST(aut,jF1,iC0min,iC0max);
                        if( iC0>-1 ){
                           con.G2[iG2].cC1++;
                           con.C1.push_back(
                             Subset_Contracted_System::tM3::tM3C1());
                           jC1++;
                           con.C1[jC1].F1a=jF1;
                           con.C1[jC1].lam=0;
                           con.C1[jC1].k=KPT[Q1[aut.Q2[aut.Q1[jQ1].Q2].Q1].br];
                           con.C1[jC1].Z0=iZ0;
                           con.C1[jC1].CYCLE=aut.C0[iC0].CYCLE;
                           con.C1[jC1].W0=aut.C0[iC0].W0;
                           con.C1[jC1].a0= aut.C0[iC0].a0;
                           con.C1[jC1].d0= aut.C0[iC0].d0;
                        }
                     }
                  }
               }
//
//
// interchain (B2+G2,G2) sub-block pair interactions
//
               if( iZ0>0 ){
                  for(int jZ0= 0;jZ0<iZ0;jZ0++){
                     int aB2=con.Z0[jZ0].B2a;
                     int bB2=(aB2-1+Z0[jZ0].cB1);
                     for(int jB2=aB2;jB2<=bB2;jB2++){
                        int jF1=con.B2[jB2].F1;
                        int iC0=SET_DIST(aut,jF1,iC0min,iC0max);
                        if( iC0>-1 ){
                           con.G2[iG2].cC1++;
                           con.C1.push_back(
                             Subset_Contracted_System::tM3::tM3C1());
                           jC1++;
                           con.C1[jC1].F1a=jB2;
                           con.C1[jC1].lam=3;
                           con.C1[jC1].k=con.Z0[jZ0].Q2a;
                           con.C1[jC1].Z0=jZ0;
                           con.C1[jC1].CYCLE=aut.C0[iC0].CYCLE;
                           con.C1[jC1].W0=aut.C0[iC0].W0;
                           con.C1[jC1].a0= aut.C0[iC0].a0;
                           con.C1[jC1].d0= aut.C0[iC0].d0;
                        }
                     }
                     int mBSE=aut.Z0[jZ0].BSEa;
                     int nBSE=(mBSE-1+aut.Z0[jZ0].cBSE);
                     if( nBSE>=mBSE ){
                        for(int jBSE=mBSE;jBSE<=nBSE;jBSE++){
                           int jQ1=aut.BSE[jBSE].Q1;
                           int aB2=con.Q1[jQ1].G2a;
                           int bB2=(aB2-1+Q1[jQ1].cG2);
                           for(int jB2=aB2;jB2<=bB2;jB2++){
                              int jF1=con.B2[jB2].F1;
                              int iC0=SET_DIST(aut,jF1,iC0min,iC0max);
                              if( iC0>-1 ){
                                 con.G2[iG2].cC1++;
                                 con.C1.push_back(
                                   Subset_Contracted_System::tM3::tM3C1());
                                 jC1++;
                                 con.C1[jC1].F1a=jB2;
                                 con.C1[jC1].lam=3;
                                 con.C1[jC1].k=con.Z0[jZ0].Q2a;
                                 con.C1[jC1].Z0=jZ0;
                                 con.C1[jC1].CYCLE=aut.C0[iC0].CYCLE;
                                 con.C1[jC1].W0=aut.C0[iC0].W0;
                                 con.C1[jC1].a0= aut.C0[iC0].a0;
                                 con.C1[jC1].d0= aut.C0[iC0].d0;
                              }
                           }
                        }
                     }
                     int mGEN=aut.Z0[jZ0].GENa;
                     int nGEN=(mGEN-1+aut.Z0[jZ0].cGEN);
                     if( nGEN>=mGEN ){
                        for(int jGEN=mGEN;jGEN<=nGEN;jGEN++){
                           int jQ1=aut.GEN[jGEN].Q1;
                           int aG2=con.Q1[jQ1].G2a;
                           int bG2=(aG2-1+Q1[jQ1].cG2);
                           for(int jG2=aG2;jG2<=bG2;jG2++){
                              int jF1=con.G2[jG2].F1;
                              int iC0=SET_DIST(aut,jF1,iC0min,iC0max);
                              if( iC0>-1 ){
                                 con.G2[iG2].cC1++;
                                 con.C1.push_back(
                                   Subset_Contracted_System::tM3::tM3C1());
                                 jC1++;
                                 con.C1[jC1].F1a=jG2;
                                 con.C1[jC1].lam=2;
                                 con.C1[jC1].k=aut.Q1[jQ1].Q2;
                                 con.C1[jC1].Z0=jZ0;
                                 con.C1[jC1].CYCLE=aut.C0[iC0].CYCLE;
                                 con.C1[jC1].W0=aut.C0[iC0].W0;
                                 con.C1[jC1].a0= aut.C0[iC0].a0;
                                 con.C1[jC1].d0= aut.C0[iC0].d0;
                              }
                           }
                        }
                     }
                  }
               }
            }

         }
      }
      con.Z0[iZ0].cC1=(jC1-con.Z0[iZ0].C1a+1);
   }
   con.oC1=con.C1.size();
   return;
}
