#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../dst/Distance_Constraints.hh"
#include "../fil/Structure.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../set/Mechanical_System.hh"
#include "../set/Set_Automatic.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <iomanip>

void Mechanical_System::SET(const DAT_PHYSICS_CONSTS& physics_consts,
                            const DAT_ARRAY_CONSTS& array_consts,
                            const DAT_ENERGY_PARAMS& energy_params,
                            const DAT_RESIDUE_MAPPINGS& residue_mappings,
                            const Thread_Options& opt,
                            const Structure& str,
                            Output_Streams& out,
                            const Distance_Constraints& dst,
                            Subset_Contracted_System& col,
                            Conf_Dependent_System& dep){
   int oZ0=Z0.size();
   int oC0=dst.nC0;
   int oQ1=X1.size();
   int oU1=U1.size();
   int oF1=F1.size();
   int oB1=B1.size();
   int oG1=G1.size();
   Set_Automatic aut(oZ0,oC0,oQ1,oU1,oF1,oB1,oG1);

   aut.RRcut= opt.Rcut/physics_consts.ANG;
   aut.RRcut*=aut.RRcut;

   if( out.VERBOSE&& false ){
      out.FILE3<< std::fixed<< std::setprecision(3);
      out.FILE3<<" Rcut="<< std::setw( 8)<<opt.Rcut<<'\n';
   }
   for(int iM3= 0;iM3<col.nM3;iM3++){
      Subset_Contracted_System::tM3& con=col.M3[iM3];
      if( out.VERBOSE&& out.SHELL ){
         out.FILE3<<" subset name="<<con.QSUB<<'\n';
      }

      SET_Q1(aut,physics_consts,array_consts,energy_params,residue_mappings,
             str,dst,con,dep);
      SET_Q2(aut,opt,dst,con,dep);
      SET_Q3(aut,con);
      SET_E0(aut,opt,con,dep);
      SET_C1(aut,con);
      SET_WRITE(aut,physics_consts,residue_mappings,str,out,con,dep);
   }
   return;
}
