#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <iomanip>

class MEM_car {
private:
   std::vector<double> o_Q1chi;         //
   std::vector<Coordinates> o_F1x;      //
public:
   MEM_car(int oQ1,int oF1):
      o_Q1chi(oQ1),
      o_F1x(oF1)
   {
   }
   double& Q1chi(int i){
      return o_Q1chi.at( i);  }
   Coordinates& F1x(int i){
      return o_F1x.at( i);  }
};

void Structure::CAR(const DAT_PHYSICS_CONSTS& physics_consts,
                    const DAT_RESIDUE_MAPPINGS& residue_mappings){
   int oZ0=nZ0;
   int oR0=(Z0[oZ0-1].R0a+Z0[oZ0-1].cR0);
   int oQ1=oZ0;
   int oU1=0;
   int oF1=0;
   int oB1=0;
   int oG1=0;
   int oH1=0;
   int oJ1=0;
   int oY1=0;
   for(int iR0= 0;iR0<oR0;iR0++){
      int iL0=R0[iR0].L0;
      oQ1+=residue_mappings.L0[iL0].cQ0;
      oU1+=residue_mappings.L0[iL0].cU0;
      oF1+=residue_mappings.L0[iL0].cF0;
      oB1+=residue_mappings.L0[iL0].cB0;
      oG1+=residue_mappings.L0[iL0].cG0;
      oH1+=residue_mappings.L0[iL0].cH0;
      oJ1+=residue_mappings.L0[iL0].cJ0;
      oY1+=residue_mappings.L0[iL0].cY0;
   }
   MEM_car vv(oQ1,oF1);
   Mechanical_System mol(oZ0,oR0,oQ1,oU1,oF1,oB1,oG1,oH1,oJ1,oY1);
   Rotation_Matrix PR[ 3];
//
//
// populate mechanical system
//
   int oQ0=residue_mappings.Q0.size();
   int oF0=residue_mappings.F0.size();
   int oG0=residue_mappings.G0.size();
   int mQ1=0;
   int mF1=0;
   int mB1=0;
   int mG1=0;
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      mol.Z0[iZ0].Q1a=mQ1;
      mol.Z0[iZ0].cQ1=1;
      mol.Z0[iZ0].cQ1bb=1;
      mol.Z0[iZ0].F1a=mF1;
      mol.Z0[iZ0].cF1=0;
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int iL0=R0[iR0].L0;
         mol.Z0[iZ0].cQ1+=residue_mappings.L0[iL0].cQ0;
         mol.Z0[iZ0].cQ1bb+=( residue_mappings.L0[iL0].cQ0
                             -residue_mappings.L0[iL0].cU0);
         mol.Z0[iZ0].cF1+=residue_mappings.L0[iL0].cF0;
      }
      mol.Z0[iZ0].B1a=mB1;
      mol.Z0[iZ0].G1a=mG1;
      mol.Q1[mQ1].br=0;
      mol.Q1[mQ1].omg=0;
      mol.Q1[mQ1].tu.identity();
      mF1+=mol.Z0[iZ0].cF1;
      int pX0=-1,pF0=-1,dF0,pG0=-1,dG0;
//    int dX0;
      int pG1=-1;
      int dG1=1;
      int iQ1bb=(mQ1+1);
      int iQ1sc=(mQ1+mol.Z0[iZ0].cQ1bb);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int iL0=R0[iR0].L0;
         int mQ0=residue_mappings.L0[iL0].Q0a;
         int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
         int mF0=residue_mappings.L0[iL0].F0a;
         int nF0=(mF0-1+residue_mappings.L0[iL0].cF0);
         int mB0=residue_mappings.L0[iL0].B0a;
         int nB0=(mB0-1+residue_mappings.L0[iL0].cB0);
         int mG0=residue_mappings.L0[iL0].G0a;
         int nG0=(mG0-1+residue_mappings.L0[iL0].cG0);
         char c1=residue_mappings.L0[iL0].c1;
         std::string aa=residue_mappings.L0[iL0].aa;
         if      ( c1=='r' ){
            int jL0=R0[iR0+1].L0;
            mF1-=(residue_mappings.L0[iL0].cF0
                 +residue_mappings.L0[jL0].cF0);
         }else if( c1=='b' ){
            int jL0=R0[iR0-1].L0;
            mF1+=(pF0+1-residue_mappings.L0[jL0].F0a);
         }else{
            mF1-=residue_mappings.L0[iL0].cF0;
         }
         if( c1=='r' ){
            int jL0=R0[iR0+1].L0;
//          dX0=residue_mappings.L0[jL0].cQ0;
            dF0=residue_mappings.L0[jL0].cF0;
            dG0=1;
            for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
               if      ( residue_mappings.Q0[iQ0].ext==1 ){
                  pG0=(residue_mappings.Q0[iQ0].G0a
                      +residue_mappings.Q0[iQ0].cG0-2);
                  pG1=(mG1+pG0+1-mG0);
               }else if( residue_mappings.Q0[iQ0].ext==2 ){
                  pX0=residue_mappings.Q0[iQ0].X0;
                  pF0=(residue_mappings.X0[pX0].F0a
                      +residue_mappings.X0[pX0].cF0-2);
               }
            }
         }else{
            pX0=oQ0;
//          dX0=0;
            pF0=oF0;
            dF0=0;
            pG0=oG0;
            dG0=0;
         }
         if( aa=="5OH " ){
            mG1--;
         }
         mol.R0[iR0].F1a=mF1;
         mol.R0[iR0].cF1=residue_mappings.L0[iL0].cF0;
         if( c1=='r' ){
            mol.R0[iR0].cF1+=dF0;
         }
         if( nQ0>=mQ0 ){
            for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
               int iQ1=( residue_mappings.Q0[iQ0].br>0 )? iQ1sc++: iQ1bb++;
               mol.Q1[iQ1].tor=residue_mappings.Q0[iQ0].tor;
               std::string tor=mol.Q1[iQ1].tor;
               int jR0=( ((c1=='a')||(c1=='e'))&&
                         (tor=="OMG") )? iR0-1: iR0;
               int iT1=itorsion(jR0,tor);
               if( iT1==-1 ){
                  std::cerr<<"ERROR: Unmatched torsion angle name."
                           <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                           <<" iR0="<< std::setw( 4)<<(iR0-mR0+1)
                           <<" aa="<<R0[iR0].aa
                           <<" tor="<<tor<<".\n";
                  std::exit( 2);
               }
               vv.Q1chi(iQ1)= (physics_consts.RAD*T1[iT1].chi);
               mol.Q1[iQ1].br=residue_mappings.Q0[iQ0].br;
               mol.Q1[iQ1].cbr=residue_mappings.Q0[iQ0].cbr;
               mol.Q1[iQ1].omg=( residue_mappings.Q0[iQ0].omg )? 1: 0;
               mol.Q1[iQ1].tu=residue_mappings.Q0[iQ0].tu;
               int iF0=residue_mappings.Q0[iQ0].bse;
               mol.Q1[iQ1].bse=(mF1+iF0-mF0);
               if( iF0>pF0 ){
                  mol.Q1[iQ1].bse+=dF0;
               }
               int iG0=residue_mappings.Q0[iQ0].G0a;
               mol.Q1[iQ1].G1a=(mG1+iG0-mG0);
               if      ( c1=='r' ){
                  if( iG0>pG0 ){
                     mol.Q1[iQ1].G1a+=dG0;
                  }
               }else if( c1=='b' ){
                  mol.Q1[iQ1].G1a+=dG1;
               }
               mol.Q1[iQ1].cG1=residue_mappings.Q0[iQ0].cG0;
            }
         }
         if( nG0>=mG0 ){
            for(int iG0=mG0;iG0<=nG0;iG0++){
               int iG1=(mG1+iG0-mG0);
               if      ( c1=='r' ){
                  if( iG0>pG0 ){
                     iG1+=dG0;
                  }
                  if( iG1<mol.Z0[iZ0].G1a )continue;
               }else if( c1=='b' ){
                  iG1+=dG1;
               }else if( c1=='p' ){
                  if( iR0>mR0 ){
                  if( iG0<(mG0+dG1) ){
                     iG1=(pG1+iG0-mG0);
                  }
                  }
               }
               int iF0=residue_mappings.G0[iG0].F0;
               mol.G1[iG1].F1=(mF1+iF0-mF0);
               if( iF0>pF0 ){
                  mol.G1[iG1].F1+=dF0;
               }
               mol.G1[iG1].b= residue_mappings.G0[iG0].b;
            }
            mG1+=residue_mappings.L0[iL0].cG0;
         }
         for(int iF0=mF0;iF0<=nF0;iF0++){
            int iF1=(mF1+iF0-mF0);
            if( iF0>pF0 ){
               iF1+=dF0;
            }
            mol.F1[iF1].atm=residue_mappings.F0[iF0].atm;
            mol.F1[iF1].typ=residue_mappings.F0[iF0].typ;
         }
         if( nB0>=mB0 ){
            for(int iB0=mB0;iB0<=nB0;iB0++){
               int iB1=(mB1+iB0-mB0);
               int iF0=residue_mappings.B0[iB0].F0;
               mol.B1[iB1].F1=(mF1+iF0-mF0);
               mol.B1[iB1].x=residue_mappings.B0[iB0].x;
            }
            mB1+=residue_mappings.L0[iL0].cB0;
         }
         if( c1=='b' ){
            mF1=mol.R0[iR0-1].F1a;
         }
      }
      if( R0[mR0].aa=="5OH " ){
         mol.Q1[mQ1+1].tu.identity();
      }
      mol.Z0[iZ0].cB1=(mB1-mol.Z0[iZ0].B1a);
      mol.Z0[iZ0].cG1=(mG1-mol.Z0[iZ0].G1a);
      mQ1+=mol.Z0[iZ0].cQ1;
      mF1=(mol.Z0[iZ0].F1a+mol.Z0[iZ0].cF1);
   }
//
//
// generate mechanical system coordinates
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      Coordinates TRANS;
      TRANS=Z0[iZ0].trans;
      double alp= Z0[iZ0].rot(0);
      double bet= Z0[iZ0].rot(1);
      double gam= Z0[iZ0].rot(2);
      Rotation_Matrix ROT(alp,bet,gam);

      int mB1=mol.Z0[iZ0].B1a;
      int nB1=(mB1-1+mol.Z0[iZ0].cB1);
      for(int iB1=mB1;iB1<=nB1;iB1++){
         int iF1=mol.B1[iB1].F1;
         vv.F1x(iF1).generate(TRANS,ROT,mol.B1[iB1].x);
      }

      PR[ 0]= ROT;

      if( mol.Z0[iZ0].cQ1>1 ){
         int iQ1=mol.Z0[iZ0].Q1a;
         int iQ1hold=(mol.Z0[iZ0].Q1a+mol.Z0[iZ0].cQ1bb);
         for(int icQ1=(mol.Z0[iZ0].cQ1-1);icQ1>0;icQ1--){
            if( mol.Q1[iQ1].omg==1 ){
               int L=iQ1hold;
               iQ1hold=(iQ1+1);
               iQ1=L;
            }else{
               iQ1++;
            }
            int br=mol.Q1[iQ1].br;
            int cbr=mol.Q1[iQ1].cbr;
            PR[br].extend(PR[cbr],mol.Q1[iQ1].tu,vv.Q1chi(iQ1));
            int bse=mol.Q1[iQ1].bse;
            int mG1=mol.Q1[iQ1].G1a;
            int nG1=(mG1-1+mol.Q1[iQ1].cG1);
            for(int iG1=mG1;iG1<=nG1;iG1++){
               int iF1=mol.G1[iG1].F1;
               vv.F1x(iF1).generate(vv.F1x(bse),PR[br],mol.G1[iG1].b);
            }
         }
      }
   }
//
//
// update structure coordinates
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            P1[iP1].sub=1;
            std::string atm=P1[iP1].atm;
            int iF1=mol.iatom(iR0,atm);
            if( iF1==-1 ){
               std::cerr<<"ERROR: Unmatched atom name."
                        <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                        <<" iR0="<< std::setw( 4)<<(iR0-mR0+1)
                        <<" aa="<<R0[iR0].aa
                        <<" atm="<<atm<<".\n";
               std::exit( 2);
            }
            P1[iP1].x=vv.F1x(iF1);
            P1[iP1].x*=physics_consts.ANG;
         }
      }
   }
   return;
}
