#ifndef DEF_SET_AUTOMATIC
#define DEF_SET_AUTOMATIC

#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include <vector>

class Set_Automatic {
public:
   class tZ0 { /*chains in system of molecules*/
   public:
      int GENa;                 //start index into forward subgroups
      int cGEN;                 //number of forward subgroups
      int BSEa;                 //start index into base subgroups
      int cBSE;                 //number of base subgroups
      tZ0(){}
   };
   class tQ1 { /*torsions in chains [forward order]*/
   public:
      int sq;                   //group contribution to crosslink
      int chg;                  //group contribution to full charge
      int X1a;                  //start index into bb torsions
      int U1a;                  //start index into sc torsions
      int U1z;                  //end index into sc torsions
      int Q2;                   //map to forward variable torsion
      Rotation_Matrix tu;       //t(chi about x-axis)u(lam about z-axis)
      int Q3;                   //map to forward sub-block
      tQ1(){}
   };
   class tX1 { /*torsions in chains [backward order]*/
   public:
      int sx;                   //group contribution to crosslink
      int Q1;                   //map to forward torsion
      int X2;                   //map to backward sub-block
      tX1(){}
   };
   class tU1 { /*side chain torsions in chains [branch backward order]*/
   public:
      int Q1;                   //map to forward torsion
      tU1(){}
   };
   class tF1 { /*atoms in chains [backward order]*/
   public:
      int ztip;                 //tip of local z-axis
      int zbse;                 //base of local z-axis
      int xtip;                 //tip of local x-axis
      int xbse;                 //base of local x-axis
      Coordinates x;            //coords (bohr)
      tF1(){}
   };
   class tB1 { /*atoms in chain base groups [forward order]*/
   public:
      int sb;                   //atom type for crosslinking
      tB1(){}
   };
   class tG1 { /*atoms in chain forward groups [forward order]*/
   public:
      int sg;                   //atom type for crosslinking
      tG1(){}
   };
   class tQ2 { /*torsions in torsion-contracted chains [forward order]*/
   public:
      int Q1;                   //map to forward torsion
      int sq;                   //group contribution to crosslink
      int ORD;                  //map to order of generation
      int bor;                  //border type
      tQ2(){}
   };
   class tGEN { /*generated groups*/
   public:
      int Q1;                   //map to forward torsion
      tGEN(){}
   };
   class tBSE { /*base groups*/
   public:
      int Q1;                   //map to forward torsion
      tBSE(){}
   };
   class tB2 { /*atoms in torsion-contracted chain base groups [forward order]*/
   public:
      bool sub;                 //2nd atom of distance constraint
      tB2(){}
   };
   class tG2 { /*atoms in torsion-contracted chain forward groups [forward
                 order]*/
   public:
      bool sub;                 //2nd atom of distance constraint
      tG2(){}
   };
   class tC0 { /*atom pairs with distance constraint in system of molecules*/
   public:
      bool CYCLE;               //closes an intraresidue covalent cycle
      int W0;                   //index into harmonic coeffs
      double a0;                //harmonic coeff (hartree)
      double d0;                //target distance (bohr)
      tC0(){}
   };

private:
   std::vector<int> o_C0N2Z0;           //map to chain
   std::vector<int> o_C0N2F1;           //map to backward atom
   std::vector<int> o_C0N2G1;           //map to forward group atom
   std::vector<int> o_C0N2B1;           //map to base group atom
   std::vector<int> o_C0N2G2;           //map to forward group atom
   std::vector<int> o_C0N2B2;           //map to base group atom

public:
   double RRcut;                        //cutoff distance (bohr**2)
   Rotation_Matrix PR[3];               //
   std::vector<tZ0> Z0;                 //chains
   std::vector<tQ1> Q1;                 //torsions [forward order]
   std::vector<tX1> X1;                 //torsions [backward order]
   std::vector<tU1> U1;                 //sc torsions [branch backward order]
   std::vector<tF1> F1;                 //atoms [backward order]
   std::vector<tB1> B1;                 //atoms in base groups
   std::vector<tG1> G1;                 //atoms in forward groups
   std::vector<tQ2> Q2;                 //torsions contracted [forward order]
   std::vector<tGEN> GEN;               //generated groups
   std::vector<tBSE> BSE;               //base groups
   std::vector<tB2> B2;                 //atoms in contracted base groups
   std::vector<tG2> G2;                 //atoms in contracted forward groups
   int nC0;                             //number of distance constraints
   std::vector<tC0> C0;                 //atom pairs with distance constraint

   int& C0N2Z0(int i,int j){
      return o_C0N2Z0.at( i*2 +j);
   }
   int& C0N2F1(int i,int j){
      return o_C0N2F1.at( i*2 +j);
   }
   int& C0N2G1(int i,int j){
      return o_C0N2G1.at( i*2 +j);
   }
   int& C0N2B1(int i,int j){
      return o_C0N2B1.at( i*2 +j);
   }
   int& C0N2G2(int i,int j){
      return o_C0N2G2.at( i*2 +j);
   }
   int& C0N2B2(int i,int j){
      return o_C0N2B2.at( i*2 +j);
   }

   Set_Automatic(int oZ0,int oC0,int oQ1,int oU1,int oF1,int oB1,int oG1):
      o_C0N2Z0(oC0*2),
      o_C0N2F1(oC0*2),
      o_C0N2G1(oC0*2),
      o_C0N2B1(oC0*2),
      o_C0N2G2(oC0*2),
      o_C0N2B2(oC0*2),
      Z0(oZ0),
      Q1(oQ1+1),
      X1(oQ1),
      U1(oU1),
      F1(oF1),
      B1(oB1),
      G1(oG1),
      Q2(oQ1+1),
      GEN(oQ1),
      BSE(oQ1),
      B2(oF1),
      G2(oG1),
      C0(oC0)
   {
   }
};

#endif
