#ifndef DEF_MECHANICAL_SYSTEM
#define DEF_MECHANICAL_SYSTEM

#include "../con/Con_Automatic.hh"
#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../dst/Distance_Constraints.hh"
#include "../fil/Structure.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Fourier1D_Coeffs.hh"
#include "../phi/Fourier2D_Coeffs.hh"
#include "../phi/Fourier3D_Coeffs.hh"
#include "../phi/Gaussian_Volume.hh"
#include "../phi/Multipoles.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Set_Automatic.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>

class Mechanical_System {
public:
   class tZ0 { /*chains in system of molecules*/
   public:
      int R0a;                  //start index into residues
      int cR0;                  //number of residues
      int Q1a;                  //start index into torsions
      int cQ1;                  //number of torsions
      int cQ1bb;                //number of backbone torsions
      int U1a;                  //start index into sc backward groups
      int cU1;                  //number of sc backward groups
      int F1a;                  //start index into atoms
      int cF1;                  //number of atoms
      int B1a;                  //start index into atoms in base groups
      int cB1;                  //number of atoms in base groups
      int G1a;                  //start index into atoms in forward groups
      int cG1;                  //number of atoms in forward groups
      int H1a;                  //start index into atoms of sc backward groups
      int cH1;                  //number of atoms of sc backward groups
      int J1a;                  //start index into  pairs of adjacent torsions
      int cJ1;                  //number of pairs of adjacent torsions
      int Y1a;                  //start index into  triples of adjacent torsions
      int cY1;                  //number of triples of adjacent torsions
      tZ0(){}
   };
   class tR0 { /*residues in chains*/
   public:
      int L0;                   //residue in dataset
      char c1;                  //1 char class name
      std::string aa;           //4 char residue name
      int F1a;                  //start index into atoms
      int cF1;                  //number of atoms in residue
      int X1a;                  //start index into torsions
      int cX1;                  //number of torsions in residue
      int F1n;                  //map to index of N atom
      int F1h;                  //
      int F1c;                  //
      int F1o;                  //
      tR0(){}
   };
   class tQ1 { /*torsions in chains [forward order]*/
   public:
      std::string tor;          //3 char torsion name
      int br;                   //branch
      int omg;                  //order of generation bb-sc switch
      int cbr;                  //branch of connected torsion
      int jnt;                  //connected torsion
      int bse;                  //base atom
      int G1a;                  //start index into atoms of forward group
      int cG1;                  //number of atoms of forward group
      Rotation_Matrix tu;       //t(chi about x-axis)u(lam about z-axis)
      Fourier1D_Coeffs tau;     //fourier coeffs (hartree)
      int cG2;                  //number of atoms of forward group
      tQ1(){}
   };
   class tX1 { /*torsions in chains [backward order]*/
   public:
      int F1a;                  //start index into atoms of backward group
      int cF1;                  //number of atoms of backward group
      tX1(){}
   };
   class tU1 { /*side chain torsions [branch backward order]*/
   public:
      int H1a;                  //start index into atoms of sc backward groups
      int cH1;                  //number of atoms of sc backward group
      tU1(){}
   };
   class tF1 { /*atoms in chains [backward order]*/
   public:
      std::string atm;          //4 char atom name
      int typ;                  //atom type
      int hb;                   //H-bond bit pattern {1=don,2=acc,3=other}
      int lnk;                  //index of backward atom of 1-2 atom pair
      int lte;                  //maximum L of multipoles
      Multipoles q;             //atomic multipoles
      int lhb;                  //maximum L of multipoles
      Multipoles p;             //H-bond octopole
      Gaussian_Volume gau;      //volume density sqrt(hart/bohr**3)
      int mu;                   //number of intersecting atoms
      int fac[3];               //intersecting atoms
      std::string wjnt;         //water site donor or acceptor
      Coordinates u;            //u0*[-1.0+tanh( u1*excluded_volume -u2)]
      Gaussian_Volume ef[4];    //elec field density sqrt(hart/bohr**3)
      int zet;                  //charge
      Gaussian_Volume vf;       //volume density sqrt(1/bohr**3)
      int kap;                  //low dielectric site
      int R0;                   //mapping to set of residues
      bool ion;                 //contained in ionized group
      double off;               //charge overlay to reduce full charges
      tF1(){}
   };
   class tB1 { /*atoms in chain base groups [forward order]*/
   public:
      int F1;                   //mapping to set of atoms
      Coordinates x;            //coords (bohr)
      tB1(){}
   };
   class tG1 { /*atoms in chain forward groups [forward order]*/
   public:
      int F1;                   //mapping to set of atoms
      Coordinates b;            //untransformed coords (bohr)
      tG1(){}
   };
   class tH1 { /*atoms in backward groups of branch torsions [branch
                 backward order]*/
   public:
      int F1;                   //mapping to backward numbering
      tH1(){}
   };
   class tJ1 { /*pairs of adjacent torsion angles in chains*/
   public:
      Fourier2D_Coeffs tau;     //fourier coeffs (hartree)
      tJ1(){}
   };
   class tY1 { /*triples of adjacent torsion angles in chains*/
   public:
      Fourier3D_Coeffs tau;     //fourier coeffs (hartree)
      tY1(){}
   };

private:
   std::vector<int> o_J1N2Q1;           //pair of torsions
   std::vector<int> o_Y1N3Q1;           //triple of torsions
   std::vector<int> o_Y1N3J1;           //triple of pairs of torsions

   int& J1N2Q1(int i,int j){
      return o_J1N2Q1.at( i*2 +j);
   }
   int& Y1N3Q1(int i,int j){
      return o_Y1N3Q1.at( i*3 +j);
   }
   int& Y1N3J1(int i,int j){
      return o_Y1N3J1.at( i*3 +j);
   }

   void SET_Q1(Set_Automatic& aut,
               const DAT_PHYSICS_CONSTS& physics_consts,
               const DAT_ARRAY_CONSTS& array_consts,
               const DAT_ENERGY_PARAMS& energy_params,
               const DAT_RESIDUE_MAPPINGS& residue_mappings,
               const Structure& str,
               const Distance_Constraints& dst,
               Subset_Contracted_System::tM3& con,
               Conf_Dependent_System& dep);
   void SET_Q2(Set_Automatic& aut,
               const Thread_Options& opt,
               const Distance_Constraints& dst,
               Subset_Contracted_System::tM3& con,
               Conf_Dependent_System& dep);
   void SET_Q3(Set_Automatic& aut,
               Subset_Contracted_System::tM3& con);
   void SET_E0(Set_Automatic& aut,
               const Thread_Options& opt,
               Subset_Contracted_System::tM3& con,
               const Conf_Dependent_System& dep);
   int SET_PASS(Set_Automatic& aut,
                Subset_Contracted_System::tM3& con,
                int mQ2,int iQ2,
                int j__,int iQ3,
                int iE0,
                int SSBND=0);
   void SET_C1(Set_Automatic& aut,
               Subset_Contracted_System::tM3& con);
   int SET_DIST(Set_Automatic& aut,
                int jF1,int iC0min,int iC0max);
   void SET_WRITE(Set_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_RESIDUE_MAPPINGS& residue_mappings,
                  const Structure& str,
                  Output_Streams& out,
                  const Subset_Contracted_System::tM3& con,
                  const Conf_Dependent_System& dep) const;

   void CON_Q2(Con_Automatic& aut,
               const DAT_ARRAY_CONSTS& array_consts,
               const DAT_ENERGY_PARAMS& energy_params,
               const Thread_Options& opt,
               Subset_Contracted_System::tM3& con,
               Conf_Dependent_System& dep);
   void CON_F2(Con_Automatic& aut,
               const DAT_PHYSICS_CONSTS& physics_consts,
               const DAT_ARRAY_CONSTS& array_consts,
               const DAT_ENERGY_PARAMS& energy_params,
               Output_Streams& out,
               Subset_Contracted_System::tM3& con,
               Conf_Dependent_System& dep);
   void CON_BPAIR(Con_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_ARRAY_CONSTS& array_consts,
                  const DAT_ENERGY_PARAMS& energy_params,
                  Output_Streams& out,
                  Subset_Contracted_System::tM3& con,
                  int iZ0,int iQ2,int mQ2,int iE0);
   void CON_APAIR(Con_Automatic& aut,
                 const DAT_PHYSICS_CONSTS& physics_consts,
                 const DAT_ARRAY_CONSTS& array_consts,
                 const DAT_ENERGY_PARAMS& energy_params,
                 Output_Streams& out,
                 Subset_Contracted_System::tM3& con,
                 int jF1,int jZ0,int iE0,
                 int iF1,int i_2,int iQ2,int iZ0);
   void CON_E1(Con_Automatic& aut,
               Subset_Contracted_System::tM3& con);
   void CON_F(Con_Automatic& aut,
              const DAT_PHYSICS_CONSTS& physics_consts,
              const DAT_ARRAY_CONSTS& array_consts,
              const DAT_ENERGY_PARAMS& energy_params,
              const DAT_REGION_MAPS& region_maps,
              const Thread_Options& opt,
              Output_Streams& out,
              Subset_Contracted_System::tM3& con,
              Conf_Dependent_System& dep);
   void CON_WRITE(Con_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  Output_Streams& out,
                  Subset_Contracted_System::tM3& con,
                  Conf_Dependent_System& dep) const;

public:
   int nZ0;                     //number of chains
   /*sets*/
   std::vector<tZ0> Z0;         //chains
   std::vector<tR0> R0;         //residues in chains
   std::vector<tQ1> Q1;         //torsions in chains [forward order]
   std::vector<tX1> X1;         //torsions in chains [backward order]
   std::vector<tU1> U1;         //side chain torsions [branch backward order]
   std::vector<tF1> F1;         //atoms in chains [backward order]
   std::vector<tB1> B1;         //atoms in chain base groups [forward order]
   std::vector<tG1> G1;         //atoms in chain forward groups [forward order]
   std::vector<tH1> H1;         //atoms in backward groups of branch torsions
   std::vector<tJ1> J1;         //pairs of adjacent torsion angles in chains
   std::vector<tY1> Y1;         //triples of adjacent torsion angles in chains

   void SET(const DAT_PHYSICS_CONSTS& physics_consts,
            const DAT_ARRAY_CONSTS& array_consts,
            const DAT_ENERGY_PARAMS& energy_params,
            const DAT_RESIDUE_MAPPINGS& residue_mappings,
            const Thread_Options& opt,
            const Structure& str,
            Output_Streams& out,
            const Distance_Constraints& dst,
            Subset_Contracted_System& col,
            Conf_Dependent_System& dep);

   void CON(const DAT_PHYSICS_CONSTS& physics_consts,
            const DAT_ARRAY_CONSTS& array_consts,
            const DAT_ENERGY_PARAMS& energy_params,
            const DAT_REGION_MAPS& region_maps,
            const Thread_Options& opt,
            Output_Streams& out,
            Subset_Contracted_System& col,
            Conf_Dependent_System& dep);

   const int& J1N2Q1(int i,int j) const {
      return o_J1N2Q1.at( i*2 +j);
   }
   const int& Y1N3Q1(int i,int j) const {
      return o_Y1N3Q1.at( i*3 +j);
   }
   const int& Y1N3J1(int i,int j) const {
      return o_Y1N3J1.at( i*3 +j);
   }

   Mechanical_System(int oZ0,int oR0,
                     int oQ1,int oU1,
                     int oF1,int oB1,int oG1,int oH1,
                     int oJ1,int oY1):
      o_J1N2Q1(oJ1*2),
      o_Y1N3Q1(oY1*3),
      o_Y1N3J1(oY1*3),
      nZ0(oZ0),
      Z0(oZ0),
      R0(oR0),
      Q1(oQ1+1),
      X1(oQ1),
      U1(oU1),
      F1(oF1),
      B1(oB1),
      G1(oG1),
      H1(oH1),
      J1(oJ1),
      Y1(oY1)
   {
   }

   int iatom(int iR0,std::string atm) const{
      int mF1=R0[iR0].F1a;
      int nF1=(mF1+R0[iR0].cF1);
      for(int jF1=mF1;jF1<nF1;jF1++){
         if( F1[jF1].atm==atm ){
            return jF1;
         }
      }
      return -1;
   }
};

#endif
