#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Energy_Surface.hh"
#include "../reg/Regularization_Target.hh"
#include "../str/Output_Streams.hh"
#include <iomanip>
#include <cmath>

void Energy_Surface5::PHI(const DAT_PHYSICS_CONSTS& physics_consts,
                          Output_Streams& out,
                          const Regularization_Target& reg){
   double D[3],RR,R, E[3],SS,S, F[3],TT,T;
   double dR[3],dS[3],dT[3];
   double ddR[3][3],ddS[3][3],ddT[3][3];
   double dddR[3][3][3],dddS[3][3][3],dddT[3][3][3];
   double CP,SP;
   double C1,C2,Z;
   double QdC[3][ 4];
   double QQddC[3][3][ 4][4];
   double U[3],V[3],W[3];
   double sgn;
   double QdU[3][3][ 4],QdW[3][3][ 4];
   double QQddU[3][3][3][ 4][4],QQddW[3][3][3][ 4][4];
//
//
// zero energy surface
//
   Fa= (0.00);
   Fb= (0.00);
   Fc= (0.00);
   Fd= (0.00);
   for(int iU2= 0;iU2<nU2;iU2++){
      U2g(iU2)= (0.00);
   }
   for(int iU2= 0;iU2<nU2;iU2++){
      for(int jU2= 0;jU2<nU2;jU2++){
         U2U2a(iU2,jU2)= (0.00);
      }
   }
//
//
// atom positions
//
   for(int iA1= 0;iA1<reg.nA1;iA1++){
      int iU2=reg.A1[iA1].U2;
      for(int i=0;i<3;i++){
         if( iU2>= 0 ){
            D[i]=( U2chi(iU2+i) -reg.A1[iA1].y(i));
         }else{
            D[i]=( reg.A1[iA1].x(i) -reg.A1[iA1].y(i));
         }
         Fa+=reg.coa*( D[i]*D[i]);
         if( iU2>= 0 ){
            U2g(iU2+i)+=reg.coa*(2.)*D[i];
            U2U2a(iU2+i,iU2+i)+=reg.coa*(2.);
         }
      }
   }
//
//
// bond lengths
//
   for(int iA2= 0;iA2<reg.nA2;iA2++){
      int iA1=reg.A2N2A1(iA2,0);
      int jA1=reg.A2N2A1(iA2,1);
      int iU2=reg.A1[iA1].U2;
      int jU2=reg.A1[jA1].U2;
      RR= (0.00);
      for(int i=0;i<3;i++){
         if( (iU2>= 0)&&(jU2>= 0) ){
            D[i]=( U2chi(iU2+i) -U2chi(jU2+i));
         }else if( (iU2>= 0) ){
            D[i]=( U2chi(iU2+i) -reg.A1[jA1].x(i));
         }else if( (jU2>= 0) ){
            D[i]=( reg.A1[iA1].x(i) -U2chi(jU2+i));
         }else{
            D[i]=( reg.A1[iA1].x(i) -reg.A1[jA1].x(i));
         }
         RR+=D[i]*D[i];
      }
      R= std::sqrt( RR);
      double dst=( R -reg.A2[iA2].dst);
      Fb+=reg.cob*(dst*dst);
      if( (iU2< 0)&&(jU2< 0) )continue;
      for(int i=0;i<3;i++){
         dR[i]= D[i]/R;
         for(int j=i;j<3;j++){
            ddR[i][j]=-dR[i]*D[j]/RR;
            if( j==i )ddR[i][j]+=(1.)/R;
            ddR[j][i]= ddR[i][j];
         }
      }
      if( (iU2>= 0) ){
         for(int i=0;i<3;i++){
            U2g(iU2+i)+=reg.cob*(2.)*dst*dR[i];
            for(int j=i;j<3;j++){
               U2U2a(iU2+i,iU2+j)+=reg.cob*(2.)*( dR[i]*dR[j] +dst*ddR[i][j]);
            }
         }
      }
      if( (jU2>= 0) ){
         for(int i=0;i<3;i++){
            U2g(jU2+i)-=reg.cob*(2.)*dst*dR[i];
            for(int j=i;j<3;j++){
               U2U2a(jU2+i,jU2+j)+=reg.cob*(2.)*( dR[i]*dR[j] +dst*ddR[i][j]);
            }
         }
      }
      if( (iU2>= 0)&&(jU2>= 0) ){
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               Z= -reg.cob*(2.)*( dR[i]*dR[j] +dst*ddR[i][j]);
               if( iU2<jU2 ){
                  U2U2a(iU2+i,jU2+j)+=Z;
               }else{
                  U2U2a(jU2+j,iU2+i)+=Z;
               }
            }
         }
      }
   }
//
//
// bond angles
//
   for(int iA3= 0;iA3<reg.nA3;iA3++){
      int iA1=reg.A3N3A1(iA3,0);
      int jA1=reg.A3N3A1(iA3,1);
      int kA1=reg.A3N3A1(iA3,2);
      int iU2=reg.A1[iA1].U2;
      int jU2=reg.A1[jA1].U2;
      int kU2=reg.A1[kA1].U2;
      RR= (0.00);
      SS= (0.00);
      for(int i=0;i<3;i++){
         if( (iU2>= 0)&&(jU2>= 0) ){
            D[i]=( U2chi(iU2+i) -U2chi(jU2+i));
         }else if( (iU2>= 0) ){
            D[i]=( U2chi(iU2+i) -reg.A1[jA1].x(i));
         }else if( (jU2>= 0) ){
            D[i]=( reg.A1[iA1].x(i) -U2chi(jU2+i));
         }else{
            D[i]=( reg.A1[iA1].x(i) -reg.A1[jA1].x(i));
         }
         if( (jU2>= 0)&&(kU2>= 0) ){
            E[i]=( U2chi(kU2+i) -U2chi(jU2+i));
         }else if( (jU2>= 0) ){
            E[i]=( reg.A1[kA1].x(i) -U2chi(jU2+i));
         }else if( (kU2>= 0) ){
            E[i]=( U2chi(kU2+i) -reg.A1[jA1].x(i));
         }else{
            E[i]=( reg.A1[kA1].x(i) -reg.A1[jA1].x(i));
         }
         RR+=D[i]*D[i];
         SS+=E[i]*E[i];
      }
      R= std::sqrt( RR);
      S= std::sqrt( SS);
      CP= (0.00);
      for(int i=0;i<3;i++){
         dR[i]= D[i]/R;
         dS[i]= E[i]/S;
         CP+=dS[i]*dR[i];
      }
      double lam=( std::acos( CP) -physics_consts.RAD*reg.A3[iA3].lam);
      double fac=( reg.A3[iA3].RIGID )? (16.00): ( 1.00);
      Fc+=reg.coc*fac*(lam*lam);
      SP= std::sqrt( (1.) -CP*CP);
      if( SP<(1.00e-10) )SP= (1.00e-10);
      if( (iU2< 0)&&(jU2< 0)&&(kU2< 0) )continue;
      C1= reg.coc*fac*(2.)*lam*(-(1.)/SP);
      C2= reg.coc*fac*((2.)/(SP*SP))*( (1.) -lam*(CP/SP));
      for(int i=0;i<3;i++){
         for(int j=i;j<3;j++){
            ddR[i][j]=-dR[i]*D[j]/RR;
            ddS[i][j]=-dS[i]*E[j]/SS;
            for(int k=j;k<3;k++){
               dddR[i][j][k]=-(3.)*ddR[i][j]*D[k]/RR;
               if( j==i )dddR[i][j][k]-=dR[k]/RR;
               if( k==i )dddR[i][j][k]-=dR[j]/RR;
               if( k==j )dddR[i][j][k]-=dR[i]/RR;
               dddR[i][k][j]= dddR[i][j][k];
               dddR[j][i][k]= dddR[i][j][k];
               dddR[j][k][i]= dddR[i][j][k];
               dddR[k][i][j]= dddR[i][j][k];
               dddR[k][j][i]= dddR[i][j][k];
               dddS[i][j][k]=-(3.)*ddS[i][j]*E[k]/SS;
               if( j==i )dddS[i][j][k]-=dS[k]/SS;
               if( k==i )dddS[i][j][k]-=dS[j]/SS;
               if( k==j )dddS[i][j][k]-=dS[i]/SS;
               dddS[i][k][j]= dddS[i][j][k];
               dddS[j][i][k]= dddS[i][j][k];
               dddS[j][k][i]= dddS[i][j][k];
               dddS[k][i][j]= dddS[i][j][k];
               dddS[k][j][i]= dddS[i][j][k];
            }
            if( j==i )ddR[i][j]+=(1.)/R;
            ddR[j][i]= ddR[i][j];
            if( j==i )ddS[i][j]+=(1.)/S;
            ddS[j][i]= ddS[i][j];
         }
      }
      for(int i=0;i<3;i++){
         QdC[i][ 0]=( dS[0]*ddR[0][i] +dS[1]*ddR[1][i] +dS[2]*ddR[2][i]);
         QdC[i][ 2]=( ddS[0][i]*dR[0] +ddS[1][i]*dR[1] +ddS[2][i]*dR[2]);
         for(int j=i;j<3;j++){
            QQddC[i][j][ 0][0]=(
              dS[0]*dddR[0][i][j] +dS[1]*dddR[1][i][j] +dS[2]*dddR[2][i][j]);
            QQddC[j][i][ 0][0]= QQddC[i][j][ 0][0];
            QQddC[i][j][ 2][2]=(
              dddS[0][i][j]*dR[0] +dddS[1][i][j]*dR[1] +dddS[2][i][j]*dR[2]);
            QQddC[j][i][ 2][2]= QQddC[i][j][ 2][2];
            QQddC[i][j][ 0][2]=(
              ddS[0][j]*ddR[0][i] +ddS[1][j]*ddR[1][i] +ddS[2][j]*ddR[2][i]);
            QQddC[j][i][ 0][2]=(
              ddS[0][i]*ddR[0][j] +ddS[1][i]*ddR[1][j] +ddS[2][i]*ddR[2][j]);
         }
      }
      if( (iU2>= 0) ){
         for(int i=0;i<3;i++){
            U2g(iU2+i)+=C1*QdC[i][ 0];
            for(int j=i;j<3;j++){
               U2U2a(iU2+i,iU2+j)+=( C2*QdC[i][ 0]*QdC[j][ 0]
                                    +C1*QQddC[i][j][ 0][0]);
            }
         }
      }
      if( (jU2>= 0) ){
         for(int i=0;i<3;i++){
            U2g(jU2+i)-=C1*( QdC[i][ 0] +QdC[i][ 2]);
            for(int j=i;j<3;j++){
               U2U2a(jU2+i,jU2+j)+=( C2*( QdC[i][ 0] +QdC[i][ 2])
                                       *( QdC[j][ 0] +QdC[j][ 2])
                                    +C1*( QQddC[i][j][ 0][0]
                                         +QQddC[i][j][ 0][2]
                                         +QQddC[j][i][ 0][2]
                                         +QQddC[i][j][ 2][2]));
            }
         }
      }
      if( (kU2>= 0) ){
         for(int i=0;i<3;i++){
            U2g(kU2+i)+=C1*QdC[i][ 2];
            for(int j=i;j<3;j++){
               U2U2a(kU2+i,kU2+j)+=( C2*QdC[i][ 2]*QdC[j][ 2]
                                    +C1*QQddC[i][j][ 2][2]);
            }
         }
      }
      if( (iU2>= 0)&&(jU2>= 0) ){
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               Z= -C2*( QdC[j][ 0] +QdC[j][ 2])*QdC[i][ 0]
                  -C1*( QQddC[i][j][ 0][0] +QQddC[i][j][ 0][2]);
               if( iU2<jU2 ){
                  U2U2a(iU2+i,jU2+j)+=Z;
               }else{
                  U2U2a(jU2+j,iU2+i)+=Z;
               }
            }
         }
      }
      if( (iU2>= 0)&&(kU2>= 0) ){
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               Z= C2*QdC[i][ 0]*QdC[j][ 2]
                 +C1*QQddC[i][j][ 0][2];
               if( iU2<kU2 ){
                  U2U2a(iU2+i,kU2+j)+=Z;
               }else{
                  U2U2a(kU2+j,iU2+i)+=Z;
               }
            }
         }
      }
      if( (jU2>= 0)&&(kU2>= 0) ){
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               Z= -C2*( QdC[i][ 0] +QdC[i][ 2])*QdC[j][ 2]
                  -C1*( QQddC[i][j][ 0][2] +QQddC[i][j][ 2][2]);
               if( jU2<kU2 ){
                  U2U2a(jU2+i,kU2+j)+=Z;
               }else{
                  U2U2a(kU2+j,jU2+i)+=Z;
               }
            }
         }
      }
   }
//
//
// torsion angles
//
   for(int iA4= 0;iA4<reg.nA4;iA4++){
      int iA1=reg.A4N4A1(iA4,0);
      int jA1=reg.A4N4A1(iA4,1);
      int kA1=reg.A4N4A1(iA4,2);
      int lA1=reg.A4N4A1(iA4,3);
      int iU2=reg.A1[iA1].U2;
      int jU2=reg.A1[jA1].U2;
      int kU2=reg.A1[kA1].U2;
      int lU2=reg.A1[lA1].U2;
      for(int i=0;i<3;i++){
         if( (jU2>= 0)&&(kU2>= 0) ){
            D[i]=( U2chi(jU2+i) -U2chi(kU2+i));
         }else if( (jU2>= 0) ){
            D[i]=( U2chi(jU2+i) -reg.A1[kA1].x(i));
         }else if( (kU2>= 0) ){
            D[i]=( reg.A1[jA1].x(i) -U2chi(kU2+i));
         }else{
            D[i]=( reg.A1[jA1].x(i) -reg.A1[kA1].x(i));
         }
         if( (kU2>= 0)&&(lU2>= 0) ){
            E[i]=( U2chi(lU2+i) -U2chi(kU2+i));
         }else if( (kU2>= 0) ){
            E[i]=( reg.A1[lA1].x(i) -U2chi(kU2+i));
         }else if( (lU2>= 0) ){
            E[i]=( U2chi(lU2+i) -reg.A1[kA1].x(i));
         }else{
            E[i]=( reg.A1[lA1].x(i) -reg.A1[kA1].x(i));
         }
         if( (iU2>= 0)&&(jU2>= 0) ){
            F[i]=( U2chi(iU2+i) -U2chi(jU2+i));
         }else if( (iU2>= 0) ){
            F[i]=( U2chi(iU2+i) -reg.A1[jA1].x(i));
         }else if( (jU2>= 0) ){
            F[i]=( reg.A1[iA1].x(i) -U2chi(jU2+i));
         }else{
            F[i]=( reg.A1[iA1].x(i) -reg.A1[jA1].x(i));
         }
      }
      U[0]=( D[1]*E[2] -D[2]*E[1]);
      U[1]=( D[2]*E[0] -D[0]*E[2]);
      U[2]=( D[0]*E[1] -D[1]*E[0]);
      V[0]=( D[1]*U[2] -D[2]*U[1]);
      V[1]=( D[2]*U[0] -D[0]*U[2]);
      V[2]=( D[0]*U[1] -D[1]*U[0]);
      W[0]=( D[1]*F[2] -D[2]*F[1]);
      W[1]=( D[2]*F[0] -D[0]*F[2]);
      W[2]=( D[0]*F[1] -D[1]*F[0]);
      RR= (0.00);
      SS= (0.00);
      TT= (0.00);
      for(int i=0;i<3;i++){
         RR+=U[i]*U[i];
         SS+=V[i]*V[i];
         TT+=W[i]*W[i];
      }
      R= std::sqrt( RR);
      S= std::sqrt( SS);
      T= std::sqrt( TT);
      CP= (0.00);
      SP= (0.00);
      for(int i=0;i<3;i++){
         dR[i]= U[i]/R;
         dS[i]= V[i]/S;
         dT[i]= W[i]/T;
         CP+=dR[i]*dT[i];
         SP+=dS[i]*dT[i];
      }
      if( CP>( (1.00) -(1.00e-12)) )CP=( (1.00) -(1.00e-12));
      if( CP<(-(1.00) +(1.00e-12)) )CP=(-(1.00) +(1.00e-12));
      sgn=( SP<=(0.00) )?-(1.00): (1.00);
      SP= std::sqrt( (1.00) -CP*CP);
      if( SP<(1.00e-10) )SP= (1.00e-10);
      SP*=sgn;
      double chi=( sgn*std::acos( CP) -physics_consts.RAD*reg.A4[iA4].chi);
      if      ( chi<-physics_consts.PI ){
         chi+=(2.00)*physics_consts.PI;
      }else if( chi> physics_consts.PI ){
         chi-=(2.00)*physics_consts.PI;
      }
      Fd+=reg.cod*(chi*chi);
      if( (iU2< 0)&&(jU2< 0)&&(kU2< 0)&&(lU2< 0) )continue;
      C1= reg.cod*(2.)*chi*(-(1.)/SP);
      C2= reg.cod*((2.)/(SP*SP))*( (1.) -chi*(CP/SP));
      for(int i=0;i<3;i++){
         for(int j=i;j<3;j++){
            ddT[i][j]=-dT[i]*W[j]/TT;
            ddR[i][j]=-dR[i]*U[j]/RR;
            for(int k=j;k<3;k++){
               dddT[i][j][k]=-(3.)*ddT[i][j]*W[k]/TT;
               if( j==i )dddT[i][j][k]-=dT[k]/TT;
               if( k==i )dddT[i][j][k]-=dT[j]/TT;
               if( k==j )dddT[i][j][k]-=dT[i]/TT;
               dddT[i][k][j]= dddT[i][j][k];
               dddT[j][i][k]= dddT[i][j][k];
               dddT[j][k][i]= dddT[i][j][k];
               dddT[k][i][j]= dddT[i][j][k];
               dddT[k][j][i]= dddT[i][j][k];
               dddR[i][j][k]=-(3.)*ddR[i][j]*U[k]/RR;
               if( j==i )dddR[i][j][k]-=dR[k]/RR;
               if( k==i )dddR[i][j][k]-=dR[j]/RR;
               if( k==j )dddR[i][j][k]-=dR[i]/RR;
               dddR[i][k][j]= dddR[i][j][k];
               dddR[j][i][k]= dddR[i][j][k];
               dddR[j][k][i]= dddR[i][j][k];
               dddR[k][i][j]= dddR[i][j][k];
               dddR[k][j][i]= dddR[i][j][k];
            }
            if( j==i )ddT[i][j]+=(1.)/T;
            ddT[j][i]= ddT[i][j];
            if( j==i )ddR[i][j]+=(1.)/R;
            ddR[j][i]= ddR[i][j];
         }
      }
      for(int i=0;i<3;i++){
         for(int j=0;j<3;j++){
            QdW[i][j][ 0]= (0.00);
            QdW[i][j][ 1]= (0.00);
            QdW[i][j][ 2]= (0.00);
            QdU[i][j][ 1]= (0.00);
            QdU[i][j][ 2]= (0.00);
            QdU[i][j][ 3]= (0.00);
            for(int k=0;k<3;k++){
               QdW[i][j][ 0]+=( reg.feps(i,k,j)*D[k]);
               QdW[i][j][ 1]+=(-reg.feps(i,k,j)*D[k]
                               +reg.feps(i,j,k)*F[k]);
               QdW[i][j][ 2]+=(-reg.feps(i,j,k)*F[k]);
               QdU[i][j][ 1]+=( reg.feps(i,j,k)*E[k]);
               QdU[i][j][ 2]+=(-reg.feps(i,k,j)*D[k]
                               -reg.feps(i,j,k)*E[k]);
               QdU[i][j][ 3]+=( reg.feps(i,k,j)*D[k]);
            }
         }
      }
      for(int i=0;i<3;i++){
         for(int j=0;j<3;j++){
            for(int k=0;k<3;k++){
//             QQddW[i][j][k][ 0][0]= (0.00);
               QQddW[i][j][k][ 0][1]= reg.feps(i,k,j);
               QQddW[i][j][k][ 0][2]=-reg.feps(i,k,j);
               QQddW[i][j][k][ 1][0]= reg.feps(i,j,k);
//             QQddW[i][j][k][ 1][1]= (0.00);
               QQddW[i][j][k][ 1][2]= reg.feps(i,k,j);
               QQddW[i][j][k][ 2][0]=-reg.feps(i,j,k);
               QQddW[i][j][k][ 2][1]= reg.feps(i,j,k);
//             QQddW[i][j][k][ 2][2]= (0.00);
//             QQddU[i][j][k][ 1][1]= (0.00);
               QQddU[i][j][k][ 1][2]=-reg.feps(i,j,k);
               QQddU[i][j][k][ 1][3]= reg.feps(i,j,k);
               QQddU[i][j][k][ 2][1]=-reg.feps(i,k,j);
//             QQddU[i][j][k][ 2][2]= (0.00);
               QQddU[i][j][k][ 2][3]=-reg.feps(i,j,k);
               QQddU[i][j][k][ 3][1]= reg.feps(i,k,j);
               QQddU[i][j][k][ 3][2]=-reg.feps(i,k,j);
//             QQddU[i][j][k][ 3][3]= (0.00);
            }
         }
      }
      if( (iU2>= 0) ){
         for(int i=0;i<3;i++){
            QdC[i][ 0]= (0.00);
            for(int l=0;l<3;l++){
               QdC[i][ 0]+=( dR[0]*ddT[0][l]
                            +dR[1]*ddT[1][l]
                            +dR[2]*ddT[2][l])
                           *QdW[l][i][ 0];
            }
            for(int j=i;j<3;j++){
               QQddC[i][j][ 0][0]= (0.00);
               for(int l=0;l<3;l++){
                  for(int m=0;m<3;m++){
                     QQddC[i][j][ 0][0]+=( dR[0]*dddT[0][l][m]
                                          +dR[1]*dddT[1][l][m]
                                          +dR[2]*dddT[2][l][m])
                                         *QdW[l][i][ 0]
                                         *QdW[m][j][ 0];
                  }
//                QQddC[i][j][ 0][0]+=( dR[0]*ddT[0][l]
//                                     +dR[1]*ddT[1][l]
//                                     +dR[2]*ddT[2][l])
//                                    *QQddW[l][i][j][ 0][0];
               }
            }
         }
         for(int i=0;i<3;i++){
            U2g(iU2+i)+=C1*QdC[i][ 0];
            for(int j=i;j<3;j++){
               U2U2a(iU2+i,iU2+j)+=( C2*QdC[i][ 0]*QdC[j][ 0]
                                    +C1*QQddC[i][j][ 0][0]);
            }
         }
      }
      if( (jU2>= 0) ){
         for(int i=0;i<3;i++){
            QdC[i][ 1]= (0.00);
            for(int l=0;l<3;l++){
               QdC[i][ 1]+=( ( dR[0]*ddT[0][l]
                              +dR[1]*ddT[1][l]
                              +dR[2]*ddT[2][l])
                             *QdW[l][i][ 1]
                            +( ddR[0][l]*dT[0]
                              +ddR[1][l]*dT[1]
                              +ddR[2][l]*dT[2])
                             *QdU[l][i][ 1]);
            }
            for(int j=i;j<3;j++){
               QQddC[i][j][ 1][1]= (0.00);
               for(int l=0;l<3;l++){
                  for(int m=0;m<3;m++){
                     QQddC[i][j][ 1][1]+=(( dR[0]*dddT[0][l][m]
                                           +dR[1]*dddT[1][l][m]
                                           +dR[2]*dddT[2][l][m])
                                          *QdW[l][i][ 1]
                                          *QdW[m][j][ 1]
                                         +( ddR[0][m]*ddT[0][l]
                                           +ddR[1][m]*ddT[1][l]
                                           +ddR[2][m]*ddT[2][l])
                                          *QdW[l][i][ 1]
                                          *QdU[m][j][ 1]
                                         +( ddR[0][l]*ddT[0][m]
                                           +ddR[1][l]*ddT[1][m]
                                           +ddR[2][l]*ddT[2][m])
                                          *QdU[l][i][ 1]
                                          *QdW[m][j][ 1]
                                         +( dddR[0][l][m]*dT[0]
                                           +dddR[1][l][m]*dT[1]
                                           +dddR[2][l][m]*dT[2])
                                          *QdU[l][i][ 1]
                                          *QdU[m][j][ 1]);
                  }
//                QQddC[i][j][ 1][1]+=( ( dR[0]*ddT[0][l]
//                                       +dR[1]*ddT[1][l]
//                                       +dR[2]*ddT[2][l])
//                                      *QQddW[l][i][j][ 1][1]
//                                     +( ddR[0][l]*dT[0]
//                                       +ddR[1][l]*dT[1]
//                                       +ddR[2][l]*dT[2])
//                                      *QQddU[l][i][j][ 1][1]);
               }
            }
         }
         for(int i=0;i<3;i++){
            U2g(jU2+i)+=C1*QdC[i][ 1];
            for(int j=i;j<3;j++){
               U2U2a(jU2+i,jU2+j)+=( C2*QdC[i][ 1]*QdC[j][ 1]
                                    +C1*QQddC[i][j][ 1][1]);
            }
         }
      }
      if( (kU2>= 0) ){
         for(int i=0;i<3;i++){
            QdC[i][ 2]= (0.00);
            for(int l=0;l<3;l++){
               QdC[i][ 2]+=( ( dR[0]*ddT[0][l]
                              +dR[1]*ddT[1][l]
                              +dR[2]*ddT[2][l])
                             *QdW[l][i][ 2]
                            +( ddR[0][l]*dT[0]
                              +ddR[1][l]*dT[1]
                              +ddR[2][l]*dT[2])
                             *QdU[l][i][ 2]);
            }
            for(int j=i;j<3;j++){
               QQddC[i][j][ 2][2]= (0.00);
               for(int l=0;l<3;l++){
                  for(int m=0;m<3;m++){
                     QQddC[i][j][ 2][2]+=(( dR[0]*dddT[0][l][m]
                                           +dR[1]*dddT[1][l][m]
                                           +dR[2]*dddT[2][l][m])
                                          *QdW[l][i][ 2]
                                          *QdW[m][j][ 2]
                                         +( ddR[0][m]*ddT[0][l]
                                           +ddR[1][m]*ddT[1][l]
                                           +ddR[2][m]*ddT[2][l])
                                          *QdW[l][i][ 2]
                                          *QdU[m][j][ 2]
                                         +( ddR[0][l]*ddT[0][m]
                                           +ddR[1][l]*ddT[1][m]
                                           +ddR[2][l]*ddT[2][m])
                                          *QdU[l][i][ 2]
                                          *QdW[m][j][ 2]
                                         +( dddR[0][l][m]*dT[0]
                                           +dddR[1][l][m]*dT[1]
                                           +dddR[2][l][m]*dT[2])
                                          *QdU[l][i][ 2]
                                          *QdU[m][j][ 2]);
                  }
//                QQddC[i][j][ 2][2]+=( ( dR[0]*ddT[0][l]
//                                       +dR[1]*ddT[1][l]
//                                       +dR[2]*ddT[2][l])
//                                      *QQddW[l][i][j][ 2][2]
//                                     +( ddR[0][l]*dT[0]
//                                       +ddR[1][l]*dT[1]
//                                       +ddR[2][l]*dT[2])
//                                      *QQddU[l][i][j][ 2][2]);
               }
            }
         }
         for(int i=0;i<3;i++){
            U2g(kU2+i)+=C1*QdC[i][ 2];
            for(int j=i;j<3;j++){
               U2U2a(kU2+i,kU2+j)+=( C2*QdC[i][ 2]*QdC[j][ 2]
                                    +C1*QQddC[i][j][ 2][2]);
            }
         }
      }
      if( (lU2>= 0) ){
         for(int i=0;i<3;i++){
            QdC[i][ 3]= (0.00);
            for(int l=0;l<3;l++){
               QdC[i][ 3]+=( ddR[0][l]*dT[0]
                            +ddR[1][l]*dT[1]
                            +ddR[2][l]*dT[2])
                           *QdU[l][i][ 3];
            }
            for(int j=i;j<3;j++){
               QQddC[i][j][ 3][3]= (0.00);
               for(int l=0;l<3;l++){
                  for(int m=0;m<3;m++){
                     QQddC[i][j][ 3][3]+=( dddR[0][l][m]*dT[0]
                                          +dddR[1][l][m]*dT[1]
                                          +dddR[2][l][m]*dT[2])
                                         *QdU[l][i][ 3]
                                         *QdU[m][j][ 3];
                  }
//                QQddC[i][j][ 3][3]+=( ddR[0][l]*dT[0]
//                                     +ddR[1][l]*dT[1]
//                                     +ddR[2][l]*dT[2])
//                                    *QQddU[l][i][j][ 3][3];
               }
            }
         }
         for(int i=0;i<3;i++){
            U2g(lU2+i)+=C1*QdC[i][ 3];
            for(int j=i;j<3;j++){
               U2U2a(lU2+i,lU2+j)+=( C2*QdC[i][ 3]*QdC[j][ 3]
                                    +C1*QQddC[i][j][ 3][3]);
            }
         }
      }
      if( (iU2>= 0)&&(jU2>= 0) ){
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               QQddC[i][j][ 0][1]= (0.00);
               for(int l=0;l<3;l++){
                  for(int m=0;m<3;m++){
                     QQddC[i][j][ 0][1]+=(( dR[0]*dddT[0][l][m]
                                           +dR[1]*dddT[1][l][m]
                                           +dR[2]*dddT[2][l][m])
                                          *QdW[l][i][ 0]
                                          *QdW[m][j][ 1]
                                         +( ddR[0][m]*ddT[0][l]
                                           +ddR[1][m]*ddT[1][l]
                                           +ddR[2][m]*ddT[2][l])
                                          *QdW[l][i][ 0]
                                          *QdU[m][j][ 1]);
                  }
                  QQddC[i][j][ 0][1]+=( dR[0]*ddT[0][l]
                                       +dR[1]*ddT[1][l]
                                       +dR[2]*ddT[2][l])
                                      *QQddW[l][i][j][ 0][1];
               }
            }
         }
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               Z= C2*QdC[i][ 0]*QdC[j][ 1]
                 +C1*QQddC[i][j][ 0][1];
               if( iU2<jU2 ){
                  U2U2a(iU2+i,jU2+j)+=Z;
               }else{
                  U2U2a(jU2+j,iU2+i)+=Z;
               }
            }
         }
      }
      if( (iU2>= 0)&&(kU2>= 0) ){
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               QQddC[i][j][ 0][2]= (0.00);
               for(int l=0;l<3;l++){
                  for(int m=0;m<3;m++){
                     QQddC[i][j][ 0][2]+=(( dR[0]*dddT[0][l][m]
                                           +dR[1]*dddT[1][l][m]
                                           +dR[2]*dddT[2][l][m])
                                          *QdW[l][i][ 0]
                                          *QdW[m][j][ 2]
                                         +( ddR[0][m]*ddT[0][l]
                                           +ddR[1][m]*ddT[1][l]
                                           +ddR[2][m]*ddT[2][l])
                                          *QdW[l][i][ 0]
                                          *QdU[m][j][ 2]);
                  }
                  QQddC[i][j][ 0][2]+=( dR[0]*ddT[0][l]
                                       +dR[1]*ddT[1][l]
                                       +dR[2]*ddT[2][l])
                                      *QQddW[l][i][j][ 0][2];
               }
            }
         }
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               Z= C2*QdC[i][ 0]*QdC[j][ 2]
                 +C1*QQddC[i][j][ 0][2];
               if( iU2<kU2 ){
                  U2U2a(iU2+i,kU2+j)+=Z;
               }else{
                  U2U2a(kU2+j,iU2+i)+=Z;
               }
            }
         }
      }
      if( (iU2>= 0)&&(lU2>= 0) ){
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               QQddC[i][j][ 0][3]= (0.00);
               for(int l=0;l<3;l++){
                  for(int m=0;m<3;m++){
                     QQddC[i][j][ 0][3]+=( ddR[0][m]*ddT[0][l]
                                          +ddR[1][m]*ddT[1][l]
                                          +ddR[2][m]*ddT[2][l])
                                         *QdW[l][i][ 0]
                                         *QdU[m][j][ 3];
                  }
               }
            }
         }
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               Z= C2*QdC[i][ 0]*QdC[j][ 3]
                 +C1*QQddC[i][j][ 0][3];
               if( iU2<lU2 ){
                  U2U2a(iU2+i,lU2+j)+=Z;
               }else{
                  U2U2a(lU2+j,iU2+i)+=Z;
               }
            }
         }
      }
      if( (jU2>= 0)&&(kU2>= 0) ){
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               QQddC[i][j][ 1][2]= (0.00);
               for(int l=0;l<3;l++){
                  for(int m=0;m<3;m++){
                     QQddC[i][j][ 1][2]+=(( dR[0]*dddT[0][l][m]
                                           +dR[1]*dddT[1][l][m]
                                           +dR[2]*dddT[2][l][m])
                                          *QdW[l][i][ 1]
                                          *QdW[m][j][ 2]
                                         +( ddR[0][m]*ddT[0][l]
                                           +ddR[1][m]*ddT[1][l]
                                           +ddR[2][m]*ddT[2][l])
                                          *QdW[l][i][ 1]
                                          *QdU[m][j][ 2]
                                         +( ddR[0][l]*ddT[0][m]
                                           +ddR[1][l]*ddT[1][m]
                                           +ddR[2][l]*ddT[2][m])
                                          *QdU[l][i][ 1]
                                          *QdW[m][j][ 2]
                                         +( dddR[0][l][m]*dT[0]
                                           +dddR[1][l][m]*dT[1]
                                           +dddR[2][l][m]*dT[2])
                                          *QdU[l][i][ 1]
                                          *QdU[m][j][ 2]);
                  }
                  QQddC[i][j][ 1][2]+=( ( dR[0]*ddT[0][l]
                                         +dR[1]*ddT[1][l]
                                         +dR[2]*ddT[2][l])
                                        *QQddW[l][i][j][ 1][2]
                                       +( ddR[0][l]*dT[0]
                                         +ddR[1][l]*dT[1]
                                         +ddR[2][l]*dT[2])
                                        *QQddU[l][i][j][ 1][2]);
               }
            }
         }
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               Z= C2*QdC[i][ 1]*QdC[j][ 2]
                 +C1*QQddC[i][j][ 1][2];
               if( jU2<kU2 ){
                  U2U2a(jU2+i,kU2+j)+=Z;
               }else{
                  U2U2a(kU2+j,jU2+i)+=Z;
               }
            }
         }
      }
      if( (jU2>= 0)&&(lU2>= 0) ){
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               QQddC[i][j][ 1][3]= (0.00);
               for(int l=0;l<3;l++){
                  for(int m=0;m<3;m++){
                     QQddC[i][j][ 1][3]+=(( ddR[0][m]*ddT[0][l]
                                           +ddR[1][m]*ddT[1][l]
                                           +ddR[2][m]*ddT[2][l])
                                          *QdW[l][i][ 1]
                                          *QdU[m][j][ 3]
                                         +( dddR[0][l][m]*dT[0]
                                           +dddR[1][l][m]*dT[1]
                                           +dddR[2][l][m]*dT[2])
                                          *QdU[l][i][ 1]
                                          *QdU[m][j][ 3]);
                  }
                  QQddC[i][j][ 1][3]+=( ddR[0][l]*dT[0]
                                       +ddR[1][l]*dT[1]
                                       +ddR[2][l]*dT[2])
                                      *QQddU[l][i][j][ 1][3];
               }
            }
         }
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               Z= C2*QdC[i][ 1]*QdC[j][ 3]
                 +C1*QQddC[i][j][ 1][3];
               if( jU2<lU2 ){
                  U2U2a(jU2+i,lU2+j)+=Z;
               }else{
                  U2U2a(lU2+j,jU2+i)+=Z;
               }
            }
         }
      }
      if( (kU2>= 0)&&(lU2>= 0) ){
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               QQddC[i][j][ 2][3]= (0.00);
               for(int l=0;l<3;l++){
                  for(int m=0;m<3;m++){
                     QQddC[i][j][ 2][3]+=(( ddR[0][m]*ddT[0][l]
                                           +ddR[1][m]*ddT[1][l]
                                           +ddR[2][m]*ddT[2][l])
                                          *QdW[l][i][ 2]
                                          *QdU[m][j][ 3]
                                         +( dddR[0][l][m]*dT[0]
                                           +dddR[1][l][m]*dT[1]
                                           +dddR[2][l][m]*dT[2])
                                          *QdU[l][i][ 2]
                                          *QdU[m][j][ 3]);
                  }
                  QQddC[i][j][ 2][3]+=( ddR[0][l]*dT[0]
                                       +ddR[1][l]*dT[1]
                                       +ddR[2][l]*dT[2])
                                      *QQddU[l][i][j][ 2][3];
               }
            }
         }
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               Z= C2*QdC[i][ 2]*QdC[j][ 3]
                 +C1*QQddC[i][j][ 2][3];
               if( kU2<lU2 ){
                  U2U2a(kU2+i,lU2+j)+=Z;
               }else{
                  U2U2a(lU2+j,kU2+i)+=Z;
               }
            }
         }
      }
   }
//
//
//
//
   TOT=( Fa +Fb +Fc +Fd);
//
//
// diagnostic output
//
// out.FILE2<<"________________________________________"
//            "________________________________________\n";
// out.FILE2<< std::fixed<< std::setprecision(7);
// out.FILE2<<"A1x\n";
// for(int iA1= 0;iA1<reg.nA1;iA1++){
//    int iU2=reg.A1[iA1].U2;
//    if( iU2==-1 )continue;
//    out.FILE2<< std::setw( 5)<<iA1;
//    for(int i=0;i<3;i++){
//       out.FILE2<< std::setw(12)<<U2chi(iU2+i);
//    }
//    out.FILE2<<'\n';
// }
// out.FILE2<< std::scientific<< std::setprecision(7);
// out.FILE2<<"FUNC\n";
// out.FILE2<< std::setw(15)<<TOT<<'\n';
// out.FILE2<<"1st DERIV\n";
// for(int iA1= 0;iA1<reg.nA1;iA1++){
//    int iU2=reg.A1[iA1].U2;
//    if( iU2==-1 )continue;
//    out.FILE2<< std::setw( 5)<<iA1;
//    for(int i=0;i<3;i++){
//       out.FILE2<< std::setw(15)<<U2g(iU2+i);
//    }
//    out.FILE2<<'\n';
// }
// out.FILE2<<"2nd DERIV\n";
// for(int iU2=0;iU2<nU2;iU2++){
//    for(int jU2min=iU2;jU2min<nU2;jU2min+=6){
//       int jU2max=(jU2min+6);
//       if( jU2max>nU2 )jU2max=nU2;
//       for(int jU2=jU2min;jU2<jU2max;jU2++){
//          out.FILE2<< std::setw(15)<<U2U2a(iU2,jU2);
//       }
//       out.FILE2<<'\n';
//    }
// }
   return;
}
