#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../reg/Regularization_Target.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <iomanip>
#include <cmath>

class MEM_reg {
public:
   class tA8 { /*subset of physical atoms*/
   public:
      int A1;                   //index of movable atom
      tA8(){}
   };
   class tK1 { /*subsets of degrees of freedom in regularization*/
   public:
      int nA8;                  //number
      std::vector<tA8> A8;      //subset of movable atoms
      tK1(){}
   };
private:
   std::vector<int> o_P1A1;     //index of movable atom
public:
   std::vector<tK1> K1;         //set of subsets of movable atoms
   MEM_reg(int o):
      o_P1A1(o)
   {
   }
   int& P1A1(int i){
      return o_P1A1.at( i);  }
};

void Structure::REG(const DAT_PHYSICS_CONSTS& physics_consts,
                    const DAT_RESIDUE_MAPPINGS& residue_mappings,
                    Output_Streams& out){
   int oZ0=nZ0;
   int oR0=(Z0[oZ0-1].R0a+Z0[oZ0-1].cR0);
   int oP1=(R0[oR0-1].P1a+R0[oR0-1].cP1);
   MEM_reg vv(oP1);
   Regularization_Target reg;
//
//
// z-matrix entry for peptide C-terminal oxygen
//
   int jP2;
   {
      std::string aa="ASP ";
      int iL0=residue_mappings.iresidue( aa);
      if( iL0==-1 ){
         std::cerr<<"ERROR: Unmatched residue name in residue data."
                  <<" aa="<<aa<<".\n";
         std::exit( 1);
      }else{
         std::string atm=" OD1";
         jP2=residue_mappings.ip2atom(iL0,atm);
         if( jP2==-1 ){
            std::cerr<<"ERROR: Unmatched atom name in residue data."
                     <<" atm="<<atm<<".\n";
            std::exit( 1);
         }
      }
   }
//
//
// z-matrix entry for ribose atom C5' following phospodiester residue PO
//
   int kP2;
   {
      std::string aa="PO  ";
      int iL0=residue_mappings.iresidue( aa);
      if( iL0==-1 ){
         std::cerr<<"ERROR: Unmatched residue name in residue data."
                  <<" aa="<<aa<<".\n";
         std::exit( 1);
      }else{
         std::string atm=" O5'";
         kP2=residue_mappings.ip2atom(iL0,atm);
         if( kP2==-1 ){
            std::cerr<<"ERROR: Unmatched atom name in residue data."
                     <<" atm="<<atm<<".\n";
            std::exit( 1);
         }
         kP2+=3;
      }
   }
//
//
// add target function elements for heavy atom positions
//
   int oA8=85;
   reg.nA1=0;
   int nK1=0;
   vv.K1.push_back( MEM_reg::tK1());
   vv.K1[nK1  ].nA8=0;
   vv.K1[nK1  ].A8.resize(oA8);
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            vv.P1A1(iP1)=-1;
            if( P1[iP1].sub==0 )continue;
            if( P1[iP1].typ< 8 )continue;
            vv.P1A1(iP1)=reg.nA1;
            reg.A1.push_back( Regularization_Target::tA1());
            reg.A1[reg.nA1].y= P1[iP1].x;
            reg.A1[reg.nA1].x= P1[iP1].x;
            if( vv.K1[nK1  ].nA8>=(oA8-10) ){
               nK1++;
               vv.K1.push_back( MEM_reg::tK1());
               vv.K1[nK1  ].nA8=0;
               vv.K1[nK1  ].A8.resize(oA8);
            }
            vv.K1[nK1  ].A8[vv.K1[nK1  ].nA8++].A1=reg.nA1;
            if( (nK1> 0)&&(vv.K1[nK1-1].nA8<oA8) ){
               vv.K1[nK1-1].A8[vv.K1[nK1-1].nA8++].A1=reg.nA1;
            }
            reg.nA1++;
         }
      }
   }
   nK1++;
//
//
// add target function elements from z-matrix
//
   reg.nA2= 0;
   reg.nA3= 0;
   reg.nA4= 0;
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char c1=R0[iR0].c1;
         std::string aa=R0[iR0].aa;
         bool CTERMINAL=( (aa[3]=='e')||(aa[3]=='z') )? true: false;
         bool PORIBOSE=( (c1=='r')&&
                         (R0[iR0-1].aa!="5OH ") )? true: false;
         if      ( (aa[0]=='e')||(aa[0]=='z') ){
            aa=aa.substr(1,3)+' ';
         }else if( (aa[3]=='e')||(aa[3]=='z') ){
            aa=aa.substr(0,3)+' ';
         }
         int iL0=residue_mappings.iresidue( aa);
         if( iL0==-1 ){
            std::cerr<<"ERROR: Unmatched residue name in residue data."
                     <<" aa="<<aa<<".\n";
            std::exit( 1);
         }
         int mP2=residue_mappings.L0[iL0].P2a;
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            if( P1[iP1].typ< 8 )continue;
            std::string atm=P1[iP1].atm;
            bool OXYGEN=( atm==" O  " )? true: false;
            bool C5PRIM=( atm==" C5'" )? true: false;
            int iP2=residue_mappings.ip2atom(iL0,atm);
            if( iP2==-1 )continue;
//          int j0R0=iR0;
            int j0P1=iP1;
            if( iP2<(mP2+1) )continue;
            int j1R0=(iR0+residue_mappings.P2[iP2].grp1);
            if( j1R0<mR0 )continue;
            if( j1R0>nR0 )continue;
            std::string atm1=residue_mappings.P2[iP2].atm1;
            int j1P1=iatom(j1R0,atm1);
            if( j1P1==-1 )continue;
            if( P1[j1P1].sub==0 )continue;
            reg.A2.push_back( Regularization_Target::tA2());
            reg.o_A2N2A1.push_back( vv.P1A1(j0P1));
            reg.o_A2N2A1.push_back( vv.P1A1(j1P1));
            if      ( CTERMINAL&&OXYGEN ){
               reg.A2[reg.nA2++].dst= residue_mappings.P2[jP2].dst;
            }else if( PORIBOSE&&C5PRIM  ){
               reg.A2[reg.nA2++].dst= residue_mappings.P2[kP2].dst;
               reg.A3.push_back( Regularization_Target::tA3());
               reg.o_A3N3A1.push_back( vv.P1A1(j0P1));
               reg.o_A3N3A1.push_back( vv.P1A1(j1P1));
               std::string atm2=" P  ";
               int j2P1=iatom(j1R0,atm2);
               reg.o_A3N3A1.push_back( vv.P1A1(j2P1));
               reg.A3[reg.nA3++].lam= residue_mappings.P2[kP2].lam;
            }else{
               reg.A2[reg.nA2++].dst= residue_mappings.P2[iP2].dst;
            }
            if( iP2<(mP2+2) )continue;
            int j2R0=(iR0+residue_mappings.P2[iP2].grp2);
            if( j2R0<mR0 )continue;
            if( j2R0>nR0 )continue;
            std::string atm2=residue_mappings.P2[iP2].atm2;
            int j2P1=iatom(j2R0,atm2);
            if( j2P1==-1 )continue;
            if( P1[j2P1].sub==0 )continue;
            reg.A3.push_back( Regularization_Target::tA3());
            reg.o_A3N3A1.push_back( vv.P1A1(j0P1));
            reg.o_A3N3A1.push_back( vv.P1A1(j1P1));
            reg.o_A3N3A1.push_back( vv.P1A1(j2P1));
            if( CTERMINAL&&OXYGEN ){
               reg.A3[reg.nA3++].lam= residue_mappings.P2[jP2].lam;
            }else{
               if( (atm==" C3'")||
                   (atm==" O3'") ){
                  reg.A3[reg.nA3  ].RIGID=true;
               }
               reg.A3[reg.nA3++].lam= residue_mappings.P2[iP2].lam;
            }
            if( iP2<(mP2+3) )continue;
            int j3R0=(iR0+residue_mappings.P2[iP2].grp3);
            if( j3R0<mR0 )continue;
            if( j3R0>nR0 )continue;
            std::string atm3=residue_mappings.P2[iP2].atm3;
            int j3P1=iatom(j3R0,atm3);
            if( j3P1==-1 )continue;
            if( P1[j3P1].sub==0 )continue;
            if( residue_mappings.P2[iP2].chi<(999.) ){
               reg.A4.push_back( Regularization_Target::tA4());
               reg.o_A4N4A1.push_back( vv.P1A1(j0P1));
               reg.o_A4N4A1.push_back( vv.P1A1(j1P1));
               reg.o_A4N4A1.push_back( vv.P1A1(j2P1));
               reg.o_A4N4A1.push_back( vv.P1A1(j3P1));
               reg.A4[reg.nA4++].chi= residue_mappings.P2[iP2].chi;
            }
         }
//
//
// add target function elements for cycle closure
//
         if      ( aa=="PRO " ){
// P1
//[  ] N
//[ 1] CA
//[ 2] HA
//[ 3] C
//[ 4] O
//[ 5] CB
//[ 6]1HB
//[ 7]2HB
//[ 8] CG
//[ 9]1HG
//[10]2HG
//[11] CD
//[12]1HD
//[13]2HD
// CD--N    1.460
            if( (P1[mP1+11].sub==1)&&
                (P1[mP1   ].sub==1) ){
               reg.A2.push_back( Regularization_Target::tA2());
               reg.o_A2N2A1.push_back( vv.P1A1(mP1+11));
               reg.o_A2N2A1.push_back( vv.P1A1(mP1   ));
               reg.A2[reg.nA2++].dst= (1.460);
            }
// CG--CD--N    104.7
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 8));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+11));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1   ));
//          reg.A3[reg.nA3++].lam= (104.70);
// CD--N---CA   113.0
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+11));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1   ));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 1));
//          reg.A3[reg.nA3++].lam= (113.00);
// CD--N---C---CA   180.0
//          if( iR0>mR0 ){
//             int kP1=iatom((iR0-1)," C  ");
//             if( (kP1>-1)&&(P1[kP1].sub==1) ){
//                reg.A4.push_back( Regularization_Target::tA4());
//                reg.o_A4N4A1.push_back( vv.P1A1(mP1+11));
//                reg.o_A4N4A1.push_back( vv.P1A1(mP1   ));
//                reg.o_A4N4A1.push_back( vv.P1A1(kP1   ));
//                reg.o_A4N4A1.push_back( vv.P1A1(mP1+ 1));
//                reg.A4[reg.nA4++].chi= (180.00);
//             }
//          }
         }else if( aa=="D   " ){
// P1
//[  ] C5'
//[ 1]1H5'
//[ 2]2H5'
//[ 3] C4'
//[ 4] H4'
//[ 5] O4'
//[ 6] C3'
//[ 7] H3'
//[ 8] C2'
//[ 9]1H2'
//[10]2H2'
//[11] C1'
//[12] H1'
// O4'-C1'  1.420
//          reg.A2.push_back( Regularization_Target::tA2());
//          reg.o_A2N2A1.push_back( vv.P1A1(mP1+11));
//          reg.o_A2N2A1.push_back( vv.P1A1(mP1+ 5));
//          reg.A2[reg.nA2++].dst= (1.420);
// C4'-O4'-C1'  110.1
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+11));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 5));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 3));
//          reg.A3[reg.nA3++].lam= (110.10);
// O4'-C1'-C2'  105.9
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 8));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+11));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 5));
//          reg.A3[reg.nA3++].lam= (105.90);
         }else if( aa=="R   " ){
// P1
//[  ] C5'
//[ 1]1H5'
//[ 2]2H5'
//[ 3] C4'
//[ 4] H4'
//[ 5] O4'
//[ 6] C3'
//[ 7] H3'
//[ 8] C2'
//[ 9] H2'
//[10] O2'
//[11] HO2
//[12] C1'
//[13] H1'
//
// O4'-C1'  1.412
//          reg.A2.push_back( Regularization_Target::tA2());
//          reg.o_A2N2A1.push_back( vv.P1A1(mP1+12));
//          reg.o_A2N2A1.push_back( vv.P1A1(mP1+ 5));
//          reg.A2[reg.nA2++].dst= (1.412);
// C4'-O4'-C1'  109.9
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+12));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 5));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 3));
//          reg.A3[reg.nA3++].lam= (109.90);
// O4'-C1'-C2'  107.6
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 8));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+12));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 5));
//          reg.A3[reg.nA3++].lam= (107.60);
         }else if( aa=="RME " ){
// P1
//[  ] C5'
//[ 1]1H5'
//[ 2]2H5'
//[ 3] C4'
//[ 4] H4'
//[ 5] O4'
//[ 6] C3'
//[ 7] H3'
//[ 8] C2'
//[ 9] H2'
//[10] O2'
//[11] CM'
//[12]1HM'
//[13]2HM'
//[14]3HM'
//[15] C1'
//[16] H1'
// O4'-C1'  1.412
//          reg.A2.push_back( Regularization_Target::tA2());
//          reg.o_A2N2A1.push_back( vv.P1A1(mP1+15));
//          reg.o_A2N2A1.push_back( vv.P1A1(mP1+ 5));
//          reg.A2[reg.nA2++].dst= (1.412);
// C4'-O4'-C1'  109.9
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+15));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 5));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 3));
//          reg.A3[reg.nA3++].lam= (109.90);
// O4'-C1'-C2'  107.6
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 8));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+15));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 5));
//          reg.A3[reg.nA3++].lam= (107.60);
         }else if( aa=="RF  " ){
// P1
//[  ] C5'
//[ 1]1H5'
//[ 2]2H5'
//[ 3] C4'
//[ 4] H4'
//[ 5] O4'
//[ 6] C3'
//[ 7] H3'
//[ 8] C2'
//[ 9] H2'
//[10] F2'
//[11] C1'
//[12] H1'
// O4'-C1'  1.412
//          reg.A2.push_back( Regularization_Target::tA2());
//          reg.o_A2N2A1.push_back( vv.P1A1(mP1+11));
//          reg.o_A2N2A1.push_back( vv.P1A1(mP1+ 5));
//          reg.A2[reg.nA2++].dst= (1.412);
// C4'-O4'-C1'  109.9
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+11));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 5));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 3));
//          reg.A3[reg.nA3++].lam= (109.90);
// O4'-C1'-C2'  107.6
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 8));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+11));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 5));
//          reg.A3[reg.nA3++].lam= (107.60);
         }else if( aa=="MOE " ){
// P1
//[  ] C5'
//[ 1]1H5'
//[ 2]2H5'
//[ 3] C4'
//[ 4] H4'
//[ 5] O4'
//[ 6] C3'
//[ 7] H3'
//[ 8] C2'
//[ 9] H2'
//[10] O2'
//[11] CA'
//[12]1HA'
//[13]2HA'
//[14] CB'
//[15]1HB'
//[16]2HB'
//[17] OC'
//[18] CD'
//[19]1HD'
//[20]2HD'
//[21]3HD'
//[22] C1'
//[23] H1'
// O4'-C1'  1.412
            reg.o_A2N2A1.push_back( vv.P1A1(mP1+22));
            reg.o_A2N2A1.push_back( vv.P1A1(mP1+ 5));
            reg.A2.push_back( Regularization_Target::tA2());
            reg.A2[reg.nA2++].dst= (1.412);
// C4'-O4'-C1'  109.9
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+22));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 5));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 3));
//          reg.A3[reg.nA3++].lam= (109.90);
// O4'-C1'-C2'  107.6
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 8));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+22));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 5));
//          reg.A3[reg.nA3++].lam= (107.60);
         }else if( aa=="LNA " ){
// P1
//[  ] C5'
//[ 1]1H5'
//[ 2]2H5'
//[ 3] C4'
//[ 4] O4'
//[ 5] C3'
//[ 6] H3'
//[ 7] C2'
//[ 8] H2'
//[ 9] O2'
//[10] C6'
//[11]1H6'
//[12]2H6'
//[13] C1'
//[14] H1'
// O4'-C1'  1.424
//          reg.A2.push_back( Regularization_Target::tA2());
//          reg.o_A2N2A1.push_back( vv.P1A1(mP1+13));
//          reg.o_A2N2A1.push_back( vv.P1A1(mP1+ 4));
//          reg.A2[reg.nA2++].dst= (1.424);
// C4'-O4'-C1'
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+13));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 4));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 3));
//          reg.A3[reg.nA3++].lam= (106.90);
// O4'-C1'-C2'
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 7));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+13));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 4));
//          reg.A3[reg.nA3++].lam= (102.89);
// C6'-C4'  1.522
//          reg.A2.push_back( Regularization_Target::tA2());
//          reg.o_A2N2A1.push_back( vv.P1A1(mP1+10));
//          reg.o_A2N2A1.push_back( vv.P1A1(mP1+ 3));
//          reg.A2[reg.nA2++].dst= (1.522);
// C6'-C4'-C3'
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+10));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 3));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 5));
//          reg.A3[reg.nA3++].lam= (103.41);
// C6'-C4'-O4'
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+10));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 3));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 4));
//          reg.A3[reg.nA3++].lam= (104.97);
// O2'-C6'-C4'
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 9));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+10));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 3));
//          reg.A3[reg.nA3++].lam= (101.28);
         }else if( aa=="CET " ){
// P1
//[  ] C5'
//[ 1]1H5'
//[ 2]2H5'
//[ 3] C4'
//[ 4] O4'
//[ 5] C3'
//[ 6] H3'
//[ 7] C2'
//[ 8] H2'
//[ 9] O2'
//[10] C6'
//[11] H6'
//[12] C7'
//[13]1H7'
//[14]2H7'
//[15]3H7'
//[16] C1'
//[17] H1'
// O4'-C1'  1.424
//          reg.A2.push_back( Regularization_Target::tA2());
//          reg.o_A2N2A1.push_back( vv.P1A1(mP1+16));
//          reg.o_A2N2A1.push_back( vv.P1A1(mP1+ 4));
//          reg.A2[reg.nA2++].dst= (1.424);
// C4'-O4'-C1'
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+16));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 4));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 3));
//          reg.A3[reg.nA3++].lam= (106.90);
// O4'-C1'-C2'
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 7));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+16));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 4));
//          reg.A3[reg.nA3++].lam= (102.89);
// C6'-C4'  1.522
//          reg.A2.push_back( Regularization_Target::tA2());
//          reg.o_A2N2A1.push_back( vv.P1A1(mP1+10));
//          reg.o_A2N2A1.push_back( vv.P1A1(mP1+ 3));
//          reg.A2[reg.nA2++].dst= (1.522);
// C6'-C4'-C3'
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+10));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 3));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 5));
//          reg.A3[reg.nA3++].lam= (103.41);
// C6'-C4'-O4'
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+10));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 3));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 4));
//          reg.A3[reg.nA3++].lam= (104.97);
// O2'-C6'-C4'
//          reg.A3.push_back( Regularization_Target::tA3());
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 9));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+10));
//          reg.o_A3N3A1.push_back( vv.P1A1(mP1+ 3));
//          reg.A3[reg.nA3++].lam= (101.28);
         }
      }
   }
//
//
// harmonic coeffs
//
   reg.coa= (6.25);
   reg.cob= (1.00e+4);
   reg.coc= (6.85)/std::pow(physics_consts.RAD,2);
   reg.cod= (5.14)/std::pow(physics_consts.RAD,2);

   for(int i=0;i<3;i++){
      for(int j=0;j<3;j++){
         for(int k=0;k<3;k++){
            reg.feps(i,j,k)= (0.00);
         }
      }
   }
   reg.feps(0,1,2)=( 1.00);
   reg.feps(0,2,1)=(-1.00);
   reg.feps(1,2,0)=( 1.00);
   reg.feps(1,0,2)=(-1.00);
   reg.feps(2,0,1)=( 1.00);
   reg.feps(2,1,0)=(-1.00);
//
//
// minimize target function
//
   int oU2=(3*oA8);
   Energy_Surface5 ene(oU2);
   int oM2=128;
   Local_Minimization5 loc(oM2,nK1);
   for(int iK1= 0;iK1<nK1;iK1++){
      loc.K1BETA(iK1)= (1.00e-02);
   }
   double zBMIN= (1.00e-06);
   double zBMAX= (1.00e-01);
   loc.BDEL= (2.00e-01);
   double zEPS1= (1.00e-06);
   loc.EPS2= (1.00e-02);

   for(int iA1= 0;iA1<reg.nA1;iA1++){
      reg.A1[iA1].U2=-1;
   }

   for(int nCYC=8;nCYC>0;nCYC--){
      for(reg.iK1=0;reg.iK1<nK1;reg.iK1++){
         ene.nU2= 0;
         int nA8=vv.K1[reg.iK1].nA8;
         for(int iA8= 0;iA8<nA8;iA8++){
            int iA1=vv.K1[reg.iK1].A8[iA8].A1;
            for(int i=0;i<3;i++){
               ene.U2chi(ene.nU2+i)= reg.A1[iA1].x(i);
            }
            reg.A1[iA1].U2=ene.nU2;
            ene.nU2+=3;
         }

         loc.EPS1= ene.nU2*std::pow(zEPS1,2);
         loc.BETA= std::sqrt( ene.nU2)*loc.K1BETA(reg.iK1);
         loc.BMIN= std::sqrt( ene.nU2)*zBMIN;
         loc.BMAX= std::sqrt( ene.nU2)*zBMAX;
         loc.nM2=(oM2-1);
         loc.MOV(physics_consts,out,ene,reg);
         loc.WRT(out,ene,reg);

         ene.nU2= 0;
         nA8=vv.K1[reg.iK1].nA8;
         for(int iA8= 0;iA8<nA8;iA8++){
            int iA1=vv.K1[reg.iK1].A8[iA8].A1;
            for(int i=0;i<3;i++){
               reg.A1[iA1].x(i)= ene.U2chi(ene.nU2+i);
            }
            reg.A1[iA1].U2=-1;
            ene.nU2+=3;
         }
      }
   }
//
//
// rms deviation
//
   double rmsd= (0.00);
   for(int iA1= 0;iA1<reg.nA1;iA1++){
      rmsd+=( reg.A1[iA1].x -reg.A1[iA1].y).rr();
   }
   rmsd= std::sqrt( rmsd/reg.nA1);
   if( out.VERBOSE&&false ){
      out.FILE3<< std::fixed<< std::setprecision(3);
      out.FILE3<<" heavy atom RMSD of regularized structure="
               << std::setw( 8)<<rmsd<<'\n';
   }
//
//
// update structure
//
   int iA1=-1;
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            if( P1[iP1].typ< 8 )continue;
            iA1++;
            P1[iP1].x= reg.A1[iA1].x;
         }
      }
   }
//
//
// complete first residue of peptide chains
//
   Rotation_Matrix P;
   Coordinates x;
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      if( Z0[iZ0].cR0== 1 )continue;
      int mR0=Z0[iZ0].R0a;
      std::string aa=R0[mR0].aa;
      if( (aa[0]!='e')&&(aa[0]!='z') )continue;
      aa=aa.substr(1,3)+' ';
      int iL0=residue_mappings.iresidue( aa);
      int i0P1=iatom(mR0  ," N  ");
      int i1P1=iatom(mR0  ," CA ");
      int i2P1=iatom(mR0  ," C  ");
      int i3P1=iatom(mR0  ," O  ");
      if( P1[i2P1].sub==0 )continue;
      if( P1[i3P1].sub==0 )continue;
      int j0P1=iatom(mR0+1," N  ");
      if( P1[j0P1].sub==0 )continue;
      if( P1[i1P1].sub==0 ){
         Coordinates zU=( P1[i2P1].x -P1[j0P1].x);
         zU.normalize();
         Coordinates zV=( P1[i3P1].x -P1[j0P1].x);
         double zVU= dot(zV,zU);
         zV-=zVU*zU;
         zV.normalize();
         Coordinates zW= cross(zU,zV);
         P(0,0)= zU(0);
         P(1,0)= zU(1);
         P(2,0)= zU(2);
         P(0,1)= zV(0);
         P(1,1)= zV(1);
         P(2,1)= zV(2);
         P(0,2)= zW(0);
         P(1,2)= zW(1);
         P(2,2)= zW(2);
         double D= (1.522);
         double the=( (180.00) -(116.70))*physics_consts.RAD;
         double CT= std::cos( the);
         double ST= std::sin( the);
         double phi= ( 180.00)*physics_consts.RAD;
         double CP= std::cos( phi);
         double SP= std::sin( phi);
         x(0)= D*CT;
         x(1)= D*ST*CP;
         x(2)= D*ST*SP;
         P1[i1P1].sub=1;
         P1[i1P1].x.generate(P1[i2P1].x,P,x);
      }
      if( P1[i0P1].sub==0 ){
         Coordinates zU=( P1[i1P1].x -P1[i2P1].x);
         zU.normalize();
         Coordinates zV=( P1[j0P1].x -P1[i2P1].x);
         double zVU= dot(zV,zU);
         zV-=zVU*zU;
         zV.normalize();
         Coordinates zW= cross(zU,zV);
         P(0,0)= zU(0);
         P(1,0)= zU(1);
         P(2,0)= zU(2);
         P(0,1)= zV(0);
         P(1,1)= zV(1);
         P(2,1)= zV(2);
         P(0,2)= zW(0);
         P(1,2)= zW(1);
         P(2,2)= zW(2);
         double D= (1.449);
         int iP2=residue_mappings.ip2atom(iL0," C  ");
         double the=( (180.00) -residue_mappings.P2[iP2].lam)
                   *physics_consts.RAD;
         double CT= std::cos( the);
         double ST= std::sin( the);
         double phi= (150.00)*physics_consts.RAD;
         double CP= std::cos( phi);
         double SP= std::sin( phi);
         x(0)= D*CT;
         x(1)= D*ST*CP;
         x(2)= D*ST*SP;
         P1[i0P1].sub=1;
         P1[i0P1].x.generate(P1[i1P1].x,P,x);
      }
   }
   return;
}
