#ifndef DEF_REGULARIZATION_TARGET
#define DEF_REGULARIZATION_TARGET

#include "../phi/Coordinates.hh"
#include <vector>

class Regularization_Target {
public:
   class tA1 { /*physical atoms in system of molecules*/
   public:
      Coordinates y;            //target position (angstrom)
      Coordinates x;            //position (angstrom)
      int U2;                   //mapping to degree of freedom
      tA1(){}
   };
   class tA2 { /*bond lengths in system of molecules*/
   public:
      double dst;               //target bond length (angstrom)
      tA2(){}
   };
   class tA3 { /*bond angles in system of molecules*/
   public:
      double lam;               //target bond angle (degree)
      bool RIGID;               //constrain backbone conf
      tA3():RIGID(false){}
   };
   class tA4 { /*torsion angles in system of molecules*/
   public:
      double chi;               //target torsion angle (degree)
      tA4(){}
   };

private:
   std::vector<double> o_feps;  //coeffs for 3d determinant

public:
   std::vector<int> o_A2N2A1;   //mapping pair to physical atoms
   std::vector<int> o_A3N3A1;   //mapping 3-tuple to physical atoms
   std::vector<int> o_A4N4A1;   //mapping 4-tuple to physical atoms
   int nA1;                     //number
   std::vector<tA1> A1;         //set of physical atoms
   int nA2;                     //number
   std::vector<tA2> A2;         //set of bond lengths
   int nA3;                     //number
   std::vector<tA3> A3;         //set of bond angles
   int nA4;                     //number
   std::vector<tA4> A4;         //set of torsion angles
   /*harmonic coeffs for deviations from target values*/
   double coa;                  //atom coordinates
   double cob;                  //bond lengths
   double coc;                  //bond angles
   double cod;                  //torsion angles
   int iK1;                     //index into subsets of degs of free

   int& A2N2A1(int i,int j){
      return o_A2N2A1.at( i*2 +j);
   }
   int& A3N3A1(int i,int j){
      return o_A3N3A1.at( i*3 +j);
   }
   int& A4N4A1(int i,int j){
      return o_A4N4A1.at( i*4 +j);
   }
   const int& A2N2A1(int i,int j) const {
      return o_A2N2A1.at( i*2 +j);
   }
   const int& A3N3A1(int i,int j) const {
      return o_A3N3A1.at( i*3 +j);
   }
   const int& A4N4A1(int i,int j) const {
      return o_A4N4A1.at( i*4 +j);
   }
   double& feps(int i,int j,int k){
      return o_feps.at( i*9 +j*3 +k);
   }
   const double& feps(int i,int j,int k) const {
      return o_feps.at( i*9 +j*3 +k);
   }

   Regularization_Target():
      o_feps(3*3*3)
   {
   }
};

#endif
