#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Gaussian_Volume.hh"
#include "../phi/Phi_Automatic.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include <cstdlib>
#include <iomanip>
#include <cmath>

void Energy_Surface2::QFAC(Phi_Automatic& aut,
                           const DAT_PHYSICS_CONSTS& physics_consts,
                           Output_Streams& out,
                           const Mechanical_System& mol,
                           const Subset_Contracted_System::tM3& con,
                           Conf_Dependent_System& dep){
//
//
// cartesian coords of current conf
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
//
      Coordinates TRANS;
      double alp,bet,gam;
      if( !con.Z0[iZ0].sub ){
         TRANS=dep.Z0[iZ0].trans;
         alp= dep.Z0[iZ0].rot(0);
         bet= dep.Z0[iZ0].rot(1);
         gam= dep.Z0[iZ0].rot(2);
      }else{
         int iU2=Z0[iZ0].U2a;
         TRANS(0)= U2chi(iU2  );
         TRANS(1)= U2chi(iU2+1);
         TRANS(2)= U2chi(iU2+2);
         alp= U2chi(iU2+3);
         bet= U2chi(iU2+4);
         gam= U2chi(iU2+5);
      }
      Rotation_Matrix ROT(alp,bet,gam);
//
      int mB3=con.Z0[iZ0].B3a;
      int nB3=(mB3-1+con.Z0[iZ0].cB3);
      for(int iB3=mB3;iB3<=nB3;iB3++){
         int iF2=con.B3[iB3].F2;
         int iT2=con.F2[iF2].typ;
         if( (iT2== 1)||(iT2== 4)||(iT2== 7)||(iT2>17) )continue;
         aut.F2[iF2].x.generate(TRANS,
                                ROT,
                                dep.F2[iF2].x);
      }
//
      if( nQ2>mQ2 ){
         aut.PR[ 0]= ROT;
         int iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            int br=con.Q2[iQ2].br;
            int cbr=con.Q2[iQ2].cbr;
            aut.PR[br].extend(aut.PR[cbr],
                              dep.Q2[iQ2].tu,
                              U2chi(Q2[iQ2].U2));
            int mG3=con.Q2[iQ2].G3a;
            int nG3=(mG3-1+con.Q2[iQ2].cG3);
            for(int iG3=mG3;iG3<=nG3;iG3++){
               int iF2=con.G3[iG3].F2;
               int iT2=con.F2[iF2].typ;
               if( (iT2== 1)||(iT2== 4)||(iT2== 7)||(iT2>17) )continue;
               aut.F2[iF2].x.generate(aut.F2[con.Q2[iQ2].bseF2].x,
                                      aut.PR[br],
                                      dep.G3[iG3].b);
            }
         }
      }
   }
//
//
// reduction of full chg elec field by dielec medium
//
//// out.FILE3<<std::fixed<<std::setprecision( 4);
   Gaussian_Volume vf;
   {
      double z= physics_consts.ANG*physics_consts.ANG;
      vf.sig=(  2.5191);
      vf.eta=(  0.7745)*z;
   }
   for(int iF2= 0;iF2<oF2;iF2++){
      F2[iF2].fq= (1.00);
      if( con.F2[iF2].zet==0 )continue;
      double RRij=( 0.00);
      double e2=(  0.00);
      for(int i=0;i<4;i++){
         for(int j=0;j<4;j++){
            e2+=eef(physics_consts,
                    con.F2[iF2].ef[i],
                    con.F2[iF2].ef[j],
                    RRij);
         }
      }
      double e3=(  0.00);
      for(int kF2= 0;kF2<oF2;kF2++){
         int kT2=con.F2[kF2].typ;
         if( (kT2< 8)||(kT2>17) )continue;
         if( con.F2[kF2].mu!=1 )continue;
         double RRik=( aut.F2[iF2].x -aut.F2[kF2].x).rr();
         double RRjk= RRik;
         for(int i=0;i<4;i++){
            for(int j=0;j<4;j++){
               e3+=eevf(physics_consts,
                        con.F2[iF2].ef[i],
                        con.F2[iF2].ef[j],
                        vf,
                        RRij,
                        RRik,
                        RRjk);
            }
         }
      }
//// out.FILE3<<" iF2="<<std::setw( 4)<<iF2
////          <<" atm="<<con.F2[iF2].atm
////          <<" iR0="<<std::setw( 3)<<con.F2[iF2].R0
////          <<" e2="<<std::setw( 9)<<e2
////          <<" e3="<<std::setw( 9)<<e3;
      if( e3> e2 )e3= e2;
      double x= (e3/e2);
      double b= std::exp( (1.50)*std::log( ( .375)));
      double a=( (1.00) -b);
      F2[iF2].fq=( a*x +b);
//// out.FILE3<<" (e3/e2)="<<std::setw( 9)<<x
////          <<" fq="<<std::setw( 9)<<F2[iF2].fq<<std::endl;
   }
   return;
}
