#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Gaussian_Volume.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <iomanip>
#include <cmath>

class MEM_phis {
private:
   std::vector<Coordinates> o_F2x;      //atom position
   std::vector<Coordinates> o_B6x;      //position of base centroid
   std::vector<Coordinates> o_G6x;      //position of generated centroid
public:
   MEM_phis(int oF2,int oB6,int oG6):
      o_F2x(oF2),
      o_B6x(oB6),
      o_G6x(oG6)
   {
   }
   Coordinates& F2x(int i){
      return o_F2x.at( i);  }
   Coordinates& B6x(int i){
      return o_B6x.at( i);  }
   Coordinates& G6x(int i){
      return o_G6x.at( i);  }
};

void Energy_Surface4::PHIS(const DAT_PHYSICS_CONSTS& physics_consts,
                           const DAT_RESIDUE_MAPPINGS& residue_mappings,
                           Output_Streams& out,
                           const Mechanical_System& mol,
                           const Subset_Contracted_System::tM3& con,
                           const Conf_Dependent_System& dep){

   MEM_phis vv(oF2,con.oB6,con.oG6);
//
//
// generate atom coordinates
//
   Coordinates TRANS;                           //rigid body translation
   Rotation_Matrix PR[3];                       //generation matrix

   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);

      double alp,bet,gam;
      if( !con.Z0[iZ0].sub ){
         TRANS=dep.Z0[iZ0].trans;
         alp= dep.Z0[iZ0].rot(0);
         bet= dep.Z0[iZ0].rot(1);
         gam= dep.Z0[iZ0].rot(2);
      }else{
         int iU2=Z0[iZ0].U2a;
         TRANS(0)= U2chi(iU2  );
         TRANS(1)= U2chi(iU2+1);
         TRANS(2)= U2chi(iU2+2);
         alp= U2chi(iU2+3);
         bet= U2chi(iU2+4);
         gam= U2chi(iU2+5);
      }
      Rotation_Matrix ROT(alp,bet,gam);

      int mB3=con.Z0[iZ0].B3a;
      int nB3=(mB3-1+con.Z0[iZ0].cB3);
      for(int iB3=mB3;iB3<=nB3;iB3++){
         int iF2=con.B3[iB3].F2;
         int iT2=con.F2[iF2].typ;
         if( (iT2== 7)||(iT2> 17) )continue;
         vv.F2x(iF2).generate(TRANS,
                               ROT,
                               dep.F2[iF2].x);
      }

      if( nQ2>mQ2 ){
         PR[ 0]= ROT;

         int iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            int br=con.Q2[iQ2].br;
            int cbr=con.Q2[iQ2].cbr;
            PR[br].extend(PR[cbr],
                          dep.Q2[iQ2].tu,
                          U2chi(Q2[iQ2].U2));
            int mG3=con.Q2[iQ2].G3a;
            int nG3=(mG3-1+con.Q2[iQ2].cG3);
            for(int iG3=mG3;iG3<=nG3;iG3++){
               int iF2=con.G3[iG3].F2;
               int iT2=con.F2[iF2].typ;
               if( (iT2== 7)||(iT2> 17) )continue;
               vv.F2x(iF2).generate(vv.F2x(con.Q2[iQ2].bseF2),
                                     PR[br],
                                     dep.G3[iG3].b);
            }
         }
      }
   }
//
//
// centroid positions for base and generated residues
//
   for(int iB6= 0;iB6<con.oB6;iB6++){
      int iL0=con.B6[iB6].L0;
      int jF2=con.B6N3F2(iB6,0);
      int iF2=con.B6N3F2(iB6,1);
      int kF2=con.B6N3F2(iB6,2);

      double r= residue_mappings.L0[iL0].dst;
      double the=( physics_consts.PI -residue_mappings.L0[iL0].lam);
      double phi= residue_mappings.L0[iL0].chi;
      double CT= std::cos( the);
      double ST= std::sin( the);
      double CP= std::cos( phi);
      double SP= std::sin( phi);

      Coordinates zU=( vv.F2x(iF2) -vv.F2x(jF2)).normalize();
      Coordinates zV=( vv.F2x(kF2) -vv.F2x(jF2));
      double zVU= dot(zV,zU);
      zV-=(zVU*zU);
      zV.normalize();
      Coordinates zW= cross(zU,zV);

      Rotation_Matrix B;
      B(0,0)= zU(0);
      B(1,0)= zU(1);
      B(2,0)= zU(2);
      B(0,1)= zV(0);
      B(1,1)= zV(1);
      B(2,1)= zV(2);
      B(0,2)= zW(0);
      B(1,2)= zW(1);
      B(2,2)= zW(2);
      Coordinates x;
      x(0)= r*CT;
      x(1)= r*ST*CP;
      x(2)= r*ST*SP;

      vv.B6x(iB6).generate(vv.F2x(iF2),B,x);
   }

   for(int iG6= 0;iG6<con.oG6;iG6++){
      int iL0=con.G6[iG6].L0;
      int jF2=con.G6N3F2(iG6,0);
      int iF2=con.G6N3F2(iG6,1);
      int kF2=con.G6N3F2(iG6,2);

      double r= residue_mappings.L0[iL0].dst;
      double the=( physics_consts.PI -residue_mappings.L0[iL0].lam);
      double phi= residue_mappings.L0[iL0].chi;
      double CT= std::cos( the);
      double ST= std::sin( the);
      double CP= std::cos( phi);
      double SP= std::sin( phi);

      Coordinates zU=( vv.F2x(iF2) -vv.F2x(jF2)).normalize();
      Coordinates zV=( vv.F2x(kF2) -vv.F2x(jF2));
      double zVU= dot(zV,zU);
      zV-=(zVU*zU);
      zV.normalize();
      Coordinates zW= cross(zU,zV);

      Rotation_Matrix B;
      B(0,0)= zU(0);
      B(1,0)= zU(1);
      B(2,0)= zU(2);
      B(0,1)= zV(0);
      B(1,1)= zV(1);
      B(2,1)= zV(2);
      B(0,2)= zW(0);
      B(1,2)= zW(1);
      B(2,2)= zW(2);
      Coordinates x;
      x(0)= r*CT;
      x(1)= r*ST*CP;
      x(2)= r*ST*SP;

      vv.G6x(iG6).generate(vv.F2x(iF2),B,x);
   }
//
//
// calc S3,S4,S5
//
   Fs3= (0.00);
   Fs4= (0.00);
   Fs5= (0.00);

   for(int iG6= 0;iG6<con.oG6;iG6++){
      int iL0=con.G6[iG6].L0;
      for(int jB6= 0;jB6<con.oB6;jB6++){
         int jL0=con.B6[jB6].L0;
         if( B6G6pass(jB6,iG6) )continue;
         double zR=( vv.G6x(iG6) -vv.B6x(jB6)).r();
         if( zR<(12.28) )Fs3+=residue_mappings.L0L0con(jL0,iL0);
      }
   }

   for(int iG6= 0;iG6<(con.oG6-1);iG6++){
      int iL0=con.G6[iG6].L0;
      for(int jG6=(iG6+1);jG6<con.oG6;jG6++){
         int jL0=con.G6[jG6].L0;
         if( G6G6pass(iG6,jG6) )continue;
         double zR=( vv.G6x(jG6) -vv.G6x(iG6)).r();
         if( zR<(12.28) )Fs3+=residue_mappings.L0L0con(iL0,jL0);
      }
   }

   for(int iB6= 0;iB6<con.oB6;iB6++){
      int iL0=con.B6[iB6].L0;
      if( residue_mappings.L0[iL0].pol<2 )continue;
      double sig1= residue_mappings.L0[iL0].gau.sig;
      double eta1= residue_mappings.L0[iL0].gau.eta;
      for(int jB6=iB6;jB6<con.oB6;jB6++){
         int jL0=con.B6[jB6].L0;
         if( residue_mappings.L0[jL0].pol<2 )continue;
         if( B6B6pass(iB6,jB6) )continue;
         double zF=( jB6==iB6 )? (1.): (2.);
         double sig= residue_mappings.L0[jL0].gau.sig;
         double eta= residue_mappings.L0[jL0].gau.eta;
         double eta2=( eta1 +eta);
         double zRR=( vv.B6x(jB6) -vv.B6x(iB6)).rr();
         double zG= (eta1*eta/eta2);
         double sig2a= zF*(4.)*eta1*eta*sig1*sig*std::exp(-zG*zRR);
         double zH= sig2a*( eta1 -eta)/eta2;
         Coordinates x= ((1.00)/eta2)*( eta1*vv.B6x(iB6) +eta*vv.B6x(jB6));
         Coordinates sig2b= zH*( vv.B6x(iB6) -vv.B6x(jB6));
         double sig2c= sig2a*(-zG*zRR/eta2);
         double zZ= (physics_consts.PI/eta2);
         Fs4+=(zZ*std::sqrt( zZ)*( ((1.50)/eta2)*sig2a +sig2c));
         for(int kG6= 0;kG6<con.oG6;kG6++){
            int kL0=con.G6[kG6].L0;
            if( residue_mappings.L0[kL0].pol!=0 )continue;
            sig= residue_mappings.L0[kL0].gau.sig;
            eta= residue_mappings.L0[kL0].gau.eta;
            double eta3=( eta2 +eta);
            Coordinates zD=( vv.G6x(kG6) -x);
            zRR= zD.rr();
            zG= (eta2*eta/eta3);
            double sig3= sig*std::exp(-zG*zRR);
            zH= (eta/eta3);
            zZ= (physics_consts.PI/eta3);
            Fs5+=sig3*zZ*std::sqrt( zZ)*(
                  +sig2a*( ((1.50)/eta3) +(zH*zH)*zRR)
                  +zH*dot(sig2b,zD)
                  +sig2c);
         }
      }
   }

   double zF= (2.00);
   for(int iB6= 0;iB6<con.oB6;iB6++){
      int iL0=con.B6[iB6].L0;
      if( residue_mappings.L0[iL0].pol<2 )continue;
      double sig1= residue_mappings.L0[iL0].gau.sig;
      double eta1= residue_mappings.L0[iL0].gau.eta;
      for(int jG6= 0;jG6<con.oG6;jG6++){
         int jL0=con.G6[jG6].L0;
         if( residue_mappings.L0[jL0].pol<2 )continue;
         if( B6G6pass(iB6,jG6) )continue;
         double sig= residue_mappings.L0[jL0].gau.sig;
         double eta= residue_mappings.L0[jL0].gau.eta;
         double eta2=( eta1 +eta);
         double zRR=( vv.G6x(jG6) -vv.B6x(iB6)).rr();
         double zG= (eta1*eta/eta2);
         double sig2a= zF*(4.)*eta1*eta*sig1*sig*std::exp(-zG*zRR);
         double zH= sig2a*( eta1 -eta)/eta2;
         Coordinates x= ((1.00)/eta2)*( eta1*vv.B6x(iB6) +eta*vv.G6x(jG6));
         Coordinates sig2b= zH*( vv.B6x(iB6) -vv.G6x(jG6));
         double sig2c= sig2a*(-zG*zRR/eta2);
         double zZ= (physics_consts.PI/eta2);
         Fs4+=(zZ*std::sqrt( zZ)*( ((1.50)/eta2)*sig2a +sig2c));
         for(int kB6= 0;kB6<con.oB6;kB6++){
            int kL0=con.B6[kB6].L0;
            if( residue_mappings.L0[kL0].pol!=0 )continue;
            sig= residue_mappings.L0[kL0].gau.sig;
            eta= residue_mappings.L0[kL0].gau.eta;
            double eta3=( eta2 +eta);
            Coordinates zD=( vv.B6x(kB6) -x);
            zRR= zD.rr();
            zG= (eta2*eta/eta3);
            double sig3= sig*std::exp(-zG*zRR);
            zH= (eta/eta3);
            zZ= (physics_consts.PI/eta3);
            Fs5+=sig3*zZ*std::sqrt( zZ)*(
                  +sig2a*( ((1.50)/eta3) +(zH*zH)*zRR)
                  +zH*dot(sig2b,zD)
                  +sig2c);
         }
         for(int kG6= 0;kG6<con.oG6;kG6++){
            int kL0=con.G6[kG6].L0;
            if( residue_mappings.L0[kL0].pol!=0 )continue;
            sig= residue_mappings.L0[kL0].gau.sig;
            eta= residue_mappings.L0[kL0].gau.eta;
            double eta3=( eta2 +eta);
            Coordinates zD=( vv.G6x(kG6) -x);
            zRR= zD.rr();
            zG= (eta2*eta/eta3);
            double sig3= sig*std::exp(-zG*zRR);
            zH= (eta/eta3);
            zZ= (physics_consts.PI/eta3);
            Fs5+=sig3*zZ*std::sqrt( zZ)*(
                  +sig2a*( ((1.50)/eta3) +(zH*zH)*zRR)
                  +zH*dot(sig2b,zD)
                  +sig2c);
         }
      }
   }

   for(int iG6= 0;iG6<con.oG6;iG6++){
      int iL0=con.G6[iG6].L0;
      if( residue_mappings.L0[iL0].pol<2 )continue;
      double sig1= residue_mappings.L0[iL0].gau.sig;
      double eta1= residue_mappings.L0[iL0].gau.eta;
      for(int jG6=iG6;jG6<con.oG6;jG6++){
         int jL0=con.G6[jG6].L0;
         if( residue_mappings.L0[jL0].pol<2 )continue;
         if( G6G6pass(iG6,jG6) )continue;
         zF=( jG6==iG6 )? (1.): (2.);
         double sig= residue_mappings.L0[jL0].gau.sig;
         double eta= residue_mappings.L0[jL0].gau.eta;
         double eta2=( eta1 +eta);
         double zRR=( vv.G6x(jG6) -vv.G6x(iG6)).rr();
         double zG= (eta1*eta/eta2);
         double sig2a= zF*(4.)*eta1*eta*sig1*sig*std::exp(-zG*zRR);
         double zH= sig2a*( eta1 -eta)/eta2;
         Coordinates x= ((1.00)/eta2)*( eta1*vv.G6x(iG6) +eta*vv.G6x(jG6));
         Coordinates sig2b= zH*( vv.G6x(iG6) -vv.G6x(jG6));
         double sig2c= sig2a*(-zG*zRR/eta2);
         double zZ= (physics_consts.PI/eta2);
         Fs4+=(zZ*std::sqrt( zZ)*( ((1.50)/eta2)*sig2a +sig2c));
         for(int kB6= 0;kB6<con.oB6;kB6++){
            int kL0=con.B6[kB6].L0;
            if( residue_mappings.L0[kL0].pol!=0 )continue;
            sig= residue_mappings.L0[kL0].gau.sig;
            eta= residue_mappings.L0[kL0].gau.eta;
            double eta3=( eta2 +eta);
            Coordinates zD=( vv.B6x(kB6) -x);
            zRR= zD.rr();
            zG= (eta2*eta/eta3);
            double sig3= sig*std::exp(-zG*zRR);
            zH= (eta/eta3);
            zZ= (physics_consts.PI/eta3);
            Fs5+=sig3*zZ*std::sqrt( zZ)*(
                  +sig2a*( ((1.50)/eta3) +(zH*zH)*zRR)
                  +zH*dot(sig2b,zD)
                  +sig2c);
         }
         for(int kG6= 0;kG6<con.oG6;kG6++){
            int kL0=con.G6[kG6].L0;
            if( residue_mappings.L0[kL0].pol!=0 )continue;
            sig= residue_mappings.L0[kL0].gau.sig;
            eta= residue_mappings.L0[kL0].gau.eta;
            double eta3=( eta2 +eta);
            Coordinates zD=( vv.G6x(kG6) -x);
            zRR= zD.rr();
            zG= (eta2*eta/eta3);
            double sig3= sig*std::exp(-zG*zRR);
            zH= (eta/eta3);
            zZ= (physics_consts.PI/eta3);
            Fs5+=sig3*zZ*std::sqrt( zZ)*(
                  +sig2a*( ((1.50)/eta3) +(zH*zH)*zRR)
                  +zH*dot(sig2b,zD)
                  +sig2c);
         }
      }
   }
//
//
// diagnostic output
//
   if( out.VERBOSE&&false ){
      out.FILE3<<"   Fs3   ""   Fs4   ""   Fs5   \n";
      out.FILE3<< std::fixed<< std::setprecision( 2);
      out.FILE3<< std::setw( 9)<<Fs3
               << std::setw( 9)<<Fs4
               << std::setw( 9)<<Fs5<<'\n';
   }

   return;
}
