#include "../con/Subset_Contracted_System.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"

void Energy_Surface2::PHIE_T2D(const Subset_Contracted_System::tM3& con,
                               const Conf_Dependent_System& dep,
                               int iZ0){
   int mJ2=con.Z0[iZ0].J2a;
   int nJ2=(mJ2-1+con.Z0[iZ0].cJ2);
   for(int iJ2=mJ2;iJ2<=nJ2;iJ2++){
      int iQ2=dep.J2N2Q2(iJ2, 0);
      int jQ2=dep.J2N2Q2(iJ2, 1);
      if( Q2[iQ2].cut||Q2[jQ2].cut )continue;
      if( Q2[iQ2].pass||Q2[jQ2].pass )continue;
      int iU2=Q2[iQ2].U2;
      int jU2=Q2[jQ2].U2;
      Ft+=dep.J2[iJ2].tau.f(U2chi(iU2),U2chi(jU2));
   }
   int mY2=con.Z0[iZ0].Y2a;
   int nY2=(mY2-1+con.Z0[iZ0].cY2);
   for(int iY2=mY2;iY2<=nY2;iY2++){
      int iQ2=dep.Y2N3Q2(iY2,0);
      int jQ2=dep.Y2N3Q2(iY2,1);
      int kQ2=dep.Y2N3Q2(iY2,2);
      if( Q2[iQ2].cut||Q2[jQ2].cut||Q2[kQ2].cut )continue;
      if( Q2[iQ2].pass||Q2[jQ2].pass||Q2[kQ2].pass )continue;
      int iU2=Q2[iQ2].U2;
      int jU2=Q2[jQ2].U2;
      int kU2=Q2[kQ2].U2;
      Ft+=dep.Y2[iY2].tau.f(U2chi(iU2),U2chi(jU2),U2chi(kU2));
   }
   return;
}
