#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include <cmath>

void Energy_Surface2::PHIE_T1D(const Conf_Dependent_System& dep,
                               int iQ2){
   if( Q2[iQ2].cut )return;
   if( Q2[iQ2].pass )return;
   int iU2=Q2[iQ2].U2;
   Ft+=dep.Q2[iQ2].tau.f(U2chi(iU2));

   if( TETHER ){
      if( U2sub(iU2) ){
         double PI=( 3.141592653589790);
         double CAL=( 627.50955);
         double alph= (512.00)/(CAL*PI*PI);
         alph*=(1.00);
         double z=( U2chi(iU2) -U2ch0(iU2));
         if      ( z<-PI ){
            z+=(2.00)*PI;
         }else if( z> PI ){
            z-=(2.00)*PI;
         }
         Fs+= alph*z*z;
      }
   }
   return;
}
