#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi_Automatic.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <iomanip>

void Energy_Surface2::PHIE_RESTCH(Phi_Automatic& aut,
                                  const DAT_PHYSICS_CONSTS& physics_consts,
                                  const DAT_ARRAY_CONSTS& array_consts,
                                  const DAT_ENERGY_PARAMS& energy_params,
                                  const Thread_Options& opt,
                                  Output_Streams& out,
                                  const Subset_Contracted_System::tM3& con,
                                  const Conf_Dependent_System& dep){
   aut.nR=0;
   aut.nG=0;
   aut.nA=0;
   for(int L=0;L<8;L++){
      Lprof[L]=0;
   }
//
//
// calc Fr+Fe+Fs+Fh
//
   Fr= (0.00);
   Fe= (0.00);
   Fs= (0.00);
   Fh= (0.00);
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      int mE1=con.Z0[iZ0].E1a;
      int iQ2=mQ2;
      int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
      for(int icQ2=(nQ2-mQ2+1);icQ2>0;icQ2--){
         int nE1=(mE1-1+con.Q2[iQ2].cE1);
         if( nE1>=mE1 ){
            for(int iE1=mE1;iE1<=nE1;iE1++){
               if( E1pass(iE1) )continue;
               if( !E1part(iE1) )continue;
               PHIE_E1(aut,
                       physics_consts,array_consts,energy_params,
                       con,
                       iZ0,mQ2,iQ2,iE1);
            }
            mE1+=con.Q2[iQ2].cE1;
         }
         if( con.Q2[iQ2].omg==1 ){
            int L=iQ2hold;
            iQ2hold=(iQ2+1);
            iQ2=L;
         }else{
            iQ2++;
         }
      }
   }
//
//
// calc Ft+Fc+Fb
//
   Ft= (0.00);
   Fc= (0.00);
   Fb= (0.00);
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
//
//
// calc Ft (1D and 2D components)
//
      int iQ2=mQ2;
      int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
      for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
         if( con.Q2[iQ2].omg==1 ){
            int L=iQ2hold;
            iQ2hold=(iQ2+1);
            iQ2=L;
         }else{
            iQ2++;
         }
         PHIE_T1D(dep,iQ2);
      }
      PHIE_T2D(con,dep,iZ0);
//
//
// calc Fc+Fb
//
      if( con.Z0[iZ0].cC1==0 )continue;
      iQ2=mQ2;
      int mC1=con.Z0[iZ0].C1a;
      int mB3=con.Z0[iZ0].B3a;
      int nB3=(mB3-1+con.Z0[iZ0].cB3);
      for(int iB3=mB3;iB3<=nB3;iB3++){
         int iF2=con.B3[iB3].F2;
         int iT2=con.F2[iF2].typ;
         if( (iT2== 7)||(iT2==30)||(iT2== 1)||(iT2== 4) )continue;
         int nC1=(mC1-1+con.B3[iB3].cC1);
         if( nC1>=mC1 ){
            for(int iC1=mC1;iC1<=nC1;iC1++){
//             int jZ0=con.C1[iC1].Z0;
               int kQ2=con.C1[iC1].k;
               if( Q2[iQ2].cut||Q2[kQ2].cut )continue;
               int lam=con.C1[iC1].lam;
               int jF2=con.C1[iC1].F2a;
               if      ( lam==0 ){
               }else if( lam==1 ){
                  jF2=con.H2[jF2].F2;
               }else if( lam==2 ){
                  jF2=con.G3[jF2].F2;
               }else if( lam==3 ){
                  jF2=con.B3[jF2].F2;
               }
               PHIE_C(aut,
                      energy_params,
                      opt,con,
                      jF2,iC1,iF2);
            }
            mC1+=con.B3[iB3].cC1;
         }
      }
      if( nQ2>mQ2 ){
         int iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            int mG3=con.Q2[iQ2].G3a;
            int nG3=(mG3-1+con.Q2[iQ2].cG3);
            for(int iG3=mG3;iG3<=nG3;iG3++){
               int iF2=con.G3[iG3].F2;
               int iT2=con.F2[iF2].typ;
               if( (iT2== 7)||(iT2==30)||(iT2== 1)||(iT2== 4) )continue;
               int nC1=(mC1-1+con.G3[iG3].cC1);
               if( nC1>=mC1 ){
                  for(int iC1=mC1;iC1<=nC1;iC1++){
//                   int jZ0=con.C1[iC1].Z0;
                     int kQ2=con.C1[iC1].k;
                     if( Q2[iQ2].cut||Q2[kQ2].cut )continue;
                     int lam=con.C1[iC1].lam;
                     int jF2=con.C1[iC1].F2a;
                     if      ( lam==0 ){
                     }else if( lam==1 ){
                        jF2=con.H2[jF2].F2;
                     }else if( lam==2 ){
                        jF2=con.G3[jF2].F2;
                     }else if( lam==3 ){
                        jF2=con.B3[jF2].F2;
                     }
                     PHIE_C(aut,
                            energy_params,
                            opt,con,
                            jF2,iC1,iF2);
                  }
                  mC1+=con.G3[iG3].cC1;
               }
            }
         }
      }
   }
// if( out.VERBOSE ){
//    out.FILE3<< std::fixed<< std::setprecision(3);
//    out.FILE3<<"       Fr   "
//             <<"       Fe   "
//             <<"       Fs   "
//             <<"       Ft   "
//             <<"       Fc   "
//             <<"       Fb   "
//             <<"       Fh   "<<'\n';
//    out.FILE3<< std::setw(12)<<(Fr*physics_consts.CAL)
//             << std::setw(12)<<(Fe*physics_consts.CAL)
//             << std::setw(12)<<(Fs*physics_consts.CAL)
//             << std::setw(12)<<(Ft*physics_consts.CAL)
//             << std::setw(12)<<(Fc*physics_consts.CAL)
//             << std::setw(12)<<(Fb*physics_consts.CAL)
//             << std::setw(12)<<(Fh*physics_consts.CAL)<<'\n';
//    out.FILE3<<"    nR  "
//             <<"    nG  "
//             <<"    nA  "<<'\n';
//    out.FILE3<< std::setw( 8)<<aut.nR
//             << std::setw( 8)<<aut.nG
//             << std::setw( 8)<<aut.nA<<'\n';
// }
   return;
}
