#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Gaussian_Volume.hh"
#include "../phi/Phi_Automatic.hh"
#include <cmath>

void Energy_Surface2::PHIE_RESH(Phi_Automatic& aut,
                                const DAT_PHYSICS_CONSTS& physics_consts,
                                const DAT_ARRAY_CONSTS& array_consts,
                                const DAT_ENERGY_PARAMS& energy_params,
                                const Subset_Contracted_System::tM3& con,
                                int jF2,
                                int jZ0,
                                int iE1,
                                int iF2,
                                int i_3,
                                int iQ2,
                                int iZ0,
                                bool EPASS){
//
//
// calc Fr, Fe, Fs, Fh
//
   int iT2=con.F2[iF2].typ;
   if( iT2==30 )return;
   int jT2=con.F2[jF2].typ;
   if( jT2==30 )return;
   int iHB=con.F2[iF2].hb;
   int jHB=con.F2[jF2].hb;
//
//
// patch (iT2,jT2) (iHB,jHB)
//
   if      ( (jHB==1)&&(iHB==2) ){
      if      ( (con.F2[jF2].atm==" H  ")&&
                (con.F2[iF2].atm==" O  ") ){
         if( con.F2[jF2].R0==(con.F2[iF2].R0+ 2) ){
            jT2= 1;
            jHB=3;
         }
      }else if( (con.F2[jF2].atm==" HG ")&&
                (con.F2[iF2].atm==" O  ") ){
         if( con.F2[jF2].R0==(con.F2[iF2].R0+ 1) ){
            jT2= 1;
            jHB=3;
         }
      }
   }else if( (jHB==2)&&(iHB==1) ){
      if      ( (con.F2[jF2].atm==" O  ")&&
                (con.F2[iF2].atm==" H  ") ){
         if( con.F2[iF2].R0==(con.F2[jF2].R0+ 2) ){
            iT2= 1;
            iHB=3;
         }
      }else if( (con.F2[jF2].atm==" O  ")&&
                (con.F2[iF2].atm==" HG ") ){
         if( con.F2[iF2].R0==(con.F2[jF2].R0+ 1) ){
            iT2= 1;
            iHB=3;
         }
      }
   }
   int LTE1=con.F2[jF2].lte;
   int LTE2=con.F2[iF2].lte;
   bool atomatom=(LTE1>=0)&&(LTE2>=0);
   int n1=con.F2[jF2].mu;
   int n2=con.F2[iF2].mu;
   bool sitesite=(n1>0)&&(n2>0);
   int iS3=-1;

   if( atomatom ){
      if( con.E1[iE1].sse==1 ){
         int i=( con.F2[jF2].sf&  7);
         int k=(con.F2[jF2].sf-i);
         if( iQ2>con.Z0[iZ0].Q2a ){
            int j=( con.G3[i_3].sg&  7);
            if( (con.G3[i_3].sg-j)==k )iS3=energy_params.S2S2S3(i,j);
         }else{
            int j=( con.B3[i_3].sb&  7);
            if( (con.B3[i_3].sb-j)==k )iS3=energy_params.S2S2S3(i,j);
         }
         if( iS3==-2 )return;
      }
      aut.x=( aut.F2[iF2].x -aut.F2[jF2].x);
      aut.RR= aut.x.rr();
   }else if( sitesite ){
      if( jZ0==iZ0 ){
         for(int i1= 0;i1<n1;i1++){
            for(int i2= 0;i2<n2;i2++){
               if( con.F2[iF2].fac[i2]==con.F2[jF2].fac[i1] )return;
            }
         }
      }
      aut.x=( aut.F2[iF2].x -aut.F2[jF2].x);
      aut.RR= aut.x.rr();
      if( aut.RR>(576.00) )return;
   }else{
      return;
   }

   aut.R= std::sqrt( aut.RR);
   if( aut.R<(1.00e-12) )aut.R= (1.00e-12);

   if( atomatom ){
//
//
// calc Fr
//
      if( (iS3<=0)&&(jF2!=con.F2[iF2].lnk) ){
         double EPS= energy_params.T2T2e(iT2,jT2);
         double RHO= energy_params.T2T2r(iT2,jT2);
         double ZZ= (aut.R/RHO);
         double alp= energy_params.T2T2a(iT2,jT2);

         double FF  =( (1.00) +alp)
                    /( ZZ +alp);
         double GG  = (1.12)
                    /( std::pow(ZZ,7) +(.12));

         Fr+=EPS*(
             std::pow(FF,7)*( GG -(2.00))
                  );

         if( (jHB&iHB)==0 ){
            aut.QQ.populate(1);
            double ZZZ= std::sqrt( (2.00));
            int dT2,aT2;
            if( (iT2== 2)||(iT2== 5) ){
               dT2=(iT2-1);
               aT2=jT2;
               aut.QQ.populate(1,aut.F2[iF2].q);
               double u0= aut.QQ.r(1,-1)*ZZZ;
               double u1=-aut.QQ.i(1,-1)*ZZZ;
               double u2= aut.QQ.r(1, 0);
               double z= (-1.00)/std::sqrt( u0*u0 +u1*u1 +u2*u2);
               aut.QQ*=z;
            }else{
               dT2=(jT2-1);
               aT2=iT2;
               aut.QQ.populate(1,aut.F2[jF2].q);
               double u0= aut.QQ.r(1,-1)*ZZZ;
               double u1=-aut.QQ.i(1,-1)*ZZZ;
               double u2= aut.QQ.r(1, 0);
               double z= ( 1.00)/std::sqrt( u0*u0 +u1*u1 +u2*u2);
               aut.QQ*=z;
            }

            aut.ZZ= (1.00)/aut.R;
            aut.CT= (aut.x(2)*aut.ZZ);
            aut.ST= std::sqrt( (1.00) -aut.CT*aut.CT);
            if( aut.ST>(1.00e-12) ){
               aut.CP= (aut.x(0)*aut.ZZ)/aut.ST;
               aut.SP= (aut.x(1)*aut.ZZ)/aut.ST;
            }else{
               aut.CP= (1.00);
               aut.SP= (0.00);
            }
            aut.H.populate(array_consts,1,
                           aut.CT,aut.ST,aut.CP,aut.SP);

            double C= (0.00);
            for(int M=-1;M<=1;M++){
               double F_r=( aut.QQ.r(1,M)*aut.H.r(1,M)
                           -aut.QQ.i(1,M)*aut.H.i(1,M));
//             double F_i=( aut.QQ.r(1,M)*aut.H.i(1,M)
//                         +aut.QQ.i(1,M)*aut.H.r(1,M));
               C+=F_r;
            }

            double G=-EPS*(std::pow(FF,7)*( GG -(2.00)));

            EPS= energy_params.T2T2e(dT2,aT2);
            RHO= energy_params.T2T2r(dT2,aT2);
            ZZ= (aut.R/RHO);
            alp= energy_params.T2T2a(dT2,aT2);
            FF  =( (1.00) +alp)
                /( ZZ +alp);
            GG  = (1.12)
                /( std::pow(ZZ,7) +(.12));
            G+=EPS*(
               std::pow(FF,7)*( GG -(2.00)));

            double F=( (1.00) -C*C*C*C);
            Fr+=F*G;

            if( con.F2[jF2].ion||con.F2[iF2].ion ){
               EPS= energy_params.T2T2e(dT2,aT2)*(  .32);
               RHO= energy_params.T2T2r(dT2,aT2);
               ZZ= (aut.R/RHO);
               alp= energy_params.T2T2a(dT2,aT2);
      
               FF  =( (1.00) +alp)
                   /( ZZ +alp);
               GG  = (1.12)
                   /( std::pow(ZZ,7) +(.12));
      
               Fr+=EPS*(
                   std::pow(FF,7)*( GG -(2.00))
                        );
            }
         }
      }
//
//
// calc Fs
//
      if( iS3>=0 ){
         double a0= energy_params.S3[iS3].a;
         double r0= energy_params.S3[iS3].r;
         Fs+=a0*std::pow(( aut.R -r0),2);
         if( iS3==2 ){
            double Es= std::pow( (1.00)/(aut.R*physics_consts.ANG), 9);
            Fs+=Es;
         }
      }
//
//
// calc Fh
//
      if( sitesite ){
         if( aut.R<(24.00) ){
            double F1= array_consts.SGN(n1+n2-1);
            double F2= pairf(physics_consts,
                             con.F2[jF2].gau,con.F2[iF2].gau,
                             aut.RR);
            Fh+=(F1*F2);
         }
      }
//
//
// calc Fe
//
      if( !EPASS ){
         aut.ZZ= (1.00)/aut.R;
         aut.CT= (aut.x(2)*aut.ZZ);
         aut.ST= std::sqrt( (1.00) -aut.CT*aut.CT);
         if( aut.ST>(1.00e-12) ){
            aut.CP= (aut.x(0)*aut.ZZ)/aut.ST;
            aut.SP= (aut.x(1)*aut.ZZ)/aut.ST;
         }else{
            aut.CP= (1.00);
            aut.SP= (0.00);
         }
         int LTE=PHI_L(aut.R,(3.20),energy_params.LTE);
         PHIE_ME(aut,
                 array_consts,
                 aut.F2[jF2].q,LTE1,aut.F2[iF2].q,LTE2,LTE);
      }

   }else if( sitesite ){
      if( aut.R<(24.00) ){
         double F1= array_consts.SGN(n1+n2-1);
         double F2= pairf(physics_consts,
                          con.F2[jF2].gau,con.F2[iF2].gau,
                          aut.RR);
         Fh+=(F1*F2);
      }
   }

   return;
}
