#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Gaussian_Volume.hh"
#include "../phi/Phi_Automatic.hh"
#include "../str/Output_Streams.hh"
#include <iomanip>
#include <cmath>

void Energy_Surface2::PHIE_PWM(Phi_Automatic& aut,
                               const DAT_PHYSICS_CONSTS& physics_consts,
                               Output_Streams& out,
                               const Subset_Contracted_System::tM3& con){
//
//
// calc Fw
//
   Fw= (0.00);
   if( QMEDIUM ){
      int oDOT=aut.DOT.size();
      for(int iDOT= 0;iDOT<oDOT;iDOT++){
         int iF2=aut.DOT[iDOT].F2;
         if( con.F2[iF2].typ!=30 )continue;
         double x=( con.F2[iF2].u(1)*aut.F2[iF2].v -con.F2[iF2].u(2));
         double y= con.F2[iF2].u(0)*( (-1.00) +std::tanh( x));
         Fw+=y;
     }
   }
//
//
// gaussian approx of Fm
//
   Fp_e= (0.00);
   for(int iF2= 0;iF2<oF2;iF2++){
      if( con.F2[iF2].zet==0 )continue;
      for(int jF2=iF2;jF2<oF2;jF2++){
         if( con.F2[jF2].zet==0 )continue;
         double z=(( jF2==iF2 )? (1.00): (2.00))
                 *F2[iF2].fq*F2[jF2].fq;
         double RRij=( aut.F2[iF2].x -aut.F2[jF2].x).rr();
         double ee= (0.00);
         for(int i=0;i<4;i++){
            for(int j=0;j<4;j++){
               ee+=eef(physics_consts,
                       con.F2[iF2].ef[i],
                       con.F2[jF2].ef[j],
                       RRij);
            }
         }
         Fp_e+=(fac_m2*z*ee);
         for(int kF2= 0;kF2<oF2;kF2++){
            if( con.F2[kF2].kap==0 )continue;
            double RRik=( aut.F2[iF2].x -aut.F2[kF2].x).rr();
            double RRjk=( aut.F2[jF2].x -aut.F2[kF2].x).rr();
            double eev= (0.00);
            for(int i=0;i<4;i++){
               for(int j=0;j<4;j++){
                  eev+=eevf(physics_consts,
                            con.F2[iF2].ef[i],
                            con.F2[jF2].ef[j],
                            con.F2[kF2].vf,
                            RRij,
                            RRik,
                            RRjk);
               }
            }
            Fp_e+=(fac_m3*z*eev);
         }
      }
   }
//
//
// func +patch of 2nd deriv
//
   Fp_a= (0.00);
   Fp_b= (0.00);
   Fp_c= (0.00);
   Fp_d= (0.00);
   for(int iR0= 0;iR0<oR0;iR0++){
      for(int jR0= 0;jR0<oR0;jR0++){
         if( !R0R0(iR0,jR0).b )continue;
         double e= R0R0(iR0,jR0).e;
         double C= R0R0(iR0,jR0).C;
         double B= R0R0(iR0,jR0).B;
         double D= R0R0(iR0,jR0).D;
         Fp_a+=e;
         Fp_b+=e*( .50)*B;
         Fp_c+=e*( .50)*C;
         Fp_d+=e*D;
      }
   }
   for(int iF2F2= 0;iF2F2<oF2F2;iF2F2++){
      if( !F2F2(iF2F2).b )continue;
      double e= F2F2(iF2F2).e;
      double C= F2F2(iF2F2).C;
      double B= F2F2(iF2F2).B;
      double D= F2F2(iF2F2).D;
      Fp_a+=e;
      Fp_b+=e*( .50)*B;
      Fp_c+=e*( .50)*C;
      Fp_d+=e*D;
   }
   Fp=( Fp_a +Fp_b +Fp_c +Fp_d +Fp_e);
   TOT=( Fr +Fe +Fs +Ft +Fc +Fb +Fh +Fp +Fw);
   if( QMEDIUM ){
   }else{
      TOT-=Fw;
   }
// if( out.VERBOSE ){
//    out.FILE3<< std::fixed<< std::setprecision(3);
//    out.FILE3<<"       Fp   "
//             <<"       Fw   "
//             <<"       Fp_a "
//             <<"       Fp_b "
//             <<"       Fp_c "
//             <<"       Fp_d "
//             <<"       Fp_e "<<'\n';
//    out.FILE3<< std::setw(12)<<(Fp*physics_consts.CAL)
//             << std::setw(12)<<(Fw*physics_consts.CAL)
//             << std::setw(12)<<(Fp_a*physics_consts.CAL)
//             << std::setw(12)<<(Fp_b*physics_consts.CAL)
//             << std::setw(12)<<(Fp_c*physics_consts.CAL)
//             << std::setw(12)<<(Fp_d*physics_consts.CAL)
//             << std::setw(12)<<(Fp_e*physics_consts.CAL)<<'\n';
// }
   return;
}
