#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Multipoles.hh"
#include "../phi/Phi_Automatic.hh"

void Energy_Surface2::PHIE_ME(Phi_Automatic& aut,
                              const DAT_ARRAY_CONSTS& array_consts,
                              const Multipoles& a1,
                              int LTE1,
                              const Multipoles& a2,
                              int LTE2,
                              int LTE){
//
//
// truncated multipole expansion of electrostatic interaction energy
//
   double Lr[ 9];

   if( LTE1>LTE )LTE1=LTE;
   if( LTE2>LTE )LTE2=LTE;
   int LTEe=(LTE1+LTE2);
   if( LTEe>LTE )LTEe=LTE;
   Lprof[LTEe]++;

   aut.q1.populate(LTE1,a1);
   aut.q2.populate(LTE2,a2);

   aut.QQ.populate(LTEe);
   aut.QQ.product(array_consts,aut.q1,aut.q2);

   if( aut.ZZ>(1.00) )aut.ZZ= (1.00);
   Lr[ 1]= aut.ZZ;
   for(int L=2;L<=(LTEe+1);L++){
      Lr[L  ]= aut.ZZ*Lr[L-1];
   }

   aut.H.populate(array_consts,LTEe,
                  aut.CT,aut.ST,aut.CP,aut.SP);

   for(int L=0;L<=LTEe;L++){
      double F= (0.00);
      for(int M=-L;M<=L;M++){
         double F_r=( aut.QQ.r(L,M)*aut.H.r(L,M)
                     -aut.QQ.i(L,M)*aut.H.i(L,M));
//       double F_i=( aut.QQ.r(L,M)*aut.H.i(L,M)
//                   +aut.QQ.i(L,M)*aut.H.r(L,M));
         F+=F_r;
      }
      Fe+=Lr[L+1]*F;
   }
   return;
}
