#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi_Automatic.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <iomanip>
#include <cmath>

void Energy_Surface2::PHIE_GP(Phi_Automatic& aut,
                              const DAT_PHYSICS_CONSTS& physics_consts,
                              const DAT_REGION_MAPS& region_maps,
                              Output_Streams& out,
                              const Mechanical_System& mol,
                              const Subset_Contracted_System::tM3& con,
                              const Conf_Dependent_System& dep){
//
// Fg, disallow regions
// attributed to entropic reduction~ -kT*4*ln( 2) independent of fac_pp
//
// out.FILE3<<std::fixed<<std::setprecision( 4);
   Fg= (0.00);
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char c1=mol.R0[iR0].c1;
         if( c1!='a' )continue;
         std::string aa=mol.R0[iR0].aa;
         if( (aa[0]=='e')||(aa[0]=='z') )continue;
         if( (aa[3]=='e')||(aa[3]=='z') )continue;
//
         double phi(   0.00),psi(   0.00);
         int iU2=con.R0[iR0].U2phi;
         if( iU2>-1 ){
            phi= U2chi(iU2)/physics_consts.RAD;
         }else{
            int iQ1=con.R0[iR0].Q1phi;
            if( iQ1>-1 ){
               phi= dep.Q1[iQ1].chi/physics_consts.RAD;
            }
         }
         int jU2=con.R0[iR0].U2psi;
         if( jU2>-1 ){
            psi= U2chi(jU2)/physics_consts.RAD;
         }else{
            int jQ1=con.R0[iR0].Q1psi;
            if( jQ1>-1 ){
               psi= dep.Q1[jQ1].chi/physics_consts.RAD;
            }
         }
//
         std::string cnf0("  "),cnf1("  ");
         if( phi>(0.00) ){
            phi=-phi;
            psi=-psi;
            cnf0[1]='*';
            cnf1[1]='*';
         }
         int iH4=1 +int( phi +(180.00))/10;
         int jH4=1 +int( psi +(180.00))/10;
         int iI0=( aa=="GLY " )? region_maps.H4H4gly(iH4,jH4):
                                 region_maps.H4H4ala(iH4,jH4);
         cnf0[0]=region_maps.I0alp(iI0);
         cnf1[0]=region_maps.I0bet(iI0);
//
         std::string cnf=cnf0;
         if( (aa=="SER ")&&(cnf=="A*") ){
//          out.FILE3<<" SER(A*), iR0="
//                   <<std::setw( 3)<<(iR0+ 1)
//                   <<" (phi,psi)=("<<std::setw( 9)<<(-phi)<<','
//                                   <<std::setw( 9)<<(-psi)<<')'
//                   <<" (iH4,jH4)=("<<std::setw( 2)<<iH4<<','
//                                   <<std::setw( 2)<<jH4<<')'
//                   <<'\n';
            Fg+=( 0.82);
         }
         if( (aa=="CYS ")&&(cnf=="A*") ){
//          out.FILE3<<" CYS(A*), iR0="
//                   <<std::setw( 3)<<(iR0+ 1)
//                   <<" (phi,psi)=("<<std::setw( 9)<<(-phi)<<','
//                                   <<std::setw( 9)<<(-psi)<<')'
//                   <<" (iH4,jH4)=("<<std::setw( 2)<<iH4<<','
//                                   <<std::setw( 2)<<jH4<<')'
//                   <<'\n';
            Fg+=( 1.64);
         }
         cnf=cnf1;
         if( aa=="GLY " ){
            if( cnf[0]=='G' )Fg+=( 1.64);
            if( cnf[0]=='X' )Fg+=( 1.64);
//          if( (cnf[0]=='G')||(cnf[0]=='X') ){
//             out.FILE3<<' '<<aa.substr(0,3)<<'('<<cnf[0]<<"), iR0="
//                      <<std::setw( 3)<<(iR0+ 1)
//                      <<" (phi,psi)=("<<std::setw( 9)<<(-phi)<<','
//                                      <<std::setw( 9)<<(-psi)<<')'
//                      <<" (iH4,jH4)=("<<std::setw( 2)<<iH4<<','
//                                      <<std::setw( 2)<<jH4<<')'
//                      <<'\n';
//          }
         }else{
            if( cnf=="G " )Fg+=( 1.64);
            if( cnf=="X " )Fg+=( 1.64);
//          if( (cnf[0]=='G')||(cnf[0]=='X') ){
//             out.FILE3<<' '<<aa.substr(0,3)<<'('<<cnf[0]<<"), iR0="
//                      <<std::setw( 3)<<(iR0+ 1)
//                      <<" (phi,psi)=("<<std::setw( 9)<<(-phi)<<','
//                                      <<std::setw( 9)<<(-psi)<<')'
//                      <<" (iH4,jH4)=("<<std::setw( 2)<<iH4<<','
//                                      <<std::setw( 2)<<jH4<<')'
//                      <<'\n';
//          }
         }
//       if( cnf[0]=='C' ){
//          if( R0R0(iR0   ,iR0- 1).a ){
//             Fg+=( 0.82);
//          }
//       }
//
      }
   }
//
//
// Fg, peptide-peptide H-bonds outside of helix and sheet
//
   double z= (-1.00)/physics_consts.CAL;
   for(int iR0= 0;iR0<oR0;iR0++){
      for(int jR0= 0;jR0<oR0;jR0++){
         if( std::abs( jR0-iR0)<2 )continue;
         if( R0R0(iR0,jR0).e>z )continue;
         bool LINK=true;
// helix, turn
         if      ( jR0==(iR0- 4) ){ //C-terminal cap of helix
            LINK=false;
         }else if( jR0==(iR0- 3) ){ //4-13 helix
            LINK=false;
         }else if( jR0==(iR0- 2) ){ //3-10 helix
            LINK=false;
         }
// sheet antiparallel
         if      ( ((iR0+ 1)<oR0)&&((jR0- 1)> -1)&&
                   (R0R0(jR0- 1,iR0+ 1).e<z) ){
            LINK=false;
         }else if( ((iR0- 1)> -1)&&((jR0+ 1)<oR0)&&
                   (R0R0(jR0+ 1,iR0- 1).e<z) ){
            LINK=false;
         }else if( ((iR0+ 2)<oR0)&&((jR0- 2)> -1)&&
                   (R0R0(iR0+ 2,jR0- 2).e<z) ){
            LINK=false;
         }
// sheet parallel
         if      ( ((iR0- 1)> -1)&&((jR0- 1)> -1)&&
                   (R0R0(jR0- 1,iR0- 1).e<z) ){
            LINK=false;
         }else if( ((iR0+ 1)<oR0)&&((jR0+ 1)<oR0)&&
                   (R0R0(jR0+ 1,iR0+ 1).e<z) ){
            LINK=false;
         }
//
         if( LINK ){
//          out.FILE3<<" peptide-peptide H-bond"
//                   " outside helix or sheet, (iR0,jR0)=("
//                   <<std::setw( 3)<<(iR0+ 2)
//                   <<std::setw( 3)<<(jR0+ 1)<<')'
//                   <<'\n';
            Fg+=( 6.40);
         }
      }
   }
//
//
// Fg, multiple H-bonds to a single donor or acceptor
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<nR0;iR0++){
         char ci=mol.R0[iR0].c1;
         if( (ci!='a')&&(ci!='e') )continue;
         int iF2=con.R0N6F2(iR0+1, 3);
         if( iF2==-1 )continue;
         int n( 0);
         double g( -9.99);
         for(int jZ0= 0;jZ0<oZ0;jZ0++){
            int aR0=mol.Z0[jZ0].R0a;
            int bR0=(aR0-1+mol.Z0[jZ0].cR0);
            for(int jR0=aR0;jR0<bR0;jR0++){
               char cj=mol.R0[jR0].c1;
               if( (cj!='a')&&(cj!='e') )continue;
               if( std::abs( jR0-iR0)<2 )continue;
               if( R0R0(iR0,jR0).a ){
                  n++;
                  double e= R0R0(iR0,jR0).e*physics_consts.CAL;
                  if( e> g )g= e;
               }
            }
         }
         int iD=F2[iF2].D;
         for(int jA= 0;jA<oA;jA++){
            int ijF2F2=DAF2F2(iD,jA);
            if( ijF2F2==-1 )continue;
            if( F2F2(ijF2F2).a ){
               n++;
               double e= F2F2(ijF2F2).e*physics_consts.CAL;
               if( e> g )g= e;
            }
         }
         if( n>1 ){
//          out.FILE3<<" multiple H-bonds to peptide H, iR0="
//                   <<std::setw( 3)<<(iR0+ 2)
//                   <<" n="<<std::setw( 2)<<n
//                   <<" g="<<std::setw( 8)<<g
//                   <<'\n';
            Fg+=(( 2.40)*double(n-1));
         }
      }
   }
   for(int jZ0= 0;jZ0<oZ0;jZ0++){
      int mR0=mol.Z0[jZ0].R0a;
      int nR0=(mR0-1+mol.Z0[jZ0].cR0);
      for(int jR0=mR0;jR0<nR0;jR0++){
         char cj=mol.R0[jR0].c1;
         if( (cj!='a')&&(cj!='e') )continue;
         int jF2=con.R0N6F2(jR0  , 5);
         int n( 0);
         double g( -9.99);
         for(int iZ0= 0;iZ0<oZ0;iZ0++){
            int aR0=mol.Z0[iZ0].R0a;
            int bR0=(aR0-1+mol.Z0[iZ0].cR0);
            for(int iR0=aR0;iR0<bR0;iR0++){
               char ci=mol.R0[iR0].c1;
               if( (ci!='a')&&(ci!='e') )continue;
               if( std::abs( jR0-iR0)<2 )continue;
               int iF2=con.R0N6F2(iR0+1, 3);
               if( iF2==-1 )continue;
               if( R0R0(iR0,jR0).a ){
                  n++;
                  double e= R0R0(iR0,jR0).e*physics_consts.CAL;
                  if( e> g )g= e;
               }
            }
         }
         int jA=F2[jF2].A;
         for(int iD= 0;iD<oD;iD++){
            int ijF2F2=DAF2F2(iD,jA);
            if( ijF2F2==-1 )continue;
            if( F2F2(ijF2F2).a ){
               n++;
               double e= F2F2(ijF2F2).e*physics_consts.CAL;
               if( e> g )g= e;
            }
         }
         if( n>1 ){
//          out.FILE3<<" multiple H-bonds to peptide O, jR0="
//                   <<std::setw( 3)<<(jR0+ 1)
//                   <<" n="<<std::setw( 2)<<n
//                   <<" g="<<std::setw( 8)<<g
//                   <<'\n';
            Fg+=(( 1.25)*double(n-1));
         }
      }
   }
//
//
// helix, disfavor 3-10 and 5-16
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=(mR0+ 2);iR0<(nR0- 2);iR0++){
         int jR0=(iR0- 2);
         int kR0=(iR0+ 2);
         if( !R0R0(iR0,jR0).a )continue;
         if( !R0R0(kR0,jR0).a )continue;
//       out.FILE3<<" bifurcated acceptor 3-10 and 5-16, (iR0,jR0)=("
//                <<std::setw( 3)<<(iR0+ 2)
//                <<std::setw( 3)<<(jR0+ 1)<<')'
//                <<" and (kR0,jR0)=("
//                <<std::setw( 3)<<(kR0+ 2)
//                <<std::setw( 3)<<(jR0+ 1)<<')'
//                <<'\n';
         if( mol.R0[kR0].aa=="GLY " ){
            Fg+=( 4.50);
         }else{
            Fg+=( 6.00);
         }
      }
   }
//
//
// helix, disfavor consecutive 5-16
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=(mR0+ 4);iR0<(nR0- 1);iR0++){
         int jR0=(iR0- 4);
         int kR0=(iR0+ 1);
         int lR0=(jR0+ 1);
         if( !R0R0(iR0,jR0).a )continue;
         if( !R0R0(kR0,lR0).a )continue;
//       out.FILE3<<" consecutive 5-16 H-bonds, (iR0,jR0)=("
//                <<std::setw( 3)<<(iR0+ 2)
//                <<std::setw( 3)<<(jR0+ 1)<<')'
//                <<std::setw( 8)<<(R0R0(iR0,jR0).e*physics_consts.CAL)
//                <<" (kR0,lR0)=("
//                <<std::setw( 3)<<(kR0+ 2)
//                <<std::setw( 3)<<(lR0+ 1)<<')'
//                <<std::setw( 8)<<(R0R0(kR0,lR0).e*physics_consts.CAL)
//                <<'\n';
         Fg+=( 4.00);
      }
   }
//
//
// helix, disfavor consecutive 4-13, 5-16
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=(mR0+ 3);iR0<(nR0- 2);iR0++){
         int jR0=(iR0- 3);
         int kR0=(iR0+ 2);
         int lR0=(jR0+ 1);
         if( !R0R0(iR0,jR0).a )continue;
         if( !R0R0(kR0,lR0).a )continue;
         if( (R0R0(kR0- 1,lR0).a)&&
             (mol.R0[kR0].aa=="GLY ") ){
         }else{
//          out.FILE3<<" consecutive 4-13, 5-16 H-bonds, (iR0,jR0)=("
//                   <<std::setw( 3)<<(iR0+ 2)
//                   <<std::setw( 3)<<(jR0+ 1)<<')'
//                   <<std::setw( 8)<<(R0R0(iR0,jR0).e*physics_consts.CAL)
//                   <<" (kR0,lR0)=("
//                   <<std::setw( 3)<<(kR0+ 2)
//                   <<std::setw( 3)<<(lR0+ 1)<<')'
//                   <<std::setw( 8)<<(R0R0(kR0,lR0).e*physics_consts.CAL)
//                   <<'\n';
            Fg+=( 2.50);
         }
      }
   }
   TOT+=Fg;
//
//
// diagnostic output
//
// out.FILE3<< std::fixed<< std::setprecision( 2);
// out.FILE3<<"   Fg  "<<'\n';
// out.FILE3<< std::setw( 7)<<Fg<<'\n';
   return;
}
