#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi_Automatic.hh"
#include <cmath>

void Energy_Surface2::PHIE_E1(Phi_Automatic& aut,
                              const DAT_PHYSICS_CONSTS& physics_consts,
                              const DAT_ARRAY_CONSTS& array_consts,
                              const DAT_ENERGY_PARAMS& energy_params,
                              const Subset_Contracted_System::tM3& con,
                              int iZ0,
                              int mQ2,
                              int iQ2,
                              int iE1){
   int iQ3=con.E1[iE1].Q3;
   int mQ1=con.Q3[iQ3].Q1a;
   int nQ1=(mQ1-1+con.Q3[iQ3].cQ1);
   int jZ0=con.E1[iE1].Z0;
// int kQ2=con.E1[iE1].k;
   int lam=con.E1[iE1].lam;
   if      ( lam==0 ){
      bool EPASS=false;
      int jX1=con.E1[iE1].X2;
      int aF2=con.X1[jX1].F2a;
      int bF2=(aF2-1+con.X1[jX1].cF2);
      for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
         int iQ1=con.Q1[pQ1].ord;
         int mG3=con.Q1[iQ1].G3a;
         int nG3=(mG3-1+con.Q1[iQ1].cG3);
         for(int iG3=mG3;iG3<=nG3;iG3++){
            int iF2=con.G3[iG3].F2;
            for(int jF2=aF2;jF2<=bF2;jF2++){
               PHIE_RESH(aut,
                         physics_consts,array_consts,energy_params,
                         con,
                         jF2,jZ0,iE1,iF2,iG3,iQ2,iZ0,EPASS);
               aut.nA++;
            }
         }
      }

   }else if( lam==1 ){
      bool EPASS=false;
      int jU1=con.E1[iE1].X2;
      int aH2=con.U1[jU1].H2a;
      int bH2=(aH2-1+con.U1[jU1].cH2);
      for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
         int iQ1=con.Q1[pQ1].ord;
         int mG3=con.Q1[iQ1].G3a;
         int nG3=(mG3-1+con.Q1[iQ1].cG3);
         for(int iG3=mG3;iG3<=nG3;iG3++){
            int iF2=con.G3[iG3].F2;
            for(int jH2=aH2;jH2<=bH2;jH2++){
               int jF2=con.H2[jH2].F2;
               PHIE_RESH(aut,
                         physics_consts,array_consts,energy_params,
                         con,
                         jF2,jZ0,iE1,iF2,iG3,iQ2,iZ0,EPASS);
               aut.nA++;
            }
         }
      }

   }else if( (lam==2)||(lam==3) ){
      bool EPASS=false;
      int jQ1=con.E1[iE1].X2;
      int a_3=con.Q1[jQ1].G3a;
      int b_3=(a_3-1+con.Q1[jQ1].cG3);
      for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
         int iQ1=con.Q1[pQ1].ord;
         int mG3=con.Q1[iQ1].G3a;
         int nG3=(mG3-1+con.Q1[iQ1].cG3);
         for(int iG3=mG3;iG3<=nG3;iG3++){
            int iF2=con.G3[iG3].F2;
            for(int j_3=a_3;j_3<=b_3;j_3++){
               int jF2=( lam==3 )? con.B3[j_3].F2:
                                   con.G3[j_3].F2;
               PHIE_RESH(aut,
                         physics_consts,array_consts,energy_params,
                         con,
                         jF2,jZ0,iE1,iF2,iG3,iQ2,iZ0,EPASS);
               aut.nA++;
            }
         }
      }

   }else if( lam==4 ){
      int jX2=con.E1[iE1].X2;
      aut.x=( aut.Q3[iQ3].x -aut.X2[jX2].x);
      aut.RR= aut.x.rr();
      aut.R= std::sqrt( aut.RR);
      double d=( aut.Q3[iQ3].r>=aut.X2[jX2].r )? aut.Q3[iQ3].r:
                                                 aut.X2[jX2].r;
      int LTEe=PHI_L(aut.R,d, 8);
      bool GRPGRP=false;
      if( LTEe<8 ){
         GRPGRP=true;
         PHIE_E(aut,array_consts,
                aut.X2[jX2].q,
                aut.Q3[iQ3].q,
                LTEe);
         aut.nR++;
      }
      int aX1=con.X2[jX2].X1a;
      int bX1=(aX1-1+con.X2[jX2].cX1);
      for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
         int iQ1=con.Q1[pQ1].ord;
         int mG3=con.Q1[iQ1].G3a;
         int nG3=(mG3-1+con.Q1[iQ1].cG3);
         for(int pX1=aX1;pX1<=bX1;pX1++){
            int jX1=con.X1[pX1].ord;
            bool EPASS=GRPGRP;
            if( !EPASS ){
               aut.x=( aut.Q1[iQ1].x -aut.X1[jX1].x);
               aut.RR= aut.x.rr();
               aut.R= std::sqrt( aut.RR);
               d=( aut.Q1[iQ1].r>=aut.X1[jX1].r )? aut.Q1[iQ1].r:
                                                   aut.X1[jX1].r;
               LTEe=PHI_L(aut.R,d, 8);
               if( LTEe<8 ){
                  EPASS=true;
                  PHIE_E(aut,array_consts,
                         aut.X1[jX1].q,
                         aut.Q1[iQ1].q,
                         LTEe);
                  aut.nG++;
               }
            }
            int aF2=con.X1[jX1].F2a;
            int bF2=(aF2-1+con.X1[jX1].cF2);
            for(int iG3=mG3;iG3<=nG3;iG3++){
               int iF2=con.G3[iG3].F2;
               for(int jF2=aF2;jF2<=bF2;jF2++){
                  PHIE_RESH(aut,
                            physics_consts,array_consts,energy_params,
                            con,
                            jF2,jZ0,iE1,iF2,iG3,iQ2,iZ0,EPASS);
                  aut.nA++;
               }
            }
         }
      }

   }else if( (lam==6)||(lam==7) ){
      int jQ3=con.E1[iE1].X2;
      aut.x=( aut.Q3[iQ3].x -aut.Q3[jQ3].x);
      aut.RR= aut.x.rr();
      aut.R= std::sqrt( aut.RR);
      double d=( aut.Q3[iQ3].r>=aut.Q3[jQ3].r )? aut.Q3[iQ3].r:
                                                 aut.Q3[jQ3].r;
      int LTEe=PHI_L(aut.R,d, 8);
      bool GRPGRP=false;
      if( LTEe<8 ){
         GRPGRP=true;
         PHIE_E(aut,array_consts,
                aut.Q3[jQ3].q,
                aut.Q3[iQ3].q,
                LTEe);
         aut.nR++;
      }
      int aQ1=con.Q3[jQ3].Q1a;
      int bQ1=(aQ1-1+con.Q3[jQ3].cQ1);
      for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
         int iQ1=con.Q1[pQ1].ord;
         int m_3=con.Q1[iQ1].G3a;
         int n_3=(m_3-1+con.Q1[iQ1].cG3);
         for(int qQ1=aQ1;qQ1<=bQ1;qQ1++){
            int jQ1=con.Q1[qQ1].ord;
            bool EPASS=GRPGRP;
            if( !EPASS ){
               aut.x=( aut.Q1[iQ1].x -aut.Q1[jQ1].x);
               aut.RR= aut.x.rr();
               aut.R= std::sqrt( aut.RR);
               d=( aut.Q1[iQ1].r>=aut.Q1[jQ1].r )? aut.Q1[iQ1].r:
                                                   aut.Q1[jQ1].r;
               LTEe=PHI_L(aut.R,d, 8);
               if( LTEe<8 ){
                  EPASS=true;
                  PHIE_E(aut,array_consts,
                         aut.Q1[jQ1].q,
                         aut.Q1[iQ1].q,
                         LTEe);
                  aut.nG++;
               }
            }
            int a_3=con.Q1[jQ1].G3a;
            int b_3=(a_3-1+con.Q1[jQ1].cG3);
            for(int i_3=m_3;i_3<=n_3;i_3++){
               int iF2=(iQ2==mQ2)? con.B3[i_3].F2:
                                   con.G3[i_3].F2;
               for(int j_3=a_3;j_3<=b_3;j_3++){
                  int jF2=( lam==7 )? con.B3[j_3].F2:
                                      con.G3[j_3].F2;
                  PHIE_RESH(aut,
                            physics_consts,array_consts,energy_params,
                            con,
                            jF2,jZ0,iE1,iF2,i_3,iQ2,iZ0,EPASS);
                  aut.nA++;
               }
            }
         }
      }

   }
   return;
}
