#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Multipoles.hh"
#include "../phi/Phi_Automatic.hh"
#include <cmath>

void Energy_Surface2::PHIE_E(Phi_Automatic& aut,
                             const DAT_ARRAY_CONSTS& array_consts,
                             const Multipoles& a1,
                             const Multipoles& a2,
                             int LTE){
//
//
// calc Fe
//
   if( aut.R<(1.00e-12) )aut.R= (1.00e-12);
   aut.ZZ= (1.00)/aut.R;
   aut.CT= (aut.x(2)*aut.ZZ);
   aut.ST= std::sqrt( (1.00) -aut.CT*aut.CT);
   if( aut.ST>(1.00e-12) ){
      aut.CP= (aut.x(0)*aut.ZZ)/aut.ST;
      aut.SP= (aut.x(1)*aut.ZZ)/aut.ST;
   }else{
      aut.CP= (1.00);
      aut.SP= (0.00);
   }
   int LTE1=a1.order();
   int LTE2=a2.order();
   PHIE_ME(aut,
           array_consts,
           a1,LTE1,a2,LTE2,LTE);
   return;
}
