#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi_Automatic.hh"
#include "../str/Thread_Options.hh"
#include <cmath>

void Energy_Surface2::PHIE_C(Phi_Automatic& aut,
                             const DAT_ENERGY_PARAMS& energy_params,
                             const Thread_Options& opt,
                             const Subset_Contracted_System::tM3& con,
                             int jF2,
                             int iC1,
                             int iF2){
//
//
// calc Fc+Fb
//
   aut.x=( aut.F2[iF2].x -aut.F2[jF2].x);
   aut.R= aut.x.r();
   if( aut.R<(1.00e-12) )aut.R= (1.00e-12);
   double r0= con.C1[iC1].d0;
   double a0;
   if( con.C1[iC1].CYCLE ){
      a0= con.C1[iC1].a0;
      Fb+=a0*std::pow(( aut.R -r0),2);
   }else{
//    int iW0=con.C1[iC1].W0;
      int iW0=opt.iW0_active;
      a0= energy_params.W0a(iW0);
      Fc+=a0*std::pow(( aut.R -r0),2);
   }
   return;
}
