#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi_Automatic.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
//
//
// evaluate Fr+Fe+Fs+Ft+Fc+Fb+Fh+Fp+Fw+Fm
//
void Energy_Surface2::PHIE(Phi_Automatic& aut,
                           const DAT_PHYSICS_CONSTS& physics_consts,
                           const DAT_ARRAY_CONSTS& array_consts,
                           const DAT_ENERGY_PARAMS& energy_params,
                           const DAT_REGION_MAPS& region_maps,
                           const Thread_Options& opt,
                           Output_Streams& out,
                           const Mechanical_System& mol,
                           const Subset_Contracted_System::tM3& con,
                           Conf_Dependent_System& dep){
//
//
// generate coordinates and multipoles for atoms and groups
//
   PHI_XQ(aut,
          array_consts,
          out,mol,con,dep);
//
//
// construct params of Fw
//
   if( (opt.MODE=="bb ")||(opt.MODE=="sc ") ){
   }else{
      PHI_WPAR(aut,
               physics_consts,
               con);
   }
//
//
// assemble peptide-peptide H-bonds, chains of H-bonds, bifurcations
//
   if( (opt.MODE=="bb ")||(opt.MODE=="sc ") ){
   }else{
      PHI_PPAR(aut,
               physics_consts,array_consts,region_maps,
               mol,con,dep);
   }
//
//
// evaluate energy
//
   PHIE_RESTCH(aut,
               physics_consts,array_consts,energy_params,
               opt,out,con,dep);
   if( (opt.MODE=="bb ")||(opt.MODE=="sc ") ){
      Fp= (0.00);
      Fp_a= (0.00);
      Fp_b= (0.00);
      Fp_c= (0.00);
      Fp_d= (0.00);
      Fp_e= (0.00);
      Fw= (0.00);
      TOT=( Fr +Fe +Fs +Ft +Fc +Fb +Fh +Fp +Fw);
   }else{
      PHIE_PWM(aut,
               physics_consts,
               out,con);
   }
   TOT*=(physics_consts.CAL);
   return;
}
//
//
// evaluate Fr+Fe+Fs+Ft+Fc+Fb+Fh+Fp+Fw+Fm +Fg
//
void Energy_Surface2::PHIG(Phi_Automatic& aut,
                           const DAT_PHYSICS_CONSTS& physics_consts,
                           const DAT_ARRAY_CONSTS& array_consts,
                           const DAT_ENERGY_PARAMS& energy_params,
                           const DAT_REGION_MAPS& region_maps,
                           const Thread_Options& opt,
                           Output_Streams& out,
                           const Mechanical_System& mol,
                           const Subset_Contracted_System::tM3& con,
                           Conf_Dependent_System& dep){
   if( QMEDIUM ){
   }else{
      for(int iE1= 0;iE1<oE1;iE1++){
         E1part(iE1, true);
      }
   }
//
//
// generate coordinates and multipoles for atoms and groups
//
   PHI_XQ(aut,
          array_consts,
          out,mol,con,dep);
//
//
// construct params of Fw
//
   if( (opt.MODE=="bb ")||(opt.MODE=="sc ") ){
   }else{
      PHI_WPAR(aut,
               physics_consts,
               con);
   }
//
//
// assemble peptide-peptide H-bonds, chains of H-bonds, bifurcations
//
   if( (opt.MODE=="bb ")||(opt.MODE=="sc ") ){
   }else{
      PHI_PPAR(aut,
               physics_consts,array_consts,region_maps,
               mol,con,dep);
   }
//
//
// evaluate energy
//
   PHIE_RESTCH(aut,
               physics_consts,array_consts,energy_params,
               opt,out,con,dep);
   if( (opt.MODE=="bb ")||(opt.MODE=="sc ") ){
      Fp= (0.00);
      Fp_a= (0.00);
      Fp_b= (0.00);
      Fp_c= (0.00);
      Fp_d= (0.00);
      Fp_e= (0.00);
      Fw= (0.00);
      TOT=( Fr +Fe +Fs +Ft +Fc +Fb +Fh +Fp +Fw);
   }else{
      PHIE_PWM(aut,
               physics_consts,
               out,con);
   }
   TOT*=(physics_consts.CAL);
   if( (opt.MODE=="bb ")||(opt.MODE=="sc ") ){
      Fg= (0.00);
   }else{
      PHIE_GP(aut,
              physics_consts,region_maps,
              out,mol,con,dep);
   }
   return;
}
