#include "../con/Subset_Contracted_System.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi_Automatic.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"

void Energy_Surface4::PHID_X(Phi_Automatic& aut,
                             const Mechanical_System& mol,
                             const Subset_Contracted_System::tM3& con,
                             const Conf_Dependent_System& dep){
   int oZ0=mol.nZ0;

   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);

      double alp,bet,gam;
      if( !con.Z0[iZ0].sub ){
         aut.TRANS=dep.Z0[iZ0].trans;
         alp= dep.Z0[iZ0].rot(0);
         bet= dep.Z0[iZ0].rot(1);
         gam= dep.Z0[iZ0].rot(2);
      }else{
         int iU2=Z0[iZ0].U2a;
         aut.TRANS(0)= U2chi(iU2  );
         aut.TRANS(1)= U2chi(iU2+1);
         aut.TRANS(2)= U2chi(iU2+2);
         alp= U2chi(iU2+3);
         bet= U2chi(iU2+4);
         gam= U2chi(iU2+5);
      }
      Rotation_Matrix ROT(alp,bet,gam);

      if( (!RECYCLE)||con.Z0[iZ0].sub ){
         int mB3=con.Z0[iZ0].B3a;
         int nB3=(mB3-1+con.Z0[iZ0].cB3);
         for(int iB3=mB3;iB3<=nB3;iB3++){
            int iF2=con.B3[iB3].F2;
            aut.F2[iF2].x.generate(aut.TRANS,
                                   ROT,
                                   dep.F2[iF2].x);
         }
      }

      if( nQ2>mQ2 ){
         aut.PR[ 0]= ROT;

         int iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            int br=con.Q2[iQ2].br;
            int cbr=con.Q2[iQ2].cbr;
            aut.PR[br].extend(aut.PR[cbr],
                              dep.Q2[iQ2].tu,
                              U2chi(Q2[iQ2].U2));
            Q2[iQ2].c= aut.PR[br];
            Coordinates c;
            c(0)= Q2[iQ2].c(0,0);
            c(1)= Q2[iQ2].c(1,0);
            c(2)= Q2[iQ2].c(2,0);
            for(int jZ0= 0;jZ0<oZ0;jZ0++){
               Coordinates x=aut.F2[con.Q2[iQ2].bseF2].x;
               if( !con.Z0[jZ0].sub ){
                  x-=dep.Z0[jZ0].trans;
               }else{
                  int jU2=Z0[jZ0].U2a;
                  x(0)-=U2chi(jU2  );
                  x(1)-=U2chi(jU2+1);
                  x(2)-=U2chi(jU2+2);
               }
               Z0Q2y(jZ0,iQ2)= cross(c,x);
            }
            int mG3=con.Q2[iQ2].G3a;
            int nG3=(mG3-1+con.Q2[iQ2].cG3);
            for(int iG3=mG3;iG3<=nG3;iG3++){
               int iF2=con.G3[iG3].F2;
               aut.F2[iF2].x.generate(aut.F2[con.Q2[iQ2].bseF2].x,
                                      aut.PR[br],
                                      dep.G3[iG3].b);
            }
         }
      }

   }
   return;
}
