#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi_Automatic.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Thread_Options.hh"

void Energy_Surface4::PHID(Phi_Automatic& aut,
                           const DAT_PHYSICS_CONSTS& physics_consts,
                           const DAT_ARRAY_CONSTS& array_consts,
                           const DAT_ENERGY_PARAMS& energy_params,
                           const Thread_Options& opt,
                           const Mechanical_System& mol,
                           const Subset_Contracted_System::tM3& con,
                           Conf_Dependent_System& dep){
// for(int iU2= 0;iU2<nU2;iU2++){
//    U2g(iU2)= (0.00);
// }
// for(int iU2= 0;iU2<nU2;iU2++){
//    for(int jU2= 0;jU2<nU2;jU2++){
//       U2U2a(iU2,jU2)= (0.00);
//    }
// }

   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      int iQ2min=con.Z0[iZ0].Q2a;
      int iQ2max=(iQ2min-1+con.Z0[iZ0].cQ2);
      for(int iQ2=iQ2min;iQ2<=iQ2max;iQ2++){
         for(int jZ0= 0;jZ0<mol.nZ0;jZ0++){
            int jQ2min=con.Z0[jZ0].Q2a;
            int jQ2max=(jQ2min-1+con.Z0[jZ0].cQ2);
            for(int jQ2=jQ2min;jQ2<=jQ2max;jQ2++){
               Q2Q2e(iQ2,jQ2).zero();
            }
         }
      }
   }

   PHID_X(aut,
          mol,con,dep);
   PHID_TC(aut,
           physics_consts,array_consts,energy_params,
           opt,mol,con,dep);

   TOT*=(physics_consts.CAL);

   for(int iU2= 0;iU2<nU2;iU2++){
      U2g(iU2)*=(physics_consts.CAL*U2uca(iU2));
   }

   for(int iU2= 0;iU2<nU2;iU2++){
      for(int jU2=iU2;jU2<nU2;jU2++){
         U2U2a(iU2,jU2)*=(physics_consts.CAL*U2uca(iU2)*U2uca(jU2));
      }
   }
   return;
}
