#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi_Automatic.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <iomanip>

class MEM_phi_xq {
private:
   std::vector<bool> o_Q3sub;           //f=recycle group coords and mpoles
   std::vector<bool> o_X2sub;           //f=recycle group coords and mpoles
   std::vector<bool> o_Q2sub;           //f=recycle atom coords and mpoles
public:
   MEM_phi_xq(int oQ3,int oX2,int oQ2):
      o_Q3sub(oQ3,false),
      o_X2sub(oX2,false),
      o_Q2sub(oQ2,false)
   {
   }
   void Q3sub(int i,bool a){
      o_Q3sub[ i]=a;  }
   bool Q3sub(int i){
      return o_Q3sub[ i];  }
   void X2sub(int i,bool a){
      o_X2sub[ i]=a;  }
   bool X2sub(int i){
      return o_X2sub[ i];  }
   void Q2sub(int i,bool a){
      o_Q2sub[ i]=a;  }
   bool Q2sub(int i){
      return o_Q2sub[ i];  }
};

void Energy_Surface2::PHI_XQ(Phi_Automatic& aut,
                             const DAT_ARRAY_CONSTS& array_consts,
                             Output_Streams& out,
                             const Mechanical_System& mol,
                             const Subset_Contracted_System::tM3& con,
                             const Conf_Dependent_System& dep){
   int oQ3=con.oQ3;
   int oX2=con.oX2;
   MEM_phi_xq vv(oQ3,oX2,oQ2);
//
//
// identify groups excluded from recycling
//
   if( RECYCLE ){
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mE1=con.Z0[iZ0].E1a;
         int nE1=(mE1-1+con.Z0[iZ0].cE1);
         for(int iE1=mE1;iE1<=nE1;iE1++){
            if( E1pass(iE1) )continue;
            vv.Q3sub(con.E1[iE1].Q3, true);
            int lam=con.E1[iE1].lam;
            if( lam==4 ){
               vv.X2sub(con.E1[iE1].X2, true);
            }else if( (lam==6)||(lam==7) ){
               vv.Q3sub(con.E1[iE1].X2, true);
            }
         }
      }
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mQ2=con.Z0[iZ0].Q2a;
         int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
         for(int iQ2=mQ2;iQ2<=nQ2;iQ2++){
            int mQ3=con.Q2[iQ2].Q3a;
            int nQ3=(mQ3-1+con.Q2[iQ2].cQ3);
            for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
               if( vv.Q3sub(iQ3) )vv.Q2sub(iQ2, true);
            }
            if( iQ2==mQ2 )continue;
            int mX2=con.Q2[iQ2].X2a;
            int nX2=(mX2-1+con.Q2[iQ2].cX2);
            for(int iX2=mX2;iX2<=nX2;iX2++){
               if( vv.X2sub(iX2) )vv.Q2sub(iQ2, true);
            }
         }
         if( !con.Z0[iZ0].sub ){
            vv.Q2sub(mQ2,false);
            int mQ3=con.Q2[mQ2].Q3a;
            int nQ3=(mQ3-1+con.Q2[mQ2].cQ3);
            for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
               vv.Q3sub(iQ3,false);
            }
            if( nQ2>mQ2 ){
               int jQ2=(mQ2+1);
               if( con.Q2[jQ2].br>0 ){
                  jQ2=nQ2;
                  while( con.Q2[jQ2].cbr>0 ){
                     jQ2=con.Q2[jQ2].jnt;
                  }
                  int mX2=con.Z0[iZ0].X2a;
                  int nX2=(con.Q2[jQ2].X2a-1);
                  for(int iX2=mX2;iX2<=nX2;iX2++){
                     vv.X2sub(iX2,false);
                  }
               }else{
                  int mX2=con.Q2[jQ2].X2a;
                  int nX2=(mX2-1+con.Q2[jQ2].cX2);
                  for(int iX2=mX2;iX2<=nX2;iX2++){
                     vv.X2sub(iX2,false);
                  }
               }
            }
         }
      }
   }
//
//
// generate coordinates and multipoles for atoms and groups
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);

      double alp,bet,gam;
      if( !con.Z0[iZ0].sub ){
         aut.TRANS=dep.Z0[iZ0].trans;
         alp= dep.Z0[iZ0].rot(0);
         bet= dep.Z0[iZ0].rot(1);
         gam= dep.Z0[iZ0].rot(2);
      }else{
         int iU2=Z0[iZ0].U2a;
         aut.TRANS(0)= U2chi(iU2  );
         aut.TRANS(1)= U2chi(iU2+1);
         aut.TRANS(2)= U2chi(iU2+2);
         alp= U2chi(iU2+3);
         bet= U2chi(iU2+4);
         gam= U2chi(iU2+5);
      }
      Rotation_Matrix ROT(alp,bet,gam);
      Q2[mQ2].c=ROT;
      Q2[mQ2].x=aut.TRANS;
      if( RECYCLE&&(!vv.Q2sub(mQ2)) ){
      }else{
         int mB3=con.Z0[iZ0].B3a;
         int nB3=(mB3-1+con.Z0[iZ0].cB3);
         for(int iB3=mB3;iB3<=nB3;iB3++){
            int iF2=con.B3[iB3].F2;
            aut.F2[iF2].x.generate(aut.TRANS,
                                   ROT,
                                   dep.F2[iF2].x);
            aut.F2[iF2].q.rotate(array_consts,
                                 ROT,
                                 dep.F2[iF2].q);
            aut.F2[iF2].p.rotate(array_consts,
                                 ROT,
                                 dep.F2[iF2].p);
            if( !con.F2[iF2].ion )continue;
            if( QMEDIUM ){
               aut.F2[iF2].q.r(0,0)+=( .375)*con.F2[iF2].off;
            }else{
               aut.F2[iF2].q.r(0,0)-=con.F2[iF2].off;
            }
         }
      }
      for(int jZ0= 0;jZ0<iZ0;jZ0++){
         Coordinates t=( Q2[mQ2].x -Q2[con.Z0[jZ0].Q2a].x);
         for(int j=0;j<3;j++){
            Coordinates b=array_consts.dROTx[j]*t;
            for(int i=0;i<3;i++){
               Z0Z0y(jZ0,iZ0)(i,j)= b(i);
            }
         }
      }

      if( nQ2>mQ2 ){
         aut.PR[ 0]=ROT;
         int iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            int br=con.Q2[iQ2].br;
            int cbr=con.Q2[iQ2].cbr;
            aut.PR[br].extend(aut.PR[cbr],
                              dep.Q2[iQ2].tu,
                              U2chi(Q2[iQ2].U2));
            Q2[iQ2].c=aut.PR[br];
            Q2[iQ2].x=aut.F2[con.Q2[iQ2].bseF2].x;
            Coordinates c;
            c(0)= Q2[iQ2].c(0,0);
            c(1)= Q2[iQ2].c(1,0);
            c(2)= Q2[iQ2].c(2,0);
            for(int jZ0= 0;jZ0<oZ0;jZ0++){
               Coordinates x=Q2[iQ2].x;
               if( !con.Z0[jZ0].sub ){
                  x-=dep.Z0[jZ0].trans;
               }else{
                  int jU2=Z0[jZ0].U2a;
                  x(0)-=U2chi(jU2  );
                  x(1)-=U2chi(jU2+1);
                  x(2)-=U2chi(jU2+2);
               }
               Z0Q2y(jZ0,iQ2)=cross(c,x);
            }
            if( RECYCLE&&(!vv.Q2sub(iQ2)) ){
            }else{
               int mG3=con.Q2[iQ2].G3a;
               int nG3=(mG3-1+con.Q2[iQ2].cG3);
               for(int iG3=mG3;iG3<=nG3;iG3++){
                  int iF2=con.G3[iG3].F2;
                  aut.F2[iF2].x.generate(aut.F2[con.Q2[iQ2].bseF2].x,
                                         aut.PR[br],
                                         dep.G3[iG3].b);
                  aut.F2[iF2].q.rotate(array_consts,
                                       aut.PR[br],
                                       dep.F2[iF2].q);
                  aut.F2[iF2].p.rotate(array_consts,
                                       aut.PR[br],
                                       dep.F2[iF2].p);
                  if( !con.F2[iF2].ion )continue;
                  if( QMEDIUM ){
                     aut.F2[iF2].q.r(0,0)+=( .375)*con.F2[iF2].off;
                  }else{
                     aut.F2[iF2].q.r(0,0)-=con.F2[iF2].off;
                  }
               }
            }
         }
      }
      int mQ3=con.Z0[iZ0].Q3a;
      int nQ3=(mQ3-1+con.Z0[iZ0].cQ3);
      int jQ3=(con.Q2[mQ2].Q3a+con.Q2[mQ2].cQ3);
      for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
         if( RECYCLE&&(!vv.Q3sub(iQ3)) )continue;
         if( con.Q3[iQ3].lte<0 )continue;
         int mQ1=con.Q3[iQ3].Q1a;
         int nQ1=(mQ1-1+con.Q3[iQ3].cQ1);
         aut.Q3[iQ3].x.zero();
         double n=0;
         for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
            int iQ1=con.Q1[pQ1].ord;
            int m_3=con.Q1[iQ1].G3a;
            int n_3=(m_3-1+con.Q1[iQ1].cG3);
            for(int i_3=m_3;i_3<=n_3;i_3++){
               int iF2=( iQ3<jQ3 )? con.B3[i_3].F2: con.G3[i_3].F2;
               if( con.F2[iF2].lte<0 )continue;
               aut.Q3[iQ3].x+=aut.F2[iF2].x;
               n++;
            }
         }
         aut.Q3[iQ3].x/=n;
         aut.Q3[iQ3].q.zero();
         aut.Q3[iQ3].r= (3.20);
         for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
            int iQ1=con.Q1[pQ1].ord;
            int m_3=con.Q1[iQ1].G3a;
            int n_3=(m_3-1+con.Q1[iQ1].cG3);
            for(int i_3=m_3;i_3<=n_3;i_3++){
               int iF2=( iQ3<jQ3 )? con.B3[i_3].F2: con.G3[i_3].F2;
               if( con.F2[iF2].lte<0 )continue;
               Coordinates d=( aut.Q3[iQ3].x -aut.F2[iF2].x);
               aut.Q3[iQ3].q.translate(array_consts,d,aut.F2[iF2].q);
               double r= d.r();
               if( ( r +(3.20))>aut.Q3[iQ3].r ){
                  aut.Q3[iQ3].r=( r +(3.20));
               }
            }
         }
      }
      for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
         if( RECYCLE&&(!vv.Q3sub(iQ3)) )continue;
         int mQ1=con.Q3[iQ3].Q1a;
         int nQ1=(mQ1-1+con.Q3[iQ3].cQ1);
         for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
            int iQ1=con.Q1[pQ1].ord;
            if( con.Q1[iQ1].lte<0 )continue;
            int m_3=con.Q1[iQ1].G3a;
            int n_3=(m_3-1+con.Q1[iQ1].cG3);
            aut.Q1[iQ1].x.zero();
            double n=0;
            for(int i_3=m_3;i_3<=n_3;i_3++){
               int iF2=( iQ3<jQ3 )? con.B3[i_3].F2: con.G3[i_3].F2;
               if( con.F2[iF2].lte<0 )continue;
               aut.Q1[iQ1].x+=aut.F2[iF2].x;
               n++;
            }
            aut.Q1[iQ1].x/=n;
            aut.Q1[iQ1].q.zero();
            aut.Q1[iQ1].r= (3.20);
            for(int i_3=m_3;i_3<=n_3;i_3++){
               int iF2=( iQ3<jQ3 )? con.B3[i_3].F2: con.G3[i_3].F2;
               if( con.F2[iF2].lte<0 )continue;
               Coordinates d=( aut.Q1[iQ1].x -aut.F2[iF2].x);
               aut.Q1[iQ1].q.translate(array_consts,d,aut.F2[iF2].q);
               double r= d.r();
               if( ( r +(3.20))>aut.Q1[iQ1].r ){
                  aut.Q1[iQ1].r=( r +(3.20));
               }
            }
         }
      }
      int mX2=con.Z0[iZ0].X2a;
      int nX2=(mX2-1+con.Z0[iZ0].cX2);
      for(int iX2=mX2;iX2<=nX2;iX2++){
         if( RECYCLE&&(!vv.X2sub(iX2)) )continue;
         if( con.X2[iX2].lte<0 )continue;
         int mX1=con.X2[iX2].X1a;
         int nX1=(mX1-1+con.X2[iX2].cX1);
         aut.X2[iX2].x.zero();
         double n= (0.00);
         for(int pX1=mX1;pX1<=nX1;pX1++){
            int iX1=con.X1[pX1].ord;
            int mF2=con.X1[iX1].F2a;
            int nF2=(mF2-1+con.X1[iX1].cF2);
            for(int iF2=mF2;iF2<=nF2;iF2++){
               if( con.F2[iF2].lte<0 )continue;
               aut.X2[iX2].x+=aut.F2[iF2].x;
               n++;
            }
         }
         aut.X2[iX2].x/=n;
         aut.X2[iX2].q.zero();
         aut.X2[iX2].r= (3.20);
         for(int pX1=mX1;pX1<=nX1;pX1++){
            int iX1=con.X1[pX1].ord;
            int mF2=con.X1[iX1].F2a;
            int nF2=(mF2-1+con.X1[iX1].cF2);
            for(int iF2=mF2;iF2<=nF2;iF2++){
               if( con.F2[iF2].lte<0 )continue;
               Coordinates d=( aut.X2[iX2].x -aut.F2[iF2].x);
               aut.X2[iX2].q.translate(array_consts,d,aut.F2[iF2].q);
               double r= d.r();
               if( ( r +(3.20))>aut.X2[iX2].r ){
                  aut.X2[iX2].r=( r +(3.20));
               }
            }
         }
      }
      for(int iX2=mX2;iX2<=nX2;iX2++){
         if( RECYCLE&&(!vv.X2sub(iX2)) )continue;
         int mX1=con.X2[iX2].X1a;
         int nX1=(mX1-1+con.X2[iX2].cX1);
         for(int pX1=mX1;pX1<=nX1;pX1++){
            int iX1=con.X1[pX1].ord;
            if( con.X1[iX1].lte<0 )continue;
            int mF2=con.X1[iX1].F2a;
            int nF2=(mF2-1+con.X1[iX1].cF2);
            aut.X1[iX1].x.zero();
            double n=0;
            for(int iF2=mF2;iF2<=nF2;iF2++){
               if( con.F2[iF2].lte<0 )continue;
               aut.X1[iX1].x+=aut.F2[iF2].x;
               n++;
            }
            aut.X1[iX1].x/=n;
            aut.X1[iX1].q.zero();
            aut.X1[iX1].r= (3.20);
            for(int iF2=mF2;iF2<=nF2;iF2++){
               if( con.F2[iF2].lte<0 )continue;
               Coordinates d=( aut.X1[iX1].x -aut.F2[iF2].x);
               aut.X1[iX1].q.translate(array_consts,d,aut.F2[iF2].q);
               double r= d.r();
               if( ( r +(3.20))>aut.X1[iX1].r ){
                  aut.X1[iX1].r=( r +(3.20));
               }
            }
         }
      }
   }
//
//
// diagnostic output
//
// for(int iZ0= 0;iZ0<oZ0;iZ0++){
//    int mQ1=mol.Z0[iZ0].Q1a;
//    int nQ1=(mQ1-1+mol.Z0[iZ0].cQ1);
//    for(int iQ1=mQ1;iQ1<=nQ1;iQ1++){
//       int Lmax=con.Q1[iQ1].lte;
//       if( Lmax<0 )continue;
//       out.FILE3<<" iQ1="<< std::setw( 5)<<iQ1
//                <<" x="<<aut.Q1[iQ1].x<< std::setprecision(2)
//                <<" r="<< std::setw( 6)<<aut.Q1[iQ1].r
//                <<" lte="<< std::setw( 1)<<Lmax<<'\n';
//       out.FILE3<<aut.Q1[iQ1].q;
//    }
//    int mX1=(mQ1+1);
//    int nX1=nQ1;
//    if( nX1>=mX1 ){
//       for(int iX1=mX1;iX1<=nX1;iX1++){
//          int Lmax=con.X1[iX1].lte;
//          if( Lmax<0 )continue;
//          out.FILE3<<" iX1="<< std::setw( 5)<<iX1
//                   <<" x="<<aut.X1[iX1].x<< std::setprecision(2)
//                   <<" r="<< std::setw( 6)<<aut.X1[iX1].r
//                   <<" lte="<< std::setw( 1)<<Lmax<<'\n';
//          out.FILE3<<aut.X1[iX1].q;
//       }
//    }
//    int mQ3=con.Z0[iZ0].Q3a;
//    int nQ3=(mQ3-1+con.Z0[iZ0].cQ3);
//    for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
//       int Lmax=con.Q3[iQ3].lte;
//       if( Lmax<0 )continue;
//       out.FILE3<<" iQ3="<< std::setw( 5)<<iQ3
//                <<" x="<<aut.Q3[iQ3].x<< std::setprecision(2)
//                <<" r="<< std::setw( 6)<<aut.Q3[iQ3].r
//                <<" lte="<< std::setw( 1)<<Lmax<<'\n';
//       out.FILE3<<aut.Q3[iQ3].q;
//    }
//    int mX2=con.Z0[iZ0].X2a;
//    int nX2=(mX2-1+con.Z0[iZ0].cX2);
//    if( nX2>=mX2 ){
//       for(int iX2=mX2;iX2<=nX2;iX2++){
//          int Lmax=con.X2[iX2].lte;
//          if( Lmax<0 )continue;
//          out.FILE3<<" iX2="<< std::setw( 5)<<iX2
//                   <<" x="<<aut.X2[iX2].x<< std::setprecision(2)
//                   <<" r="<< std::setw( 6)<<aut.X2[iX2].r
//                   <<" lte="<< std::setw( 1)<<Lmax<<'\n';
//          out.FILE3<<aut.X2[iX2].q;
//       }
//    }
// }
   return;
}
