#include "../con/Subset_Contracted_System.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"

void Energy_Surface2::PHI_T2D(const Subset_Contracted_System::tM3& con,
                              const Conf_Dependent_System& dep,
                              int iZ0){
   int mJ2=con.Z0[iZ0].J2a;
   int nJ2=(mJ2-1+con.Z0[iZ0].cJ2);
   for(int iJ2=mJ2;iJ2<=nJ2;iJ2++){
      int iQ2=dep.J2N2Q2(iJ2, 0);
      int jQ2=dep.J2N2Q2(iJ2, 1);
      if( Q2[iQ2].cut||Q2[jQ2].cut )continue;
      int iU2=Q2[iQ2].U2;
      int jU2=Q2[jQ2].U2;
      double g[2],a[2][2];
      Ft+=dep.J2[iJ2].tau.fga(U2chi(iU2),U2chi(jU2),g,a);
      U2g(iU2)+=g[0];
      U2g(jU2)+=g[1];
      U2U2a(iU2,iU2)+=a[0][0];
      U2U2a(jU2,jU2)+=a[1][1];
      if( iU2<jU2 ){
         U2U2a(iU2,jU2)+=a[0][1];
      }else{
         U2U2a(jU2,iU2)+=a[0][1];
      }
   }
   int mY2=con.Z0[iZ0].Y2a;
   int nY2=(mY2-1+con.Z0[iZ0].cY2);
   for(int iY2=mY2;iY2<=nY2;iY2++){
      int iQ2=dep.Y2N3Q2(iY2,0);
      int jQ2=dep.Y2N3Q2(iY2,1);
      int kQ2=dep.Y2N3Q2(iY2,2);
      if( Q2[iQ2].cut||Q2[jQ2].cut||Q2[kQ2].cut )continue;
      int iU2=Q2[iQ2].U2;
      int jU2=Q2[jQ2].U2;
      int kU2=Q2[kQ2].U2;
      double g[3],a[3][3];
      Ft+=dep.Y2[iY2].tau.fga(U2chi(iU2),U2chi(jU2),U2chi(kU2),g,a);
      U2g(iU2)+=g[0];
      U2g(jU2)+=g[1];
      U2g(kU2)+=g[2];
      U2U2a(iU2,iU2)+=a[0][0];
      U2U2a(jU2,jU2)+=a[1][1];
      U2U2a(kU2,kU2)+=a[2][2];
      if( iU2<jU2 ){
         U2U2a(iU2,jU2)+=a[0][1];
      }else{
         U2U2a(jU2,iU2)+=a[0][1];
      }
      if( iU2<kU2 ){
         U2U2a(iU2,kU2)+=a[0][2];
      }else{
         U2U2a(kU2,iU2)+=a[0][2];
      }
      if( jU2<kU2 ){
         U2U2a(jU2,kU2)+=a[1][2];
      }else{
         U2U2a(kU2,jU2)+=a[1][2];
      }
   }
   return;
}
