#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include <cmath>

void Energy_Surface2::PHI_T1D(const Conf_Dependent_System& dep,
                              int iQ2){
   if( Q2[iQ2].cut )return;
   int iU2=Q2[iQ2].U2;
   double g,a;
   Ft+=dep.Q2[iQ2].tau.fga(U2chi(iU2),g,a);
   U2g(iU2)+=g;
   U2U2a(iU2,iU2)+=a;

   if( TETHER ){
      if( U2sub(iU2) ){
         double PI=( 3.141592653589790);
         double CAL=( 627.50955);
         double alph= (512.00)/(CAL*PI*PI);
         alph*=(1.00);
         double z=( U2chi(iU2) -U2ch0(iU2));
         if      ( z<-PI ){
            z+=(2.00)*PI;
         }else if( z> PI ){
            z-=(2.00)*PI;
         }
         Fs+= alph*z*z;
         U2g(iU2)+= (2.00)*alph*z;
         U2U2a(iU2,iU2)+= (2.00)*alph;
      }
   }
   return;
}
