#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Gaussian_Volume.hh"
#include "../phi/Phi_Automatic.hh"
#include <string>
#include <cmath>

void Energy_Surface2::PHI_RESH(Phi_Automatic& aut,
                               const DAT_PHYSICS_CONSTS& physics_consts,
                               const DAT_ARRAY_CONSTS& array_consts,
                               const DAT_ENERGY_PARAMS& energy_params,
                               const Subset_Contracted_System::tM3& con,
                               int jF2,
                               int kQ2,
                               int jZ0,
                               int iE1,
                               int iF2,
                               int i_3,
                               int iQ2,
                               int iZ0,
                               bool EPASS){
//
//
// calc Fr, Fe, Fs, Fh
//
   int iT2=con.F2[iF2].typ;
   if( iT2==30 )return;
   int jT2=con.F2[jF2].typ;
   if( jT2==30 )return;
   int iHB=con.F2[iF2].hb;
   int jHB=con.F2[jF2].hb;
//
//
// patch (jT2,iT2) (jHB,iHB)
//
   if      ( (jHB==1)&&(iHB==2) ){
      if      ( (con.F2[jF2].atm==" H  ")&&
                (con.F2[iF2].atm==" O  ") ){
         if( con.F2[jF2].R0==(con.F2[iF2].R0+ 2) ){
            jT2= 1;
            jHB=3;
         }
      }else if( (con.F2[jF2].atm==" HG ")&&
                (con.F2[iF2].atm==" O  ") ){
         if( con.F2[jF2].R0==(con.F2[iF2].R0+ 1) ){
            jT2= 1;
            jHB=3;
         }
      }
   }else if( (jHB==2)&&(iHB==1) ){
      if      ( (con.F2[jF2].atm==" O  ")&&
                (con.F2[iF2].atm==" H  ") ){
         if( con.F2[iF2].R0==(con.F2[jF2].R0+ 2) ){
            iT2= 1;
            iHB=3;
         }
      }else if( (con.F2[jF2].atm==" O  ")&&
                (con.F2[iF2].atm==" HG ") ){
         if( con.F2[iF2].R0==(con.F2[jF2].R0+ 1) ){
            iT2= 1;
            iHB=3;
         }
      }
   }
   int LTE1=con.F2[jF2].lte;
   int LTE2=con.F2[iF2].lte;
   bool atomatom=(LTE1>=0)&&(LTE2>=0);
   int n1=con.F2[jF2].mu;
   int n2=con.F2[iF2].mu;
   bool sitesite=(n1>0)&&(n2>0);
   int iS3=-1;

   if( atomatom ){
      if( con.E1[iE1].sse==1 ){
         int i=( con.F2[jF2].sf&  7);
         int k=(con.F2[jF2].sf-i);
         if( iQ2>con.Z0[iZ0].Q2a ){
            int j=( con.G3[i_3].sg&  7);
            if( (con.G3[i_3].sg-j)==k )iS3=energy_params.S2S2S3(i,j);
         }else{
            int j=( con.B3[i_3].sb&  7);
            if( (con.B3[i_3].sb-j)==k )iS3=energy_params.S2S2S3(i,j);
         }
         if( iS3==-2 )return;
      }
      aut.x=( aut.F2[iF2].x -aut.F2[jF2].x);
      aut.RR= aut.x.rr();
   }else if( sitesite ){
      if( jZ0==iZ0 ){
         for(int i1= 0;i1<n1;i1++){
            for(int i2= 0;i2<n2;i2++){
               if( con.F2[iF2].fac[i2]==con.F2[jF2].fac[i1] )return;
            }
         }
      }
      aut.x=( aut.F2[iF2].x -aut.F2[jF2].x);
      aut.RR= aut.x.rr();
      if( aut.RR>(576.00) )return;
   }else{
      return;
   }

   aut.R= std::sqrt( aut.RR);
   if( aut.R<(1.00e-12) )aut.R= (1.00e-12);
   aut.ZZ= (1.00)/aut.R;
   aut.CT= (aut.x(2)*aut.ZZ);
   aut.ST= std::sqrt( (1.00) -aut.CT*aut.CT);
   if( aut.ST>(1.00e-12) ){
      aut.CP= (aut.x(0)*aut.ZZ)/aut.ST;
      aut.SP= (aut.x(1)*aut.ZZ)/aut.ST;
   }else{
      aut.CP= (1.00);
      aut.SP= (0.00);
   }

   if( !MICRO ){
      if( (aut.R*physics_consts.ANG)<(4.00) ){
         E1part(iE1, true);
      }
   }
   aut.ISOTROPIC=true;
   if( atomatom ){
//
//
//  calc Fr
//
      if( (iS3<=0)&&
          (iT2!= 7)&&(jT2!= 7)&&(iT2!=29)&&(jT2!=29)&&
          (jF2!=con.F2[iF2].lnk) ){

         double EPS= energy_params.T2T2e(iT2,jT2);
         double RHO= energy_params.T2T2r(iT2,jT2);
         double ZZ= (aut.R/RHO);
         double alp= energy_params.T2T2a(iT2,jT2);

         double FF  =( (1.00) +alp)
                    /( ZZ +alp);
         double dFF =-FF
                    /( ZZ +alp);
         double ddFF=-(2.00)*dFF
                    /( ZZ +alp);
         double GG  = (1.12)
                    /( std::pow(ZZ,7) +(.12));
         double dGG =-GG*(7.00)*std::pow(ZZ,6)
                    /( std::pow(ZZ,7) +(.12));
         double ddGG= dGG*( (6.00)*(.12)/ZZ -(8.00)*std::pow(ZZ,6))
                    /( std::pow(ZZ,7) +(.12));

         e1_Fr+=EPS*(
             std::pow(FF,7)*( GG -(2.00))
                     );
         aut.dedr= (EPS/RHO)*(
             (7.00)*std::pow(FF,6)*dFF*( GG -(2.00))
            +std::pow(FF,7)*dGG
                              );
         aut.ddedrdr= (EPS/std::pow(RHO,2))*(
             (42.00)*std::pow(FF,5)*std::pow(dFF,2)*( GG -(2.00))
            +(14.00)*std::pow(FF,6)*dFF*dGG
            +( 7.00)*std::pow(FF,6)*ddFF*( GG -(2.00))
            +std::pow(FF,7)*ddGG
                                             );

         if( (jHB&iHB)==0 ){
            aut.ISOTROPIC=false;
            double dFdt,dFdp,
                   dFdq[3];
            double ddFdtdt,ddFdtdp,ddFdpdp,
                   ddFdqdt[3],ddFdqdp[3],
                   ddFdqdq[3][3];

            aut.QQ.populate(1);
            double ZZZ= std::sqrt( (2.00));
            int dT2,aT2;
            if( iHB==1 ){
               dT2=(iT2-1);
               aT2=jT2;
               aut.QQ.populate(1,aut.F2[iF2].q);
               double u0= aut.QQ.r(1,-1)*ZZZ;
               double u1=-aut.QQ.i(1,-1)*ZZZ;
               double u2= aut.QQ.r(1, 0);
               double z= (-1.00)/std::sqrt( u0*u0 +u1*u1 +u2*u2);
               aut.QQ*=z;
               aut.QQ.chain(array_consts,aut.QdQ,aut.QddQ);
            }else{
               dT2=(jT2-1);
               aT2=iT2;
               aut.QQ.populate(1,aut.F2[jF2].q);
               double u0= aut.QQ.r(1,-1)*ZZZ;
               double u1=-aut.QQ.i(1,-1)*ZZZ;
               double u2= aut.QQ.r(1, 0);
               double z= ( 1.00)/std::sqrt( u0*u0 +u1*u1 +u2*u2);
               aut.QQ*=z;
               for(int i=0;i<3;i++){
                  aut.QdQ[i].populate(1);
                  aut.QdQ[i].zero();
                  for(int j=0;j<3;j++){
                     aut.QddQ[i][j].populate(1);
                     aut.QddQ[i][j].zero();
                  }
               }
            }

            aut.H.populate(array_consts,1,
                           aut.CT,aut.ST,aut.CP,aut.SP,
                           aut.dH,aut.ddH);

            double dCdq[3];
            double ddCdqdt[3],ddCdqdp[3],
                   ddCdqdq[3][3];
            double C= (0.00);
            double dCdt= (0.00);
            double dCdp= (0.00);
            double ddCdtdt= (0.00);
            double ddCdtdp= (0.00);
            double ddCdpdp= (0.00);
            for(int i=0;i<3;i++){
               dCdq[i]= (0.00);
               ddCdqdt[i]= (0.00);
               ddCdqdp[i]= (0.00);
               for(int j=0;j<3;j++){
                  ddCdqdq[i][j]= (0.00);
               }
            }
            for(int M=-1;M<=1;M++){
               double F_r=( aut.QQ.r(1,M)*aut.H.r(1,M)
                           -aut.QQ.i(1,M)*aut.H.i(1,M));
               double F_i=( aut.QQ.r(1,M)*aut.H.i(1,M)
                           +aut.QQ.i(1,M)*aut.H.r(1,M));
               C+=F_r;
               dCdp+=(M)*F_i;
               ddCdpdp-=(M*M)*F_r;
               double dF_r=( aut.QQ.r(1,M)*aut.dH.r(1,M)
                            -aut.QQ.i(1,M)*aut.dH.i(1,M));
               double dF_i=( aut.QQ.r(1,M)*aut.dH.i(1,M)
                            +aut.QQ.i(1,M)*aut.dH.r(1,M));
               dCdt+=dF_r;
               ddCdtdp+=(M)*dF_i;
               double ddF_r=( aut.QQ.r(1,M)*aut.ddH.r(1,M)
                             -aut.QQ.i(1,M)*aut.ddH.i(1,M));
//             double ddF_i=( aut.QQ.r(1,M)*aut.ddH.i(1,M)
//                           +aut.QQ.i(1,M)*aut.ddH.r(1,M));
               ddCdtdt+=ddF_r;
               for(int i=0;i<3;i++){
                  dF_r=( aut.QdQ[i].r(1,M)*aut.H.r(1,M)
                        -aut.QdQ[i].i(1,M)*aut.H.i(1,M));
                  dF_i=( aut.QdQ[i].r(1,M)*aut.H.i(1,M)
                        +aut.QdQ[i].i(1,M)*aut.H.r(1,M));
                  dCdq[i]+=dF_r;
                  ddCdqdp[i]+=(M)*dF_i;
                  dF_r=( aut.QdQ[i].r(1,M)*aut.dH.r(1,M)
                        -aut.QdQ[i].i(1,M)*aut.dH.i(1,M));
//                dF_i=( aut.QdQ[i].r(1,M)*aut.dH.i(1,M)
//                      +aut.QdQ[i].i(1,M)*aut.dH.r(1,M));
                  ddCdqdt[i]+=dF_r;
                  for(int j=0;j<3;j++){
                     ddF_r=( aut.QddQ[i][j].r(1,M)*aut.H.r(1,M)
                            -aut.QddQ[i][j].i(1,M)*aut.H.i(1,M));
//                   ddF_i=( aut.QddQ[i][j].r(1,M)*aut.H.i(1,M)
//                          +aut.QddQ[i][j].i(1,M)*aut.H.r(1,M));
                     ddCdqdq[i][j]+=ddF_r;
                  }
               }
            }

            double G=-EPS*(std::pow(FF,7)*( GG -(2.00)));
            double dGdr=-aut.dedr;
            double ddGdrdr=-aut.ddedrdr;

            EPS= energy_params.T2T2e(dT2,aT2);
            RHO= energy_params.T2T2r(dT2,aT2);
            ZZ= (aut.R/RHO);
            alp= energy_params.T2T2a(dT2,aT2);

            FF  =( (1.00) +alp)
                /( ZZ +alp);
            dFF =-FF
                /( ZZ +alp);
            ddFF=-(2.00)*dFF
                /( ZZ +alp);
            GG  = (1.12)
                /( std::pow(ZZ,7) +(.12));
            dGG =-GG*(7.00)*std::pow(ZZ,6)
                /( std::pow(ZZ,7) +(.12));
            ddGG= dGG*( (6.00)*(.12)/ZZ -(8.00)*std::pow(ZZ,6))
                /( std::pow(ZZ,7) +(.12));

            G+=EPS*(
               std::pow(FF,7)*( GG -(2.00)));
            dGdr+=(EPS/RHO)*(
               (7.00)*std::pow(FF,6)*dFF*( GG -(2.00))
              +std::pow(FF,7)*dGG);
            ddGdrdr+=(EPS/std::pow(RHO,2))*(
               (42.00)*std::pow(FF,5)*std::pow(dFF,2)*( GG -(2.00))
              +(14.00)*std::pow(FF,6)*dFF*dGG
              +( 7.00)*std::pow(FF,6)*ddFF*( GG -(2.00))
              +std::pow(FF,7)*ddGG);

            double F=( (1.00) -C*C*C*C);
            dFdt=-(4.00)*C*C*C*dCdt;
            dFdp=-(4.00)*C*C*C*dCdp;
            ddFdtdt=-(4.00)*( (3.00)*C*C*dCdt*dCdt +C*C*C*ddCdtdt);
            ddFdtdp=-(4.00)*( (3.00)*C*C*dCdt*dCdp +C*C*C*ddCdtdp);
            ddFdpdp=-(4.00)*( (3.00)*C*C*dCdp*dCdp +C*C*C*ddCdpdp);
            for(int i=0;i<3;i++){
               dFdq[i]=-(4.00)*C*C*C*dCdq[i];
               ddFdqdt[i]=-(4.00)*( (3.00)*C*C*dCdq[i]*dCdt +C*C*C*ddCdqdt[i]);
               ddFdqdp[i]=-(4.00)*( (3.00)*C*C*dCdq[i]*dCdp +C*C*C*ddCdqdp[i]);
               for(int j=0;j<3;j++){
                  ddFdqdq[i][j]=
                    -(4.00)*( (3.00)*C*C*dCdq[i]*dCdq[j] +C*C*C*ddCdqdq[i][j]);
               }
            }

            e1_Fr+=F*G;
            aut.dedr+=F*dGdr;
            aut.dedt=dFdt*G;
            aut.dedp=dFdp*G;
            aut.ddedrdr+=F*ddGdrdr;
            aut.ddedrdt=dFdt*dGdr;
            aut.ddedrdp=dFdp*dGdr;
            aut.ddedtdt=ddFdtdt*G;
            aut.ddedtdp=ddFdtdp*G;
            aut.ddedpdp=ddFdpdp*G;
            for(int i=0;i<3;i++){
               aut.dedq[i]=dFdq[i]*G;
               aut.ddedqdr[i]=dFdq[i]*dGdr;
               aut.ddedqdt[i]=ddFdqdt[i]*G;
               aut.ddedqdp[i]=ddFdqdp[i]*G;
               for(int j=0;j<3;j++){
                  aut.ddedqdq[i][j]=ddFdqdq[i][j]*G;
               }
            }

            if( con.F2[jF2].ion||con.F2[iF2].ion ){
               EPS= energy_params.T2T2e(dT2,aT2)*(  .32);
               RHO= energy_params.T2T2r(dT2,aT2);
               ZZ= (aut.R/RHO);
               alp= energy_params.T2T2a(dT2,aT2);
      
               FF  =( (1.00) +alp)
                   /( ZZ +alp);
               dFF =-FF
                   /( ZZ +alp);
               ddFF=-(2.00)*dFF
                   /( ZZ +alp);
               GG  = (1.12)
                   /( std::pow(ZZ,7) +(.12));
               dGG =-GG*(7.00)*std::pow(ZZ,6)
                   /( std::pow(ZZ,7) +(.12));
               ddGG= dGG*( (6.00)*(.12)/ZZ -(8.00)*std::pow(ZZ,6))
                   /( std::pow(ZZ,7) +(.12));
      
               e1_Fr+=EPS*(
                   std::pow(FF,7)*( GG -(2.00))
                           );
               aut.dedr+= (EPS/RHO)*(
                   (7.00)*std::pow(FF,6)*dFF*( GG -(2.00))
                  +std::pow(FF,7)*dGG
                                    );
               aut.ddedrdr+= (EPS/std::pow(RHO,2))*(
                   (42.00)*std::pow(FF,5)*std::pow(dFF,2)*( GG -(2.00))
                  +(14.00)*std::pow(FF,6)*dFF*dGG
                  +( 7.00)*std::pow(FF,6)*ddFF*( GG -(2.00))
                  +std::pow(FF,7)*ddGG
                                                   );
            }

         }
      }else{
         aut.dedr= (0.00);
         aut.ddedrdr= (0.00);
      }
//
//
//  calc Fs
//
      if( iS3>=0 ){
         double a0= energy_params.S3[iS3].a;
         double r0= energy_params.S3[iS3].r;
         e1_Fs+=a0*std::pow(( aut.R -r0),2);
         aut.dedr+=(2.00)*a0*( aut.R -r0);
         aut.ddedrdr+=(2.00)*a0;
         if( iS3==2 ){
            double Es= std::pow( (1.00)/(aut.R*physics_consts.ANG), 9);
            e1_Fs+=Es;
            aut.dedr-=(9.00)*Es*aut.ZZ;
            aut.ddedrdr+=(90.0)*Es/aut.RR;
         }
      }
//
//
//  calc Fh
//
      if( sitesite ){
         if( aut.R<(24.00) ){
            double F1= array_consts.SGN(n1+n2-1);
            double G2,A2;
            double F2= pairfga(physics_consts,
                                con.F2[jF2].gau,con.F2[iF2].gau,
                                aut.R,
                                G2,A2);
            e1_Fh+=(F1*F2);
            aut.dedr+=(F1*G2);
            aut.ddedrdr+=(F1*A2);
         }
      }
//
//
//  calc Fe
//
      if( !EPASS ){
         int LTE=PHI_L(aut.R,(3.20),energy_params.LTE);
         PHI_ME(aut,
                array_consts,
                aut.F2[jF2].q,LTE1,aut.F2[iF2].q,LTE2,LTE);
      }

   }else if( sitesite ){
//
//
// calc Fh
//
      double F1= array_consts.SGN(n1+n2-1);
      double F2= pairfga(physics_consts,
                         con.F2[jF2].gau,con.F2[iF2].gau,
                         aut.R,
                         aut.dedr,aut.ddedrdr);
      e1_Fh+=(F1*F2);
      aut.dedr*=F1;
      aut.ddedrdr*=F1;

   }
   PHI_PART(aut,
            array_consts,
            kQ2,jZ0,aut.F2[iF2].x,iQ2,iZ0);
   return;
}
