#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Gaussian_Volume.hh"
#include "../phi/Phi_Automatic.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <iomanip>
#include <cmath>

class MEM_phi_pwm {
private:
   std::vector<double> o_U2p;                   //
   std::vector<bool> o_U2b;                     //
public:
   MEM_phi_pwm(int o):
      o_U2p(o, (0.00)),
      o_U2b(o, false)
   {
   }
   double& U2p(int i){
      return o_U2p.at( i);  }
   void U2b(int i,bool a){
      o_U2b[ i]=a;  }
   bool U2b(int i){
      return o_U2b[ i];  }
};

void Energy_Surface2::PHI_PWM(Phi_Automatic& aut,
                                 const DAT_PHYSICS_CONSTS& physics_consts,
                                 const DAT_ARRAY_CONSTS& array_consts,
                                 const DAT_REGION_MAPS& region_maps,
                                 Output_Streams& out,
                                 const Mechanical_System& mol,
                                 const Subset_Contracted_System::tM3& con,
                                 const Conf_Dependent_System& dep){
   MEM_phi_pwm vv(nU2);
//
//
// calc Fw+Fm
//
   o_F2F2E8.resize(oF2*(oF2+ 1)/2,-1);
   nE8=0;
   nO8=0;
   aut.ISOTROPIC=true;
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      if( !con.Z0[iZ0].sub ){
         aut.TRANS=dep.Z0[iZ0].trans;
      }else{
         int iU2=Z0[iZ0].U2a;
         aut.TRANS(0)= U2chi(iU2  );
         aut.TRANS(1)= U2chi(iU2+1);
         aut.TRANS(2)= U2chi(iU2+2);
      }
      int mE1=con.Z0[iZ0].E1a;
      int iQ2=mQ2;
      int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
      for(int icQ2=(nQ2-mQ2+1);icQ2>0;icQ2--){
         aut.br=con.Q2[iQ2].br;
         if( aut.br==0 ){
            aut.BBw=iQ2;
            aut.SCa=(nQ2+1);
         }else{
            if( con.Q2[iQ2].cbr==0 )aut.SCa=iQ2;
         }
         int nE1=(mE1-1+con.Q2[iQ2].cE1);
         if( nE1>=mE1 ){
            for(int iE1=mE1;iE1<=nE1;iE1++){
               e1_g.zero();
               e1_h.zero();
               PHI_E1_WM(aut,
                         physics_consts,array_consts,
                         con,
                         iZ0,mQ2,iQ2,iE1);
               int kQ2=con.E1[iE1].k;
               Q2Q2e(kQ2,iQ2)+=e1_g;
               Q2Q2e(iQ2,kQ2)+=e1_h;
            }
            mE1+=con.Q2[iQ2].cE1;
         }
         if( con.Q2[iQ2].omg==1 ){
            int L=iQ2hold;
            iQ2hold=(iQ2+1);
            iQ2=L;
         }else{
            iQ2++;
         }
      }
   }
// out.FILE3<< std::fixed<< std::setprecision( 3);
// out.FILE3<<" nE8="<< std::setw( 6)<<aut.nE8
//          <<" nO8="<< std::setw( 8)<<aut.nO8<<'\n';
//
//
// func +patch of 2nd deriv
//
   Fw= (0.00);
   for(int aG5=-16;aG5<= 16;aG5++){
      int iG5min=(aG5-3);
      int iG5max=(aG5+3);
      if( iG5min<-16 )iG5min=-16;
      if( iG5max> 16 )iG5max= 16;
      for(int bG5=-16;bG5<= 16;bG5++){
         int jG5min=(bG5-3);
         int jG5max=(bG5+3);
         if( jG5min<-16 )jG5min=-16;
         if( jG5max> 16 )jG5max= 16;
         for(int cG5=-16;cG5<= 16;cG5++){
            int kG5min=(cG5-3);
            int kG5max=(cG5+3);
            if( kG5min<-16 )kG5min=-16;
            if( kG5max> 16 )kG5max= 16;
            int i=( 1089*(aG5+16) +33*(bG5+16) +(cG5+16));
            if( aut.G5G5G5(i).n==0 )continue;
            int iDOTmin=aut.G5G5G5(i).i;
            int iDOTmax=(iDOTmin-1+aut.G5G5G5(i).n);
            for(int iDOT=iDOTmin;iDOT<=iDOTmax;iDOT++){
               int iF2=aut.DOT[iDOT].F2;
               if( con.F2[iF2].typ!=30 )continue;
               double x=( con.F2[iF2].u(1)*aut.F2[iF2].v -con.F2[iF2].u(2));
               double y= con.F2[iF2].u(0)*( (-1.00) +std::tanh( x));
               Fw+=y;
               for(int iG5=iG5min;iG5<=iG5max;iG5++){
                  for(int jG5=jG5min;jG5<=jG5max;jG5++){
                     for(int kG5=kG5min;kG5<=kG5max;kG5++){
                        int j=( 1089*(iG5+16) +33*(jG5+16) +(kG5+16));
                        if( aut.G5G5G5(j).n==0 )continue;
                        int jDOTmin=aut.G5G5G5(j).i;
                        int jDOTmax=(jDOTmin-1+aut.G5G5G5(j).n);
                        for(int jDOT=jDOTmin;jDOT<=jDOTmax;jDOT++){
                           int jF2=aut.DOT[jDOT].F2;
                           if( con.F2[jF2].typ==30 )continue;
                           int ijE8=F2F2E8(iF2,jF2);
                           if( ijE8!=-1 ){
                              int aO8=E8[ijE8].O8a;
                              int bO8=(aO8+E8[ijE8].cO8);
                              for(int ijO8=aO8;ijO8<bO8;ijO8++){
                                 int ijU2=O8[ijO8].U2;
                                 double dRRij=O8[ijO8].s;
                                 vv.U2p(ijU2)+=(E8[ijE8].dv*dRRij);
                                 vv.U2b(ijU2, true);
                              }
                           }
                        }
                     }
                  }
               }
               for(int iU2= 0;iU2<nU2;iU2++){
                  if( !vv.U2b(iU2) )continue;
                  for(int jU2=iU2;jU2<nU2;jU2++){
                     if( !vv.U2b(jU2) )continue;
                     U2U2a(iU2,jU2)+=aut.F2[iF2].h*vv.U2p(iU2)*vv.U2p(jU2);
                  }
               }
               for(int iU2= 0;iU2<nU2;iU2++){
                  if( !vv.U2b(iU2) )continue;
                  vv.U2p(iU2)= (0.00);
                  vv.U2b(iU2, false);
               }
            }
         }
      }
   }
//
//
// gaussian approx of Fm
//
   Fp_e= (0.00);
   for(int iF2= 0;iF2<oF2;iF2++){
      if( con.F2[iF2].zet==0 )continue;
      for(int jF2=iF2;jF2<oF2;jF2++){
         if( con.F2[jF2].zet==0 )continue;
         double z=(( jF2==iF2 )? (1.00): (2.00))
                 *F2[iF2].fq*F2[jF2].fq;
         double RRij=( aut.F2[iF2].x -aut.F2[jF2].x).rr();
         double ee= (0.00);
         for(int i=0;i<4;i++){
            for(int j=0;j<4;j++){
               ee+=eef(physics_consts,
                       con.F2[iF2].ef[i],
                       con.F2[jF2].ef[j],
                       RRij);
            }
         }
         Fp_e+=(fac_m2*z*ee);
         int ijE8=F2F2E8(iF2,jF2);
         double A_ij_ik( 0.00),A_ij_jk( 0.00),A_ik_jk( 0.00);
         for(int kF2= 0;kF2<oF2;kF2++){
            if( con.F2[kF2].kap==0 )continue;
            double RRik=( aut.F2[iF2].x -aut.F2[kF2].x).rr();
            double RRjk=( aut.F2[jF2].x -aut.F2[kF2].x).rr();
            double eev= (0.00);
            double B_ij_ik( 0.00),B_ij_jk( 0.00),B_ik_jk( 0.00);
            for(int i=0;i<4;i++){
               for(int j=0;j<4;j++){
                  eev+=eevf(physics_consts,
                            con.F2[iF2].ef[i],
                            con.F2[jF2].ef[j],
                            con.F2[kF2].vf,
                            RRij,
                            RRik,
                            RRjk,
                            A_ij_ik,
                            A_ij_jk,
                            A_ik_jk);
                  B_ij_ik+=A_ij_ik;
                  B_ij_jk+=A_ij_jk;
                  B_ik_jk+=A_ik_jk;
               }
            }
            Fp_e+=(fac_m3*z*eev);
            B_ij_ik*=(fac_m3*z);
            B_ij_jk*=(fac_m3*z);
            B_ik_jk*=(fac_m3*z);
//
//
// 2nd deriv through 2 of (RRij,RRik,RRjk)
//
            int ikE8=F2F2E8(iF2,kF2);
            int jkE8=F2F2E8(jF2,kF2);
            if( (ijE8!=-1) &&(ikE8!=-1) ){
               int aO8=E8[ikE8].O8a;
               int bO8=(aO8+E8[ikE8].cO8);
               for(int ikO8=aO8;ikO8<bO8;ikO8++){
                  int ikU2=O8[ikO8].U2;
                  double dRRik=O8[ikO8].s;
                  vv.U2p(ikU2)+=(B_ij_ik*dRRik);
                  vv.U2b(ikU2, true);
               }
            }
            if( (ijE8!=-1) &&(jkE8!=-1) ){
               int aO8=E8[jkE8].O8a;
               int bO8=(aO8+E8[jkE8].cO8);
               for(int jkO8=aO8;jkO8<bO8;jkO8++){
                  int jkU2=O8[jkO8].U2;
                  double dRRjk=O8[jkO8].s;
                  vv.U2p(jkU2)+=(B_ij_jk*dRRjk);
                  vv.U2b(jkU2, true);
               }
            }
            if( (ikE8!=-1) &&(jkE8!=-1) &&(jF2!=iF2) ){
               int mO8=E8[ikE8].O8a;
               int nO8=(mO8+E8[ikE8].cO8);
               int aO8=E8[jkE8].O8a;
               int bO8=(aO8+E8[jkE8].cO8);
               for(int ikO8=mO8;ikO8<nO8;ikO8++){
                  int ikU2=O8[ikO8].U2;
                  double dRRik=O8[ikO8].s;
                  for(int jkO8=aO8;jkO8<bO8;jkO8++){
                     int jkU2=O8[jkO8].U2;
                     double dRRjk=O8[jkO8].s;
                     U2U2a_up(ikU2,jkU2)+=(B_ik_jk*dRRik*dRRjk);
                  }
               }
            }
         }
         if( ijE8!=-1 ){
            int mO8=E8[ijE8].O8a;
            int nO8=(mO8+E8[ijE8].cO8);
            for(int ijO8=mO8;ijO8<nO8;ijO8++){
               int ijU2=O8[ijO8].U2;
               double dRRij=O8[ijO8].s;
               for(int pU2= 0;pU2<nU2;pU2++){
                  if( !vv.U2b(pU2) )continue;
                  U2U2a_up(ijU2,pU2)+=(vv.U2p(pU2)*dRRij);
               }
            }
            for(int pU2= 0;pU2<nU2;pU2++){
               if( !vv.U2b(pU2) )continue;
               vv.U2p(pU2)= (0.00);
               vv.U2b(pU2, false);
            }
         }
      }
   }
   o_F2F2E8.clear();
   E8.clear();
   O8.clear();
//
//
// calc Fp
//
   o_F2F2E9.resize(oF2*(oF2+ 1)/2,-1);
   nE9=0;
   nO9=0;
   aut.ISOTROPIC=false;
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      if( !con.Z0[iZ0].sub ){
         aut.TRANS=dep.Z0[iZ0].trans;
      }else{
         int iU2=Z0[iZ0].U2a;
         aut.TRANS(0)= U2chi(iU2  );
         aut.TRANS(1)= U2chi(iU2+1);
         aut.TRANS(2)= U2chi(iU2+2);
      }
      int mE1=con.Z0[iZ0].E1a;
      int iQ2=mQ2;
      int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
      for(int icQ2=(nQ2-mQ2+1);icQ2>0;icQ2--){
         aut.br=con.Q2[iQ2].br;
         if( aut.br==0 ){
            aut.BBw=iQ2;
            aut.SCa=(nQ2+1);
         }else{
            if( con.Q2[iQ2].cbr==0 )aut.SCa=iQ2;
         }
         int nE1=(mE1-1+con.Q2[iQ2].cE1);
         if( nE1>=mE1 ){
            for(int iE1=mE1;iE1<=nE1;iE1++){
               e1_g.zero();
               e1_h.zero();
               PHI_E1_P(aut,
                        physics_consts,
                        array_consts,
                        con,
                        iZ0,mQ2,iQ2,iE1);
               int kQ2=con.E1[iE1].k;
               Q2Q2e(kQ2,iQ2)+=e1_g;
               Q2Q2e(iQ2,kQ2)+=e1_h;
            }
            mE1+=con.Q2[iQ2].cE1;
         }
         if( con.Q2[iQ2].omg==1 ){
            int L=iQ2hold;
            iQ2hold=(iQ2+1);
            iQ2=L;
         }else{
            iQ2++;
         }
      }
   }
// out.FILE3<< std::fixed<< std::setprecision( 3);
// out.FILE3<<" nE9="<< std::setw( 6)<<aut.nE9
//          <<" nO9="<< std::setw( 8)<<aut.nO9<<'\n';
//
//
// func +patch of 2nd deriv
//
   Fp_a= (0.00);
   Fp_b= (0.00);
   Fp_c= (0.00);
   Fp_d= (0.00);
   for(int iR0= 0;iR0<oR0;iR0++){
      for(int jR0= 0;jR0<oR0;jR0++){
         if( !R0R0(iR0,jR0).b )continue;
         double e= R0R0(iR0,jR0).e;
         double C= R0R0(iR0,jR0).C;
         double B= R0R0(iR0,jR0).B;
         double D= R0R0(iR0,jR0).D;
         Fp_a+=e;
         Fp_b+=e*( .50)*B;
         Fp_c+=e*( .50)*C;
         Fp_d+=e*D;
      }
   }
   for(int iF2F2= 0;iF2F2<oF2F2;iF2F2++){
      if( !F2F2(iF2F2).b )continue;
      double e= F2F2(iF2F2).e;
      double C= F2F2(iF2F2).C;
      double B= F2F2(iF2F2).B;
      double D= F2F2(iF2F2).D;
      Fp_a+=e;
      Fp_b+=e*( .50)*B;
      Fp_c+=e*( .50)*C;
      Fp_d+=e*D;
   }
//
// chains of peptide plane alignment
// patterns of H-bonds in helices or sheets
//
   for(int iE4= 0;iE4<nE4;iE4++){
      int iF2=E4[iE4].iF2;
      int jF2=E4[iE4].jF2;
      int kF2=E4[iE4].kF2;
      int lF2=E4[iE4].lF2;
      double z= E4[iE4].f;
      int ijE9=F2F2E9(iF2,jF2);
      int klE9=F2F2E9(kF2,lF2);
      if( (ijE9!=-1)&&(klE9!=-1) ){
         int mO9=E9[ijE9].O9a;
         int nO9=(mO9+E9[ijE9].cO9);
         int aO9=E9[klE9].O9a;
         int bO9=(aO9+E9[klE9].cO9);
         for(int ijO9=mO9;ijO9<nO9;ijO9++){
            int ijU2=O9[ijO9].U2;
            double deij= O9[ijO9].s;
            for(int klO9=aO9;klO9<bO9;klO9++){
               int klU2=O9[klO9].U2;
               double dekl= O9[klO9].s;
               if( klU2==ijU2 ){
                  U2U2a_up(ijU2,klU2)+=((2.00)*z*deij*dekl);
               }else{
                  U2U2a_up(ijU2,klU2)+=(z*deij*dekl);
               }
            }
         }
      }
   }
//
//
// peptide-peptide H-bond crosslinks
//
   double g0,a00,g1,a11;
   double g[2],a[2][2];
   for(int iR0= 0;iR0<oR0;iR0++){
      for(int jR0= 0;jR0<oR0;jR0++){
         if( !R0R0(iR0,jR0).b )continue;
         int iF2=con.R0N6F2(iR0+1, 3);
         int jF2=con.R0N6F2(jR0  , 5);
         double e= R0R0(iR0,jR0).e;
         int ijE9=F2F2E9(iF2,jF2);
         int mO9( 0),nO9( 0);
         if( ijE9!=-1 ){
            mO9=E9[ijE9].O9a;
            nO9=(mO9+E9[ijE9].cO9);
         }
//
         int N4N2U2[4][2];
         N4N2U2[0][0]=con.R0[iR0   ].U2phi;
         N4N2U2[0][1]=con.R0[iR0   ].U2psi;
         N4N2U2[1][0]=con.R0[iR0+ 1].U2phi;
         N4N2U2[1][1]=con.R0[iR0+ 1].U2psi;
         N4N2U2[2][0]=con.R0[jR0   ].U2phi;
         N4N2U2[2][1]=con.R0[jR0   ].U2psi;
         N4N2U2[3][0]=con.R0[jR0+ 1].U2phi;
         N4N2U2[3][1]=con.R0[jR0+ 1].U2psi;
         int N4N2Q1[4][2];
         N4N2Q1[0][0]=con.R0[iR0   ].Q1phi;
         N4N2Q1[0][1]=con.R0[iR0   ].Q1psi;
         N4N2Q1[1][0]=con.R0[iR0+ 1].Q1phi;
         N4N2Q1[1][1]=con.R0[iR0+ 1].Q1psi;
         N4N2Q1[2][0]=con.R0[jR0   ].Q1phi;
         N4N2Q1[2][1]=con.R0[jR0   ].Q1psi;
         N4N2Q1[3][0]=con.R0[jR0+ 1].Q1phi;
         N4N2Q1[3][1]=con.R0[jR0+ 1].Q1psi;
         double phi(   0.00),psi(   0.00);
         for(int i=0;i<4;i++){
            int iU2=N4N2U2[i][0];
            int jU2=N4N2U2[i][1];
            if( (iU2==-1)&&(jU2==-1) )continue;
            if( iU2>-1 ){
               phi= U2chi(iU2);
            }else{
               phi= dep.Q1[N4N2Q1[i][0]].chi;
            }
            if( jU2>-1 ){
               psi= U2chi(jU2);
            }else{
               psi= dep.Q1[N4N2Q1[i][1]].chi;
            }
            region_maps.phipsi.fga(phi,psi,g,a);
            if      ( (iU2>-1)&&
                      (jU2>-1) ){
               region_maps.phi.fga(phi,g0,a00);
               g[0]+=g0;
               a[0][0]+=a00;
               U2g(iU2)+=g[0]*e;
               U2U2a(iU2,iU2)+=a[0][0]*e;
               region_maps.psi.fga(psi,g1,a11);
               g[1]+=g1;
               a[1][1]+=a11;
               U2g(jU2)+=g[1]*e;
               U2U2a(jU2,jU2)+=a[1][1]*e;
               U2U2a(iU2,jU2)+=a[0][1]*e;
            }else if( iU2>-1 ){
               region_maps.phi.fga(phi,g0,a00);
               g[0]+=g0;
               a[0][0]+=a00;
               U2g(iU2)+=g[0]*e;
               U2U2a(iU2,iU2)+=a[0][0]*e;
            }else if( jU2>-1 ){
               region_maps.psi.fga(psi,g1,a11);
               g[1]+=g1;
               a[1][1]+=a11;
               U2g(jU2)+=g[1]*e;
               U2U2a(jU2,jU2)+=a[1][1]*e;
            }
            if( iU2>-1 ){
               for(int ijO9=mO9;ijO9<nO9;ijO9++){
                  int ijU2=O9[ijO9].U2;
                  double deij= O9[ijO9].s;
                  if( ijU2==iU2 ){
                     U2U2a_up(iU2,ijU2)+=( 2.00)*g[0]*deij;
                  }else{
                     U2U2a_up(iU2,ijU2)+=g[0]*deij;
                  }
               }
            }
            if( jU2>-1 ){
               for(int ijO9=mO9;ijO9<nO9;ijO9++){
                  int ijU2=O9[ijO9].U2;
                  double deij= O9[ijO9].s;
                  if( ijU2==jU2 ){
                     U2U2a_up(jU2,ijU2)+=( 2.00)*g[1]*deij;
                  }else{
                     U2U2a_up(jU2,ijU2)+=g[1]*deij;
                  }
               }
            }
         }
//
      }
   }
//
//
// other H-bond crosslinks
//
   for(int iF2F2= 0;iF2F2<oF2F2;iF2F2++){
      if( !F2F2(iF2F2).b )continue;
      int iF2=F2F2(iF2F2).iF2;
      int jF2=F2F2(iF2F2).jF2;
      std::string atmi=con.F2[iF2].atm;
      std::string atmj=con.F2[jF2].atm;
      int iR0=con.F2[iF2].R0;
      int jR0=con.F2[jF2].R0;
      double e= F2F2(iF2F2).e;
      int ijE9=F2F2E9(iF2,jF2);
      int mO9( 0),nO9( 0);
      if( ijE9!=-1 ){
         mO9=E9[ijE9].O9a;
         nO9=(mO9+E9[ijE9].cO9);
      }
      if( atmi==" H  " ){
         if( iR0== 0 )continue;
         int N4N2U2[4][2];
         N4N2U2[0][0]=con.R0[iR0- 1].U2phi;
         N4N2U2[0][1]=con.R0[iR0- 1].U2psi;
         N4N2U2[1][0]=con.R0[iR0   ].U2phi;
         N4N2U2[1][1]=con.R0[iR0   ].U2psi;
         int N4N2Q1[4][2];
         N4N2Q1[0][0]=con.R0[iR0- 1].Q1phi;
         N4N2Q1[0][1]=con.R0[iR0- 1].Q1psi;
         N4N2Q1[1][0]=con.R0[iR0   ].Q1phi;
         N4N2Q1[1][1]=con.R0[iR0   ].Q1psi;
         double phi(   0.00),psi(   0.00);
         for(int i=0;i<2;i++){
            int iU2=N4N2U2[i][0];
            int jU2=N4N2U2[i][1];
            if( (iU2==-1)&&(jU2==-1) )continue;
            if( iU2>-1 ){
               phi= U2chi(iU2);
            }else{
               phi= dep.Q1[N4N2Q1[i][0]].chi;
            }
            if( jU2>-1 ){
               psi= U2chi(jU2);
            }else{
               psi= dep.Q1[N4N2Q1[i][1]].chi;
            }
            region_maps.phipsi.fga(phi,psi,g,a);
            if      ( (iU2>-1)&&
                      (jU2>-1) ){
               region_maps.phi.fga(phi,g0,a00);
               g[0]+=g0;
               a[0][0]+=a00;
               U2g(iU2)+=g[0]*e;
               U2U2a(iU2,iU2)+=a[0][0]*e;
               region_maps.psi.fga(psi,g1,a11);
               g[1]+=g1;
               a[1][1]+=a11;
               U2g(jU2)+=g[1]*e;
               U2U2a(jU2,jU2)+=a[1][1]*e;
               U2U2a(iU2,jU2)+=a[0][1]*e;
            }else if( iU2>-1 ){
               region_maps.phi.fga(phi,g0,a00);
               g[0]+=g0;
               a[0][0]+=a00;
               U2g(iU2)+=g[0]*e;
               U2U2a(iU2,iU2)+=a[0][0]*e;
            }else if( jU2>-1 ){
               region_maps.psi.fga(psi,g1,a11);
               g[1]+=g1;
               a[1][1]+=a11;
               U2g(jU2)+=g[1]*e;
               U2U2a(jU2,jU2)+=a[1][1]*e;
            }
            if( iU2>-1 ){
               for(int ijO9=mO9;ijO9<nO9;ijO9++){
                  int ijU2=O9[ijO9].U2;
                  double deij= O9[ijO9].s;
                  if( ijU2==iU2 ){
                     U2U2a_up(iU2,ijU2)+=( 2.00)*g[0]*deij;
                  }else{
                     U2U2a_up(iU2,ijU2)+=g[0]*deij;
                  }
               }
            }
            if( jU2>-1 ){
               for(int ijO9=mO9;ijO9<nO9;ijO9++){
                  int ijU2=O9[ijO9].U2;
                  double deij= O9[ijO9].s;
                  if( ijU2==jU2 ){
                     U2U2a_up(jU2,ijU2)+=( 2.00)*g[1]*deij;
                  }else{
                     U2U2a_up(jU2,ijU2)+=g[1]*deij;
                  }
               }
            }
         }
//
      }
      if( atmj==" O  " ){
         if( jR0==(oR0- 1) )continue;
         int N4N2U2[4][2];
         N4N2U2[2][0]=con.R0[jR0   ].U2phi;
         N4N2U2[2][1]=con.R0[jR0   ].U2psi;
         N4N2U2[3][0]=con.R0[jR0+ 1].U2phi;
         N4N2U2[3][1]=con.R0[jR0+ 1].U2psi;
         int N4N2Q1[4][2];
         N4N2Q1[2][0]=con.R0[jR0   ].Q1phi;
         N4N2Q1[2][1]=con.R0[jR0   ].Q1psi;
         N4N2Q1[3][0]=con.R0[jR0+ 1].Q1phi;
         N4N2Q1[3][1]=con.R0[jR0+ 1].Q1psi;
         double phi(   0.00),psi(   0.00);
         for(int i=2;i<4;i++){
            int iU2=N4N2U2[i][0];
            int jU2=N4N2U2[i][1];
            if( (iU2==-1)&&(jU2==-1) )continue;
            if( iU2>-1 ){
               phi= U2chi(iU2);
            }else{
               phi= dep.Q1[N4N2Q1[i][0]].chi;
            }
            if( jU2>-1 ){
               psi= U2chi(jU2);
            }else{
               psi= dep.Q1[N4N2Q1[i][1]].chi;
            }
            region_maps.phipsi.fga(phi,psi,g,a);
            if      ( (iU2>-1)&&
                      (jU2>-1) ){
               region_maps.phi.fga(phi,g0,a00);
               g[0]+=g0;
               a[0][0]+=a00;
               U2g(iU2)+=g[0]*e;
               U2U2a(iU2,iU2)+=a[0][0]*e;
               region_maps.psi.fga(psi,g1,a11);
               g[1]+=g1;
               a[1][1]+=a11;
               U2g(jU2)+=g[1]*e;
               U2U2a(jU2,jU2)+=a[1][1]*e;
               U2U2a(iU2,jU2)+=a[0][1]*e;
            }else if( iU2>-1 ){
               region_maps.phi.fga(phi,g0,a00);
               g[0]+=g0;
               a[0][0]+=a00;
               U2g(iU2)+=g[0]*e;
               U2U2a(iU2,iU2)+=a[0][0]*e;
            }else if( jU2>-1 ){
               region_maps.psi.fga(psi,g1,a11);
               g[1]+=g1;
               a[1][1]+=a11;
               U2g(jU2)+=g[1]*e;
               U2U2a(jU2,jU2)+=a[1][1]*e;
            }
            if( iU2>-1 ){
               for(int ijO9=mO9;ijO9<nO9;ijO9++){
                  int ijU2=O9[ijO9].U2;
                  double deij= O9[ijO9].s;
                  if( ijU2==iU2 ){
                     U2U2a_up(iU2,ijU2)+=( 2.00)*g[0]*deij;
                  }else{
                     U2U2a_up(iU2,ijU2)+=g[0]*deij;
                  }
               }
            }
            if( jU2>-1 ){
               for(int ijO9=mO9;ijO9<nO9;ijO9++){
                  int ijU2=O9[ijO9].U2;
                  double deij= O9[ijO9].s;
                  if( ijU2==jU2 ){
                     U2U2a_up(jU2,ijU2)+=( 2.00)*g[1]*deij;
                  }else{
                     U2U2a_up(jU2,ijU2)+=g[1]*deij;
                  }
               }
            }
         }
//
      }
   }
   o_F2F2E9.clear();
   E9.clear();
   O9.clear();
   Fp=( Fp_a +Fp_b +Fp_c +Fp_d +Fp_e);
   TOT=( Fr +Fe +Fs +Ft +Fc +Fb +Fh +Fp +Fw);
   return;
}
