#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi_Automatic.hh"

void Energy_Surface2::PHI_PART1(Phi_Automatic& aut,
                                int kQ2,
                                int jZ0,
                                const Coordinates& x2,
                                int iQ2,
                                int iZ0){
//
//
// reusable values
//
   aut.x=( x2 -aut.TRANS);
   aut.x.chain(aut.dx);
//
//
// d(rtp)dx
//
   double dRdx[3];
   dRdx[0]= aut.ST*aut.CP;
   dRdx[1]= aut.ST*aut.SP;
   dRdx[2]= aut.CT;
//
//
// d(rtp)d(t,alp,bet.gam)
//
   double dR[6];
   for(int i=0;i<3;i++){
      dR[  i]= dRdx[i];
      dR[3+i]=( dRdx[0]*aut.dx[i](0)
               +dRdx[1]*aut.dx[i](1)
               +dRdx[2]*aut.dx[i](2));
   }
//
// ded(t,alp,bet,gam)
// atom pair contribution to block pair
//
   for(int i=0;i<6;i++){
      aut.e11(i)= aut.dedr*dR[i];
   }
   if( !aut.ISOTROPIC ){
      double dTdx[3];
      double dPdx[3];
      dTdx[0]= aut.CT*aut.CP*aut.ZZ;
      dTdx[1]= aut.CT*aut.SP*aut.ZZ;
      dTdx[2]=-aut.ST*aut.ZZ;
      if( aut.ST<(1.00e-12) ){
         dPdx[0]= (0.00);
         dPdx[1]= (0.00);
      }else{
         double z= aut.ZZ/aut.ST;
         dPdx[0]=-z*aut.SP;
         dPdx[1]= z*aut.CP;
      }
      dPdx[2]= (0.00);
      double dT[6];
      double dP[6];
      for(int i=0;i<3;i++){
         dT[  i]= dTdx[i];
         dT[3+i]=( dTdx[0]*aut.dx[i](0)
                  +dTdx[1]*aut.dx[i](1)
                  +dTdx[2]*aut.dx[i](2));
         dP[  i]= dPdx[i];
         dP[3+i]=( dPdx[0]*aut.dx[i](0)
                  +dPdx[1]*aut.dx[i](1)
                  +dPdx[2]*aut.dx[i](2));
      }
      for(int i=0;i<6;i++){
         aut.e11(i)+=( aut.dedt*dT[i]
                      +aut.dedp*dP[i]);
      }
      for(int i=0;i<3;i++){
         aut.e11(3+i)+=aut.dedq[i];
      }
   }
//
//
// accumulate block pair
//
   for(int i=0;i<6;i++){
      aut.p_g(i)=aut.e11(i);
   }
//
//
// block pair wrt origin of chain of backward group
//
   if( jZ0<iZ0 ){
      for(int i=0;i<3;i++){
         aut.e00(  i)=-aut.e11(  i);
         aut.e00(3+i)=-aut.e11(3+i)
                        -aut.e11(  0)*Z0Z0y(jZ0,iZ0)(0,i)
                        -aut.e11(  1)*Z0Z0y(jZ0,iZ0)(1,i)
                        -aut.e11(  2)*Z0Z0y(jZ0,iZ0)(2,i);
      }
      for(int i=0;i<6;i++){
         aut.p_h(i)=aut.e00(i);
      }
   }
   return;
}
