#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Multipoles.hh"
#include "../phi/Phi_Automatic.hh"

void Energy_Surface2::PHI_ME(Phi_Automatic& aut,
                             const DAT_ARRAY_CONSTS& array_consts,
                             const Multipoles& a1,
                             int LTE1,
                             const Multipoles& a2,
                             int LTE2,
                             int LTE){
//
//
// truncated multipole expansion of electrostatic interaction energy
//
   if( aut.ISOTROPIC ){
      aut.dedt= (0.00);
      aut.dedp= (0.00);
      aut.ddedrdt= (0.00);
      aut.ddedrdp= (0.00);
      aut.ddedtdt= (0.00);
      aut.ddedtdp= (0.00);
      aut.ddedpdp= (0.00);
      for(int i=0;i<3;i++){
         aut.dedq[i]= (0.00);
         aut.ddedqdr[i]= (0.00);
         aut.ddedqdt[i]= (0.00);
         aut.ddedqdp[i]= (0.00);
         for(int j=0;j<3;j++){
            aut.ddedqdq[i][j]= (0.00);
         }
      }
      aut.ISOTROPIC=false;
   }

   if( LTE1>LTE )LTE1=LTE;
   if( LTE2>LTE )LTE2=LTE;
   int LTEe=(LTE1+LTE2);
   if( LTEe>LTE )LTEe=LTE;
   Lprof[LTEe]++;

   aut.q1.populate(LTE1,a1);
   aut.q2.populate(LTE2,a2);
   aut.q2.chain(array_consts,aut.dq2,aut.ddq2);
   aut.QQ.populate(LTEe);
   aut.QQ.product(array_consts,aut.q1,aut.q2,aut.dq2,aut.ddq2,aut.QdQ,aut.QddQ);

   double Lr[11];
   if( aut.ZZ>(1.00) )aut.ZZ= (1.00);
   Lr[ 1]= aut.ZZ;
   for(int L=2;L<=(LTEe+3);L++){
      Lr[L  ]= aut.ZZ*Lr[L-1];
   }

   aut.H.populate(array_consts,LTEe,
                  aut.CT,aut.ST,aut.CP,aut.SP,
                  aut.dH,aut.ddH);

   double dFdt,dFdp,
          dFdq[3];
   double ddFdtdt,ddFdtdp,ddFdpdp,
          ddFdqdt[3],ddFdqdp[3],
          ddFdqdq[3][3];
   for(int L=0;L<=LTEe;L++){
      double F= (0.00);
      dFdt= (0.00);
      dFdp= (0.00);
      ddFdtdt= (0.00);
      ddFdtdp= (0.00);
      ddFdpdp= (0.00);
      for(int i=0;i<3;i++){
         dFdq[i]= (0.00);
         ddFdqdt[i]= (0.00);
         ddFdqdp[i]= (0.00);
         for(int j=0;j<3;j++){
            ddFdqdq[i][j]= (0.00);
         }
      }
      for(int M=-L;M<=L;M++){
         double F_r=( aut.QQ.r(L,M)*aut.H.r(L,M)
                     -aut.QQ.i(L,M)*aut.H.i(L,M));
         double F_i=( aut.QQ.r(L,M)*aut.H.i(L,M)
                     +aut.QQ.i(L,M)*aut.H.r(L,M));
         F+=F_r;
         dFdp+=(M)*F_i;
         ddFdpdp-=(M*M)*F_r;
         double dF_r=( aut.QQ.r(L,M)*aut.dH.r(L,M)
                      -aut.QQ.i(L,M)*aut.dH.i(L,M));
         double dF_i=( aut.QQ.r(L,M)*aut.dH.i(L,M)
                      +aut.QQ.i(L,M)*aut.dH.r(L,M));
         dFdt+=dF_r;
         ddFdtdp+=(M)*dF_i;
         double ddF_r=( aut.QQ.r(L,M)*aut.ddH.r(L,M)
                       -aut.QQ.i(L,M)*aut.ddH.i(L,M));
//       double ddF_i=( aut.QQ.r(L,M)*aut.ddH.i(L,M)
//                     +aut.QQ.i(L,M)*aut.ddH.r(L,M));
         ddFdtdt+=ddF_r;
         for(int i=0;i<3;i++){
            dF_r=( aut.QdQ[i].r(L,M)*aut.H.r(L,M)
                  -aut.QdQ[i].i(L,M)*aut.H.i(L,M));
            dF_i=( aut.QdQ[i].r(L,M)*aut.H.i(L,M)
                  +aut.QdQ[i].i(L,M)*aut.H.r(L,M));
            dFdq[i]+=dF_r;
            ddFdqdp[i]+=(M)*dF_i;
            ddF_r=( aut.QdQ[i].r(L,M)*aut.dH.r(L,M)
                   -aut.QdQ[i].i(L,M)*aut.dH.i(L,M));
//          ddF_i=( aut.QdQ[i].r(L,M)*aut.dH.i(L,M)
//                 +aut.QdQ[i].i(L,M)*aut.dH.r(L,M));
            ddFdqdt[i]+=ddF_r;
            for(int j=0;j<3;j++){
               ddF_r=( aut.QddQ[i][j].r(L,M)*aut.H.r(L,M)
                      -aut.QddQ[i][j].i(L,M)*aut.H.i(L,M));
//             ddF_i=( aut.QddQ[i][j].r(L,M)*aut.H.i(L,M)
//                    +aut.QddQ[i][j].i(L,M)*aut.H.r(L,M));
               ddFdqdq[i][j]+=ddF_r;
            }
         }
      }
      e1_Fe+=Lr[L+1]*F;
      aut.dedr-=(L+1)*Lr[L+2]*F;
      aut.dedt+=Lr[L+1]*dFdt;
      aut.dedp+=Lr[L+1]*dFdp;
      aut.ddedrdr+=(L+1)*(L+2)*Lr[L+3]*F;
      aut.ddedrdt-=(L+1)*Lr[L+2]*dFdt;
      aut.ddedrdp-=(L+1)*Lr[L+2]*dFdp;
      aut.ddedtdt+=Lr[L+1]*ddFdtdt;
      aut.ddedtdp+=Lr[L+1]*ddFdtdp;
      aut.ddedpdp+=Lr[L+1]*ddFdpdp;
      for(int i=0;i<3;i++){
         aut.dedq[i]+=Lr[L+1]*dFdq[i];
         aut.ddedqdr[i]-=(L+1)*Lr[L+2]*dFdq[i];
         aut.ddedqdt[i]+=Lr[L+1]*ddFdqdt[i];
         aut.ddedqdp[i]+=Lr[L+1]*ddFdqdp[i];
         for(int j=0;j<3;j++){
            aut.ddedqdq[i][j]+=Lr[L+1]*ddFdqdq[i][j];
         }
      }
   }
   return;
}
