#include "../phi/Energy_Surface.hh"

int Energy_Surface2::PHI_L(double r,
                           double d,
                           int Lmax) const {
   if( r<d )return Lmax;
   double z= (r/d);
   double y= (1.00)/(ethresh*d);
   double a= z;
   double b= y;
   for(int L=0;L<Lmax;L++){
      a*=z;
      b+=y;
      if( a>b )return L;
   }
   return Lmax;
}
