#include "../con/Subset_Contracted_System.hh"
#include "../phi/Block_Pair.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi_Automatic.hh"

void Energy_Surface2::PHI_A(const Phi_Automatic& aut,
                            const Subset_Contracted_System::tM3& con,
                            int jZ0,
                            int jQ2,
                            int iZ0,
                            int iQ2){
   if( jQ2>con.Z0[jZ0].Q2a ){
      if( iQ2>con.Z0[iZ0].Q2a ){
         int jU2=Q2[jQ2].U2;
         int iU2=Q2[iQ2].U2;
         int i1,i2;
         if( jU2<=iU2 ){
            i1=jU2;
            i2=iU2;
         }else{
            i1=iU2;
            i2=jU2;
         }
         const Block_Pair& e=Q2Q2e(jQ2,iQ2);
         double z1=( e(3,3)*Q2[jQ2].c(0,0)*Q2[iQ2].c(0,0)
                    +e(3,4)*Q2[jQ2].c(0,0)*Q2[iQ2].c(1,0)
                    +e(3,5)*Q2[jQ2].c(0,0)*Q2[iQ2].c(2,0)
                    +e(4,3)*Q2[jQ2].c(1,0)*Q2[iQ2].c(0,0)
                    +e(4,4)*Q2[jQ2].c(1,0)*Q2[iQ2].c(1,0)
                    +e(4,5)*Q2[jQ2].c(1,0)*Q2[iQ2].c(2,0)
                    +e(5,3)*Q2[jQ2].c(2,0)*Q2[iQ2].c(0,0)
                    +e(5,4)*Q2[jQ2].c(2,0)*Q2[iQ2].c(1,0)
                    +e(5,5)*Q2[jQ2].c(2,0)*Q2[iQ2].c(2,0));

         double z2=( e(0,3)*Z0Q2y(iZ0,jQ2)(0)*Q2[iQ2].c(0,0)
                    +e(0,4)*Z0Q2y(iZ0,jQ2)(0)*Q2[iQ2].c(1,0)
                    +e(0,5)*Z0Q2y(iZ0,jQ2)(0)*Q2[iQ2].c(2,0)
                    +e(1,3)*Z0Q2y(iZ0,jQ2)(1)*Q2[iQ2].c(0,0)
                    +e(1,4)*Z0Q2y(iZ0,jQ2)(1)*Q2[iQ2].c(1,0)
                    +e(1,5)*Z0Q2y(iZ0,jQ2)(1)*Q2[iQ2].c(2,0)
                    +e(2,3)*Z0Q2y(iZ0,jQ2)(2)*Q2[iQ2].c(0,0)
                    +e(2,4)*Z0Q2y(iZ0,jQ2)(2)*Q2[iQ2].c(1,0)
                    +e(2,5)*Z0Q2y(iZ0,jQ2)(2)*Q2[iQ2].c(2,0));

         double z3=( e(3,0)*Q2[jQ2].c(0,0)*Z0Q2y(iZ0,iQ2)(0)
                    +e(3,1)*Q2[jQ2].c(0,0)*Z0Q2y(iZ0,iQ2)(1)
                    +e(3,2)*Q2[jQ2].c(0,0)*Z0Q2y(iZ0,iQ2)(2)
                    +e(4,0)*Q2[jQ2].c(1,0)*Z0Q2y(iZ0,iQ2)(0)
                    +e(4,1)*Q2[jQ2].c(1,0)*Z0Q2y(iZ0,iQ2)(1)
                    +e(4,2)*Q2[jQ2].c(1,0)*Z0Q2y(iZ0,iQ2)(2)
                    +e(5,0)*Q2[jQ2].c(2,0)*Z0Q2y(iZ0,iQ2)(0)
                    +e(5,1)*Q2[jQ2].c(2,0)*Z0Q2y(iZ0,iQ2)(1)
                    +e(5,2)*Q2[jQ2].c(2,0)*Z0Q2y(iZ0,iQ2)(2));

         double z4=( e(0,0)*Z0Q2y(iZ0,jQ2)(0)*Z0Q2y(iZ0,iQ2)(0)
                    +e(0,1)*Z0Q2y(iZ0,jQ2)(0)*Z0Q2y(iZ0,iQ2)(1)
                    +e(0,2)*Z0Q2y(iZ0,jQ2)(0)*Z0Q2y(iZ0,iQ2)(2)
                    +e(1,0)*Z0Q2y(iZ0,jQ2)(1)*Z0Q2y(iZ0,iQ2)(0)
                    +e(1,1)*Z0Q2y(iZ0,jQ2)(1)*Z0Q2y(iZ0,iQ2)(1)
                    +e(1,2)*Z0Q2y(iZ0,jQ2)(1)*Z0Q2y(iZ0,iQ2)(2)
                    +e(2,0)*Z0Q2y(iZ0,jQ2)(2)*Z0Q2y(iZ0,iQ2)(0)
                    +e(2,1)*Z0Q2y(iZ0,jQ2)(2)*Z0Q2y(iZ0,iQ2)(1)
                    +e(2,2)*Z0Q2y(iZ0,jQ2)(2)*Z0Q2y(iZ0,iQ2)(2));

         U2U2a(i1,i2)+=aut.sgnj*( z1 +z2 +z3 +z4);
      }else{
         const Block_Pair& e=Q2Q2e(jQ2,iQ2);
         const Block_Pair& f=Q2Q2e(iQ2,jQ2);
         int iU2=Z0[iZ0].U2a;
         int kU2=Z0[jZ0].U2a;
         int jU2=Q2[jQ2].U2;
         for(int i=0;i<6;i++){
            U2U2a(iU2+i,jU2)+=aut.sgnj*(-e(0,i)*Z0Q2y(iZ0,jQ2)(0)
                                        -e(1,i)*Z0Q2y(iZ0,jQ2)(1)
                                        -e(2,i)*Z0Q2y(iZ0,jQ2)(2)
                                        -e(3,i)*Q2[jQ2].c(0,0)
                                        -e(4,i)*Q2[jQ2].c(1,0)
                                        -e(5,i)*Q2[jQ2].c(2,0));
            U2U2a(kU2+i,jU2)+=aut.sgnj*( f(i,0)*Z0Q2y(jZ0,jQ2)(0)
                                        +f(i,1)*Z0Q2y(jZ0,jQ2)(1)
                                        +f(i,2)*Z0Q2y(jZ0,jQ2)(2)
                                        +f(i,3)*Q2[jQ2].c(0,0)
                                        +f(i,4)*Q2[jQ2].c(1,0)
                                        +f(i,5)*Q2[jQ2].c(2,0));
         }
      }
   }else{
      if( iQ2>con.Z0[iZ0].Q2a ){
         const Block_Pair& e=Q2Q2e(jQ2,iQ2);
         const Block_Pair& f=Q2Q2e(iQ2,jQ2);
         int kU2=Z0[iZ0].U2a;
         int jU2=Z0[jZ0].U2a;
         int iU2=Q2[iQ2].U2;
         for(int i=0;i<6;i++){
            U2U2a(kU2+i,iU2)+=(-e(i,0)*Z0Q2y(iZ0,iQ2)(0)
                               -e(i,1)*Z0Q2y(iZ0,iQ2)(1)
                               -e(i,2)*Z0Q2y(iZ0,iQ2)(2)
                               -e(i,3)*Q2[iQ2].c(0,0)
                               -e(i,4)*Q2[iQ2].c(1,0)
                               -e(i,5)*Q2[iQ2].c(2,0));
            U2U2a(jU2+i,iU2)+=( f(0,i)*Z0Q2y(jZ0,iQ2)(0)
                               +f(1,i)*Z0Q2y(jZ0,iQ2)(1)
                               +f(2,i)*Z0Q2y(jZ0,iQ2)(2)
                               +f(3,i)*Q2[iQ2].c(0,0)
                               +f(4,i)*Q2[iQ2].c(1,0)
                               +f(5,i)*Q2[iQ2].c(2,0));
         }
      }else{
         const Block_Pair& e=Q2Q2e(jQ2,iQ2);
         Block_Pair g;
         const Block_Pair& h=Q2Q2e(iQ2,jQ2);
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               g(  i,  j)=-e(  i,  j);
               g(3+i,  j)=-e(3+i,  j)
                             -e(  0,  j)*Z0Z0y(jZ0,iZ0)(0,i)
                             -e(  1,  j)*Z0Z0y(jZ0,iZ0)(1,i)
                             -e(  2,  j)*Z0Z0y(jZ0,iZ0)(2,i);
               g(  i,3+j)=-e(  i,3+j);
               g(3+i,3+j)=-e(3+i,3+j)
                             -e(  0,3+j)*Z0Z0y(jZ0,iZ0)(0,i)
                             -e(  1,3+j)*Z0Z0y(jZ0,iZ0)(1,i)
                             -e(  2,3+j)*Z0Z0y(jZ0,iZ0)(2,i);
            }
         }
         int iU2=Z0[iZ0].U2a;
         int jU2=Z0[jZ0].U2a;
         for(int i=0;i<3;i++){
            U2g(jU2+i)+=h(i);
            U2g(iU2+i)+=e(i);
            for(int j=i;j<6;j++){
               U2U2a(jU2+i,jU2+j)+=h(j,i);
               U2U2a(iU2+i,iU2+j)+=e(i,j);
            }
         }
         for(int i=3;i<6;i++){
            U2g(jU2+i)+=h(i);
            U2g(iU2+i)+=e(i);
            for(int j=i;j<6;j++){
               U2U2a(jU2+i,jU2+j)+=h(j,i);
               U2U2a(iU2+i,iU2+j)+=e(j,i);
            }
         }
         for(int i=0;i<6;i++){
            for(int j=0;j<6;j++){
               U2U2a(jU2+i,iU2+j)+=g(i,j);
            }
         }
      }
   }
   return;
}
