#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Block_Pair.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi_Automatic.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include <vector>

class MEM_phi3_restch {
private:
   std::vector<int> o_Q2ORD;                    //order of generation
public:
   std::vector<std::vector<int> > o_Q2hQ2;      //connected Q2 with higher br
   std::vector<int> o_JNTQ2;                    //
   MEM_phi3_restch(int oQ2):
      o_Q2ORD(oQ2)
   {
   }
   int& Q2ORD(int i){
      return o_Q2ORD.at( i);  }
   std::vector<int>& Q2hQ2(int i){
      return o_Q2hQ2.at( i);  }
   int& JNTQ2(int i){
      return o_JNTQ2.at( i);  }
};

void Energy_Surface2::PHI3_RESTCH(Phi_Automatic& aut,
                                  const DAT_PHYSICS_CONSTS& physics_consts,
                                  const DAT_ARRAY_CONSTS& array_consts,
                                  Output_Streams& out,
                                  const Mechanical_System& mol,
                                  const Subset_Contracted_System::tM3& con){
   MEM_phi3_restch vv(oQ2);
   if( SURFACE ){
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int iQ2min=con.Z0[iZ0].Q2a;
         int iQ2max=(iQ2min-1+con.Z0[iZ0].cQ2);
         for(int iQ2=iQ2min;iQ2<=iQ2max;iQ2++){
            for(int jZ0= 0;jZ0<oZ0;jZ0++){
               int jQ2min=con.Z0[jZ0].Q2a;
               int jQ2max=(jQ2min-1+con.Z0[jZ0].cQ2);
               for(int jQ2=jQ2min;jQ2<=jQ2max;jQ2++){
                  Q2Q2e(iQ2,jQ2)=Q2Q2g(iQ2,jQ2);
               }
            }
         }
      }
   }
   Fr+=macro_Fr;
   Fe+=macro_Fe;
   Fs+=macro_Fs;
   Fh+=macro_Fh;
   TOT=( Fr +Fe +Fs +Ft +Fc +Fb +Fh +Fp +Fw);
//
//
// evaluate dTOT(dt,da) Q2Q2e(dt,da)
//
   aut.sgnj=(-1.00);
   for(int iZ0= 1;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      for(int iQ2=mQ2;iQ2<=nQ2;iQ2++){
         for(int jZ0= 0;jZ0<iZ0;jZ0++){
            int aQ2=con.Z0[jZ0].Q2a;
            int bQ2=(aQ2-1+con.Z0[jZ0].cQ2);
            for(int jQ2=aQ2;jQ2<=bQ2;jQ2++){
               PHI3_D(aut,
                      physics_consts,
                      con,jZ0,jQ2,iZ0,iQ2);
            }
         }
      }
   }
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      int BBw=mQ2;
      int SCa=(nQ2+1);
      int iQ2=mQ2;
      int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
      for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
         if( con.Q2[iQ2].omg==1 ){
            int L=iQ2hold;
            iQ2hold=(iQ2+1);
            iQ2=L;
         }else{
            iQ2++;
         }
         int br=con.Q2[iQ2].br;
         int cbr=con.Q2[iQ2].cbr;
         if( br==0 ){
            BBw=iQ2;
            SCa=(nQ2+1);
         }else{
            if( cbr==0 )SCa=iQ2;
         }
         int jQ2=mQ2;
         int jQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int jcQ2=(nQ2-mQ2)-(icQ2-1);jcQ2>0;jcQ2--){
            if( con.Q2[jQ2].omg==1 ){
               int L=jQ2hold;
               jQ2hold=(jQ2+1);
               jQ2=L;
            }else{
               jQ2++;
            }
            bool jPATH=false;
            if( con.Q2[jQ2].br<=br ){
               if( (jQ2<=BBw)||
                   (jQ2>=SCa) )jPATH=true;
// jQ2 is in the path to iQ2
            }
            aut.sgnj=( jPATH )? ( 1.00): (-1.00);
            PHI3_D(aut,
                   physics_consts,
                   con,iZ0,jQ2,iZ0,iQ2);
         }
      }
   }
   if( !SURFACE )return;
//
//
// contract Q2Q2 interchain
//
   for(int iZ0= 1;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      for(int jZ0= 0;jZ0<iZ0;jZ0++){
         int aQ2=con.Z0[jZ0].Q2a;
         int bQ2=(aQ2-1+con.Z0[jZ0].cQ2);
// con.Q2[nQ2+1].jnt=mQ2
         {
            int iQ2ent=mQ2;
            int iQ2=mQ2;
            int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
            for(int icQ2=(nQ2-mQ2+1);icQ2>0;icQ2--){
               int ibr=con.Q2[iQ2].br;
               if( ((con.Q2[iQ2+1].jnt!=iQ2)&&(ibr>0))||
                   (icQ2==1) ){
// iQ2 is the terminal torsion of a branch
                  int jQ2=aQ2;
                  int jQ2hold=(aQ2+con.Z0[jZ0].cQ2bb);
                  for(int jcQ2=(bQ2-aQ2+1);jcQ2>0;jcQ2--){
                     int jbr=con.Q2[jQ2].br;
                     if( ((con.Q2[jQ2+1].jnt!=jQ2)&&(jbr>0))||
                         (jcQ2==1) ){
// jQ2 is the terminal torsion of a branch

                        for(int kQ2=iQ2;kQ2>mQ2;kQ2=con.Q2[kQ2].jnt){
                           for(int lQ2=jQ2;;lQ2=con.Q2[lQ2].jnt){
                              Block_Pair e=Q2Q2e(lQ2,kQ2);
                              e.transform(aut.Q2[lQ2].c,
                                          aut.Q2[lQ2].x-Q2[mQ2].backup_x,
                                          Q2[lQ2].backup_c,
                                          Q2[lQ2].backup_x-Q2[mQ2].backup_x,
                                          extend( aut.Q2[iQ2ent].c,
                                                 -U2d(Q2[iQ2ent].U2)),
                                          aut.Q2[iQ2ent].x-Q2[mQ2].backup_x,
                                          Q2[iQ2ent].backup_c,
                                          Q2[iQ2ent].backup_x-Q2[mQ2].backup_x);
                              Q2Q2e(iQ2ent,kQ2)+=e;
                              if( lQ2==aQ2 )break;
                              if( (jcQ2>1)&&
                                  (con.Q2[lQ2].cbr<jbr) )break;
                           }
                           if( (icQ2>1)&&
                               (con.Q2[kQ2].cbr<ibr) )break;
                        }

                     }
                     if( con.Q2[jQ2].omg==1 ){
                        int L=jQ2hold;
                        jQ2hold=(jQ2+1);
                        jQ2=L;
                     }else{
                        jQ2++;
                     }
                  }
               }
               if( con.Q2[iQ2].omg==1 ){
                  int L=iQ2hold;
                  iQ2hold=(iQ2+1);
                  iQ2=L;
               }else{
                  iQ2++;
               }
               if( con.Q2[iQ2].jnt==mQ2 )iQ2ent=iQ2;
            }
         }
         {
            int iQ2=mQ2;
            int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
            for(int icQ2=(nQ2-mQ2+1);icQ2>0;icQ2--){
               int ibr=con.Q2[iQ2].br;
               if( ((con.Q2[iQ2+1].jnt!=iQ2)&&(ibr>0))||
                   (icQ2==1) ){
// iQ2 is the terminal torsion of a branch
                  vv.o_Q2hQ2.resize(bQ2-aQ2+1);
                  int jQ2ent=aQ2;
                  int jQ2=aQ2;
                  int jQ2hold=(aQ2+con.Z0[jZ0].cQ2bb);
                  for(int jcQ2=(bQ2-aQ2+1);jcQ2>0;jcQ2--){
                     int jbr=con.Q2[jQ2].br;
                     if( jQ2>aQ2 ){
                        int gQ2=con.Q2[jQ2].jnt;
                        if( con.Q2[gQ2].br<jbr ){
                           vv.Q2hQ2(gQ2-aQ2).push_back(jQ2);
                        }
                     }
                     if( ((con.Q2[jQ2+1].jnt!=jQ2)&&(jbr>0))||
                         (jcQ2==1) ){
// jQ2 is the terminal torsion of a branch

                        for(int kQ2=iQ2;;kQ2=con.Q2[kQ2].jnt){
                           int gQ2=( kQ2>mQ2 )? con.Q2[kQ2].jnt: jQ2ent;
                           int hQ2=0;
                           for(int lQ2=jQ2;;lQ2=con.Q2[lQ2].jnt){
                              if( kQ2>mQ2 ){
                                 Q2Q2e(lQ2,gQ2)+=Q2Q2e(lQ2,kQ2);
                              }else if( lQ2>aQ2 ){
                                 Block_Pair e=Q2Q2e(lQ2,kQ2);
                                 Rotation_Matrix ROT= Q2[lQ2].backup_c
                                                     *transpose(aut.Q2[lQ2].c);
                                 Coordinates TRANS=( Q2[lQ2].backup_x
                                                    -ROT*aut.Q2[lQ2].x);
                                 Coordinates xi=( TRANS +ROT*aut.Q2[mQ2].x);
                                 Coordinates xj=( TRANS +ROT*aut.Q2[aQ2].x);
                                 Rotation_Matrix p;
                                 Coordinates t=( xi -xj);
                                 for(int j=0;j<3;j++){
                                    Coordinates b= array_consts.dROTx[j]*t;
                                    for(int i=0;i<3;i++){
                                       p(i,j)= b(i);
                                    }
                                 }
                                 Block_Pair g,h;
                                 for(int i=0;i<3;i++){
                                    h(  i)=-e(  i);
                                    h(3+i)=-e(3+i)
                                           -e(  0)*p(0,i)
                                           -e(  1)*p(1,i)
                                           -e(  2)*p(2,i);
                                 }
                                 for(int i=0;i<3;i++){
                                    for(int j=0;j<3;j++){
                                       g(  i,  j)=-e(  i,  j);
                                       g(3+i,  j)=-e(3+i,  j)
                                                  -e(  0,  j)*p(0,i)
                                                  -e(  1,  j)*p(1,i)
                                                  -e(  2,  j)*p(2,i);
                                       g(  i,3+j)=-e(  i,3+j);
                                       g(3+i,3+j)=-e(3+i,3+j)
                                                  -e(  0,3+j)*p(0,i)
                                                  -e(  1,3+j)*p(1,i)
                                                  -e(  2,3+j)*p(2,i);
                                    }
                                 }
                                 for(int i=0;i<3;i++){
                                    for(int j=0;j<3;j++){
                                       h(  j,  i)=-g(  i,  j);
                                       h(  j,3+i)=-g(3+i,  j);
                                       h(3+j,  i)=-g(  i,3+j)
                                                  -g(  i,  0)*p(0,j)
                                                  -g(  i,  1)*p(1,j)
                                                  -g(  i,  2)*p(2,j);
                                       h(3+j,3+i)=-g(3+i,3+j)
                                                  -g(3+i,  0)*p(0,j)
                                                  -g(3+i,  1)*p(1,j)
                                                  -g(3+i,  2)*p(2,j);
                                    }
                                 }
                                 h.transform(
                                         aut.Q2[kQ2].c,
                                         aut.Q2[kQ2].x-Q2[aQ2].backup_x,
                                         Q2[kQ2].backup_c,
                                         Q2[kQ2].backup_x-Q2[aQ2].backup_x,
                                         extend( aut.Q2[jQ2ent].c,
                                                -U2d(Q2[jQ2ent].U2)),
                                         aut.Q2[jQ2ent].x-Q2[aQ2].backup_x,
                                         Q2[jQ2ent].backup_c,
                                         Q2[jQ2ent].backup_x-Q2[aQ2].backup_x);
                                 Q2Q2e(jQ2ent,lQ2)+=h;
                              }
                              if( lQ2!=jQ2 ){
                                 Block_Pair e=Q2Q2e(hQ2,kQ2);
                                 e.transform(
                                         aut.Q2[hQ2].c,
                                         aut.Q2[hQ2].x-Q2[mQ2].backup_x,
                                         Q2[hQ2].backup_c,
                                         Q2[hQ2].backup_x-Q2[mQ2].backup_x,
                                         aut.Q2[lQ2].c,
                                         aut.Q2[lQ2].x-Q2[mQ2].backup_x,
                                         Q2[lQ2].backup_c,
                                         Q2[lQ2].backup_x-Q2[mQ2].backup_x);
                                 Q2Q2e(lQ2,kQ2)+=e;
                                 for(size_t j=0;j<vv.Q2hQ2(lQ2-aQ2).size();j++){
                                    int tQ2=vv.Q2hQ2(lQ2-aQ2)[j];
                                    if( tQ2==hQ2 )continue;
                                    Block_Pair e=Q2Q2e(tQ2,kQ2);
                                    e.transform(
                                            aut.Q2[tQ2].c,
                                            aut.Q2[tQ2].x-Q2[mQ2].backup_x,
                                            Q2[tQ2].backup_c,
                                            Q2[tQ2].backup_x-Q2[mQ2].backup_x,
                                            aut.Q2[lQ2].c,
                                            aut.Q2[lQ2].x-Q2[mQ2].backup_x,
                                            Q2[lQ2].backup_c,
                                            Q2[lQ2].backup_x-Q2[mQ2].backup_x);
                                    Q2Q2e(lQ2,kQ2)+=e;
                                 }
                              }
                              if( lQ2==aQ2 )break;
                              if( (jcQ2>1)&&
                                  (con.Q2[lQ2].cbr<jbr) )break;
                              hQ2=lQ2;
                           }
                           if( kQ2==mQ2 )break;
                           if( (icQ2>1)&&
                               (con.Q2[kQ2].cbr<ibr) )break;
                        }

                     }
                     if( con.Q2[jQ2].omg==1 ){
                        int L=jQ2hold;
                        jQ2hold=(jQ2+1);
                        jQ2=L;
                     }else{
                        jQ2++;
                     }
                     if( con.Q2[jQ2].jnt==aQ2 )jQ2ent=jQ2;
                  }
                  vv.o_Q2hQ2.clear();
               }
               if( con.Q2[iQ2].omg==1 ){
                  int L=iQ2hold;
                  iQ2hold=(iQ2+1);
                  iQ2=L;
               }else{
                  iQ2++;
               }
            }
         }
      }
   }
//
//
// contract Q2Q2 intrachain
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      vv.o_JNTQ2.resize(nQ2-mQ2);
      int iORD=0;
      int iBBw=mQ2;
      int iSCa=(nQ2+1);
      int iQ2=mQ2;
      int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
      for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
         if( con.Q2[iQ2].omg==1 ){
            int L=iQ2hold;
            iQ2hold=(iQ2+1);
            iQ2=L;
         }else{
            iQ2++;
         }
         vv.Q2ORD(iQ2)=iORD++;
         int ibr=con.Q2[iQ2].br;
         int icbr=con.Q2[iQ2].cbr;
         if( ibr==0 ){
            iBBw=iQ2;
            iSCa=(nQ2+1);
         }else{
            if( icbr==0 )iSCa=iQ2;
         }
         if( (con.Q2[iQ2+1].jnt!=iQ2)&&
             ((ibr>0)||(icQ2==1)) ){
// iQ2 is the terminal torsion of a branch
            int nJNT=0;
            int jBBw=mQ2;
            int jSCa=(nQ2+1);
            int jQ2=mQ2;
            int jQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
            for(int jcQ2=(nQ2-mQ2)-(icQ2-1);jcQ2>0;jcQ2--){
               if( con.Q2[jQ2].omg==1 ){
                  int L=jQ2hold;
                  jQ2hold=(jQ2+1);
                  jQ2=L;
               }else{
                  jQ2++;
               }
               int jbr=con.Q2[jQ2].br;
               int jcbr=con.Q2[jQ2].cbr;
               if( jbr==0 ){
                  jBBw=jQ2;
                  jSCa=(nQ2+1);
               }else{
                  if( jcbr==0 )jSCa=jQ2;
               }
               if( (jQ2<=iBBw)||((jQ2>=iSCa)&&(jbr<=ibr)) ){
// jQ2 is in the path to iQ2
                  int hQ2=con.Q2[jQ2].jnt;
                  int gQ2;
                  for(int kQ2=iQ2;kQ2>=jQ2;kQ2=gQ2){
                     gQ2=con.Q2[kQ2].jnt;
                     if( gQ2>=jQ2 ){
                        Q2Q2e(jQ2,gQ2)+=Q2Q2e(jQ2,kQ2);
                     }
                     if( hQ2>mQ2 ){
                        Block_Pair e=Q2Q2e(hQ2,kQ2);
                        e.transform(
                                extend(aut.Q2[hQ2].c,-U2d(Q2[hQ2].U2)),
                                aut.Q2[hQ2].x-Q2[mQ2].backup_x,
                                Q2[hQ2].backup_c,
                                Q2[hQ2].backup_x-Q2[mQ2].backup_x,
                                extend(aut.Q2[jQ2].c,-U2d(Q2[jQ2].U2)),
                                aut.Q2[jQ2].x-Q2[mQ2].backup_x,
                                Q2[jQ2].backup_c,
                                Q2[jQ2].backup_x-Q2[mQ2].backup_x);
                        Q2Q2e(jQ2,kQ2)+=e;
                     }
                     if( nJNT>0 ){
                        for(int iJNT=0;iJNT<nJNT;iJNT++){
                           int aQ2=vv.JNTQ2(iJNT);
                           Block_Pair e=Q2Q2e(aQ2,kQ2);
                           e.transform(
                                   aut.Q2[aQ2].c,
                                   aut.Q2[aQ2].x-Q2[mQ2].backup_x,
                                   Q2[aQ2].backup_c,
                                   Q2[aQ2].backup_x-Q2[mQ2].backup_x,
                                   extend(aut.Q2[jQ2].c,-U2d(Q2[jQ2].U2)),
                                   aut.Q2[jQ2].x-Q2[mQ2].backup_x,
                                   Q2[jQ2].backup_c,
                                   Q2[jQ2].backup_x-Q2[mQ2].backup_x);
                           Q2Q2e(jQ2,kQ2)+=e;
                        }
                     }
                     if( (con.Q2[gQ2].br<ibr)&&(icQ2>1) )break;
                  }
                  nJNT=0;
               }else{
                  if( (jcbr==0)||((jQ2>=iSCa)&&(jcbr<jbr)) ){
                     vv.JNTQ2(nJNT++)=jQ2;
                  }
                  if( con.Q2[jQ2+1].jnt!=jQ2 ){
// jQ2 is the terminal torsion of a branch
                     int gQ2;
                     int tQ2;
                     bool gPATH=true;
                     for(int kQ2=iQ2;kQ2!=jQ2;kQ2=gQ2){
                        if( (kQ2<=iBBw)||
                            ((kQ2>=iSCa)&&(con.Q2[kQ2].br<=ibr)) ){
// kQ2 is in the path to iQ2
                           tQ2=kQ2;
                           gQ2=con.Q2[kQ2].jnt;
                           if( gQ2==jBBw ){
                              gQ2=jSCa;
                              gPATH=false;
                           }else if( (gQ2>=iSCa)&&(gQ2<jQ2) ){
                              gQ2++;
                              gPATH=false;
                           }
                        }else{
                           gQ2=(kQ2+1);
                           while( con.Q2[gQ2].br>jbr ){
                              gQ2++;
                           }
                        }
                        int hQ2=0;
                        for(int lQ2=jQ2;;lQ2=con.Q2[lQ2].jnt){
                           if( gPATH ){
                              if( lQ2!=kQ2 ){
                                 Q2Q2e(lQ2,gQ2)+=Q2Q2e(lQ2,kQ2);
                              }
                              if( lQ2!=jQ2 ){
                                 Block_Pair e=Q2Q2e(hQ2,kQ2);
                                 e.transform(
                                         aut.Q2[hQ2].c,
                                         aut.Q2[hQ2].x-Q2[mQ2].backup_x,
                                         Q2[hQ2].backup_c,
                                         Q2[hQ2].backup_x-Q2[mQ2].backup_x,
                                         aut.Q2[lQ2].c,
                                         aut.Q2[lQ2].x-Q2[mQ2].backup_x,
                                         Q2[lQ2].backup_c,
                                         Q2[lQ2].backup_x-Q2[mQ2].backup_x);
                                 Q2Q2e(lQ2,kQ2)+=e;
                                 if( con.Q2[lQ2+1].br>con.Q2[lQ2].br ){
                                    Block_Pair e=Q2Q2e(lQ2+1,kQ2);
                                    e.transform(
                                            aut.Q2[lQ2+1].c,
                                            aut.Q2[lQ2+1].x-Q2[mQ2].backup_x,
                                            Q2[lQ2+1].backup_c,
                                            Q2[lQ2+1].backup_x-Q2[mQ2].backup_x,
                                            aut.Q2[lQ2].c,
                                            aut.Q2[lQ2].x-Q2[mQ2].backup_x,
                                            Q2[lQ2].backup_c,
                                            Q2[lQ2].backup_x-Q2[mQ2].backup_x);
                                    Q2Q2e(lQ2,kQ2)+=e;
                                 }
                              }
                           }else{
                              if( (lQ2!=jQ2)&&(kQ2==tQ2) ){
                                 Block_Pair e=Q2Q2e(hQ2,kQ2);
                                 e.transform(
                                         aut.Q2[hQ2].c,
                                         aut.Q2[hQ2].x-Q2[mQ2].backup_x,
                                         Q2[hQ2].backup_c,
                                         Q2[hQ2].backup_x-Q2[mQ2].backup_x,
                                         aut.Q2[lQ2].c,
                                         aut.Q2[lQ2].x-Q2[mQ2].backup_x,
                                         Q2[lQ2].backup_c,
                                         Q2[lQ2].backup_x-Q2[mQ2].backup_x);
                                 Q2Q2e(lQ2,kQ2)+=e;
                                 if( con.Q2[lQ2+1].br>con.Q2[lQ2].br ){
                                    Block_Pair e=Q2Q2e(lQ2+1,kQ2);
                                    e.transform(
                                            aut.Q2[lQ2+1].c,
                                            aut.Q2[lQ2+1].x-Q2[mQ2].backup_x,
                                            Q2[lQ2+1].backup_c,
                                            Q2[lQ2+1].backup_x-Q2[mQ2].backup_x,
                                            aut.Q2[lQ2].c,
                                            aut.Q2[lQ2].x-Q2[mQ2].backup_x,
                                            Q2[lQ2].backup_c,
                                            Q2[lQ2].backup_x-Q2[mQ2].backup_x);
                                    Q2Q2e(lQ2,kQ2)+=e;
                                 }
                              }
                              if( lQ2!=kQ2 ){
                                 int aQ2=lQ2;
                                 int bQ2=gQ2;
                                 if( vv.Q2ORD(lQ2)>vv.Q2ORD(gQ2) ){
                                    aQ2=gQ2;
                                    bQ2=lQ2;
                                 }
                                 Block_Pair e=Q2Q2e(lQ2,tQ2);
                                 e.transform(
                                         aut.Q2[lQ2].c,
                                         aut.Q2[lQ2].x-Q2[mQ2].backup_x,
                                         Q2[lQ2].backup_c,
                                         Q2[lQ2].backup_x-Q2[mQ2].backup_x,
                                         extend( aut.Q2[gQ2].c,
                                                -U2d(Q2[gQ2].U2)),
                                         aut.Q2[gQ2].x-Q2[mQ2].backup_x,
                                         Q2[gQ2].backup_c,
                                         Q2[gQ2].backup_x-Q2[mQ2].backup_x);
                                 Q2Q2e(aQ2,bQ2)-=e;
                              }
                           }
                           if( lQ2==kQ2 )break;
                           if( con.Q2[lQ2].cbr<jbr )break;
                           hQ2=lQ2;
                        }
                        if( (con.Q2[gQ2].br<ibr)&&(icQ2>1) )break;
                     }
                  }
               }
            }
         }
      }
      vv.o_JNTQ2.clear();
   }
//
//
// Q2Q2e-->gA
//
   aut.sgnj=(-1.00);
   for(int iZ0= 1;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      for(int iQ2=mQ2;iQ2<=nQ2;iQ2++){
         for(int jZ0= 0;jZ0<iZ0;jZ0++){
            int aQ2=con.Z0[jZ0].Q2a;
            int bQ2=(aQ2-1+con.Z0[jZ0].cQ2);
            for(int jQ2=aQ2;jQ2<=bQ2;jQ2++){
               PHI3_A(aut,array_consts,con,jZ0,jQ2,iZ0,iQ2);
            }
         }
      }
   }
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      int BBw=mQ2;
      int SCa=(nQ2+1);
      int iQ2=mQ2;
      int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
      for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
         if( con.Q2[iQ2].omg==1 ){
            int L=iQ2hold;
            iQ2hold=(iQ2+1);
            iQ2=L;
         }else{
            iQ2++;
         }
         int br=con.Q2[iQ2].br;
         int cbr=con.Q2[iQ2].cbr;
         if( br==0 ){
            BBw=iQ2;
            SCa=(nQ2+1);
         }else{
            if( cbr==0 )SCa=iQ2;
         }
         PHI3_G(iZ0,iQ2);
         int jQ2=mQ2;
         int jQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int jcQ2=(nQ2-mQ2)-(icQ2-1);jcQ2>0;jcQ2--){
            if( con.Q2[jQ2].omg==1 ){
               int L=jQ2hold;
               jQ2hold=(jQ2+1);
               jQ2=L;
            }else{
               jQ2++;
            }
            bool jPATH=false;
            if( con.Q2[jQ2].br<=br ){
               if( (jQ2<=BBw)||
                   (jQ2>=SCa) )jPATH=true;
// jQ2 is in the path to iQ2
            }
            aut.sgnj=( jPATH )? ( 1.00): (-1.00);
            PHI3_A(aut,array_consts,con,iZ0,jQ2,iZ0,iQ2);
         }
      }
   }
   return;
}
