#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Block_Pair.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi_Automatic.hh"
#include "../phi/Rotation_Matrix.hh"
#include <iostream>
#include <iomanip>
#include <cmath>

void Energy_Surface2::PHI3_D(const Phi_Automatic& aut,
                             const DAT_PHYSICS_CONSTS& physics_consts,
                             const Subset_Contracted_System::tM3& con,
                             int jZ0,
                             int jQ2,
                             int iZ0,
                             int iQ2){
   double CAL=physics_consts.CAL;
// double ANG=physics_consts.ANG;
// double RAD=physics_consts.RAD;
//
//
// translate block pair surface
//
   if( SURFACE ){
   }else{
      Q2Q2e(jQ2,iQ2)=Q2Q2g(jQ2,iQ2);
   }
   Block_Pair& g=Q2Q2e(jQ2,iQ2);
   if( g( 0)==(0.00) )return;
   int mQ2=con.Z0[iZ0].Q2a;
   g.translate(Q2[iQ2].backup_x-Q2[mQ2].backup_x);
//
//
// transformation (TRANS,ROT) to normalize backward group
//
   Rotation_Matrix ROT;
   Coordinates TRANS;
   {
      Rotation_Matrix cj=aut.Q2[jQ2].c;
      if( aut.sgnj>( 0.00) ){
         cj.extend(-U2d( Q2[jQ2].U2));
      }
      ROT=Q2[jQ2].backup_c*transpose(cj);
      TRANS=( Q2[jQ2].backup_x -ROT*aut.Q2[jQ2].x);
   }
//
//
// normalize forward group
//
   Rotation_Matrix ci=ROT*aut.Q2[iQ2].c;
   Coordinates xi=( TRANS +ROT*aut.Q2[iQ2].x);
//
//
// transformation (dt,P(da)) of forward group
//
   Rotation_Matrix P=ci*transpose(Q2[iQ2].backup_c);
   Coordinates dt=( xi -Q2[iQ2].backup_x);
//
//
// extract da(gam,bet,alp) from P
//
   Coordinates da;
   double aSbet= P(2,0);
   double aCbet= std::sqrt( (1.00) -aSbet*aSbet);
   da(1)= std::atan2(aSbet,aCbet);
   double aCalp=( P(2,2)/aCbet);
   double aSalp=(-P(2,1)/aCbet);
   da(0)= std::atan2(aSalp,aCalp);
   double aCgam=( P(0,0)/aCbet);
   double aSgam=(-P(1,0)/aCbet);
   da(2)= std::atan2(aSgam,aCgam);
//
//
// bound large (dt,da) displacements
//
   if( SURFACE ){
      double z=( (  .25)*dot(dt,dt) +(64.00)*dot(da,da));
      if( z>(200.00) ){
         g.bound(jQ2,iQ2,
                 (ethresh*(1.00e+5)/CAL),
                 (  .50)*dt,
                 ( 8.00)*da);
      }
   }
//
//
// partition g
//
   Coordinates t,a;
   for(int i=0;i<3;i++){
      t(i)= g(  i);
      a(i)= g(3+i);
   }
   Rotation_Matrix tt,ta;
   for(int i=0;i<3;i++){
      for(int j=0;j<3;j++){
         tt(i,j)= g(  i,  j);
         ta(i,j)= g(  i,3+j);
      }
   }
   Rotation_Matrix aa;
   aa(0,0)= g(3,3);
   aa(1,0)= g(4,3);
   aa(2,0)= g(5,3);
   aa(0,1)= g(4,3);
   aa(1,1)= g(4,4);
   aa(2,1)= g(5,4);
   aa(0,2)= g(5,3);
   aa(1,2)= g(5,4);
   aa(2,2)= g(5,5);
   Rotation_Matrix bb;
   bb(0,0)= g(3,3);
   bb(1,0)= g(3,4);
   bb(2,0)= g(3,5);
   bb(0,1)= g(3,4);
   bb(1,1)= g(4,4);
   bb(2,1)= g(5,4);
   bb(0,2)= g(3,5);
   bb(1,2)= g(5,4);
   bb(2,2)= g(5,5);
   Rotation_Matrix cc;
   cc(0,0)= g(3,3);
   cc(1,0)= g(4,3);
   cc(2,0)= g(3,5);
   cc(0,1)= g(4,3);
   cc(1,1)= g(4,4);
   cc(2,1)= g(4,5);
   cc(0,2)= g(3,5);
   cc(1,2)= g(4,5);
   cc(2,2)= g(5,5);
//
//
// calc energy impulse e(dt +P(gam,bet,alp)*x)
//
   double t_dt= dot(t,dt);
   Coordinates tt_dt= tt*dt;
   double dt_tt_dt= (.50)*dot(dt,tt_dt);
   Coordinates dt_ta= dt*ta;
   double a_da= dot(a,da);
   Coordinates ta_da= ta*da;
   double dt_ta_da= dot(dt,ta_da);
   Coordinates aa_da= aa*da;
   double da_aa_da= (.50)*dot(da,aa_da);
   double af=( t_dt +a_da +dt_tt_dt +dt_ta_da +da_aa_da);
   TOT+=(af/(3.00));
//
//
// extract db(alp,gam,bet) from P
//
   Coordinates db;
   double bSgam= P(0,1);
   double bCgam= std::sqrt( (1.00) -bSgam*bSgam);
   db(2)= std::atan2(bSgam,bCgam);
   double bCalp=( P(1,1)/bCgam);
   double bSalp=(-P(2,1)/bCgam);
   db(0)= std::atan2(bSalp,bCalp);
   double bCbet=( P(0,0)/bCgam);
   double bSbet=(-P(0,2)/bCgam);
   db(1)= std::atan2(bSbet,bCbet);
//
//
// alternative e(dt +P(alp,gam,bet)*x)
//
   double a_db= dot(a,db);
   Coordinates ta_db= ta*db;
   double dt_ta_db= dot(dt_ta,db);
   Coordinates bb_db= bb*db;
   double db_bb_db= (.50)*dot(db,bb_db);
   double bf=( t_dt +a_db +dt_tt_dt +dt_ta_db +db_bb_db);
   TOT+=(bf/(3.00));
//
//
// extract dc(bet,alp,gam) from P
//
   Coordinates dc;
   double cSalp= P(1,2);
   double cCalp= std::sqrt( (1.00) -cSalp*cSalp);
   dc(0)= std::atan2(cSalp,cCalp);
   double cCbet=( P(2,2)/cCalp);
   double cSbet=(-P(0,2)/cCalp);
   dc(1)= std::atan2(cSbet,cCbet);
   double cCgam=( P(1,1)/cCalp);
   double cSgam=(-P(1,0)/cCalp);
   dc(2)= std::atan2(cSgam,cCgam);
//
//
// alternative e(dt+P(bet,alp,gam)*x)
//
   double a_dc= dot(a,dc);
   Coordinates ta_dc= ta*dc;
   double dt_ta_dc= dot(dt_ta,dc);
   Coordinates cc_dc= cc*dc;
   double dc_cc_dc= (.50)*dot(dc,cc_dc);
   double cf=( t_dt +a_dc +dt_tt_dt +dt_ta_dc +dc_cc_dc);
   TOT+=(cf/(3.00));
//
//
//
//
   double eUNIT= (1.00e+5)*ethresh;
   if      ( eUNIT<(0.01) ){
//    eUNIT= (0.01);
   }else if( eUNIT>(2.00) ){
      eUNIT= (2.00);
   }
   double w= (8.00)*CAL/eUNIT;
   TOT+=w*( std::pow(( bf -af),2)
           +std::pow(( cf -af),2)
           +std::pow(( cf -bf),2));
   if( SURFACE ){
//
//
// diagnostic output of divergence
//
////  double T1=w*( std::pow(( bf -af),2)
////               +std::pow(( cf -af),2)
////               +std::pow(( cf -bf),2));
////  if( T1>((1.00e-1)*eUNIT/CAL) ){
////      std::cout<< std::fixed
////               <<" iQ2="<< std::setw( 3)<<iQ2
////               <<" jQ2="<< std::setw( 3)<<jQ2
////               << std::setprecision( 5)
////               <<" eUNIT="<< std::setw(12)<<(eUNIT/CAL)
////               << std::setprecision( 2)
////               <<" w="<< std::setw(12)<<w
////               << std::setprecision( 5)
////               <<" T1/eUNIT="<< std::setw(12)<<(T1/(eUNIT/CAL))<< std::endl;
////      std::cout<< std::setprecision( 5)
////               <<" dt="<< std::setw( 8)<<(dt(0)*ANG)
////                       << std::setw( 8)<<(dt(1)*ANG)
////                       << std::setw( 8)<<(dt(2)*ANG)<<'\n';
////      std::cout<< std::setprecision( 3)
////               <<" da="<< std::setw( 8)<<(da(0)/RAD)
////                       << std::setw( 8)<<(da(1)/RAD)
////                       << std::setw( 8)<<(da(2)/RAD)<<'\n';
////      std::cout<< std::setprecision( 3)
////               <<" db="<< std::setw( 8)<<(db(0)/RAD)
////                       << std::setw( 8)<<(db(1)/RAD)
////                       << std::setw( 8)<<(db(2)/RAD)<<'\n';
////      std::cout<< std::setprecision( 3)
////               <<" dc="<< std::setw( 8)<<(dc(0)/RAD)
////                       << std::setw( 8)<<(dc(1)/RAD)
////                       << std::setw( 8)<<(dc(2)/RAD)<<'\n';
////      std::cout<< std::setprecision( 3)
////               <<" ci="<< std::setw( 8)<<(ci(0,0))
////                       << std::setw( 8)<<(ci(1,0))
////                       << std::setw( 8)<<(ci(2,0))<<'\n';
////      std::cout<< std::setprecision( 3)
////               <<" c0="<< std::setw( 8)<<(backup_Q2c[iQ2](0,0))
////                       << std::setw( 8)<<(backup_Q2c[iQ2](1,0))
////                       << std::setw( 8)<<(backup_Q2c[iQ2](2,0))<<'\n';
////      std::cout<< std::setprecision( 6)
////               <<" t_dt="<< std::setw( 9)<<(t_dt*CAL)
////               <<" dt_tt_dt="<< std::setw( 9)<<(dt_tt_dt*CAL)<<'\n'
////               <<" a_da="<< std::setw( 9)<<(a_da*CAL)
////               <<" a_db="<< std::setw( 9)<<(a_db*CAL)
////               <<" a_dc="<< std::setw( 9)<<(a_dc*CAL)<<'\n'
////               <<" dt_ta_da="<< std::setw( 9)<<(dt_ta_da*CAL)
////               <<" dt_ta_db="<< std::setw( 9)<<(dt_ta_db*CAL)
////               <<" dt_ta_dc="<< std::setw( 9)<<(dt_ta_dc*CAL)<<'\n'
////               <<" da_aa_da="<< std::setw( 9)<<(da_aa_da*CAL)
////               <<" db_bb_db="<< std::setw( 9)<<(db_bb_db*CAL)
////               <<" dc_cc_dc="<< std::setw( 9)<<(dc_cc_dc*CAL)<<'\n';
////  }
//
//
// derivatives of dt wrt rotation
//
      Block_Pair dtau0,dtau1,dtau2;
      dtau0(3)=( 0.00);
      dtau1(3)= dt(2);
      dtau2(3)=-dt(1);
      dtau0(4)=-dt(2);
      dtau1(4)=( 0.00);
      dtau2(4)= dt(0);
      dtau0(5)= dt(1);
      dtau1(5)=-dt(0);
      dtau2(5)=( 0.00);
      dtau0(3,3)=( 0.00);
      dtau1(3,3)=-dt(1);
      dtau2(3,3)=-dt(2);
      dtau0(4,3)= dt(1);
      dtau1(4,3)=( 0.00);
      dtau2(4,3)=( 0.00);
      dtau0(5,3)= dt(2);
      dtau1(5,3)=( 0.00);
      dtau2(5,3)=( 0.00);
      dtau0(3,4)=( 0.00);
      dtau1(3,4)= dt(0);
      dtau2(3,4)=( 0.00);
      dtau0(4,4)=-dt(0);
      dtau1(4,4)=( 0.00);
      dtau2(4,4)=-dt(2);
      dtau0(5,4)=( 0.00);
      dtau1(5,4)= dt(2);
      dtau2(5,4)=( 0.00);
      dtau0(3,5)=( 0.00);
      dtau1(3,5)=( 0.00);
      dtau2(3,5)= dt(0);
      dtau0(4,5)=( 0.00);
      dtau1(4,5)=( 0.00);
      dtau2(4,5)= dt(1);
      dtau0(5,5)=-dt(0);
      dtau1(5,5)=-dt(1);
      dtau2(5,5)=( 0.00);
//
//
// derivatives of da wrt rotation
//
      double aCCbet= aCbet*aCbet;
      double aSSbet= aSbet*aSbet;
      double aCCgam= aCgam*aCgam;
      double aCSgam= aCgam*aSgam;
      double aSSgam= aSgam*aSgam;
      Block_Pair adalp;
      adalp(3)= aCgam/aCbet;
      adalp(4)=-aSgam/aCbet;
//    adalp(5)=( 0.00);
      adalp(3,3)= (2.00)*aSbet*aCSgam/aCCbet;
      adalp(3,4)= aSbet*( aCCgam -aSSgam)/aCCbet;
      adalp(3,5)= adalp(4);
      adalp(4,3)= adalp(3,4);
      adalp(4,4)=-adalp(3,3);
      adalp(4,5)=-adalp(3);
//    adalp(5,3)=( 0.00);
//    adalp(5,4)=( 0.00);
//    adalp(5,5)=( 0.00);
      Block_Pair adbet;
      adbet(3)= aSgam;
      adbet(4)= aCgam;
//    adbet(5)=( 0.00);
      adbet(3,3)=-aSbet*aCCgam/aCbet;
      adbet(3,4)= aSbet*aCSgam/aCbet;
      adbet(3,5)= adbet(4);
      adbet(4,3)= adbet(3,4);
      adbet(4,4)=-aSbet*aSSgam/aCbet;
      adbet(4,5)=-adbet(3);
//    adbet(5,3)=( 0.00);
//    adbet(5,4)=( 0.00);
//    adbet(5,5)=( 0.00);
      Block_Pair adgam;
      adgam(3)=-aSbet*aCgam/aCbet;
      adgam(4)= aSbet*aSgam/aCbet;
//    adgam(5)=( 1.00);
      adgam(3,3)=-( (1.00) +aSSbet)*aCSgam/aCCbet;
      adgam(3,4)=(-aCCgam +aSSbet*aSSgam)/aCCbet;
      adgam(3,5)= adgam(4);
      adgam(4,3)=( aSSgam -aSSbet*aCCgam)/aCCbet;
      adgam(4,4)=-adgam(3,3);
      adgam(4,5)=-adgam(3);
//    adgam(5,3)=( 0.00);
//    adgam(5,4)=( 0.00);
//    adgam(5,5)=( 0.00);
//
//
// derivatives of af
//
      Coordinates ta_da3;
      Coordinates ta_da4;
      Coordinates aa_da3;
      Coordinates aa_da4;
      for(int i=0;i<3;i++){
         ta_da3(i)=( ta(i,0)*adalp(3)
                    +ta(i,1)*adbet(3)
                    +ta(i,2)*adgam(3));
         ta_da4(i)=( ta(i,0)*adalp(4)
                    +ta(i,1)*adbet(4)
                    +ta(i,2)*adgam(4));
         aa_da3(i)=( aa(i,0)*adalp(3)
                    +aa(i,1)*adbet(3)
                    +aa(i,2)*adgam(3));
         aa_da4(i)=( aa(i,0)*adalp(4)
                    +aa(i,1)*adbet(4)
                    +aa(i,2)*adgam(4));
      }
      Block_Pair ae;
      ae( 0)=( g( 0)
              +tt_dt(0)
              +ta_da(0));
      ae( 1)=( g( 1)
              +tt_dt(1)
              +ta_da(1));
      ae( 2)=( g( 2)
              +tt_dt(2)
              +ta_da(2));
      ae( 3)=( ae( 1)*dtau1(3)
              +ae( 2)*dtau2(3)
              +g( 3)*adalp(3)
              +g( 4)*adbet(3)
              +g( 5)*adgam(3)
              +aa_da(0)*adalp(3)
              +aa_da(1)*adbet(3)
              +aa_da(2)*adgam(3)
              +dt_ta(0)*adalp(3)
              +dt_ta(1)*adbet(3)
              +dt_ta(2)*adgam(3));
      ae( 4)=( ae( 0)*dtau0(4)
              +ae( 2)*dtau2(4)
              +g( 3)*adalp(4)
              +g( 4)*adbet(4)
              +g( 5)*adgam(4)
              +aa_da(0)*adalp(4)
              +aa_da(1)*adbet(4)
              +aa_da(2)*adgam(4)
              +dt_ta(0)*adalp(4)
              +dt_ta(1)*adbet(4)
              +dt_ta(2)*adgam(4));
      ae( 5)=( g( 5)
              +ae( 0)*dtau0(5)
              +ae( 1)*dtau1(5)
              +aa_da(2)
              +dt_ta(2));
//
      ae(0,3)=( g(1,0)*dtau1(3)
               +g(2,0)*dtau2(3)
               +ta_da3(0));
      ae(3,0)=ae(0,3);
      ae(0,4)=( g(0,0)*dtau0(4)
               +g(2,0)*dtau2(4)
               +ta_da4(0));
      ae(4,0)=( ae(0,4) +ae( 2));
      ae(0,5)=( g(0,0)*dtau0(5)
               +g(1,0)*dtau1(5)
               +g(0,5));
      ae(5,0)=( ae(0,5) -ae( 1));
//
      ae(1,3)=( g(1,1)*dtau1(3)
               +g(2,1)*dtau2(3)
               +ta_da3(1));
      ae(3,1)=( ae(1,3) -ae( 2));
      ae(1,4)=( g(1,0)*dtau0(4)
               +g(2,1)*dtau2(4)
               +ta_da4(1));
      ae(4,1)=ae(1,4);
      ae(1,5)=( g(1,0)*dtau0(5)
               +g(1,1)*dtau1(5)
               +g(1,5));
      ae(5,1)=( ae(1,5) +ae( 0));
//
      ae(2,3)=( g(2,1)*dtau1(3)
               +g(2,2)*dtau2(3)
               +ta_da3(2));
      ae(3,2)=( ae(2,3) +ae( 1));
      ae(2,4)=( g(2,0)*dtau0(4)
               +g(2,2)*dtau2(4)
               +ta_da4(2));
      ae(4,2)=( ae(2,4) -ae( 0));
      ae(2,5)=( g(2,0)*dtau0(5)
               +g(2,1)*dtau1(5)
               +g(2,5));
      ae(5,2)=ae(2,5);
//
      ae(3,3)=( ae( 1)*dtau1(3,3)
               +ae( 2)*dtau2(3,3)
               +g( 3)*adalp(3,3)
               +g( 4)*adbet(3,3)
               +g( 5)*adgam(3,3)
               +aa_da(0)*adalp(3,3)
               +aa_da(1)*adbet(3,3)
               +aa_da(2)*adgam(3,3)
               +dt_ta(0)*adalp(3,3)
               +dt_ta(1)*adbet(3,3)
               +dt_ta(2)*adgam(3,3)
               +aa_da3(0)*adalp(3)
               +aa_da3(1)*adbet(3)
               +aa_da3(2)*adgam(3)
               +ta_da3(1)*dtau1(3)*(2.00)
               +ta_da3(2)*dtau2(3)*(2.00)
               +g(1,1)*dtau1(3)*dtau1(3)
               +g(2,1)*dtau1(3)*dtau2(3)*(2.00)
               +g(2,2)*dtau2(3)*dtau2(3));
//
      double zz;
      zz=( aa_da3(0)*adalp(4)
          +aa_da3(1)*adbet(4)
          +aa_da3(2)*adgam(4)
          +ta_da3(0)*dtau0(4)
          +ta_da3(2)*dtau2(4)
          +ta_da4(1)*dtau1(3)
          +ta_da4(2)*dtau2(3)
          +g(1,0)*dtau1(3)*dtau0(4)
          +g(2,0)*dtau2(3)*dtau0(4)
          +g(2,1)*dtau1(3)*dtau2(4)
          +g(2,2)*dtau2(3)*dtau2(4));
      ae(3,4)=( ae( 1)*dtau1(3,4)
               +g( 3)*adalp(3,4)
               +g( 4)*adbet(3,4)
               +g( 5)*adgam(3,4)
               +aa_da(0)*adalp(3,4)
               +aa_da(1)*adbet(3,4)
               +aa_da(2)*adgam(3,4)
               +dt_ta(0)*adalp(3,4)
               +dt_ta(1)*adbet(3,4)
               +dt_ta(2)*adgam(3,4)
               +zz);
      ae(4,3)=( ae( 0)*dtau0(4,3)
               +g( 3)*adalp(4,3)
               +g( 4)*adbet(4,3)
               +g( 5)*adgam(4,3)
               +aa_da(0)*adalp(4,3)
               +aa_da(1)*adbet(4,3)
               +aa_da(2)*adgam(4,3)
               +dt_ta(0)*adalp(4,3)
               +dt_ta(1)*adbet(4,3)
               +dt_ta(2)*adgam(4,3)
               +zz);
//
      zz=( aa_da3(2)
          +g(1,5)*dtau1(3)
          +g(2,5)*dtau2(3)
          +ta_da3(0)*dtau0(5)
          +ta_da3(1)*dtau1(5)
          +g(1,0)*dtau1(3)*dtau0(5)
          +g(1,1)*dtau1(3)*dtau1(5)
          +g(2,0)*dtau2(3)*dtau0(5)
          +g(2,1)*dtau2(3)*dtau1(5));
      ae(3,5)=( ae( 2)*dtau2(3,5)
               +g( 3)*adalp(3,5)
               +g( 4)*adbet(3,5)
               +g( 5)*adgam(3,5)
               +aa_da(0)*adalp(3,5)
               +aa_da(1)*adbet(3,5)
               +aa_da(2)*adgam(3,5)
               +dt_ta(0)*adalp(3,5)
               +dt_ta(1)*adbet(3,5)
               +dt_ta(2)*adgam(3,5)
               +zz);
      ae(5,3)=( ae( 0)*dtau0(5,3)
               +zz);
//
      ae(4,4)=( ae( 0)*dtau0(4,4)
               +ae( 2)*dtau2(4,4)
               +g( 3)*adalp(4,4)
               +g( 4)*adbet(4,4)
               +g( 5)*adgam(4,4)
               +aa_da(0)*adalp(4,4)
               +aa_da(1)*adbet(4,4)
               +aa_da(2)*adgam(4,4)
               +dt_ta(0)*adalp(4,4)
               +dt_ta(1)*adbet(4,4)
               +dt_ta(2)*adgam(4,4)
               +aa_da4(0)*adalp(4)
               +aa_da4(1)*adbet(4)
               +aa_da4(2)*adgam(4)
               +ta_da4(0)*dtau0(4)*(2.00)
               +ta_da4(2)*dtau2(4)*(2.00)
               +g(0,0)*dtau0(4)*dtau0(4)
               +g(2,0)*dtau2(4)*dtau0(4)*(2.00)
               +g(2,2)*dtau2(4)*dtau2(4));
//
      zz=( aa_da4(2)
          +g(0,5)*dtau0(4)
          +g(2,5)*dtau2(4)
          +ta_da4(0)*dtau0(5)
          +ta_da4(1)*dtau1(5)
          +g(0,0)*dtau0(4)*dtau0(5)
          +g(1,0)*dtau0(4)*dtau1(5)
          +g(2,0)*dtau2(4)*dtau0(5)
          +g(2,1)*dtau2(4)*dtau1(5));
      ae(4,5)=( ae( 2)*dtau2(4,5)
               +g( 3)*adalp(4,5)
               +g( 4)*adbet(4,5)
               +g( 5)*adgam(4,5)
               +aa_da(0)*adalp(4,5)
               +aa_da(1)*adbet(4,5)
               +aa_da(2)*adgam(4,5)
               +dt_ta(0)*adalp(4,5)
               +dt_ta(1)*adbet(4,5)
               +dt_ta(2)*adgam(4,5)
               +zz);
      ae(5,4)=( ae( 1)*dtau1(5,4)
               +zz);
//
      ae(5,5)=( g(5,5)
               +ae( 0)*dtau0(5,5)
               +ae( 1)*dtau1(5,5)
               +g(0,5)*dtau0(5)*(2.00)
               +g(1,5)*dtau1(5)*(2.00)
               +g(0,0)*dtau0(5)*dtau0(5)
               +g(1,0)*dtau1(5)*dtau0(5)*(2.00)
               +g(1,1)*dtau1(5)*dtau1(5));
//
//
// derivatives of db wrt rotation
//
      double bCCgam= bCgam*bCgam;
      double bSSgam= bSgam*bSgam;
      double bCCalp= bCalp*bCalp;
      double bCSalp= bCalp*bSalp;
      double bSSalp= bSalp*bSalp;
      Block_Pair bdalp;
//    bdalp(3)=( 1.00);
      bdalp(4)=-bSgam*bCalp/bCgam;
      bdalp(5)= bSgam*bSalp/bCgam;
//    bdalp(3,3)=( 0.00);
//    bdalp(3,4)=( 0.00);
//    bdalp(3,5)=( 0.00);
      bdalp(4,3)= bdalp(5);
      bdalp(4,4)=-( (1.00) +bSSgam)*bCSalp/bCCgam;
      bdalp(4,5)=(-bCCalp +bSSgam*bSSalp)/bCCgam;
      bdalp(5,3)=-bdalp(4);
      bdalp(5,4)=( bSSalp -bSSgam*bCCalp)/bCCgam;
      bdalp(5,5)=-bdalp(4,4);
      Block_Pair bdbet;
//    bdbet(3)=( 0.00);
      bdbet(4)= bCalp/bCgam;
      bdbet(5)=-bSalp/bCgam;
//    bdbet(3,3)=( 0.00);
//    bdbet(3,4)=( 0.00);
//    bdbet(3,5)=( 0.00);
      bdbet(4,3)= bdbet(5);
      bdbet(4,4)= (2.00)*bSgam*bCSalp/bCCgam;
      bdbet(4,5)= bSgam*( bCCalp -bSSalp)/bCCgam;
      bdbet(5,3)=-bdbet(4);
      bdbet(5,4)= bdbet(4,5);
      bdbet(5,5)=-bdbet(4,4);
      Block_Pair bdgam;
//    bdgam(3)=( 0.00);
      bdgam(4)= bSalp;
      bdgam(5)= bCalp;
//    bdgam(3,3)=( 0.00);
//    bdgam(3,4)=( 0.00);
//    bdgam(3,5)=( 0.00);
      bdgam(4,3)= bdgam(5);
      bdgam(4,4)=-bSgam*bCCalp/bCgam;
      bdgam(4,5)= bSgam*bCSalp/bCgam;
      bdgam(5,3)=-bdgam(4);
      bdgam(5,4)= bdgam(4,5);
      bdgam(5,5)=-bSgam*bSSalp/bCgam;
//
//
// derivatives of bf
//
      Coordinates ta_db4;
      Coordinates ta_db5;
      Coordinates bb_db4;
      Coordinates bb_db5;
      for(int i=0;i<3;i++){
         ta_db4(i)=( ta(i,0)*bdalp(4)
                    +ta(i,1)*bdbet(4)
                    +ta(i,2)*bdgam(4));
         ta_db5(i)=( ta(i,0)*bdalp(5)
                    +ta(i,1)*bdbet(5)
                    +ta(i,2)*bdgam(5));
         bb_db4(i)=( bb(i,0)*bdalp(4)
                    +bb(i,1)*bdbet(4)
                    +bb(i,2)*bdgam(4));
         bb_db5(i)=( bb(i,0)*bdalp(5)
                    +bb(i,1)*bdbet(5)
                    +bb(i,2)*bdgam(5));
      }
      Block_Pair be;
      be( 1)=( g( 1)
              +tt_dt(1)
              +ta_db(1));
      be( 2)=( g( 2)
              +tt_dt(2)
              +ta_db(2));
      be( 0)=( g( 0)
              +tt_dt(0)
              +ta_db(0));
      be( 4)=( be( 2)*dtau2(4)
              +be( 0)*dtau0(4)
              +g( 4)*bdbet(4)
              +g( 5)*bdgam(4)
              +g( 3)*bdalp(4)
              +bb_db(1)*bdbet(4)
              +bb_db(2)*bdgam(4)
              +bb_db(0)*bdalp(4)
              +dt_ta(1)*bdbet(4)
              +dt_ta(2)*bdgam(4)
              +dt_ta(0)*bdalp(4));
      be( 5)=( be( 1)*dtau1(5)
              +be( 0)*dtau0(5)
              +g( 4)*bdbet(5)
              +g( 5)*bdgam(5)
              +g( 3)*bdalp(5)
              +bb_db(1)*bdbet(5)
              +bb_db(2)*bdgam(5)
              +bb_db(0)*bdalp(5)
              +dt_ta(1)*bdbet(5)
              +dt_ta(2)*bdgam(5)
              +dt_ta(0)*bdalp(5));
      be( 3)=( g( 3)
              +be( 1)*dtau1(3)
              +be( 2)*dtau2(3)
              +bb_db(0)
              +dt_ta(0));
//
      be(1,4)=( g(2,1)*dtau2(4)
               +g(0,1)*dtau0(4)
               +ta_db4(1));
      be(4,1)=be(1,4);
      be(1,5)=( g(1,1)*dtau1(5)
               +g(0,1)*dtau0(5)
               +ta_db5(1));
      be(5,1)=( be(1,5) +be( 0));
      be(1,3)=( g(1,1)*dtau1(3)
               +g(2,1)*dtau2(3)
               +g(1,3));
      be(3,1)=( be(1,3) -be( 2));
//
      be(2,4)=( g(2,2)*dtau2(4)
               +g(0,2)*dtau0(4)
               +ta_db4(2));
      be(4,2)=( be(2,4) -be( 0));
      be(2,5)=( g(2,1)*dtau1(5)
               +g(0,2)*dtau0(5)
               +ta_db5(2));
      be(5,2)=be(2,5);
      be(2,3)=( g(2,1)*dtau1(3)
               +g(2,2)*dtau2(3)
               +g(2,3));
      be(3,2)=( be(2,3) +be( 1));
//
      be(0,4)=( g(0,2)*dtau2(4)
               +g(0,0)*dtau0(4)
               +ta_db4(0));
      be(4,0)=( be(0,4) +be( 2));
      be(0,5)=( g(0,1)*dtau1(5)
               +g(0,0)*dtau0(5)
               +ta_db5(0));
      be(5,0)=( be(0,5) -be( 1));
      be(0,3)=( g(0,1)*dtau1(3)
               +g(0,2)*dtau2(3)
               +g(0,3));
      be(3,0)=be(0,3);
//
      be(4,4)=( be( 2)*dtau2(4,4)
               +be( 0)*dtau0(4,4)
               +g( 4)*bdbet(4,4)
               +g( 5)*bdgam(4,4)
               +g( 3)*bdalp(4,4)
               +bb_db(1)*bdbet(4,4)
               +bb_db(2)*bdgam(4,4)
               +bb_db(0)*bdalp(4,4)
               +dt_ta(1)*bdbet(4,4)
               +dt_ta(2)*bdgam(4,4)
               +dt_ta(0)*bdalp(4,4)
               +bb_db4(1)*bdbet(4)
               +bb_db4(2)*bdgam(4)
               +bb_db4(0)*bdalp(4)
               +ta_db4(2)*dtau2(4)*(2.00)
               +ta_db4(0)*dtau0(4)*(2.00)
               +g(2,2)*dtau2(4)*dtau2(4)
               +g(0,2)*dtau2(4)*dtau0(4)*(2.00)
               +g(0,0)*dtau0(4)*dtau0(4));
//
      zz=( bb_db4(1)*bdbet(5)
          +bb_db4(2)*bdgam(5)
          +bb_db4(0)*bdalp(5)
          +ta_db4(1)*dtau1(5)
          +ta_db4(0)*dtau0(5)
          +ta_db5(2)*dtau2(4)
          +ta_db5(0)*dtau0(4)
          +g(2,1)*dtau2(4)*dtau1(5)
          +g(0,1)*dtau0(4)*dtau1(5)
          +g(0,2)*dtau2(4)*dtau0(5)
          +g(0,0)*dtau0(4)*dtau0(5));
      be(4,5)=( be( 2)*dtau2(4,5)
               +g( 4)*bdbet(4,5)
               +g( 5)*bdgam(4,5)
               +g( 3)*bdalp(4,5)
               +bb_db(1)*bdbet(4,5)
               +bb_db(2)*bdgam(4,5)
               +bb_db(0)*bdalp(4,5)
               +dt_ta(1)*bdbet(4,5)
               +dt_ta(2)*bdgam(4,5)
               +dt_ta(0)*bdalp(4,5)
               +zz);
      be(5,4)=( be( 1)*dtau1(5,4)
               +g( 4)*bdbet(5,4)
               +g( 5)*bdgam(5,4)
               +g( 3)*bdalp(5,4)
               +bb_db(1)*bdbet(5,4)
               +bb_db(2)*bdgam(5,4)
               +bb_db(0)*bdalp(5,4)
               +dt_ta(1)*bdbet(5,4)
               +dt_ta(2)*bdgam(5,4)
               +dt_ta(0)*bdalp(5,4)
               +zz);
//
      zz=( bb_db4(0)
          +g(2,3)*dtau2(4)
          +g(0,3)*dtau0(4)
          +ta_db4(1)*dtau1(3)
          +ta_db4(2)*dtau2(3)
          +g(2,1)*dtau2(4)*dtau1(3)
          +g(2,2)*dtau2(4)*dtau2(3)
          +g(0,1)*dtau0(4)*dtau1(3)
          +g(0,2)*dtau0(4)*dtau2(3));
      be(4,3)=( be( 0)*dtau0(4,3)
               +g( 4)*bdbet(4,3)
               +g( 5)*bdgam(4,3)
               +g( 3)*bdalp(4,3)
               +bb_db(1)*bdbet(4,3)
               +bb_db(2)*bdgam(4,3)
               +bb_db(0)*bdalp(4,3)
               +dt_ta(1)*bdbet(4,3)
               +dt_ta(2)*bdgam(4,3)
               +dt_ta(0)*bdalp(4,3)
               +zz);
      be(3,4)=( be( 1)*dtau1(3,4)
               +zz);
//
      be(5,5)=( be( 1)*dtau1(5,5)
               +be( 0)*dtau0(5,5)
               +g( 4)*bdbet(5,5)
               +g( 5)*bdgam(5,5)
               +g( 3)*bdalp(5,5)
               +bb_db(1)*bdbet(5,5)
               +bb_db(2)*bdgam(5,5)
               +bb_db(0)*bdalp(5,5)
               +dt_ta(1)*bdbet(5,5)
               +dt_ta(2)*bdgam(5,5)
               +dt_ta(0)*bdalp(5,5)
               +bb_db5(1)*bdbet(5)
               +bb_db5(2)*bdgam(5)
               +bb_db5(0)*bdalp(5)
               +ta_db5(1)*dtau1(5)*(2.00)
               +ta_db5(0)*dtau0(5)*(2.00)
               +g(1,1)*dtau1(5)*dtau1(5)
               +g(0,1)*dtau0(5)*dtau1(5)*(2.00)
               +g(0,0)*dtau0(5)*dtau0(5));
//
      zz=( bb_db5(0)
          +g(1,3)*dtau1(5)
          +g(0,3)*dtau0(5)
          +ta_db5(1)*dtau1(3)
          +ta_db5(2)*dtau2(3)
          +g(1,1)*dtau1(5)*dtau1(3)
          +g(2,1)*dtau1(5)*dtau2(3)
          +g(0,1)*dtau0(5)*dtau1(3)
          +g(0,2)*dtau0(5)*dtau2(3));
      be(5,3)=( be( 0)*dtau0(5,3)
               +g( 4)*bdbet(5,3)
               +g( 5)*bdgam(5,3)
               +g( 3)*bdalp(5,3)
               +bb_db(1)*bdbet(5,3)
               +bb_db(2)*bdgam(5,3)
               +bb_db(0)*bdalp(5,3)
               +dt_ta(1)*bdbet(5,3)
               +dt_ta(2)*bdgam(5,3)
               +dt_ta(0)*bdalp(5,3)
               +zz);
      be(3,5)=( be( 2)*dtau2(3,5)
               +zz);
//
      be(3,3)=( g(3,3)
               +be( 1)*dtau1(3,3)
               +be( 2)*dtau2(3,3)
               +g(1,3)*dtau1(3)*(2.00)
               +g(2,3)*dtau2(3)*(2.00)
               +g(1,1)*dtau1(3)*dtau1(3)
               +g(2,1)*dtau2(3)*dtau1(3)*(2.00)
               +g(2,2)*dtau2(3)*dtau2(3));
//
//
// derivatives of dc wrt rotation
//
      double cCCalp= cCalp*cCalp;
      double cSSalp= cSalp*cSalp;
      double cCCbet= cCbet*cCbet;
      double cCSbet= cCbet*cSbet;
      double cSSbet= cSbet*cSbet;
      Block_Pair cdalp;
      cdalp(3)= cCbet;
//    cdalp(4)=( 0.00);
      cdalp(5)= cSbet;
      cdalp(3,3)=-cSalp*cSSbet/cCalp;
      cdalp(3,4)=-cdalp(5);
      cdalp(3,5)= cSalp*cCSbet/cCalp;
//    cdalp(4,3)=( 0.00);
//    cdalp(4,4)=( 0.00);
//    cdalp(4,5)=( 0.00);
      cdalp(5,3)= cdalp(3,5);
      cdalp(5,4)= cdalp(3);
      cdalp(5,5)=-cSalp*cCCbet/cCalp;
      Block_Pair cdbet;
      cdbet(3)= cSalp*cSbet/cCalp;
//    cdbet(4)=( 1.00);
      cdbet(5)=-cSalp*cCbet/cCalp;
      cdbet(3,3)=( (1.00) +cSSalp)*cCSbet/cCCalp;
      cdbet(3,4)=-cdbet(5);
      cdbet(3,5)=( cSSbet -cSSalp*cCCbet)/cCCalp;
//    cdbet(4,3)=( 0.00);
//    cdbet(4,4)=( 0.00);
//    cdbet(4,5)=( 0.00);
      cdbet(5,3)=(-cCCbet +cSSalp*cSSbet)/cCCalp;
      cdbet(5,4)= cdbet(3);
      cdbet(5,5)=-cdbet(3,3);
      Block_Pair cdgam;
      cdgam(3)=-cSbet/cCalp;
//    cdgam(4)=( 0.00);
      cdgam(5)= cCbet/cCalp;
      cdgam(3,3)=-(2.00)*cSalp*cCSbet/cCCalp;
      cdgam(3,4)=-cdgam(5);
      cdgam(3,5)= cSalp*( cCCbet -cSSbet)/cCCalp;
//    cdgam(4,3)=( 0.00);
//    cdgam(4,4)=( 0.00);
//    cdgam(4,5)=( 0.00);
      cdgam(5,3)= cdgam(3,5);
      cdgam(5,4)= cdgam(3);
      cdgam(5,5)=-cdgam(3,3);
//
//
// derivatives of cf
//
      Coordinates ta_dc5;
      Coordinates ta_dc3;
      Coordinates cc_dc5;
      Coordinates cc_dc3;
      for(int i=0;i<3;i++){
         ta_dc5(i)=( ta(i,2)*cdgam(5)
                    +ta(i,0)*cdalp(5)
                    +ta(i,1)*cdbet(5));
         ta_dc3(i)=( ta(i,2)*cdgam(3)
                    +ta(i,0)*cdalp(3)
                    +ta(i,1)*cdbet(3));
         cc_dc5(i)=( cc(i,2)*cdgam(5)
                    +cc(i,0)*cdalp(5)
                    +cc(i,1)*cdbet(5));
         cc_dc3(i)=( cc(i,2)*cdgam(3)
                    +cc(i,0)*cdalp(3)
                    +cc(i,1)*cdbet(3));
      }
      Block_Pair ce;
      ce( 2)=( g( 2)
              +tt_dt(2)
              +ta_dc(2));
      ce( 0)=( g( 0)
              +tt_dt(0)
              +ta_dc(0));
      ce( 1)=( g( 1)
              +tt_dt(1)
              +ta_dc(1));
      ce( 5)=( ce( 0)*dtau0(5)
              +ce( 1)*dtau1(5)
              +g( 5)*cdgam(5)
              +g( 3)*cdalp(5)
              +g( 4)*cdbet(5)
              +cc_dc(2)*cdgam(5)
              +cc_dc(0)*cdalp(5)
              +cc_dc(1)*cdbet(5)
              +dt_ta(2)*cdgam(5)
              +dt_ta(0)*cdalp(5)
              +dt_ta(1)*cdbet(5));
      ce( 3)=( ce( 2)*dtau2(3)
              +ce( 1)*dtau1(3)
              +g( 5)*cdgam(3)
              +g( 3)*cdalp(3)
              +g( 4)*cdbet(3)
              +cc_dc(2)*cdgam(3)
              +cc_dc(0)*cdalp(3)
              +cc_dc(1)*cdbet(3)
              +dt_ta(2)*cdgam(3)
              +dt_ta(0)*cdalp(3)
              +dt_ta(1)*cdbet(3));
      ce( 4)=( g( 4)
              +ce( 2)*dtau2(4)
              +ce( 0)*dtau0(4)
              +cc_dc(1)
              +dt_ta(1));
//
      ce(2,5)=( g(0,2)*dtau0(5)
               +g(1,2)*dtau1(5)
               +ta_dc5(2));
      ce(5,2)=ce(2,5);
      ce(2,3)=( g(2,2)*dtau2(3)
               +g(1,2)*dtau1(3)
               +ta_dc3(2));
      ce(3,2)=( ce(2,3) +ce( 1));
      ce(2,4)=( g(2,2)*dtau2(4)
               +g(0,2)*dtau0(4)
               +g(2,4));
      ce(4,2)=( ce(2,4) -ce( 0));
//
      ce(0,5)=( g(0,0)*dtau0(5)
               +g(1,0)*dtau1(5)
               +ta_dc5(0));
      ce(5,0)=( ce(0,5) -ce( 1));
      ce(0,3)=( g(0,2)*dtau2(3)
               +g(1,0)*dtau1(3)
               +ta_dc3(0));
      ce(3,0)=ce(0,3);
      ce(0,4)=( g(0,2)*dtau2(4)
               +g(0,0)*dtau0(4)
               +g(0,4));
      ce(4,0)=( ce(0,4) +ce( 2));
//
      ce(1,5)=( g(1,0)*dtau0(5)
               +g(1,1)*dtau1(5)
               +ta_dc5(1));
      ce(5,1)=( ce(1,5) +ce( 0));
      ce(1,3)=( g(1,2)*dtau2(3)
               +g(1,1)*dtau1(3)
               +ta_dc3(1));
      ce(3,1)=( ce(1,3) -ce( 2));
      ce(1,4)=( g(1,2)*dtau2(4)
               +g(1,0)*dtau0(4)
               +g(1,4));
      ce(4,1)=ce(1,4);
//
      ce(5,5)=( ce( 0)*dtau0(5,5)
               +ce( 1)*dtau1(5,5)
               +g( 5)*cdgam(5,5)
               +g( 3)*cdalp(5,5)
               +g( 4)*cdbet(5,5)
               +cc_dc(2)*cdgam(5,5)
               +cc_dc(0)*cdalp(5,5)
               +cc_dc(1)*cdbet(5,5)
               +dt_ta(2)*cdgam(5,5)
               +dt_ta(0)*cdalp(5,5)
               +dt_ta(1)*cdbet(5,5)
               +cc_dc5(2)*cdgam(5)
               +cc_dc5(0)*cdalp(5)
               +cc_dc5(1)*cdbet(5)
               +ta_dc5(0)*dtau0(5)*(2.00)
               +ta_dc5(1)*dtau1(5)*(2.00)
               +g(0,0)*dtau0(5)*dtau0(5)
               +g(1,0)*dtau0(5)*dtau1(5)*(2.00)
               +g(1,1)*dtau1(5)*dtau1(5));
//
      zz=( cc_dc5(2)*cdgam(3)
          +cc_dc5(0)*cdalp(3)
          +cc_dc5(1)*cdbet(3)
          +ta_dc5(2)*dtau2(3)
          +ta_dc5(1)*dtau1(3)
          +ta_dc3(0)*dtau0(5)
          +ta_dc3(1)*dtau1(5)
          +g(0,2)*dtau0(5)*dtau2(3)
          +g(1,2)*dtau1(5)*dtau2(3)
          +g(1,0)*dtau0(5)*dtau1(3)
          +g(1,1)*dtau1(5)*dtau1(3));
      ce(5,3)=( ce( 0)*dtau0(5,3)
               +g( 5)*cdgam(5,3)
               +g( 3)*cdalp(5,3)
               +g( 4)*cdbet(5,3)
               +cc_dc(2)*cdgam(5,3)
               +cc_dc(0)*cdalp(5,3)
               +cc_dc(1)*cdbet(5,3)
               +dt_ta(2)*cdgam(5,3)
               +dt_ta(0)*cdalp(5,3)
               +dt_ta(1)*cdbet(5,3)
               +zz);
      ce(3,5)=( ce( 2)*dtau2(3,5)
               +g( 5)*cdgam(3,5)
               +g( 3)*cdalp(3,5)
               +g( 4)*cdbet(3,5)
               +cc_dc(2)*cdgam(3,5)
               +cc_dc(0)*cdalp(3,5)
               +cc_dc(1)*cdbet(3,5)
               +dt_ta(2)*cdgam(3,5)
               +dt_ta(0)*cdalp(3,5)
               +dt_ta(1)*cdbet(3,5)
               +zz);
//
      zz=( cc_dc5(1)
          +g(0,4)*dtau0(5)
          +g(1,4)*dtau1(5)
          +ta_dc5(2)*dtau2(4)
          +ta_dc5(0)*dtau0(4)
          +g(0,2)*dtau0(5)*dtau2(4)
          +g(0,0)*dtau0(5)*dtau0(4)
          +g(1,2)*dtau1(5)*dtau2(4)
          +g(1,0)*dtau1(5)*dtau0(4));
      ce(5,4)=( ce( 1)*dtau1(5,4)
               +g( 5)*cdgam(5,4)
               +g( 3)*cdalp(5,4)
               +g( 4)*cdbet(5,4)
               +cc_dc(2)*cdgam(5,4)
               +cc_dc(0)*cdalp(5,4)
               +cc_dc(1)*cdbet(5,4)
               +dt_ta(2)*cdgam(5,4)
               +dt_ta(0)*cdalp(5,4)
               +dt_ta(1)*cdbet(5,4)
               +zz);
      ce(4,5)=( ce( 2)*dtau2(4,5)
               +zz);
//
      ce(3,3)=( ce( 2)*dtau2(3,3)
               +ce( 1)*dtau1(3,3)
               +g( 5)*cdgam(3,3)
               +g( 3)*cdalp(3,3)
               +g( 4)*cdbet(3,3)
               +cc_dc(2)*cdgam(3,3)
               +cc_dc(0)*cdalp(3,3)
               +cc_dc(1)*cdbet(3,3)
               +dt_ta(2)*cdgam(3,3)
               +dt_ta(0)*cdalp(3,3)
               +dt_ta(1)*cdbet(3,3)
               +cc_dc3(2)*cdgam(3)
               +cc_dc3(0)*cdalp(3)
               +cc_dc3(1)*cdbet(3)
               +ta_dc3(2)*dtau2(3)*(2.00)
               +ta_dc3(1)*dtau1(3)*(2.00)
               +g(2,2)*dtau2(3)*dtau2(3)
               +g(1,2)*dtau1(3)*dtau2(3)*(2.00)
               +g(1,1)*dtau1(3)*dtau1(3));
//
      zz=( cc_dc3(1)
          +g(2,4)*dtau2(3)
          +g(1,4)*dtau1(3)
          +ta_dc3(2)*dtau2(4)
          +ta_dc3(0)*dtau0(4)
          +g(2,2)*dtau2(3)*dtau2(4)
          +g(0,2)*dtau2(3)*dtau0(4)
          +g(1,2)*dtau1(3)*dtau2(4)
          +g(1,0)*dtau1(3)*dtau0(4));
      ce(3,4)=( ce( 1)*dtau1(3,4)
               +g( 5)*cdgam(3,4)
               +g( 3)*cdalp(3,4)
               +g( 4)*cdbet(3,4)
               +cc_dc(2)*cdgam(3,4)
               +cc_dc(0)*cdalp(3,4)
               +cc_dc(1)*cdbet(3,4)
               +dt_ta(2)*cdgam(3,4)
               +dt_ta(0)*cdalp(3,4)
               +dt_ta(1)*cdbet(3,4)
               +zz);
      ce(4,3)=( ce( 0)*dtau0(4,3)
               +zz);
//
      ce(4,4)=( g(4,4)
               +ce( 2)*dtau2(4,4)
               +ce( 0)*dtau0(4,4)
               +g(2,4)*dtau2(4)*(2.00)
               +g(0,4)*dtau0(4)*(2.00)
               +g(2,2)*dtau2(4)*dtau2(4)
               +g(0,2)*dtau0(4)*dtau2(4)*(2.00)
               +g(0,0)*dtau0(4)*dtau0(4));
//
//
// block pair
//
      for(int i=0;i<6;i++){
         g(i)=( ae(i)
               +be(i)
               +ce(i))/(3.00);
      }
      for(int i=0;i<3;i++){
         for(int j=0;j<3;j++){
            g(  i,3+j)=( ae(  i,3+j)
                        +be(  i,3+j)
                        +ce(  i,3+j))/(3.00);
            g(3+i,  j)=( ae(3+i,  j)
                        +be(3+i,  j)
                        +ce(3+i,  j))/(3.00);
            g(3+i,3+j)=( ae(3+i,3+j)
                        +be(3+i,3+j)
                        +ce(3+i,3+j))/(3.00);
         }
      }
      double w2= (2.00)*w;
      for(int i=0;i<6;i++){
         g(i)+=w2*( ( bf -af)*( be(i) -ae(i))
                   +( cf -af)*( ce(i) -ae(i))
                   +( cf -bf)*( ce(i) -be(i)));
      }
      for(int i=0;i<3;i++){
         for(int j=0;j<3;j++){
            g(  i,  j)+=w2*( ( be(  i) -ae(  i))*( be(  j) -ae(  j))
                            +( ce(  i) -ae(  i))*( ce(  j) -ae(  j))
                            +( ce(  i) -be(  i))*( ce(  j) -be(  j))
                             );
            g(  i,3+j)+=w2*( ( bf -af)*( be(  i,3+j) -ae(  i,3+j))
                            +( cf -af)*( ce(  i,3+j) -ae(  i,3+j))
                            +( cf -bf)*( ce(  i,3+j) -be(  i,3+j))
                            +( be(  i) -ae(  i))*( be(3+j) -ae(3+j))
                            +( ce(  i) -ae(  i))*( ce(3+j) -ae(3+j))
                            +( ce(  i) -be(  i))*( ce(3+j) -be(3+j))
                             );
            g(3+i,  j)+=w2*( ( bf -af)*( be(3+i,  j) -ae(3+i,  j))
                            +( cf -af)*( ce(3+i,  j) -ae(3+i,  j))
                            +( cf -bf)*( ce(3+i,  j) -be(3+i,  j))
                            +( be(3+i) -ae(3+i))*( be(  j) -ae(  j))
                            +( ce(3+i) -ae(3+i))*( ce(  j) -ae(  j))
                            +( ce(3+i) -be(3+i))*( ce(  j) -be(  j))
                             );
            g(3+i,3+j)+=w2*( ( bf -af)*( be(3+i,3+j) -ae(3+i,3+j))
                            +( cf -af)*( ce(3+i,3+j) -ae(3+i,3+j))
                            +( cf -bf)*( ce(3+i,3+j) -be(3+i,3+j))
                            +( be(3+i) -ae(3+i))*( be(3+j) -ae(3+j))
                            +( ce(3+i) -ae(3+i))*( ce(3+j) -ae(3+j))
                            +( ce(3+i) -be(3+i))*( ce(3+j) -be(3+j))
                             );
         }
      }
      g.translate(Q2[mQ2].backup_x-Q2[iQ2].backup_x);
   }else{
//
//
// detect divergence based on energy
//
//    double He[3],Hg[3],Ha[3];
//    He[0]= af;
//    He[1]= bf;
//    He[2]= cf;
//    Hg[0]=( t_dt +a_da);
//    Hg[1]=( t_dt +a_db);
//    Hg[2]=( t_dt +a_dc);
//    Ha[0]=( dt_tt_dt +dt_ta_da +da_aa_da);
//    Ha[1]=( dt_tt_dt +dt_ta_db +db_bb_db);
//    Ha[2]=( dt_tt_dt +dt_ta_dc +dc_cc_dc);
//    int Hord[3];
//    Hord[0]=0;
//    Hord[1]=1;
//    Hord[2]=2;
//    if( He[Hord[1]]<He[Hord[0]] ){
//       int j=Hord[0];
//       Hord[0]=Hord[1];
//       Hord[1]=j;
//    }
//    if( He[Hord[2]]<He[Hord[1]] ){
//       int j=Hord[1];
//       Hord[1]=Hord[2];
//       Hord[2]=j;
//    }
//    if( He[Hord[1]]<He[Hord[0]] ){
//       int j=Hord[0];
//       Hord[0]=Hord[1];
//       Hord[1]=j;
//    }
//    double sig_a=( He[Hord[2]] -He[Hord[0]])*CAL;
//    if( (sig_a>(( 0.25)*eUNIT))&&(jQ2!=iQ2) ){
//       DIVERGENCE=true;
//       double A=( Ha[Hord[2]] -Ha[Hord[0]]);
//       double B=( Hg[Hord[2]] -Hg[Hord[0]]);
//       double C= ((-0.25)*eUNIT/CAL);
//       double frac=( -B +std::sqrt( B*B -(4.00)*A*C))/((2.00)*A);
//       std::cout<< std::fixed;
//       std::cout<<" iQ2="<< std::setw( 3)<<iQ2
//                <<" jQ2="<< std::setw( 3)<<jQ2<< std::endl;
//       std::cout<< std::setprecision( 4)
//                <<" sig_a="<< std::setw( 7)<<sig_a
//                <<" eUNIT="<< std::setw( 7)<<(( 0.25)*eUNIT)<< std::endl;
//       std::cout<< std::setprecision( 5)
//                <<" dt="<< std::setw( 8)<<(dt(0)*ANG)
//                        << std::setw( 8)<<(dt(1)*ANG)
//                        << std::setw( 8)<<(dt(2)*ANG)
//                << std::setprecision( 3)
//                <<" da="<< std::setw( 8)<<(da(0)/RAD)
//                        << std::setw( 8)<<(da(1)/RAD)
//                        << std::setw( 8)<<(da(2)/RAD)<< std::endl;
//       std::cout<< std::setprecision( 6)
//                <<" af="<< std::setw( 9)<<(He[0]*CAL)
//                <<" bf="<< std::setw( 9)<<(He[1]*CAL)
//                <<" cf="<< std::setw( 9)<<(He[2]*CAL)<< std::endl;
//       std::cout<< std::setprecision( 6)
//                <<" t_dt="<< std::setw( 9)<<(t_dt*CAL)
//                <<" dt_tt_dt="<< std::setw( 9)<<(dt_tt_dt*CAL)<< std::endl
//                <<" a_da="<< std::setw( 9)<<(a_da*CAL)
//                <<" a_db="<< std::setw( 9)<<(a_db*CAL)
//                <<" a_dc="<< std::setw( 9)<<(a_dc*CAL)<< std::endl
//                <<" dt_ta_da="<< std::setw( 9)<<(dt_ta_da*CAL)
//                <<" dt_ta_db="<< std::setw( 9)<<(dt_ta_db*CAL)
//                <<" dt_ta_dc="<< std::setw( 9)<<(dt_ta_dc*CAL)<< std::endl
//                <<" da_aa_da="<< std::setw( 9)<<(da_aa_da*CAL)
//                <<" db_bb_db="<< std::setw( 9)<<(db_bb_db*CAL)
//                <<" dc_cc_dc="<< std::setw( 9)<<(dc_cc_dc*CAL)<< std::endl;
//       std::cout<< std::setprecision( 6)
//                <<" A="<< std::setw( 9)<<(zA*CAL)
//                <<" B="<< std::setw( 9)<<(zB*CAL)
//                <<" C="<< std::setw( 9)<<(zC*CAL)
//                << std::setprecision( 4)
//                <<" frac="<< std::setw( 7)<<frac<< std::endl;
//       if( (frac<=(0.00))||(frac>=(1.00)) ){
//          std::cout<<"FLAG: Quadratic root out of range.\n";
//       }else if( frac< betafrac ){
//          betafrac= frac;
//       }
//    }
//
//
// extract ds from (x,P)
//
//    Coordinates ds= transpose(P)*( xi -Q2[iQ2].backup_x);
//
//
// alternative e(P(gam,bet,alp)*( ds +x))
//
//    double ds_ta_da=( g(3,0)*ds(0)*da(0)
//                     +g(4,0)*ds(0)*da(1)
//                     +g(5,0)*ds(0)*da(2)
//                     +g(3,1)*ds(1)*da(0)
//                     +g(4,1)*ds(1)*da(1)
//                     +g(5,1)*ds(1)*da(2)
//                     +g(3,2)*ds(2)*da(0)
//                     +g(4,2)*ds(2)*da(1)
//                     +g(5,2)*ds(2)*da(2));
//    double ee=( t_dt +a_da +dt_tt_dt +ds_ta_da +da_aa_da);
//
//
// detect divergence based on energy
//
//    He[1]= ee;
//    Hg[1]=( t_dt +a_da);
//    Ha[1]=( dt_tt_dt +ds_ta_da +da_aa_da);
//    Hord[0]=0;
//    Hord[1]=1;
//    if( He[Hord[1]]<He[Hord[0]] ){
//       int j=Hord[0];
//       Hord[0]=Hord[1];
//       Hord[1]=j;
//    }
//    double sig_t=( He[Hord[1]] -He[Hord[0]])*CAL;
//    if( (sig_t>(( 4.00)*eUNIT))&&(jQ2!=iQ2) ){
//       DIVERGENCE=true;
//       double A=( Ha[Hord[1]] -Ha[Hord[0]]);
//       double B=( Hg[Hord[1]] -Hg[Hord[0]]);
//       double C= ((-4.00)*eUNIT/CAL);
//       double frac=( -B +std::sqrt( B*B -(4.00)*A*C))/((2.00)*A);
//       std::cout<< std::fixed;
//       std::cout<<" iQ2="<< std::setw( 3)<<iQ2
//                <<" jQ2="<< std::setw( 3)<<jQ2<< std::endl;
//       std::cout<< std::setprecision( 4)
//                <<" sig_t="<< std::setw( 7)<<sig_t
//                <<" sig_a="<< std::setw( 7)<<sig_a
//                <<" eUNIT="<< std::setw( 7)<<(( 4.00)*eUNIT)<< std::endl;
//       std::cout<< std::setprecision( 5)
//                <<" ds="<< std::setw( 8)<<(ds(0)*ANG)
//                        << std::setw( 8)<<(ds(1)*ANG)
//                        << std::setw( 8)<<(ds(2)*ANG)
//                << std::setprecision( 3)
//                <<" da="<< std::setw( 8)<<(da(0)/RAD)
//                        << std::setw( 8)<<(da(1)/RAD)
//                        << std::setw( 8)<<(da(2)/RAD)<< std::endl;
//       std::cout<< std::setprecision( 6)
//                <<" af="<< std::setw( 9)<<(He[0]*CAL)
//                <<" ee="<< std::setw( 9)<<(He[1]*CAL)<< std::endl;
//       std::cout<< std::setprecision( 6)
//                <<" t_dt="<< std::setw( 9)<<(t_dt*CAL)
//                <<" a_da="<< std::setw( 9)<<(a_da*CAL)<< std::endl
//                <<" dt_tt_dt="<< std::setw( 9)<<(dt_tt_dt*CAL)
//                <<" dt_ta_da="<< std::setw( 9)<<(dt_ta_da*CAL)
//                <<" ds_ta_da="<< std::setw( 9)<<(ds_ta_da*CAL)
//                <<" da_aa_da="<< std::setw( 9)<<(da_aa_da*CAL)<< std::endl;
//       std::cout<< std::setprecision( 6)
//                <<" A="<< std::setw( 9)<<(zA*CAL)
//                <<" B="<< std::setw( 9)<<(zB*CAL)
//                <<" C="<< std::setw( 9)<<(zC*CAL)
//                << std::setprecision( 4)
//                <<" frac="<< std::setw( 7)<<frac<< std::endl;
//       if( (frac<=(0.00))||(frac>=(1.00)) ){
//          std::cout<<"FLAG: Quadratic root out of range.\n";
//       }else if( frac< betafrac ){
//          betafrac= frac;
//       }
//    }
   }
   return;
}
