#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../phi/Block_Pair.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi_Automatic.hh"
#include "../phi/Rotation_Matrix.hh"

void Energy_Surface2::PHI3_A(const Phi_Automatic& aut,
                             const DAT_ARRAY_CONSTS& array_consts,
                             const Subset_Contracted_System::tM3& con,
                             int jZ0,
                             int jQ2,
                             int iZ0,
                             int iQ2){
   if( jQ2>con.Z0[jZ0].Q2a ){
      if( iQ2>con.Z0[iZ0].Q2a ){
         int jU2=Q2[jQ2].U2;
         int iU2=Q2[iQ2].U2;
         int i1,i2;
         if( jU2<=iU2 ){
            i1=jU2;
            i2=iU2;
         }else{
            i1=iU2;
            i2=jU2;
         }
//
//
// normalize backward and forward groups
//
         Rotation_Matrix ROT;
         Coordinates TRANS;
         {
            Rotation_Matrix zc= aut.Q2[jQ2].c;
            if( aut.sgnj>(0.00) ){
               zc.extend(-U2d(jU2));
            }
            ROT= Q2[jQ2].backup_c*transpose(zc);
            TRANS=( Q2[jQ2].backup_x -ROT*aut.Q2[jQ2].x);
         }
         Rotation_Matrix c= ROT*aut.Q2[iQ2].c;
         Coordinates x=( TRANS +ROT*aut.Q2[iQ2].x);
         int mQ2=con.Z0[iZ0].Q2a;
         Coordinates x0=( TRANS +ROT*aut.Q2[mQ2].x);
         x-=x0;
         Coordinates u;
         u(0)= c(0,0);
         u(1)= c(1,0);
         u(2)= c(2,0);
         Coordinates y=cross(u,x);
//
//
// Q2Q2e-->U2U2a
//
         const Block_Pair& e=Q2Q2e(jQ2,iQ2);
         double z1=( e(3,3)*Q2[jQ2].backup_c(0,0)*c(0,0)
                    +e(3,4)*Q2[jQ2].backup_c(0,0)*c(1,0)
                    +e(3,5)*Q2[jQ2].backup_c(0,0)*c(2,0)
                    +e(4,3)*Q2[jQ2].backup_c(1,0)*c(0,0)
                    +e(4,4)*Q2[jQ2].backup_c(1,0)*c(1,0)
                    +e(4,5)*Q2[jQ2].backup_c(1,0)*c(2,0)
                    +e(5,3)*Q2[jQ2].backup_c(2,0)*c(0,0)
                    +e(5,4)*Q2[jQ2].backup_c(2,0)*c(1,0)
                    +e(5,5)*Q2[jQ2].backup_c(2,0)*c(2,0));

         double z2=( e(0,3)*backup_Z0Q2y(iZ0,jQ2)(0)*c(0,0)
                    +e(0,4)*backup_Z0Q2y(iZ0,jQ2)(0)*c(1,0)
                    +e(0,5)*backup_Z0Q2y(iZ0,jQ2)(0)*c(2,0)
                    +e(1,3)*backup_Z0Q2y(iZ0,jQ2)(1)*c(0,0)
                    +e(1,4)*backup_Z0Q2y(iZ0,jQ2)(1)*c(1,0)
                    +e(1,5)*backup_Z0Q2y(iZ0,jQ2)(1)*c(2,0)
                    +e(2,3)*backup_Z0Q2y(iZ0,jQ2)(2)*c(0,0)
                    +e(2,4)*backup_Z0Q2y(iZ0,jQ2)(2)*c(1,0)
                    +e(2,5)*backup_Z0Q2y(iZ0,jQ2)(2)*c(2,0));

         double z3=( e(3,0)*Q2[jQ2].backup_c(0,0)*y(0)
                    +e(3,1)*Q2[jQ2].backup_c(0,0)*y(1)
                    +e(3,2)*Q2[jQ2].backup_c(0,0)*y(2)
                    +e(4,0)*Q2[jQ2].backup_c(1,0)*y(0)
                    +e(4,1)*Q2[jQ2].backup_c(1,0)*y(1)
                    +e(4,2)*Q2[jQ2].backup_c(1,0)*y(2)
                    +e(5,0)*Q2[jQ2].backup_c(2,0)*y(0)
                    +e(5,1)*Q2[jQ2].backup_c(2,0)*y(1)
                    +e(5,2)*Q2[jQ2].backup_c(2,0)*y(2));

         double z4=( e(0,0)*backup_Z0Q2y(iZ0,jQ2)(0)*y(0)
                    +e(0,1)*backup_Z0Q2y(iZ0,jQ2)(0)*y(1)
                    +e(0,2)*backup_Z0Q2y(iZ0,jQ2)(0)*y(2)
                    +e(1,0)*backup_Z0Q2y(iZ0,jQ2)(1)*y(0)
                    +e(1,1)*backup_Z0Q2y(iZ0,jQ2)(1)*y(1)
                    +e(1,2)*backup_Z0Q2y(iZ0,jQ2)(1)*y(2)
                    +e(2,0)*backup_Z0Q2y(iZ0,jQ2)(2)*y(0)
                    +e(2,1)*backup_Z0Q2y(iZ0,jQ2)(2)*y(1)
                    +e(2,2)*backup_Z0Q2y(iZ0,jQ2)(2)*y(2));

         U2U2a(i1,i2)+=aut.sgnj*( z1 +z2 +z3 +z4);
      }else{
//
//
// normalize backward and forward groups
//
         Rotation_Matrix ROT=Q2[jQ2].backup_c*transpose(aut.Q2[jQ2].c);
         Coordinates TRANS=( Q2[jQ2].backup_x -ROT*aut.Q2[jQ2].x);
         Coordinates x=( TRANS +ROT*aut.Q2[iQ2].x);
         int aQ2=con.Z0[jZ0].Q2a;
         Coordinates x0=( TRANS +ROT*aut.Q2[aQ2].x);
         Coordinates xi=( Q2[jQ2].backup_x -x);
         Coordinates xj=( Q2[jQ2].backup_x -x0);
         Coordinates u;
         u(0)= Q2[jQ2].backup_c(0,0);
         u(1)= Q2[jQ2].backup_c(1,0);
         u(2)= Q2[jQ2].backup_c(2,0);
         Coordinates yi=cross(u,xi);
         Coordinates yj=cross(u,xj);
//
//
// translate origin i to j
//
         Rotation_Matrix p;
         Coordinates t=( x -x0);
         for(int j=0;j<3;j++){
            Coordinates b=array_consts.dROTx[j]*t;
            for(int i=0;i<3;i++){
               p(i,j)= b(i);
            }
         }
         const Block_Pair& e=Q2Q2e(jQ2,iQ2);
         Block_Pair g,h;
         for(int i=0;i<3;i++){
            h(  i)=-e(  i);
            h(3+i)=-e(3+i)
                   -e(  0)*p(0,i)
                   -e(  1)*p(1,i)
                   -e(  2)*p(2,i);
         }
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               g(  i,  j)=-e(  i,  j);
               g(3+i,  j)=-e(3+i,  j)
                          -e(  0,  j)*p(0,i)
                          -e(  1,  j)*p(1,i)
                          -e(  2,  j)*p(2,i);
               g(  i,3+j)=-e(  i,3+j);
               g(3+i,3+j)=-e(3+i,3+j)
                          -e(  0,3+j)*p(0,i)
                          -e(  1,3+j)*p(1,i)
                          -e(  2,3+j)*p(2,i);
            }
         }
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               h(  j,  i)=-g(  i,  j);
               h(  j,3+i)=-g(3+i,  j);
               h(3+j,  i)=-g(  i,3+j)
                          -g(  i,  0)*p(0,j)
                          -g(  i,  1)*p(1,j)
                          -g(  i,  2)*p(2,j);
               h(3+j,3+i)=-g(3+i,3+j)
                          -g(3+i,  0)*p(0,j)
                          -g(3+i,  1)*p(1,j)
                          -g(3+i,  2)*p(2,j);
            }
         }
//
//
// Q2Q2e-->U2U2a
//
         int iU2=Z0[iZ0].U2a;
         int kU2=Z0[jZ0].U2a;
         int jU2=Q2[jQ2].U2;
         for(int i=0;i<6;i++){
            U2U2a(iU2+i,jU2)+=aut.sgnj*(-e(0,i)*yi(0)
                                        -e(1,i)*yi(1)
                                        -e(2,i)*yi(2)
                                        -e(3,i)*Q2[jQ2].backup_c(0,0)
                                        -e(4,i)*Q2[jQ2].backup_c(1,0)
                                        -e(5,i)*Q2[jQ2].backup_c(2,0));
            U2U2a(kU2+i,jU2)+=aut.sgnj*( h(i,0)*yj(0)
                                        +h(i,1)*yj(1)
                                        +h(i,2)*yj(2)
                                        +h(i,3)*Q2[jQ2].backup_c(0,0)
                                        +h(i,4)*Q2[jQ2].backup_c(1,0)
                                        +h(i,5)*Q2[jQ2].backup_c(2,0));
         }
      }
   }else{
      if( iQ2>con.Z0[iZ0].Q2a ){
//
//
// normalize backward and forward groups
//
         Rotation_Matrix ROT=Q2[jQ2].backup_c*transpose(aut.Q2[jQ2].c);
         Coordinates TRANS=( Q2[jQ2].backup_x -ROT*aut.Q2[jQ2].x);
         Rotation_Matrix c=ROT*aut.Q2[iQ2].c;
         Coordinates x=( TRANS +ROT*aut.Q2[iQ2].x);
         int mQ2=con.Z0[iZ0].Q2a;
         Coordinates x0=( TRANS +ROT*aut.Q2[mQ2].x);
         Coordinates xi=( x -x0);
         Coordinates xj=( x -Q2[jQ2].backup_x);
         Coordinates u;
         u(0)= c(0,0);
         u(1)= c(1,0);
         u(2)= c(2,0);
         Coordinates yi=cross(u,xi);
         Coordinates yj=cross(u,xj);
//
//
// translate origin i to j
//
         Rotation_Matrix p;
         Coordinates t=( x0 -Q2[jQ2].backup_x);
         for(int j=0;j<3;j++){
            Coordinates b=array_consts.dROTx[j]*t;
            for(int i=0;i<3;i++){
               p(i,j)= b(i);
            }
         }
         const Block_Pair& e=Q2Q2e(jQ2,iQ2);
         Block_Pair g,h;
         for(int i=0;i<3;i++){
            h(  i)=-e(  i);
            h(3+i)=-e(3+i)
                   -e(  0)*p(0,i)
                   -e(  1)*p(1,i)
                   -e(  2)*p(2,i);
         }
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               g(  i,  j)=-e(  i,  j);
               g(3+i,  j)=-e(3+i,  j)
                          -e(  0,  j)*p(0,i)
                          -e(  1,  j)*p(1,i)
                          -e(  2,  j)*p(2,i);
               g(  i,3+j)=-e(  i,3+j);
               g(3+i,3+j)=-e(3+i,3+j)
                          -e(  0,3+j)*p(0,i)
                          -e(  1,3+j)*p(1,i)
                          -e(  2,3+j)*p(2,i);
            }
         }
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               h(  j,  i)=-g(  i,  j);
               h(  j,3+i)=-g(3+i,  j);
               h(3+j,  i)=-g(  i,3+j)
                          -g(  i,  0)*p(0,j)
                          -g(  i,  1)*p(1,j)
                          -g(  i,  2)*p(2,j);
               h(3+j,3+i)=-g(3+i,3+j)
                          -g(3+i,  0)*p(0,j)
                          -g(3+i,  1)*p(1,j)
                          -g(3+i,  2)*p(2,j);
            }
         }
//
//
// Q2Q2e-->U2U2a
//
         int kU2=Z0[iZ0].U2a;
         int jU2=Z0[jZ0].U2a;
         int iU2=Q2[iQ2].U2;
         for(int i=0;i<6;i++){
            U2U2a(kU2+i,iU2)+=(-e(i,0)*yi(0)
                               -e(i,1)*yi(1)
                               -e(i,2)*yi(2)
                               -e(i,3)*c(0,0)
                               -e(i,4)*c(1,0)
                               -e(i,5)*c(2,0));
            U2U2a(jU2+i,iU2)+=( h(0,i)*yj(0)
                               +h(1,i)*yj(1)
                               +h(2,i)*yj(2)
                               +h(3,i)*c(0,0)
                               +h(4,i)*c(1,0)
                               +h(5,i)*c(2,0));
         }
      }else{
//
//
// normalize backward and forward groups
//
         Rotation_Matrix ROT=Q2[jQ2].backup_c*transpose(aut.Q2[jQ2].c);
         Coordinates TRANS=( Q2[jQ2].backup_x -ROT*aut.Q2[jQ2].x);
         Coordinates x=( TRANS +ROT*aut.Q2[iQ2].x);
//
//
// translate origin i to j
//
         Rotation_Matrix p;
         Coordinates t=( x -Q2[jQ2].backup_x);
         for(int j=0;j<3;j++){
            Coordinates b=array_consts.dROTx[j]*t;
            for(int i=0;i<3;i++){
               p(i,j)= b(i);
            }
         }
         const Block_Pair& e=Q2Q2e(jQ2,iQ2);
         Block_Pair g,h;
         for(int i=0;i<3;i++){
            h(  i)=-e(  i);
            h(3+i)=-e(3+i)
                   -e(  0)*p(0,i)
                   -e(  1)*p(1,i)
                   -e(  2)*p(2,i);
         }
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               g(  i,  j)=-e(  i,  j);
               g(3+i,  j)=-e(3+i,  j)
                          -e(  0,  j)*p(0,i)
                          -e(  1,  j)*p(1,i)
                          -e(  2,  j)*p(2,i);
               g(  i,3+j)=-e(  i,3+j);
               g(3+i,3+j)=-e(3+i,3+j)
                          -e(  0,3+j)*p(0,i)
                          -e(  1,3+j)*p(1,i)
                          -e(  2,3+j)*p(2,i);
            }
         }
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               h(  j,  i)=-g(  i,  j);
               h(  j,3+i)=-g(3+i,  j);
               h(3+j,  i)=-g(  i,3+j)
                          -g(  i,  0)*p(0,j)
                          -g(  i,  1)*p(1,j)
                          -g(  i,  2)*p(2,j);
               h(3+j,3+i)=-g(3+i,3+j)
                          -g(3+i,  0)*p(0,j)
                          -g(3+i,  1)*p(1,j)
                          -g(3+i,  2)*p(2,j);
            }
         }
//
//
// Q2Q2e-->U2U2a
//
         int iU2=Z0[iZ0].U2a;
         int jU2=Z0[jZ0].U2a;
         for(int i=0;i<3;i++){
            U2g(jU2+i)+=h(i);
            U2g(iU2+i)+=e(i);
            for(int j=i;j<6;j++){
               U2U2a(jU2+i,jU2+j)+=h(j,i);
               U2U2a(iU2+i,iU2+j)+=e(i,j);
            }
         }
         for(int i=3;i<6;i++){
            U2g(jU2+i)+=h(i);
            U2g(iU2+i)+=e(i);
            for(int j=i;j<6;j++){
               U2U2a(jU2+i,jU2+j)+=h(j,i);
               U2U2a(iU2+i,iU2+j)+=e(j,i);
            }
         }
         for(int i=0;i<6;i++){
            for(int j=0;j<6;j++){
               U2U2a(jU2+i,iU2+j)+=g(i,j);
            }
         }
      }
   }
   return;
}
